/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon;

import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.Array2D;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.AbstractFloorPart;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.HallMarker;
import java.util.ArrayList;
import java.util.Random;
import net.minecraftforge.common.util.ForgeDirection;

public class RoomMarker
extends AbstractFloorPart {
    public int xBase;
    public int zBase;
    public int xUnits;
    public int zUnits;
    public int id;
    public int x;
    public int z;
    public int width;
    public int length;
    public boolean used = false;
    public static final RoomMarker BLANK = new RoomMarker(-1, -1, -1, -1, -1, true);
    protected static boolean avoidCorners = false;
    public Object sharedObj = new Object();
    public ArrayList<RoomMarker> group = new ArrayList();
    public final boolean canModify;

    public RoomMarker(int x, int z, int width, int length, int id, boolean canChange) {
        this.canModify = canChange;
        this.xBase = x;
        this.x = x;
        this.zBase = z;
        this.z = z;
        this.xUnits = width;
        this.width = width;
        this.zUnits = length;
        this.length = length;
        this.id = id;
        this.group.add(this);
    }

    public String toString() {
        return super.toString() + '[' + String.format("%s,%s,%s,%s", this.x, this.z, this.width, this.length + 93);
    }

    public String unitDe() {
        return String.format("%s,%s,%s,%s", this.x, this.z, this.width, this.length);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            RoomMarker otherR = (RoomMarker)other;
            return this.x == otherR.x && this.z == otherR.z && this.width == otherR.width && this.length == otherR.length;
        }
        return false;
    }

    public RoomMarker refactor(int x, int z, int w, int l) {
        this.x = x;
        this.z = z;
        this.width = w;
        this.length = l;
        return this;
    }

    @Override
    public void joinWith(AbstractFloorPart part) {
        if (part instanceof RoomMarker) {
            this.joinRoom((RoomMarker)part);
        }
        if (part instanceof HallMarker) {
            this.joinRoom(((HallMarker)part).part1);
        }
    }

    public void joinRoom(RoomMarker other) {
        if (this.sharedObj != other.sharedObj) {
            other.group.addAll(this.group);
            for (RoomMarker room : this.group) {
                room.sharedObj = other.sharedObj;
                room.group = other.group;
            }
            this.sharedObj = other.sharedObj;
            this.group = other.group;
        }
    }

    public void reset() {
        this.used = false;
    }

    public void expand(Array2D<RoomMarker> rooms, int i, int j, ForgeDirection dir) {
        if (dir.offsetX < 0) {
            --this.xBase;
        }
        if (dir.offsetZ < 0) {
            --this.zBase;
        }
        this.xUnits += Math.abs(dir.offsetX);
        this.zUnits += Math.abs(dir.offsetZ);
        boolean hortz = WorldHelper.isHorizontal(dir);
        int stride = hortz ? this.zUnits : this.xUnits;
        for (int n = 0; n < stride; ++n) {
            int xi = hortz ? i + dir.offsetX : this.xBase + n;
            int zi = hortz ? this.zBase + n : j + dir.offsetZ;
            rooms.set(xi, zi, this);
        }
        this.used = true;
    }

    public void expand(AbstractList2D<RoomMarker> rooms, int i, int j, ForgeDirection dir) {
        if (dir.offsetX < 0) {
            --this.xBase;
        }
        if (dir.offsetZ < 0) {
            --this.zBase;
        }
        this.xUnits += Math.abs(dir.offsetX);
        this.zUnits += Math.abs(dir.offsetZ);
        boolean hortz = WorldHelper.isHorizontal(dir);
        int stride = hortz ? this.zUnits : this.xUnits;
        for (int n = 0; n < stride; ++n) {
            int xi = hortz ? i + dir.offsetX : this.xBase + n;
            int zi = hortz ? this.zBase + n : j + dir.offsetZ;
            rooms.addValue(xi, zi, this);
        }
        this.used = true;
    }

    public boolean canExpand(Array2D<RoomMarker> rooms, int i, int j, ForgeDirection dir, int sizeLimit, int maxX, int maxZ) {
        if (this.xUnits + Math.abs(dir.offsetX) > sizeLimit || this.zUnits + Math.abs(dir.offsetZ) > sizeLimit) {
            return false;
        }
        boolean hortz = WorldHelper.isHorizontal(dir);
        int stride = hortz ? this.zUnits : this.xUnits;
        for (int n = 0; n < stride; ++n) {
            int zi;
            int xi = hortz ? i + dir.offsetX : this.xBase + n;
            int n2 = zi = hortz ? this.zBase + n : j + dir.offsetZ;
            if (this.isPointValid(rooms, xi, zi, maxX, maxZ)) continue;
            return false;
        }
        return true;
    }

    public boolean canExpand(AbstractList2D<RoomMarker> rooms, int i, int j, ForgeDirection dir, int sizeLimit, int maxX, int maxZ) {
        if (this.xUnits + Math.abs(dir.offsetX) > sizeLimit || this.zUnits + Math.abs(dir.offsetZ) > sizeLimit) {
            return false;
        }
        boolean hortz = WorldHelper.isHorizontal(dir);
        int stride = hortz ? this.zUnits : this.xUnits;
        for (int n = 0; n < stride; ++n) {
            int zi;
            int xi = hortz ? i + dir.offsetX : this.xBase + n;
            int n2 = zi = hortz ? this.zBase + n : j + dir.offsetZ;
            if (this.isPointValid(rooms, xi, zi, maxX, maxZ)) continue;
            return false;
        }
        return true;
    }

    protected boolean isPointValid(Array2D<RoomMarker> rooms, int xi, int zi, int maxX, int maxZ) {
        if (xi < 0 || xi > maxX || zi < 0 || zi > maxZ) {
            return false;
        }
        RoomMarker roomAt = rooms.get(xi, zi);
        if (roomAt == null || roomAt == BLANK) {
            return true;
        }
        if (!roomAt.canModify) {
            return false;
        }
        return !roomAt.used || roomAt.xUnits == 0 || roomAt.zUnits == 0;
    }

    protected boolean isPointValid(AbstractList2D<RoomMarker> rooms, int xi, int zi, int maxX, int maxZ) {
        if (xi < 0 || xi > maxX || zi < 0 || zi > maxZ) {
            return false;
        }
        RoomMarker roomAt = rooms.get(xi, zi);
        if (roomAt == null || roomAt == BLANK) {
            return true;
        }
        if (!roomAt.canModify) {
            return false;
        }
        return !roomAt.used || roomAt.xUnits == 0 || roomAt.zUnits == 0;
    }

    public static AbstractList2D<Integer> to2DIntList(AbstractList2D<RoomMarker> rooms) {
        EntryList2D<Integer> result = new EntryList2D<Integer>();
        for (int i : rooms.xList()) {
            for (int j : rooms.zList(i)) {
                result.addValue(i, j, rooms.get((int)i, (int)j).id);
            }
        }
        return result;
    }

    @Override
    public ForgeDirection getRandomEdgePoint(Random random, int[] store, boolean evensOnly) {
        int allowed = this.width * 2 + this.length * 2 - (avoidCorners ? 9 : 5);
        int i = random.nextInt(allowed);
        return this.coordsFromEdgeIndex(i, store, evensOnly);
    }

    public int[] getRandomEdgePoint(Random random, ForgeDirection dir, boolean evensOnly) {
        int strip = WorldHelper.isHorizontal(dir) ? this.length : this.width;
        try {
            strip = random.nextInt(strip);
        }
        catch (RuntimeException e) {
            System.err.println(strip);
            System.err.println(this);
            throw e;
        }
        if (evensOnly) {
            strip &= 0xFFFFFFFE;
        }
        return this.coordsFromDirectionAndIndex(dir, strip);
    }

    @Override
    public EntryList2D<Integer> getAllEdgePoints(boolean evensOnly) {
        int i;
        EntryList2D<Integer> result = new EntryList2D<Integer>();
        int n = this.width == 1 || this.length == 1 ? this.width * this.length - 1 : (i = this.width * 2 + this.length * 2 - (avoidCorners ? 9 : 5));
        while (i >= 0) {
            int[] coords = new int[2];
            this.coordsFromEdgeIndex(i, coords, evensOnly);
            result.addValue(coords[0], coords[1], 2);
            --i;
        }
        return result;
    }

    public AbstractList2D<Integer> getAllEdgePointsForgeDir(boolean evensOnly) {
        EntryList2D<Integer> result = new EntryList2D<Integer>();
        for (ForgeDirection dir : WorldHelper.NWSE) {
            result.combine(this.getEdgePointsOnSide(dir, evensOnly), false, new Integer[0]);
        }
        return result;
    }

    public AbstractList2D<Integer> getEdgePointsOnSide(ForgeDirection dir, boolean evensOnly) {
        EntryList2D<Integer> result = new EntryList2D<Integer>();
        for (int strip = -1 + (WorldHelper.isHorizontal(dir) ? this.length : this.width); strip >= 0; strip -= evensOnly ? 2 : 1) {
            int[] coords = this.coordsFromDirectionAndIndex(dir, strip);
            result.addValue(coords[0], coords[1], 1);
        }
        return result;
    }

    public ForgeDirection coordsFromEdgeIndex(int edgeIndex, int[] store, boolean evensOnly) {
        if (this.width == 1) {
            store[0] = this.x;
            store[1] = edgeIndex + this.z;
            return ForgeDirection.UNKNOWN;
        }
        if (this.length == 1) {
            store[0] = edgeIndex + this.x;
            store[1] = this.z;
            return ForgeDirection.UNKNOWN;
        }
        edgeIndex += avoidCorners ? 2 : 1;
        int dirIndex = 0;
        int strip = this.width - 1;
        ForgeDirection dir = ForgeDirection.EAST;
        while (edgeIndex - strip > 0) {
            edgeIndex += (avoidCorners ? 1 : 0) - strip;
            dir = WorldHelper.ESWN[++dirIndex];
            strip = (WorldHelper.isHorizontal(dir) ? this.width : this.length) - 1;
        }
        edgeIndex = WorldHelper.isNegative(dir) ? (WorldHelper.isHorizontal(dir) ? this.width : this.length) - edgeIndex : edgeIndex;
        int i = 0;
        int j = 0;
        switch (dir) {
            case EAST: {
                i = edgeIndex - 1 & (evensOnly ? -2 : -1);
                j = 0;
                break;
            }
            case SOUTH: {
                i = this.xUnits - 1;
                j = edgeIndex - 1 & (evensOnly ? -2 : -1);
                break;
            }
            case WEST: {
                i = edgeIndex & (evensOnly ? -2 : -1);
                j = this.zUnits - 1;
                break;
            }
            case NORTH: {
                i = 0;
                j = edgeIndex & (evensOnly ? -2 : -1);
            }
        }
        store[0] = i + this.x;
        store[1] = j + this.z;
        return WorldHelper.ccw(dir);
    }

    public int[] coordsFromDirectionAndIndex(ForgeDirection dir, int i) {
        boolean hortz = WorldHelper.isHorizontal(dir);
        int positive = WorldHelper.isNegative(dir) ? 0 : 1;
        int xi = hortz ? positive * this.width - positive : i;
        int zi = hortz ? i : positive * this.length - positive;
        return new int[]{xi + this.x, zi + this.z};
    }

    public int getAlignedDistance(RoomMarker other) {
        return Math.abs(other.xBase - this.xBase) + Math.abs(other.zBase - this.zBase);
    }

    public boolean canLinkTo(RoomMarker linkee) {
        return linkee != null && this.sharedObj != linkee.sharedObj;
    }

    public boolean isAlignedWith(RoomMarker linkee) {
        return this.xBase == linkee.xBase || this.zBase == linkee.zBase;
    }

    public boolean is1x1Room() {
        return this.xUnits == 1 && this.zUnits == 1;
    }
}

