/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.fml.util;

import bspkrs.helpers.client.settings.KeyBindingHelper;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.settings.KeyBinding;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class InputEventListener {
    private static HashMap<KeyBinding, InputEventListener> instances = new HashMap();
    protected KeyBinding keyBinding;
    protected boolean isKeyDown;
    protected boolean allowRepeats;

    public InputEventListener(KeyBinding keyBinding, boolean allowRepeats) {
        this.keyBinding = keyBinding;
        this.allowRepeats = allowRepeats;
        this.isKeyDown = false;
        instances.put(keyBinding, this);
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
    }

    public KeyBinding getKeyBinding() {
        return this.keyBinding;
    }

    @SubscribeEvent
    public void onKeyInputEvent(InputEvent.KeyInputEvent event) {
        this.onInputEvent((InputEvent)event);
    }

    @SubscribeEvent
    public void onMouseInputEvent(InputEvent.MouseInputEvent event) {
        this.onInputEvent((InputEvent)event);
    }

    private void onInputEvent(InputEvent event) {
        boolean state;
        int keyCode = KeyBindingHelper.getKeyCode(this.keyBinding);
        boolean bl = state = keyCode < 0 ? Mouse.isButtonDown((int)(keyCode + 100)) : Keyboard.isKeyDown((int)keyCode);
        if (state != this.isKeyDown || state && this.allowRepeats) {
            if (state) {
                this.keyDown(this.keyBinding, state == this.isKeyDown);
            } else {
                this.keyUp(this.keyBinding);
            }
            this.isKeyDown = state;
        }
    }

    public abstract void keyDown(KeyBinding var1, boolean var2);

    public abstract void keyUp(KeyBinding var1);

    public static boolean isRegistered(KeyBinding kb) {
        return instances.containsKey(kb);
    }

    public static void unRegister(KeyBinding kb) {
        if (InputEventListener.isRegistered(kb)) {
            FMLCommonHandler.instance().bus().unregister((Object)instances.get(kb));
            instances.remove(kb);
        }
    }
}

