/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.authentication;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.Agent;
import com.mojang.authlib.AuthenticationService;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.launcher.Launcher;

public class AuthenticationDatabase {
    public static final String DEMO_UUID_PREFIX = "demo-";
    private final Map<String, UserAuthentication> authById;
    private final AuthenticationService authenticationService;

    public AuthenticationDatabase(AuthenticationService authenticationService) {
        this(new HashMap<String, UserAuthentication>(), authenticationService);
    }

    public AuthenticationDatabase(Map<String, UserAuthentication> authById, AuthenticationService authenticationService) {
        this.authById = authById;
        this.authenticationService = authenticationService;
    }

    public UserAuthentication getByName(String name) {
        if (name == null) {
            return null;
        }
        for (Map.Entry<String, UserAuthentication> entry : this.authById.entrySet()) {
            GameProfile profile = entry.getValue().getSelectedProfile();
            if (profile != null && profile.getName().equals(name)) {
                return entry.getValue();
            }
            if (profile != null || !AuthenticationDatabase.getUserFromDemoUUID(entry.getKey()).equals(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    public UserAuthentication getByUUID(String uuid) {
        return this.authById.get(uuid);
    }

    public Collection<String> getKnownNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<String, UserAuthentication> entry : this.authById.entrySet()) {
            GameProfile profile = entry.getValue().getSelectedProfile();
            if (profile != null) {
                names.add(profile.getName());
                continue;
            }
            names.add(AuthenticationDatabase.getUserFromDemoUUID(entry.getKey()));
        }
        return names;
    }

    public void register(String uuid, UserAuthentication authentication) {
        this.authById.put(uuid, authentication);
    }

    public Set<String> getknownUUIDs() {
        return this.authById.keySet();
    }

    public void removeUUID(String uuid) {
        this.authById.remove(uuid);
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public static String getUserFromDemoUUID(String uuid) {
        if (uuid.startsWith(DEMO_UUID_PREFIX) && uuid.length() > DEMO_UUID_PREFIX.length()) {
            return "Demo User " + uuid.substring(DEMO_UUID_PREFIX.length());
        }
        return "Demo User";
    }

    public static class Serializer
    implements JsonDeserializer<AuthenticationDatabase>,
    JsonSerializer<AuthenticationDatabase> {
        @Override
        public AuthenticationDatabase deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            TypeToken<HashMap<String, Map<String, String>>> token = new TypeToken<HashMap<String, Map<String, String>>>(){};
            HashMap<String, UserAuthentication> services = new HashMap<String, UserAuthentication>();
            Map credentials = (Map)context.deserialize(json, token.getType());
            YggdrasilAuthenticationService authService = new YggdrasilAuthenticationService(Launcher.getInstance().getProxy(), Launcher.getInstance().getClientToken().toString());
            for (Map.Entry entry : credentials.entrySet()) {
                UserAuthentication auth = authService.createUserAuthentication(Agent.MINECRAFT);
                auth.loadFromStorage((Map)entry.getValue());
                services.put((String)entry.getKey(), auth);
            }
            return new AuthenticationDatabase(services, authService);
        }

        @Override
        public JsonElement serialize(AuthenticationDatabase src, Type typeOfSrc, JsonSerializationContext context) {
            Map services = src.authById;
            HashMap credentials = new HashMap();
            for (Map.Entry entry : services.entrySet()) {
                credentials.put(entry.getKey(), ((UserAuthentication)entry.getValue()).saveForStorage());
            }
            return context.serialize(credentials);
        }
    }
}

