/*
 * Decompiled with CFR 0.152.
 */
package DITextures;

import DITextures.AbstractSkin;
import DITextures.EnumSkinPart;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraftforge.common.config.Configuration;

public class FileSkinRegistration
extends AbstractSkin {
    public FileSkinRegistration(String path) {
        String pathName = FileSkinRegistration.cleanup(path.replace("file:", ""));
        this.setInternalName(pathName);
        this.setSkinValue(EnumSkinPart.FRAMENAME, pathName + "DIFrameSkin.png");
        this.setSkinValue(EnumSkinPart.TYPEICONSNAME, pathName + "DITypeIcons.png");
        this.setSkinValue(EnumSkinPart.DAMAGENAME, pathName + "damage.png");
        this.setSkinValue(EnumSkinPart.HEALTHNAME, pathName + "health.png");
        this.setSkinValue(EnumSkinPart.BACKGROUNDNAME, pathName + "background.png");
        this.setSkinValue(EnumSkinPart.NAMEPLATENAME, pathName + "NamePlate.png");
        this.setSkinValue(EnumSkinPart.LEFTPOTIONNAME, pathName + "leftPotions.png");
        this.setSkinValue(EnumSkinPart.RIGHTPOTIONNAME, pathName + "rightPotions.png");
        this.setSkinValue(EnumSkinPart.CENTERPOTIONNAME, pathName + "centerPotions.png");
        File file = new File(pathName + "skin.cfg");
        Configuration config = new Configuration(file);
        this.loadConfig(config);
        config.save();
    }

    private InputStream getFileInputStream(String path) throws FileNotFoundException {
        return new FileInputStream(path);
    }

    private static String cleanup(String string) {
        String ret = string;
        if (ret.contains(File.separator + "." + File.separator)) {
            ret = ret.replace(File.separator + "." + File.separator, File.separator);
        } else if (ret.contains("\\.\\")) {
            ret = ret.replaceAll("\\\\.\\\\", "\\\\");
        } else if (ret.contains("/./")) {
            ret = ret.replace("/./", "/");
        }
        return ret;
    }

    @Override
    public final void loadSkin() {
        this.setSkinValue(EnumSkinPart.FRAMEID, this.checkAndReload(EnumSkinPart.FRAMEID, EnumSkinPart.FRAMENAME));
        this.setSkinValue(EnumSkinPart.TYPEICONSID, this.checkAndReload(EnumSkinPart.TYPEICONSID, EnumSkinPart.TYPEICONSNAME));
        this.setSkinValue(EnumSkinPart.DAMAGEID, this.checkAndReload(EnumSkinPart.DAMAGEID, EnumSkinPart.DAMAGENAME));
        this.setSkinValue(EnumSkinPart.HEALTHID, this.checkAndReload(EnumSkinPart.HEALTHID, EnumSkinPart.HEALTHNAME));
        this.setSkinValue(EnumSkinPart.BACKGROUNDID, this.checkAndReload(EnumSkinPart.BACKGROUNDID, EnumSkinPart.BACKGROUNDNAME));
        this.setSkinValue(EnumSkinPart.NAMEPLATEID, this.checkAndReload(EnumSkinPart.NAMEPLATEID, EnumSkinPart.NAMEPLATENAME));
        this.setSkinValue(EnumSkinPart.LEFTPOTIONID, this.checkAndReload(EnumSkinPart.LEFTPOTIONID, EnumSkinPart.LEFTPOTIONNAME));
        this.setSkinValue(EnumSkinPart.RIGHTPOTIONID, this.checkAndReload(EnumSkinPart.RIGHTPOTIONID, EnumSkinPart.RIGHTPOTIONNAME));
        this.setSkinValue(EnumSkinPart.CENTERPOTIONID, this.checkAndReload(EnumSkinPart.CENTERPOTIONID, EnumSkinPart.CENTERPOTIONNAME));
    }

    private DynamicTexture checkAndReload(EnumSkinPart enumID, EnumSkinPart enumName) {
        DynamicTexture ret = (DynamicTexture)this.getSkinValue(enumID);
        if (ret == null) {
            try {
                String tmp = (String)this.getSkinValue(enumName);
                ret = this.setupTexture(FileSkinRegistration.fixDim(ImageIO.read(this.getFileInputStream(tmp))), enumID);
            }
            catch (Exception ex) {
                FMLLog.severe((String)"Error Loading Skin!", (Object[])new Object[]{ex});
            }
        }
        return ret;
    }

    public static void scanFilesForSkins(File path) {
        try {
            for (File file : path.listFiles()) {
                if (!file.isDirectory()) continue;
                for (File files : file.listFiles()) {
                    if (!files.getAbsolutePath().endsWith("skin.cfg")) continue;
                    String thisSkin = files.getAbsolutePath().substring(0, files.getAbsolutePath().lastIndexOf(File.separator));
                    if (!thisSkin.endsWith(File.separator)) {
                        thisSkin = thisSkin + File.separator;
                    }
                    AVAILABLESKINS.add("file:" + thisSkin);
                }
            }
        }
        catch (Exception ex) {
            FMLLog.severe((String)"Error Loading Skin!", (Object[])new Object[]{ex});
        }
    }
}

