/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import shadersmodcore.transform.SMCLog;
import shadersmodcore.transform.SMCRemap;

public class SMCCTTextureSimple
implements IClassTransformer {
    private static final int logDetail = 0;

    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVloadTexture
    extends MethodVisitor {
        public MVloadTexture(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapMethodName(owner, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (ownerM.equals("net/minecraft/client/renderer/texture/TextureUtil") && nameM.equals("func_110989_a") && descM.equals("(ILjava/awt/image/BufferedImage;ZZ)I")) {
                this.mv.visitVarInsn(25, 1);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, "net/minecraft/client/renderer/texture/SimpleTexture", "field_110568_b", "Lnet/minecraft/util/ResourceLocation;");
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(182, "net/minecraft/client/renderer/texture/SimpleTexture", "getMultiTexID", "()Lshadersmodcore/client/MultiTexID;");
                this.mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTex", "loadSimpleTexture", "(ILjava/awt/image/BufferedImage;ZZLnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/util/ResourceLocation;Lshadersmodcore/client/MultiTexID;)I");
                SMCLog.finer("    loadSimpleTexture", new Object[0]);
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String nameM = SMCRemap.remapper.mapMethodName(this.classname, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (nameM.equals("func_110551_a") && descM.equals("(Lnet/minecraft/client/resources/IResourceManager;)V")) {
                SMCLog.finer("  patching method %s.%s%s = %s%s", this.classname, name, desc, nameM, descM);
                return new MVloadTexture(SMCRemap.getAdaptor(this.cv.visitMethod(access, name, desc, signature, exceptions)));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

