/*
 * Decompiled with CFR 0.152.
 */
package cc.skinme;

import cc.skinme.LogAgent;
import cc.skinme.SkinMeSettings;
import cc.skinme.Version;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public class SkinMe {
    private static final String SKIN_URL_PREFIX = "http://skins.minecraft.net/MinecraftSkins/";
    private static final String CLOAK_URL_PREFIX = "http://skins.minecraft.net/MinecraftCloaks/";
    private static final Version SKINME_MOD_VERSION = new Version("1.0.0");
    private static final Version MINECRAFT_VERSION = new Version("1.7.2");
    private static final String PATCHER_URL = "http://www.skinme.cc/mods/SkinMePatcher.jar";
    private static Version latestVersion = null;
    public static LogAgent skinMeLogger;
    public static String basePath;
    private static SkinMeSettings skinMeSettings;
    private static SkinMe skinMe;

    public SkinMe() {
        this.intilize();
    }

    private void intilize() {
        try {
            basePath = azd.A().w.getCanonicalPath();
            File skinMeFolder = new File(basePath + "/skinme");
            if (!skinMeFolder.exists() || !skinMeFolder.isDirectory()) {
                skinMeFolder.delete();
                skinMeFolder.mkdir();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        skinMeSettings = new SkinMeSettings(this);
        skinMeLogger = new LogAgent("Minecraft-SkinMe", " [SKINME]", basePath + "/skinme/skinme.log");
        skinMeLogger.logInfo("SkinMe v" + SKINME_MOD_VERSION.get() + " Intilizing...");
        skinMeSettings.loadOptions();
        if (SkinMe.skinMeSettings.checkUpdate) {
            SkinMe.checkUpdate();
        }
        skinMeLogger.logInfo("SkinMe v" + SKINME_MOD_VERSION.get() + " Intilized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replace(String url) {
        int type;
        if (url.startsWith(SKIN_URL_PREFIX) && SkinMe.skinMeSettings.applySkin) {
            type = 0;
        } else if (url.startsWith(CLOAK_URL_PREFIX) && SkinMe.skinMeSettings.applyCloak) {
            type = 1;
        } else {
            return url;
        }
        String username = url.substring(url.lastIndexOf("/") + 1, url.length() - 4);
        url = null;
        for (int i2 = 0; i2 < SkinMe.skinMeSettings.orderCount; ++i2) {
            int service = SkinMe.skinMeSettings.applyOrder[i2];
            if (service == 0 && SkinMe.skinMeSettings.keepFile) {
                int fileId = 0;
                String getIdUrl = "";
                try {
                    getIdUrl = SkinMeSettings.URLS[0][type].replace("%USER%", URLEncoder.encode(username, "UTF-8")) + "?id";
                    if (SkinMe.skinMeSettings.serverId != 0) {
                        getIdUrl = getIdUrl + "&server=" + SkinMe.skinMeSettings.serverId;
                    }
                    URL getFileIdUrl = new URL(getIdUrl);
                    URLConnection connection = getFileIdUrl.openConnection();
                    connection.connect();
                    BufferedReader br2 = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    String line = "";
                    fileId = Integer.parseInt(br2.readLine());
                    continue;
                }
                catch (Exception e2) {
                    skinMeLogger.logSevereException("Failed to check SkinMe file id at '" + getIdUrl + "'!", e2);
                    continue;
                }
                finally {
                    if (SkinMe.skinMeSettings.debug) {
                        skinMeLogger.logInfo("SkinMe file id at '" + getIdUrl + "' is " + fileId + '.');
                    }
                    if (fileId != -1 && (fileId != 0 || type != 1)) {
                        String fileUrlString = SkinMeSettings.SKINME_FILE_URL[type].replace("%ID%", Integer.toString(fileId));
                        BufferedInputStream inputStream = null;
                        FileOutputStream outputStream = null;
                        try {
                            int count;
                            File skinMeSkinsFolder = new File(basePath + "/skinme/skins");
                            File skinMeCloaksFolder = new File(basePath + "/skinme/cloaks");
                            File skinMeFile = type == 0 ? new File(basePath + "/skinme/skins/" + Integer.toString(fileId) + ".png") : new File(basePath + "/skinme/cloaks/" + Integer.toString(fileId) + ".png");
                            if (!skinMeSkinsFolder.exists() || !skinMeSkinsFolder.isDirectory()) {
                                skinMeSkinsFolder.delete();
                                skinMeSkinsFolder.mkdir();
                            }
                            if (!skinMeCloaksFolder.exists() || !skinMeCloaksFolder.isDirectory()) {
                                skinMeCloaksFolder.delete();
                                skinMeCloaksFolder.mkdir();
                            }
                            if (skinMeFile.exists()) {
                                url = skinMeFile.toURI().toURL().toString();
                                break;
                            }
                            if (SkinMe.skinMeSettings.debug) {
                                skinMeLogger.logInfo("Starting to download file from '" + getIdUrl + "'.");
                            }
                            URL fileUrl = new URL(fileUrlString);
                            inputStream = new BufferedInputStream(fileUrl.openStream());
                            outputStream = new FileOutputStream(skinMeFile);
                            byte[] data = new byte[1024];
                            while ((count = inputStream.read(data, 0, 1024)) != -1) {
                                outputStream.write(data, 0, count);
                            }
                            inputStream.close();
                            outputStream.close();
                            url = skinMeFile.toURI().toURL().toString();
                            break;
                        }
                        catch (Exception e3) {
                            skinMeLogger.logSevereException("Failed to download SkinMe file id at '" + fileUrlString + "'!", e3);
                        }
                    }
                }
            }
            String testUrl = SkinMe.praseImageUrl(service, type, username);
            if (!SkinMe.isImageExist(testUrl)) continue;
            url = testUrl;
            break;
        }
        if (SkinMe.skinMeSettings.debug && url != null) {
            if (type == 0) {
                skinMeLogger.logInfo("Used '" + url + "' as the skin url for " + username + ".");
            } else if (type == 1) {
                skinMeLogger.logInfo("Used '" + url + "' as the cape url for " + username + ".");
            }
        }
        return url;
    }

    public static String praseImageUrl(int service, int type, String username) {
        String imageUrl = null;
        try {
            imageUrl = SkinMeSettings.URLS[service][type].replace("%USER%", URLEncoder.encode(username, "UTF-8"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (service == 0 && SkinMe.skinMeSettings.serverId != 0) {
            imageUrl = imageUrl + "?server=" + SkinMe.skinMeSettings.serverId;
        }
        return imageUrl;
    }

    public static boolean isImageExist(String url) {
        try {
            URL testUrl = new URL(url);
            HttpURLConnection testHttpConnection = (HttpURLConnection)testUrl.openConnection();
            testHttpConnection.setRequestMethod("GET");
            testHttpConnection.connect();
            int responseCode = testHttpConnection.getResponseCode();
            if (SkinMe.skinMeSettings.debug) {
                skinMeLogger.logInfo("Respons code for '" + url + "' is " + responseCode + ".");
            }
            if (responseCode == 200) {
                return true;
            }
        }
        catch (Exception e2) {
            skinMeLogger.logSevereException("Failed to check respons code for '" + url + "'!", e2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkUpdate() {
        block16: {
            try {
                URL url = new URL("http://www.skinme.cc/mods/mod_versions");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.connect();
                BufferedReader br2 = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String line = "";
                while ((line = br2.readLine()) != null) {
                    try {
                        String[] info = line.split("=");
                        if (new Version(info[0]).compareTo(MINECRAFT_VERSION) != 0) continue;
                        latestVersion = new Version(info[1]);
                    }
                    catch (Exception e2) {
                        skinMeLogger.logWarning("Error occurs while checking for update: " + line);
                    }
                }
                if (latestVersion == null) {
                    skinMeLogger.logWarning("Failed to check for update!");
                    break block16;
                }
                if (latestVersion.compareTo(SKINME_MOD_VERSION) == 1) {
                    skinMeLogger.logInfo("Update Found! Latest Version: v" + latestVersion.get() + " Current Version: v" + SKINME_MOD_VERSION.get());
                    skinMeLogger.logInfo("Start downloading updater!");
                    BufferedInputStream inputStream = null;
                    FileOutputStream outputStream = null;
                    File tempFile = null;
                    try {
                        int count;
                        URL downloadUrl = new URL(PATCHER_URL);
                        tempFile = File.createTempFile("skinme-installer", ".jar");
                        inputStream = new BufferedInputStream(downloadUrl.openStream());
                        outputStream = new FileOutputStream(tempFile);
                        byte[] data = new byte[1024];
                        while ((count = inputStream.read(data, 0, 1024)) != -1) {
                            outputStream.write(data, 0, count);
                        }
                        break block16;
                    }
                    catch (Exception e3) {
                        skinMeLogger.logWarningException("Failed to download updater at 'http://www.skinme.cc/mods/SkinMePatcher.jar'!", e3);
                        break block16;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        if (tempFile != null) {
                            Process process = Runtime.getRuntime().exec("java -jar " + tempFile.getCanonicalPath() + " " + basePath);
                        }
                    }
                }
                skinMeLogger.logInfo("You are currently running the latest version.");
            }
            catch (Exception e4) {
                skinMeLogger.logSevereException("Failed to check update!", e4);
            }
        }
    }

    static {
        skinMe = new SkinMe();
    }
}

