/*
 * Decompiled with CFR 0.152.
 */
package cc.skinme;

import cc.skinme.SkinMe;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class SkinMeSettings {
    private static final String[] SKINME_URL = new String[]{"http://www.skinme.cc/MinecraftSkins/%USER%.png", "http://www.skinme.cc/MinecraftCloaks/%USER%.png"};
    private static final String[] MOJANG_URL = new String[]{"http://skins.minecraft.net/MinecraftSkins/%USER%.png", "http://skins.minecraft.net/MinecraftCloaks/%USER%.png"};
    private static final String[] MINECRACK_URL = new String[]{"http://minecrack.fr.nf/mc/skinsminecrackd/%USER%.png", "http://minecrack.fr.nf/mc/cloaksminecrackd/%USER%.png"};
    public static final String[][] URLS = new String[][]{SKINME_URL, MOJANG_URL, MINECRACK_URL};
    public static final String[] NAMES = new String[]{"SkinMe", "Mojang", "MineCrack"};
    public static final String[] SKINME_FILE_URL = new String[]{"http://www.skinme.cc/skins/%ID%.png", "http://www.skinme.cc/cloaks/%ID%.png"};
    private File optionsFile;
    public boolean applySkin = true;
    public boolean applyCloak = true;
    public boolean debug = false;
    public boolean checkUpdate = true;
    public boolean keepFile = true;
    public int[] applyOrder = new int[]{0, 1, 2};
    public int orderCount = 3;
    public int serverId = 0;

    public SkinMeSettings(SkinMe skinMe) {
        this.optionsFile = new File(SkinMe.basePath + "/skinme/options.cfg");
    }

    public void loadOptions() {
        try {
            if (!this.optionsFile.exists()) {
                SkinMe.skinMeLogger.logWarning("Option file not found, setting default options.");
                this.setOptions();
                return;
            }
            BufferedReader br2 = new BufferedReader(new FileReader(this.optionsFile));
            String line = "";
            while ((line = br2.readLine()) != null) {
                if (line.startsWith("#")) continue;
                try {
                    String[] option = line.split(":");
                    if (option[0].equals("applySkin")) {
                        this.applySkin = option[1].equals("true");
                    }
                    if (option[0].equals("applyCape")) {
                        this.applyCloak = option[1].equals("true");
                    }
                    if (option[0].equals("debug")) {
                        this.debug = option[1].equals("true");
                    }
                    if (option[0].equals("checkUpdate")) {
                        this.checkUpdate = option[1].equals("true");
                    }
                    if (option[0].equals("keepFile")) {
                        this.keepFile = option[1].equals("true");
                    }
                    if (option[0].equals("applyOrder")) {
                        String[] order = option[1].split(",");
                        int j2 = 0;
                        for (int i2 = 0; i2 < order.length; ++i2) {
                            try {
                                int tmp = Integer.parseInt(order[i2]);
                                if (tmp >= 0 && tmp <= 4) {
                                    this.applyOrder[j2++] = tmp;
                                    continue;
                                }
                                SkinMe.skinMeLogger.logInfo("Skipping invalid order: " + order[i2]);
                                continue;
                            }
                            catch (NumberFormatException e2) {
                                SkinMe.skinMeLogger.logWarning("Error in number formatting.");
                            }
                        }
                        this.orderCount = j2;
                        if (j2 == 0) {
                            this.applySkin = false;
                            this.applyCloak = false;
                            SkinMe.skinMeLogger.logWarning("Apply order is null, no skin or cape will be applied.");
                        }
                    }
                    if (!option[0].equals("server")) continue;
                    this.serverId = Integer.parseInt(option[1]);
                }
                catch (Exception e3) {
                    SkinMe.skinMeLogger.logWarning("Skipping bad option: " + line);
                }
            }
            br2.close();
            SkinMe.skinMeLogger.logInfo("Options loaded!");
            if (this.debug) {
                SkinMe.skinMeLogger.logInfo("Apply Skin: " + this.applySkin);
                SkinMe.skinMeLogger.logInfo("Apply Cape: " + this.applyCloak);
                SkinMe.skinMeLogger.logInfo("Keep Downloaded File: " + this.keepFile);
                SkinMe.skinMeLogger.logInfo("Check For Update: " + this.checkUpdate);
                String ordersText = "";
                for (int i3 = 0; i3 < this.orderCount; ++i3) {
                    ordersText = ordersText + NAMES[this.applyOrder[i3]];
                    if (i3 == this.orderCount - 1) continue;
                    ordersText = ordersText + " > ";
                }
                SkinMe.skinMeLogger.logInfo("Apply Order: " + ordersText);
                if (this.serverId != 0) {
                    SkinMe.skinMeLogger.logInfo("Server Id: " + this.serverId);
                }
            }
        }
        catch (Exception e4) {
            SkinMe.skinMeLogger.logSevereException("Failed to load options!", e4);
            e4.printStackTrace();
        }
    }

    public void setOptions() {
        try {
            BufferedWriter bw2 = new BufferedWriter(new FileWriter(this.optionsFile));
            bw2.write("#--SkinMe Configuration--\n# http://www.skinme.cc/\n#------------------------\napplySkin:true\napplyCape:true\nkeepFile:true\ncheckUpdate:true\napplyOrder:0,1,2\n#------------------------");
            bw2.close();
        }
        catch (Exception e2) {
            SkinMe.skinMeLogger.logSevereException("Failed to set default options!", e2);
            e2.printStackTrace();
        }
    }
}

