/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import shadersmodcore.transform.Names;
import shadersmodcore.transform.SMCLog;
import shadersmodcore.transform.SMCRemap;

public class SMCCTRenderBlocks
implements IClassTransformer {
    static final String[] fieldsBlockLightLevel = new String[]{null, "blockLightLevel05", "blockLightLevel06", "blockLightLevel08"};

    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVrenBlkPistonExt
    extends MethodVisitor {
        int nPatch = 0;
        int state = 0;

        public MVrenBlkPistonExt(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            this.state = 1;
            this.mv.visitTableSwitchInsn(min, max, dflt, labels);
        }

        public void visitLdcInsn(Object cst) {
            int match1 = 0;
            if (cst instanceof Float) {
                float fcst = ((Float)cst).floatValue();
                if (fcst == 0.5f) {
                    match1 = 1;
                } else if (fcst == 0.6f) {
                    match1 = 2;
                } else if (fcst == 0.8f) {
                    match1 = 3;
                }
            }
            if (match1 != 0 && this.state == 1) {
                String fieldName = fieldsBlockLightLevel[match1];
                this.mv.visitFieldInsn(178, "shadersmodcore/client/Shaders", fieldName, "F");
                ++this.nPatch;
                return;
            }
            this.mv.visitLdcInsn(cst);
        }

        public void visitEnd() {
            this.mv.visitEnd();
        }
    }

    private static class MVrenBlkFVar
    extends MethodVisitor {
        int nPatch = 0;
        int state = 0;

        public MVrenBlkFVar(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitLdcInsn(Object cst) {
            int match1 = 0;
            if (cst instanceof Float) {
                float fcst = ((Float)cst).floatValue();
                if (fcst == 0.5f) {
                    match1 = 1;
                } else if (fcst == 0.6f) {
                    match1 = 2;
                } else if (fcst == 0.8f) {
                    match1 = 3;
                }
            }
            if (match1 != 0 && this.state < 3) {
                ++this.state;
                String fieldName = fieldsBlockLightLevel[match1];
                this.mv.visitFieldInsn(178, "shadersmodcore/client/Shaders", fieldName, "F");
                ++this.nPatch;
                return;
            }
            this.mv.visitLdcInsn(cst);
        }

        public void visitEnd() {
            this.mv.visitEnd();
        }
    }

    private static class MVrenBlkWithAO
    extends MethodVisitor {
        MethodVisitor mv1;
        MethodNode mn;
        int nPatch = 0;

        public MVrenBlkWithAO(int access, String name, String desc, String signature, String[] exceptions, MethodVisitor mv) {
            super(262144);
            this.mn = new MethodNode(access, name, desc, signature, exceptions);
            this.mv = this.mn;
            this.mv1 = mv;
        }

        public void visitEnd() {
            this.mn.visitEnd();
            this.mn.accept(this.mv1);
        }

        public void visitLdcInsn(Object cst) {
            int match1 = 0;
            if (cst instanceof Float) {
                float fcst = ((Float)cst).floatValue();
                if (fcst == 0.5f) {
                    match1 = 1;
                } else if (fcst == 0.6f) {
                    match1 = 2;
                } else if (fcst == 0.8f) {
                    match1 = 3;
                }
            }
            if (match1 != 0) {
                int match2 = 0;
                InsnList insns = this.mn.instructions;
                AbstractInsnNode insn = insns.getLast();
                if (insn != null && insn.getOpcode() == 23 && (insn = insn.getPrevious()) != null && insn.getOpcode() == 25 && (insn = insn.getPrevious()) != null && insn.getOpcode() == 25 && (insn = insn.getPrevious()) != null && insn.getOpcode() == 25 && (insn = insn.getPrevious()) != null && insn.getOpcode() == 25) {
                    match2 = match1;
                }
                if (insn != null && insn.getOpcode() == 25 && (insn = insn.getPrevious()) != null && insn.getOpcode() == 25 && (insn = insn.getPrevious()) != null && insn.getOpcode() == 25 && (insn = insn.getPrevious()) != null && insn.getOpcode() == 25) {
                    match2 = match1;
                }
                if (match2 != 0) {
                    String fieldName = fieldsBlockLightLevel[match2];
                    this.mn.visitFieldInsn(178, "shadersmodcore/client/Shaders", fieldName, "F");
                    ++this.nPatch;
                    return;
                }
            }
            this.mn.visitLdcInsn(cst);
        }
    }

    private static class MVrenBlkByRenType
    extends MethodVisitor {
        int nPatch = 0;

        public MVrenBlkByRenType(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitCode() {
            this.mv.visitCode();
            this.mv.visitVarInsn(25, 1);
            this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "pushEntity", "(Lnet/minecraft/block/Block;)V");
            ++this.nPatch;
        }

        public void visitInsn(int opcode) {
            if (opcode == 172) {
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "popEntity", "()V");
                ++this.nPatch;
            }
            this.mv.visitInsn(opcode);
        }

        public void visitEnd() {
            this.mv.visitEnd();
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String remappedName = SMCRemap.remapper.mapMethodName(this.classname, name, desc);
            if (remappedName.equals(Names.RenderBlocks_renderBlockByRenderType)) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, remappedName);
                return new MVrenBlkByRenType(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (remappedName.equals(Names.RenderBlocks_renderStdBlockWithAOP) || remappedName.equals(Names.RenderBlocks_renderStdBlockWithAO)) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, remappedName);
                return new MVrenBlkWithAO(access, name, desc, signature, exceptions, this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (remappedName.equals(Names.RenderBlocks_renderStdBlockWithCM) || remappedName.equals(Names.RenderBlocks_renderBlockCactusImpl) || remappedName.equals(Names.RenderBlocks_renderBlockBed) || remappedName.equals(Names.RenderBlocks_renderBlockFluids) || remappedName.equals(Names.RenderBlocks_renderBlockDoor) || remappedName.equals(Names.RenderBlocks_renderBlockSandFalling)) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, remappedName);
                return new MVrenBlkFVar(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (remappedName.equals(Names.RenderBlocks_renderPistonExtension)) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, remappedName);
                return new MVrenBlkPistonExt(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

