/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import shadersmodcore.transform.Names;
import shadersmodcore.transform.SMCLog;
import shadersmodcore.transform.SMCRemap;

public class SMCCTRenderGlobal
implements IClassTransformer {
    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVdrawBlockDamageTexture
    extends MethodVisitor {
        int state = 0;

        public MVdrawBlockDamageTexture(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            switch (this.state) {
                case 0: {
                    if (opcode != 17 || operand != 3008) break;
                    ++this.state;
                    break;
                }
                case 2: {
                    if (opcode != 17 || operand != 3008) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endBlockDestroyProgress", "()V");
                }
            }
            this.mv.visitIntInsn(opcode, operand);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            switch (this.state) {
                case 1: {
                    if (!owner.equals("org/lwjgl/opengl/GL11") || !name.equals("glEnable")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginBlockDestroyProgress", "()V");
                    return;
                }
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class MVrenderSky
    extends MVendisTexFog {
        int state = 0;
        boolean detectedOptifine = false;
        int lastInt = 0;
        int lastVar = 0;

        public MVrenderSky(MethodVisitor mv) {
            super(mv);
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            this.mv.visitIntInsn(opcode, operand);
            this.lastInt = opcode == 17 ? operand : 0;
        }

        public void visitVarInsn(int opcode, int var) {
            this.mv.visitVarInsn(opcode, var);
            this.lastVar = opcode == 25 ? var : 0;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapFieldName(owner, name, desc);
            String descM = SMCRemap.remapper.mapDesc(desc);
            switch (this.state) {
                case 0: {
                    if (!ownerM.equals(Names.Vec3_) || !nameM.equals(Names.Vec3_xCoord)) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "setSkyColor", "(L" + Names.Vec3_ + ";)V");
                    this.mv.visitVarInsn(25, this.lastVar);
                    break;
                }
                case 1: {
                    if (!ownerM.equals(Names.RenderGlobal_) || !nameM.equals(Names.RenderGlobal_glSkyList)) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "preSkyList", "()V");
                }
            }
            this.mv.visitFieldInsn(opcode, owner, name, desc);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapMethodName(owner, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            switch (this.state) {
                case 0: {
                    if (!ownerM.equals("Config") || !nameM.equals("isSkyEnabled")) break;
                    this.detectedOptifine = true;
                    break;
                }
                case 2: {
                    if (!ownerM.equals(Names.WorldClient_) || !nameM.equals(Names.WorldClient_getRainStrength)) break;
                    ++this.state;
                }
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
            if (owner.equals("org/lwjgl/opengl/GL11")) {
                if (name.equals("glEnable")) {
                    if (this.lastInt == 3553) {
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "enableTexture2D", "()V");
                    } else if (this.lastInt == 2912) {
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "enableFog", "()V");
                    }
                } else if (name.equals("glDisable")) {
                    if (this.lastInt == 3553) {
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "disableTexture2D", "()V");
                    } else if (this.lastInt == 2912) {
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "disableFog", "()V");
                    }
                } else if (name.equals("glRotatef")) {
                    if (this.state == 3) {
                        ++this.state;
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "preCelestialRotate", "()V");
                    } else if (this.state == 4) {
                        ++this.state;
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "postCelestialRotate", "()V");
                    }
                }
            }
        }
    }

    private static class MVendisTexFog
    extends MethodVisitor {
        int lastInt = 0;

        public MVendisTexFog(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.mv.visitIntInsn(opcode, operand);
            this.lastInt = opcode == 17 && (operand == 3553 || operand == 2912) ? operand : 0;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.mv.visitMethodInsn(opcode, owner, name, desc);
            if (owner.equals("org/lwjgl/opengl/GL11")) {
                if (name.equals("glEnable")) {
                    if (this.lastInt == 3553) {
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "enableTexture2D", "()V");
                    } else if (this.lastInt == 2912) {
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "enableFog", "()V");
                    }
                } else if (name.equals("glDisable")) {
                    if (this.lastInt == 3553) {
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "disableTexture2D", "()V");
                    } else if (this.lastInt == 2912) {
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "disableFog", "()V");
                    }
                }
            }
            this.lastInt = 0;
        }
    }

    private static class MVrenderEntities
    extends MethodVisitor {
        int state = 0;

        public MVrenderEntities(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof String) {
                String scst = (String)cst;
                if (scst.equals("entities")) {
                    this.state = 1;
                } else if (scst.equals("tileentities")) {
                    this.state = 3;
                }
            }
            this.mv.visitLdcInsn(cst);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String nameM;
            this.mv.visitMethodInsn(opcode, owner, name, desc);
            if (this.state == 1) {
                this.state = 2;
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginEntities", "()V");
            } else if (this.state == 3) {
                this.state = 4;
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endEntities", "()V");
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginTileEntities", "()V");
            } else if (this.state == 4 && (nameM = SMCRemap.remapper.mapMethodName(owner, name, desc)).equals(Names.EntityRenderer_disableLightmap)) {
                this.state = 5;
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endTileEntities", "()V");
            }
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String remappedName = SMCRemap.remapper.mapMethodName(this.classname, name, desc);
            if (remappedName.equals(Names.RenderGlobal_renderEntities)) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, remappedName);
                return new MVrenderEntities(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (remappedName.equals(Names.RenderGlobal_sortAndRender)) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, remappedName);
                return new MVendisTexFog(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (remappedName.equals(Names.RenderGlobal_renderSky)) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, remappedName);
                return new MVrenderSky(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (remappedName.equals(Names.RenderGlobal_drawBlockDamageTexture) || remappedName.equals("drawBlockDamageTexture")) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, remappedName);
                return new MVdrawBlockDamageTexture(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (remappedName.equals(Names.RenderGlobal_drawSelectionBox)) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, remappedName);
                return new MVendisTexFog(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

