/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import shadersmodcore.transform.Names;
import shadersmodcore.transform.SMCLog;
import shadersmodcore.transform.SMCRemap;

public class SMCCTRendererLivingEntity
implements IClassTransformer {
    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVrenderLivingLabel
    extends MethodVisitor {
        int pushedInt = 0;

        public MVrenderLivingLabel(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.mv.visitIntInsn(opcode, operand);
            if (opcode == 17 && operand == 3553) {
                this.pushedInt = 3553;
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (this.pushedInt == 3553) {
                this.pushedInt = 0;
                if (opcode == 184 && owner.equals("org/lwjgl/opengl/GL11") && desc.equals("(I)V")) {
                    if (name.equals("glDisable")) {
                        owner = "shadersmodcore/client/Shaders";
                        name = "sglDisableT2D";
                    } else if (name.equals("glEnable")) {
                        owner = "shadersmodcore/client/Shaders";
                        name = "sglEnableT2D";
                    }
                }
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class MVdoRenderLiving
    extends MethodVisitor {
        private int lastInt = 0;
        private int state = 0;
        private static final int stateEnd = 7;
        Label labelEndVH = null;

        public MVdoRenderLiving(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitCode() {
            this.mv.visitCode();
            this.mv.visitFieldInsn(178, "shadersmodcore/client/Shaders", "useEntityHurtFlash", "Z");
            Label label1 = new Label();
            this.mv.visitJumpInsn(153, label1);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitFieldInsn(180, Names.EntityLivingBase_, Names.EntityLivingBase_hurtTime, Names.EntityLivingBase_hurtTime_desc);
            Label label2 = new Label();
            this.mv.visitJumpInsn(157, label2);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitFieldInsn(180, Names.EntityLivingBase_, Names.EntityLivingBase_deathTime, Names.EntityLivingBase_deathTime_desc);
            Label label3 = new Label();
            this.mv.visitJumpInsn(158, label3);
            this.mv.visitLabel(label2);
            this.mv.visitFrame(3, 0, null, 0, null);
            this.mv.visitIntInsn(16, 102);
            Label label4 = new Label();
            this.mv.visitJumpInsn(167, label4);
            this.mv.visitLabel(label3);
            this.mv.visitFrame(3, 0, null, 0, null);
            this.mv.visitInsn(3);
            this.mv.visitLabel(label4);
            this.mv.visitFrame(4, 0, null, 1, new Object[]{Opcodes.INTEGER});
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitVarInsn(23, 9);
            this.mv.visitMethodInsn(182, Names.EntityLivingBase_, Names.Entity_getBrightness, Names.Entity_getBrightness_desc);
            this.mv.visitVarInsn(23, 9);
            this.mv.visitMethodInsn(182, Names.RendererLivingEntity_, Names.RendererLivingEntity_getColorMultiplier, Names.RendererLivingEntity_getColorMultiplier_desc);
            this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "setEntityHurtFlash", "(II)V");
            this.mv.visitLabel(label1);
            this.mv.visitFrame(3, 0, null, 0, null);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (opcode == 17) {
                this.lastInt = operand;
            }
            this.mv.visitIntInsn(opcode, operand);
        }

        public void visitLdcInsn(Object cst) {
            int icst;
            if (cst instanceof Integer && (icst = ((Integer)cst).intValue()) == 32826 && this.labelEndVH != null) {
                this.mv.visitLabel(this.labelEndVH);
                this.labelEndVH = null;
            }
            this.mv.visitLdcInsn(cst);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapMethodName(owner, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (opcode == 182 && ownerM.equals(Names.RendererLivingEntity_) && descM.equals(Names.RendererLivingEntity_renderEquippedItems_desc) && nameM.equals(Names.RendererLivingEntity_renderEquippedItems)) {
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "resetEntityHurtFlash", "()V");
                this.mv.visitMethodInsn(opcode, owner, name, desc);
                this.mv.visitFieldInsn(178, "shadersmodcore/client/Shaders", "useEntityHurtFlash", "Z");
                this.labelEndVH = new Label();
                this.mv.visitJumpInsn(154, this.labelEndVH);
                this.state = 1;
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
            if (opcode == 184) {
                if (ownerM.equals("org/lwjgl/opengl/GL11")) {
                    if (descM.equals("(I)V") && nameM.equals("glDepthFunc")) {
                        if (this.state == 3) {
                            this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginLivingDamage", "()V");
                            ++this.state;
                        } else if (this.state == 4) {
                            this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endLivingDamage", "()V");
                            ++this.state;
                        }
                    }
                } else if (ownerM.equals(Names.OpenGlHelper_) && descM.equals(Names.OpenGlHelper_setActiveTexture_desc) && nameM.equals(Names.OpenGlHelper_setActiveTexture)) {
                    if (this.state == 1) {
                        ++this.state;
                    } else if (this.state == 2) {
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "disableLightmap", "()V");
                        ++this.state;
                    } else if (this.state == 5) {
                        ++this.state;
                    } else if (this.state == 6) {
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "enableLightmap", "()V");
                        ++this.state;
                    }
                }
            }
        }

        public void visitEnd() {
            this.mv.visitEnd();
            if (this.state != 7) {
                SMCLog.severe("state %d expected %d", this.state, 7);
            }
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            String nameM = SMCRemap.remapper.mapFieldName(this.classname, name, desc);
            if (nameM.equals(Names.RendererLivingEntity_mainModel) || nameM.equals(Names.RendererLivingEntity_renderPassModel)) {
                access = access & 0xFFFFFFF8 | 1;
            }
            return this.cv.visitField(access, name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            String nameM = SMCRemap.remapper.mapMethodName(this.classname, name, desc);
            if (nameM.equals(Names.RendererLivingEntity_doRender) && descM.equals(Names.RendererLivingEntity_doRender_desc)) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVdoRenderLiving(SMCRemap.getAdaptor(this.cv.visitMethod(access, name, desc, signature, exceptions)));
            }
            if (nameM.equals(Names.RendererLivingEntity_renderLabel)) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVrenderLivingLabel(SMCRemap.getAdaptor(this.cv.visitMethod(access, name, desc, signature, exceptions)));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

