/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import shadersmodcore.transform.Names;
import shadersmodcore.transform.SMCLog;
import shadersmodcore.transform.SMCRemap;

public class SMCCTTessellator
implements IClassTransformer {
    private static boolean inputHasStaticBuffer = false;

    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVsortQuad
    extends MethodVisitor {
        public MVsortQuad(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (opcode == 16 && operand == 32) {
                operand = 64;
            }
            super.visitIntInsn(opcode, operand);
        }
    }

    private static class MVsetNormal
    extends MethodVisitor {
        public MVsetNormal(MethodVisitor mv) {
            super(262144, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(4);
            mv.visitFieldInsn(181, Names.Tessellator_, Names.Tessellator_hasNormals, "Z");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(23, 1);
            mv.visitFieldInsn(181, Names.Tessellator_, "normalX", "F");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(23, 2);
            mv.visitFieldInsn(181, Names.Tessellator_, "normalY", "F");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(23, 3);
            mv.visitFieldInsn(181, Names.Tessellator_, "normalZ", "F");
            mv.visitInsn(177);
            Label l5 = new Label();
            mv.visitLabel(l5);
            mv.visitLocalVariable("this", "L" + Names.Tessellator_ + ";", null, l0, l5, 0);
            mv.visitLocalVariable("par1", "F", null, l0, l5, 1);
            mv.visitLocalVariable("par2", "F", null, l0, l5, 2);
            mv.visitLocalVariable("par3", "F", null, l0, l5, 3);
            mv.visitMaxs(2, 4);
            mv.visitEnd();
        }
    }

    private static class MVaddVertex
    extends MethodVisitor {
        public MVaddVertex(MethodVisitor mv) {
            super(262144, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(466, l0);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(24, 1);
            mv.visitVarInsn(24, 3);
            mv.visitVarInsn(24, 5);
            mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTess", "addVertex", "(L" + Names.Tessellator_ + ";DDD)V");
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLineNumber(467, l1);
            mv.visitInsn(177);
            Label l2 = new Label();
            mv.visitLabel(l2);
            mv.visitLocalVariable("this", "L" + Names.Tessellator_ + ";", null, l0, l2, 0);
            mv.visitLocalVariable("par1", "D", null, l0, l2, 1);
            mv.visitLocalVariable("par3", "D", null, l0, l2, 3);
            mv.visitLocalVariable("par5", "D", null, l0, l2, 5);
            mv.visitMaxs(7, 7);
            mv.visitEnd();
        }
    }

    private static class MVreset
    extends MethodVisitor {
        public MVreset(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapFieldName(owner, name, desc);
            String descM = SMCRemap.remapper.mapDesc(desc);
            if (opcode == 178 && ownerM.equals(Names.Tessellator_) && nameM.equals(Names.Tessellator_byteBuffer)) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, owner, name, desc);
                return;
            }
            this.mv.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    private static class MVdraw
    extends MethodVisitor {
        public MVdraw(MethodVisitor mv) {
            super(262144, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(185, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTess", "draw", "(L" + Names.Tessellator_ + ";)I");
            mv.visitInsn(172);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", "L" + Names.Tessellator_ + ";", null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
    }

    private static class MVinitI
    extends MethodVisitor {
        public MVinitI(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                if (inputHasStaticBuffer) {
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitVarInsn(21, 1);
                    this.mv.visitInsn(7);
                    this.mv.visitInsn(104);
                    this.mv.visitMethodInsn(184, Names.GLAllocation_, Names.GLAllocation_createDirectByteBuffer, Names.GLAllocation_createDirectByteBuffer_desc);
                    this.mv.visitFieldInsn(181, Names.Tessellator_, Names.Tessellator_byteBuffer, "Ljava/nio/ByteBuffer;");
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitFieldInsn(180, Names.Tessellator_, Names.Tessellator_byteBuffer, "Ljava/nio/ByteBuffer;");
                    this.mv.visitMethodInsn(182, "java/nio/ByteBuffer", "asIntBuffer", "()Ljava/nio/IntBuffer;");
                    this.mv.visitFieldInsn(181, Names.Tessellator_, Names.Tessellator_intBuffer, "Ljava/nio/IntBuffer;");
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitFieldInsn(180, Names.Tessellator_, Names.Tessellator_byteBuffer, "Ljava/nio/ByteBuffer;");
                    this.mv.visitMethodInsn(182, "java/nio/ByteBuffer", "asFloatBuffer", "()Ljava/nio/FloatBuffer;");
                    this.mv.visitFieldInsn(181, Names.Tessellator_, Names.Tessellator_floatBuffer, "Ljava/nio/FloatBuffer;");
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitFieldInsn(180, Names.Tessellator_, Names.Tessellator_byteBuffer, "Ljava/nio/ByteBuffer;");
                    this.mv.visitMethodInsn(182, "java/nio/ByteBuffer", "asShortBuffer", "()Ljava/nio/ShortBuffer;");
                    this.mv.visitFieldInsn(181, Names.Tessellator_, Names.Tessellator_shortBuffer, "Ljava/nio/ShortBuffer;");
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitVarInsn(21, 1);
                    this.mv.visitIntInsn(188, 10);
                    this.mv.visitFieldInsn(181, Names.Tessellator_, Names.Tessellator_rawBuffer, "[I");
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitInsn(3);
                    this.mv.visitFieldInsn(181, Names.Tessellator_, Names.Tessellator_vertexCount, "I");
                }
                this.mv.visitVarInsn(25, 0);
                this.mv.visitIntInsn(16, 16);
                this.mv.visitIntInsn(188, 6);
                this.mv.visitFieldInsn(181, Names.Tessellator_, "vertexPos", "[F");
            }
            this.mv.visitInsn(opcode);
        }
    }

    private static class MVinit
    extends MethodVisitor {
        public MVinit(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 183 && owner.equals("java/lang/Object") && name.equals("<init>") && desc.equals("()V")) {
                this.mv.visitLdcInsn((Object)new Integer(65536));
                this.mv.visitMethodInsn(183, Names.Tessellator_, "<init>", "(I)V");
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class MVclinit
    extends MethodVisitor {
        public MVclinit(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapFieldName(owner, name, desc);
            String descM = SMCRemap.remapper.mapDesc(desc);
            if (opcode == 179 && (nameM.equals(Names.Tessellator_byteBuffer) || nameM.equals(Names.Tessellator_intBuffer) || nameM.equals(Names.Tessellator_floatBuffer) || nameM.equals(Names.Tessellator_shortBuffer) || nameM.equals(Names.Tessellator_vertexCount))) {
                this.mv.visitInsn(87);
                return;
            }
            if (opcode == 178 && nameM.equals(Names.Tessellator_byteBuffer)) {
                this.mv.visitInsn(1);
                return;
            }
            this.mv.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapMethodName(owner, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (ownerM.equals(Names.GLAllocation_) && nameM.equals(Names.GLAllocation_createDirectByteBuffer) && descM.equals(Names.GLAllocation_createDirectByteBuffer_desc)) {
                this.mv.visitInsn(87);
                this.mv.visitInsn(1);
                return;
            }
            if (ownerM.equals(Names.GLAllocation_) && nameM.equals(Names.GLAllocation_createDirectIntBuffer) && descM.equals(Names.GLAllocation_createDirectIntBuffer_desc)) {
                this.mv.visitInsn(87);
                this.mv.visitInsn(1);
                return;
            }
            if (ownerM.equals("java/nio/ByteBuffer") && nameM.equals("asIntBuffer") && descM.equals("()Ljava/nio/IntBuffer;")) {
                this.mv.visitInsn(87);
                this.mv.visitInsn(1);
                return;
            }
            if (ownerM.equals("java/nio/ByteBuffer") && nameM.equals("asFloatBuffer") && descM.equals("()Ljava/nio/FloatBuffer;")) {
                this.mv.visitInsn(87);
                this.mv.visitInsn(1);
                return;
            }
            if (ownerM.equals("java/nio/ByteBuffer") && nameM.equals("asShortBuffer") && descM.equals("()Ljava/nio/ShortBuffer;")) {
                this.mv.visitInsn(87);
                this.mv.visitInsn(1);
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;
        boolean endFields = false;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            String nameM = SMCRemap.remapper.mapFieldName(this.classname, name, desc);
            if (name.equals("vertexPos") || name.equals("normalX") || name.equals("normalY") || name.equals("normalZ") || name.equals("midTextureU") || name.equals("midTextureV")) {
                return null;
            }
            if ((access & 8) != 0 && (nameM.equals(Names.Tessellator_byteBuffer) || nameM.equals(Names.Tessellator_intBuffer) || nameM.equals(Names.Tessellator_floatBuffer) || nameM.equals(Names.Tessellator_shortBuffer) || nameM.equals(Names.Tessellator_vertexCount))) {
                inputHasStaticBuffer = true;
                access = access & 0xFFFFFFF1 | 1;
            } else {
                access = access & 0xFFFFFFF9 | 1;
            }
            return this.cv.visitField(access, name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (!this.endFields) {
                this.endFields = true;
                FieldVisitor fv = this.cv.visitField(1, "vertexPos", "[F", null, null);
                fv.visitEnd();
                fv = this.cv.visitField(1, "normalX", "F", null, null);
                fv.visitEnd();
                fv = this.cv.visitField(1, "normalY", "F", null, null);
                fv.visitEnd();
                fv = this.cv.visitField(1, "normalZ", "F", null, null);
                fv.visitEnd();
                fv = this.cv.visitField(1, "midTextureU", "F", null, null);
                fv.visitEnd();
                fv = this.cv.visitField(1, "midTextureV", "F", null, null);
                fv.visitEnd();
            }
            String nameM = SMCRemap.remapper.mapMethodName(this.classname, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (nameM.equals("<clinit>")) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVclinit(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (nameM.equals("<init>") && descM.equals("()V")) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVinit(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (nameM.equals("<init>") && descM.equals("(I)V")) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVinitI(SMCRemap.getAdaptor(this.cv.visitMethod(access, name, desc, signature, exceptions)));
            }
            if (nameM.equals(Names.Tessellator_draw) && descM.equals(Names.Tessellator_draw_desc)) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVdraw(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (nameM.equals(Names.Tessellator_reset) && descM.equals(Names.Tessellator_reset_desc)) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                access = access & 0xFFFFFFF9 | 1;
                return new MVreset(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (nameM.equals(Names.Tessellator_addVertex) && descM.equals(Names.Tessellator_addVertex_desc)) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVaddVertex(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (nameM.equals(Names.Tessellator_setNormal) && descM.equals(Names.Tessellator_setNormal_desc)) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVsetNormal(SMCRemap.getAdaptor(this.cv.visitMethod(access, name, desc, signature, exceptions)));
            }
            if (nameM.equals(Names.Tessellator_sortQuad) && descM.equals(Names.Tessellator_sortQuad_desc)) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVsortQuad(SMCRemap.getAdaptor(this.cv.visitMethod(access, name, desc, signature, exceptions)));
            }
            access = access & 0xFFFFFFF9 | 1;
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

