/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import shadersmodcore.transform.Names;
import shadersmodcore.transform.SMCLog;
import shadersmodcore.transform.SMCRemap;

public class SMCCTTextureManager
implements IClassTransformer {
    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVonReload
    extends MethodVisitor {
        public MVonReload(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapMethodName(owner, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (ownerM.equals(Names.TextureObject_) && nameM.equals(Names.TextureObject_getGlTextureId) && descM.equals(Names.TextureObject_getGlTextureId_desc)) {
                this.mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTex", "deleteMultiTex", "(L" + Names.TextureObject_ + ";)I");
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class MVbindTexture
    extends MethodVisitor {
        public MVbindTexture(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapMethodName(owner, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (ownerM.equals(Names.TextureObject_) && nameM.equals(Names.TextureObject_getGlTextureId) && descM.equals(Names.TextureObject_getGlTextureId_desc)) {
                this.mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTex", "bindTexture", "(L" + Names.TextureObject_ + ";)V");
                return;
            }
            if (ownerM.equals(Names.TextureUtil_) && nameM.equals(Names.TextureUtil_bindTexture) && descM.equals(Names.TextureUtil_bindTexture_desc)) {
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String nameM = SMCRemap.remapper.mapMethodName(this.classname, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (nameM.equals(Names.TextureManager_bindTexture) && descM.equals(Names.TextureManager_bindTexture_desc)) {
                SMCLog.finer("  patching method %s.%s%s = %s%s", this.classname, name, desc, nameM, descM);
                return new MVbindTexture(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (nameM.equals(Names.TextureManager_onResourceManagerReload) && descM.equals(Names.TextureManager_onResourceManagerReload_desc)) {
                SMCLog.finer("  patching method %s.%s%s = %s%s", this.classname, name, desc, nameM, descM);
                return new MVonReload(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

