/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import shadersmodcore.transform.Names;
import shadersmodcore.transform.SMCLog;
import shadersmodcore.transform.SMCRemap;

public class SMCCTTextureMap
implements IClassTransformer {
    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVanimation
    extends MethodVisitor {
        public MVanimation(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitCode() {
            this.mv.visitCode();
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(182, Names.TextureMap_, "getMultiTexID", "()Lshadersmodcore/client/MultiTexID;");
            this.mv.visitFieldInsn(179, "shadersmodcore/client/ShadersTex", "updatingTex", "Lshadersmodcore/client/MultiTexID;");
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.mv.visitInsn(1);
                this.mv.visitFieldInsn(179, "shadersmodcore/client/ShadersTex", "updatingTex", "Lshadersmodcore/client/MultiTexID;");
            }
            this.mv.visitInsn(opcode);
        }
    }

    private static class MVloadAtlas
    extends MethodVisitor {
        int varStitcher = 0;
        boolean isStitcher = false;
        int state = 0;

        public MVloadAtlas(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (opcode == 188 && operand == 10) {
                this.mv.visitInsn(6);
                this.mv.visitInsn(104);
            }
            this.mv.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            if (opcode == 58 && this.isStitcher) {
                this.isStitcher = false;
                this.varStitcher = var;
            }
            this.mv.visitVarInsn(opcode, var);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapMethodName(owner, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (ownerM.equals(Names.ResourceManager_) && nameM.equals(Names.ResourceManager_getResource) && descM.equals(Names.ResourceManager_getResource_desc)) {
                SMCLog.finest("    %s", "loadRes");
                this.mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTex", "loadResource", "(L" + Names.ResourceManager_ + ";L" + Names.ResourceLocation_ + ";)L" + Names.IResource_ + ";");
                return;
            }
            if (opcode == 183 && ownerM.equals(Names.Stitcher_) && nameM.equals("<init>")) {
                this.isStitcher = true;
            } else {
                if (ownerM.equals(Names.TextureUtil_) && nameM.equals(Names.TextureUtil_allocateTextureMipmapAniso) && descM.equals(Names.TextureUtil_allocateTextureMipmapAniso_desc)) {
                    SMCLog.finest("    %s", "allocateTextureMap");
                    this.mv.visitVarInsn(25, this.varStitcher);
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTex", "allocateTextureMap", "(IIIIFL" + Names.Stitcher_ + ";L" + Names.TextureMap_ + ";)V");
                    this.state = 1;
                    return;
                }
                if (this.state == 1 && ownerM.equals(Names.TextureAtlasSprite_) && nameM.equals(Names.TextureAtlasSprite_getIconName) && descM.equals(Names.TextureAtlasSprite_getIconName_desc)) {
                    SMCLog.finest("    %s", "setSprite setIconName");
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTex", "setSprite", "(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTex", "setIconName", "(Ljava/lang/String;)Ljava/lang/String;");
                    this.state = 0;
                    return;
                }
                if (ownerM.equals(Names.TextureUtil_) && nameM.equals(Names.TextureUtil_uploadTexSub) && descM.equals(Names.TextureUtil_uploadTexSub_desc)) {
                    SMCLog.finest("    %s", "uploadTexSubForLoadAtlas");
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTex", "uploadTexSubForLoadAtlas", "([[IIIIIZZ)V");
                    return;
                }
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;
        boolean endFields = false;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (name.equals("atlasWidth")) {
                return null;
            }
            if (name.equals("atlasHeight")) {
                return null;
            }
            if (name.equals(Names.TextureMap_anisotropic)) {
                access = access & 0xFFFFFFF9 | 1;
            }
            return super.visitField(access, name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (!this.endFields) {
                this.endFields = true;
                FieldVisitor fv = this.cv.visitField(1, "atlasWidth", "I", null, null);
                fv.visitEnd();
                fv = this.cv.visitField(1, "atlasHeight", "I", null, null);
                fv.visitEnd();
            }
            String nameM = SMCRemap.remapper.mapMethodName(this.classname, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (nameM.equals(Names.TextureMap_getIconResLoc) && descM.equals(Names.TextureMap_getIconResLoc_desc)) {
                access = access & 0xFFFFFFF9 | 1;
            } else {
                if (nameM.equals(Names.TextureMap_loadTextureAtlas) && descM.equals(Names.TextureMap_loadTextureAtlas_desc)) {
                    SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                    return new MVloadAtlas(this.cv.visitMethod(access, name, desc, signature, exceptions));
                }
                if (nameM.equals(Names.TextureMap_updateAnimations) && descM.equals(Names.TextureMap_updateAnimations_desc)) {
                    SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                    return new MVanimation(this.cv.visitMethod(access, name, desc, signature, exceptions));
                }
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

