/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.MutantCreatures;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S0BPacketAnimation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thehippomaster.MutantCreatures.MutantCreatures;
import thehippomaster.MutantCreatures.MutantEnderman;
import thehippomaster.MutantCreatures.packet.PacketEHandPos;

public class EnderBlock
extends EntityThrowable {
    private static final double grabbedDistance = 1.6;

    public EnderBlock(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EnderBlock(World world, MutantEnderman enderman, int id) {
        super(world, (EntityLivingBase)enderman);
        this.setBlockID(enderman.heldBlock[id]);
        this.setBlockData(enderman.heldBlockData[id]);
        boolean outer = id <= 2;
        boolean right = (id & 1) == 1;
        EntityLivingBase living = enderman.func_70638_az();
        Vec3 forward = MutantCreatures.getDirVector(this.field_70177_z, outer ? 2.7f : 1.4f);
        Vec3 strafe = MutantCreatures.getDirVector(this.field_70177_z + (right ? 90.0f : -90.0f), outer ? 2.2f : 2.0f);
        this.field_70165_t += forward.field_72450_a + strafe.field_72450_a;
        this.field_70163_u += (double)((outer ? 2.8f : 1.1f) - enderman.func_70047_e());
        this.field_70161_v += forward.field_72449_c + strafe.field_72449_c;
        if (living != null) {
            this.func_70186_c(living.field_70165_t - this.field_70165_t, living.field_70163_u - this.field_70163_u, living.field_70161_v - this.field_70161_v, 1.4f, 1.0f);
        }
        this.func_70105_a(1.0f, 1.0f);
    }

    public EnderBlock(World world, EntityPlayer player, Block block, int data) {
        super(world, (EntityLivingBase)player);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.setBlockID(Block.func_149682_b((Block)block));
        this.setBlockData(data);
        this.setGrabbed(true);
        this.setThrowerID((EntityLivingBase)player);
        this.func_70105_a(1.0f, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    private void setBlockID(int id) {
        this.field_70180_af.func_75692_b(16, (Object)id);
    }

    private void setBlockData(int data) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)data));
    }

    public void setGrabbed(boolean flag) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)(flag ? 1 : 0)));
    }

    private void setThrowerID(EntityLivingBase living) {
        this.field_70180_af.func_75692_b(19, (Object)living.func_145782_y());
    }

    public int getBlockID() {
        return this.field_70180_af.func_75679_c(16);
    }

    public int getBlockData() {
        return this.field_70180_af.func_75683_a(17);
    }

    public boolean getGrabbed() {
        return this.field_70180_af.func_75683_a(18) == 1;
    }

    public EntityLivingBase getThrowerID() {
        int id = this.field_70180_af.func_75679_c(19);
        return (EntityLivingBase)this.field_70170_p.func_73045_a(id);
    }

    protected float func_70185_h() {
        if (this.getGrabbed()) {
            return 0.0f;
        }
        if (this.func_85052_h() != null && this.func_85052_h() instanceof EntityPlayer) {
            return 0.04f;
        }
        return 0.01f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return this.getGrabbed() && !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return this.getGrabbed() && !this.field_70128_L;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        EntityLivingBase thrower = this.func_85052_h();
        if (this.getGrabbed()) {
            if (thrower == null && (thrower = this.getThrowerID()) != null) {
                ReflectionHelper.setPrivateValue(EntityThrowable.class, (Object)((Object)this), (Object)thrower, (String[])MutantCreatures.fThrower);
            }
            if (thrower == null) {
                this.setGrabbed(false);
            } else {
                Vec3 vec = thrower.func_70040_Z();
                double x = thrower.field_70165_t + vec.field_72450_a * 1.6 - this.field_70165_t;
                double y = thrower.field_70163_u + (double)thrower.func_70047_e() + vec.field_72448_b * 1.6 - this.field_70163_u;
                double z = thrower.field_70161_v + vec.field_72449_c * 1.6 - this.field_70161_v;
                float offset = 0.6f;
                this.field_70159_w = x * (double)offset;
                this.field_70181_x = y * (double)offset;
                this.field_70179_y = z * (double)offset;
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                if (!this.field_70170_p.field_72995_K) {
                    EntityPlayer player = (EntityPlayer)thrower;
                    ItemStack stack = player.func_71045_bC();
                    if (stack == null || stack.func_77973_b() != MutantCreatures.endersoulHand) {
                        this.setGrabbed(false);
                    }
                } else if (thrower == Minecraft.func_71410_x().field_71439_g && this.field_70173_aa % 20 == 0) {
                    this.sendPositionPacket();
                }
            }
        }
    }

    public Vec3 getLookVec(EntityLiving living) {
        float PI = (float)Math.PI;
        float f1 = MathHelper.func_76134_b((float)(-living.field_70177_z * ((float)Math.PI / 180) - PI));
        float f2 = MathHelper.func_76126_a((float)(-living.field_70177_z * ((float)Math.PI / 180) - PI));
        float f3 = -MathHelper.func_76134_b((float)(-living.field_70125_A * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(-living.field_70125_A * ((float)Math.PI / 180)));
        return this.field_70170_p.func_82732_R().func_72345_a((double)(f2 * f3), (double)f4, (double)(f1 * f3));
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.getGrabbed() && this.func_85052_h() == player) {
            if (player.func_70093_af()) {
                return super.func_130002_c(player);
            }
            this.setGrabbed(false);
            this.moveTowardsHeading((EntityLivingBase)player);
            ItemStack stack = player.func_71045_bC();
            if (stack != null && stack.func_77973_b() == MutantCreatures.endersoulHand) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            MutantCreatures.sendPacketToAll(player, (Packet)new S0BPacketAnimation((Entity)player, 0));
        }
        return super.func_130002_c(player);
    }

    public void moveTowardsHeading(EntityLivingBase living) {
        this.field_70177_z = living.field_70177_z;
        this.field_70125_A = living.field_70125_A;
        float f = 0.4f;
        float PI = (float)Math.PI;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * PI)) * f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.4f, 1.0f);
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        boolean hitEntity;
        Block block;
        if (this.getGrabbed()) {
            return;
        }
        EntityLivingBase thrower = this.func_85052_h();
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)).func_149668_a(this.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) == null) {
            return;
        }
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(2.0, 2.0, 2.0));
        list.remove(thrower);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (this.func_70068_e(entity) > 4.0) continue;
            double x = entity.field_70165_t - this.field_70165_t;
            double z = entity.field_70161_v - this.field_70161_v;
            double d = Math.sqrt(x * x + z * z);
            entity.field_70159_w = x / d * (double)0.6f;
            entity.field_70181_x = 0.2f;
            entity.field_70179_y = z / d * (double)0.6f;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)thrower), (float)(6 + this.field_70146_Z.nextInt(3)));
        }
        boolean bl = hitEntity = mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY;
        if (hitEntity) {
            mop.field_72308_g.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)thrower), 4.0f);
        }
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        int id = this.getBlockID();
        int data = this.getBlockData();
        boolean grief = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
        if (thrower != null && thrower instanceof EntityPlayer) {
            grief = true;
        }
        boolean play = true;
        if (id >= 0) {
            Block block2 = Block.func_149729_e((int)id);
            boolean fail = false;
            if (block2 == Blocks.field_150350_a) {
                fail = true;
            } else if (block2.func_149742_c(this.field_70170_p, x, y, z)) {
                if (!this.field_70170_p.field_72995_K && grief && !hitEntity) {
                    this.field_70170_p.func_147465_d(x, y, z, block2, data, 3);
                }
            } else if (block2.func_149742_c(this.field_70170_p, x, y + 1, z)) {
                if (!this.field_70170_p.field_72995_K && grief && !hitEntity) {
                    this.field_70170_p.func_147465_d(x, y + 1, z, block2, data, 3);
                }
                this.field_70170_p.func_72926_e(2001, x, y + 1, z, id + (data << 12));
                play = false;
            }
            if (!this.field_70170_p.field_72995_K && fail) {
                ItemStack stack = new ItemStack(block2, 1, data);
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack));
            }
        }
        if (play) {
            this.field_70170_p.func_72926_e(2001, x, y, z, id + (data << 12));
        }
        if (!hitEntity) {
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound tagcompound) {
        super.func_70014_b(tagcompound);
        tagcompound.func_74777_a("blockID", (short)this.getBlockID());
        tagcompound.func_74777_a("blockData", (short)this.getBlockData());
    }

    public void func_70037_a(NBTTagCompound tagcompound) {
        super.func_70037_a(tagcompound);
        this.setBlockID(tagcompound.func_74765_d("blockID"));
        this.setBlockData(tagcompound.func_74765_d("blockData"));
    }

    private void sendPositionPacket() {
        if (!MutantCreatures.isEffectiveClient()) {
            return;
        }
        MutantCreatures.packetPipeline.sendToServer(new PacketEHandPos(this));
    }
}

