/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.MutantCreatures;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import thehippomaster.MutantCreatures.CreeperMinionEgg;
import thehippomaster.MutantCreatures.MCExplosion;
import thehippomaster.MutantCreatures.MCHandler;
import thehippomaster.MutantCreatures.MutantCreatures;
import thehippomaster.MutantCreatures.ai.MCAIAttackOnCollide;
import thehippomaster.MutantCreatures.ai.MCAICreeperCharge;
import thehippomaster.MutantCreatures.ai.MCAICreeperJump;
import thehippomaster.MutantCreatures.ai.MCAISpawnCreepers;

public class MutantCreeper
extends EntityMob {
    public MCAIAttackOnCollide aiCollideAttack;
    public MCAICreeperCharge aiChargeAttack;
    private int swingProgressInt;
    private String killerName;

    public MutantCreeper(World world) {
        super(world);
        this.field_70728_aV = 30;
        this.killerName = "";
        this.func_70105_a(2.0f, 2.4f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MCAICreeperJump(this, 0.9f, 1.4f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MCAISpawnCreepers(this, 0.6f, 4));
        this.aiChargeAttack = new MCAICreeperCharge(this, 0.7f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiChargeAttack);
        this.aiCollideAttack = new MCAIAttackOnCollide((EntityCreature)this, 1.3f, false).setMaxAttackTick(20 + this.field_70146_Z.nextInt(10));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiCollideAttack);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityOcelot.class, 0, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(120.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    private void setSwinging(boolean flag) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)(flag ? 1 : 0)));
    }

    public void setCharged(boolean flag) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)(flag ? 1 : 0)));
    }

    public void setSuperJump(boolean flag) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)(flag ? 1 : 0)));
    }

    public void setChargingAttack(boolean flag) {
        this.field_70180_af.func_75692_b(19, (Object)((byte)(flag ? 1 : 0)));
    }

    private boolean getSwinging() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    public boolean getCharged() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    public boolean getSuperJump() {
        return this.field_70180_af.func_75683_a(18) == 1;
    }

    public boolean getChargingAttack() {
        return this.field_70180_af.func_75683_a(19) == 1;
    }

    public boolean func_70650_aV() {
        return true;
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected void func_70069_a(float f) {
    }

    protected void updateSwingState() {
        int swingSpeed = 6;
        if (this.getSwinging()) {
            ++this.swingProgressInt;
            if (this.swingProgressInt >= swingSpeed) {
                this.swingProgressInt = 0;
                this.setSwinging(false);
            }
        } else {
            this.swingProgressInt = 0;
        }
        this.field_70733_aJ = (float)this.swingProgressInt / (float)swingSpeed;
    }

    protected void updateSuperJump(boolean wasOnGround) {
        if (!wasOnGround && this.field_70122_E) {
            this.setSuperJump(false);
            this.aiCollideAttack.resetAttackTick();
            if (!this.field_70170_p.field_72995_K) {
                boolean grief = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                MCExplosion explosion = new MCExplosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getCharged() ? 6.0f : 4.0f);
                explosion.destroyBlocks = grief;
                explosion.explode();
            }
        }
    }

    public void func_70071_h_() {
        EntityLivingBase target;
        float yawOffset;
        boolean wasOnGround = this.field_70122_E;
        super.func_70071_h_();
        this.field_70178_ae = this.getCharged();
        this.updateSwingState();
        if (this.getSuperJump()) {
            this.updateSuperJump(wasOnGround);
        }
        if (Math.abs(yawOffset = this.field_70177_z - this.field_70761_aq) > 3.0f) {
            this.field_70761_aq += yawOffset * 0.2f;
        }
        if ((target = this.func_70638_az()) != null && target.field_70128_L) {
            this.func_70624_b(null);
        }
    }

    public boolean func_70652_k(Entity entity) {
        this.swingHead();
        this.aiCollideAttack.resetAttackTick();
        boolean impact = true;
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70632_aY()) {
            impact = false;
        }
        if (impact) {
            double x = entity.field_70165_t - this.field_70165_t;
            double y = entity.field_70163_u - this.field_70163_u;
            double z = entity.field_70161_v - this.field_70161_v;
            double d = Math.sqrt(x * x + y * y + z * z);
            entity.field_70159_w = x / d * 0.5;
            entity.field_70181_x = y / d * (double)0.05f + (double)0.15f;
            entity.field_70179_y = z / d * 0.5;
        }
        return super.func_70652_k(entity);
    }

    public boolean func_70097_a(DamageSource source, float dmg) {
        if (source.func_94541_c()) {
            float amount = dmg / 2.0f;
            this.func_70691_i(amount);
            if (!this.field_70170_p.field_72995_K) {
                MCHandler.spawnHeartsAtEntity((Entity)this, (int)(amount / 2.0f));
            }
            return true;
        }
        if (this.getChargingAttack()) {
            --this.aiChargeAttack.hitCount;
        }
        return super.func_70097_a(source, dmg);
    }

    public void swingHead() {
        if (!this.getSwinging() || this.swingProgressInt >= 3 || this.swingProgressInt < 0) {
            this.swingProgressInt = -1;
            this.setSwinging(true);
        }
    }

    public void func_70077_a(EntityLightningBolt bolt) {
        this.setCharged(true);
    }

    public int maxDeathTime() {
        return 100;
    }

    @SideOnly(value=Side.CLIENT)
    public int getExplosionColor() {
        float f = (float)this.field_70725_aQ / (float)this.maxDeathTime();
        if (this.getChargingAttack()) {
            int i = this.field_70173_aa % 20;
            f = i < 10 ? 0.6f : 0.0f;
        }
        return (int)(f * 255.0f);
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        Entity entity = source.func_76346_g();
        if (entity != null && entity instanceof EntityPlayer) {
            this.killerName = ((EntityPlayer)entity).func_70005_c_();
        }
        this.field_70170_p.func_72956_a((Entity)this, "MutantCreatures:mutantcreeper.fuse", 0.9f, 1.0f);
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        float f = this.getCharged() ? 12.0f : 8.0f;
        float f1 = f * 1.5f;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b((double)f1, (double)f1, (double)f1));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            double x = this.field_70165_t - entity.field_70165_t;
            double y = this.field_70163_u - entity.field_70163_u;
            double z = this.field_70161_v - entity.field_70161_v;
            double d = Math.sqrt(x * x + y * y + z * z);
            float f2 = (float)this.field_70725_aQ / (float)this.maxDeathTime();
            entity.field_70159_w += x / d * (double)f2 * 0.09;
            entity.field_70181_x += y / d * (double)f2 * 0.09;
            entity.field_70179_y += z / d * (double)f2 * 0.09;
        }
        this.func_70107_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 0.2f) - (double)0.1f, this.field_70163_u, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 0.2f) - (double)0.1f);
        if (this.field_70725_aQ >= this.maxDeathTime()) {
            if (!this.field_70170_p.field_72995_K) {
                boolean grief = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                MCExplosion explosion = new MCExplosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, f);
                explosion.destroyBlocks = grief;
                explosion.explode();
                if ((this.field_70718_bc > 0 || this.func_70684_aJ()) && !this.func_70631_g_()) {
                    int k;
                    for (int i = this.func_70693_a(this.field_70717_bb); i > 0; i -= k) {
                        k = EntityXPOrb.func_70527_a((int)i);
                        this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, k));
                    }
                }
                if (this.killerName != null) {
                    CreeperMinionEgg egg = new CreeperMinionEgg(this.field_70170_p);
                    egg.setOwner(this.killerName);
                    egg.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)egg);
                }
            }
            this.func_70106_y();
        }
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && MutantCreatures.getRandomSpawnChance();
    }

    public float func_70013_c(float f) {
        float f1 = ((float)this.field_70737_aN - f) / (float)this.field_70738_aO;
        return super.func_70013_c(f) * f1;
    }

    public void func_70014_b(NBTTagCompound tagcompound) {
        super.func_70014_b(tagcompound);
        tagcompound.func_74757_a("charged", this.getCharged());
        tagcompound.func_74778_a("killer", this.killerName);
    }

    public void func_70037_a(NBTTagCompound tagcompound) {
        super.func_70037_a(tagcompound);
        this.setCharged(tagcompound.func_74767_n("charged"));
        this.killerName = tagcompound.func_74779_i("killer");
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    protected String func_70639_aQ() {
        return "MutantCreatures:mutantcreeper.living";
    }

    protected String func_70621_aR() {
        return "MutantCreatures:mutantcreeper.hurt";
    }

    protected String func_70673_aS() {
        return "none";
    }
}

