/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.MutantCreatures;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thehippomaster.MutantCreatures.EndersoulFragment;
import thehippomaster.MutantCreatures.MutantCreatures;
import thehippomaster.MutantCreatures.ai.MCAIAttackOnCollide;
import thehippomaster.MutantCreatures.ai.MCAIEnderAttackPlayer;
import thehippomaster.MutantCreatures.ai.MCAIEnderClone;
import thehippomaster.MutantCreatures.ai.MCAIEnderForcedLook;
import thehippomaster.MutantCreatures.ai.MCAIEnderMelee;
import thehippomaster.MutantCreatures.ai.MCAIEnderScream;
import thehippomaster.MutantCreatures.ai.MCAIEnderTeleSmash;
import thehippomaster.MutantCreatures.ai.MCAIEnderTeleport;
import thehippomaster.MutantCreatures.ai.MCAIEnderThrowBlock;
import thehippomaster.MutantCreatures.client.FXEnder;
import thehippomaster.MutantCreatures.packet.PacketEnderAttack;
import thehippomaster.MutantCreatures.packet.PacketEnderBlock;
import thehippomaster.MutantCreatures.packet.PacketEnderTeleport;

public class MutantEnderman
extends EntityMob {
    public int currentAttackID;
    public int animTick;
    public int hasTargetTick;
    public int preTargetTick;
    public int hasTarget;
    public int teleX;
    public int teleY;
    public int teleZ;
    public int screamDelayTick;
    public int deathTick;
    public int[] heldBlock;
    public int[] heldBlockData;
    public int[] heldBlockTick;
    public boolean triggerThrowBlock;
    protected int blockFrenzy;
    protected IAttributeInstance moveSpeed;
    protected List screamEntities;
    protected List deathEntities;
    protected MCAIAttackOnCollide aiAttackPlayer;
    protected MCAIAttackOnCollide aiAttack;
    protected MCAIEnderClone aiClone;
    private int dirty;
    private long preTargetA;
    private long preTargetB;
    private static boolean[] carriableBlocks = new boolean[256];

    public MutantEnderman(World world) {
        super(world);
        this.field_70728_aV = 35;
        this.preTargetTick = 0;
        this.hasTargetTick = 0;
        this.hasTarget = 0;
        this.currentAttackID = 0;
        this.animTick = 0;
        this.blockFrenzy = 0;
        this.screamDelayTick = 0;
        this.deathTick = 0;
        this.dirty = -1;
        this.preTargetA = 0L;
        this.preTargetB = 0L;
        this.field_70138_W = 1.4f;
        this.field_70158_ak = true;
        this.triggerThrowBlock = false;
        this.heldBlock = new int[5];
        this.heldBlockData = new int[5];
        this.heldBlockTick = new int[5];
        this.screamEntities = null;
        this.deathEntities = null;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MCAIEnderMelee(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MCAIEnderThrowBlock(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MCAIEnderForcedLook(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MCAIEnderTeleport(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MCAIEnderScream(this));
        this.aiClone = new MCAIEnderClone(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiClone);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MCAIEnderTeleSmash(this));
        this.aiAttackPlayer = new MCAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.2f, false);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiAttackPlayer);
        this.aiAttack = new MCAIAttackOnCollide((EntityCreature)this, 1.2f, true);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiAttack);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new MCAIEnderAttackPlayer(this, 16.0f, true));
        this.func_70105_a(1.2f, 4.8f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(96.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.moveSpeed = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public void setMeleeArm(int id) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)id));
    }

    public void setThrownBlock(int index) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)index));
    }

    public boolean getHasTarget() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    public int getMeleeArm() {
        return this.field_70180_af.func_75683_a(17);
    }

    public int getThrownBlock() {
        return this.field_70180_af.func_75683_a(18);
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70624_b(EntityLivingBase living) {
        super.func_70624_b(living);
        this.field_70180_af.func_75692_b(16, (Object)((byte)(living != null ? 1 : 0)));
    }

    protected void updateTargetTick() {
        int i;
        this.preTargetTick = this.hasTargetTick;
        if (this.getHasTarget()) {
            this.hasTarget = 20;
        }
        boolean emptyHanded = true;
        for (i = 1; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] > 0) {
                emptyHanded = false;
            }
            if (this.hasTarget > 0) {
                if (this.heldBlock[i] <= 0) continue;
                this.heldBlockTick[i] = Math.min(10, this.heldBlockTick[i] + 1);
                continue;
            }
            this.heldBlockTick[i] = Math.max(0, this.heldBlockTick[i] - 1);
        }
        if (this.hasTarget > 0) {
            this.hasTargetTick = Math.min(10, this.hasTargetTick + 1);
        } else if (emptyHanded) {
            this.hasTargetTick = Math.max(0, this.hasTargetTick - 1);
        } else if (!this.field_70170_p.field_72995_K) {
            for (i = 1; i < this.heldBlock.length; ++i) {
                if (this.heldBlock[i] == 0 || this.heldBlockTick[i] != 0) continue;
                int x = MathHelper.func_76128_c((double)(this.field_70165_t - 1.5 + this.field_70146_Z.nextDouble() * 4.0));
                int y = MathHelper.func_76128_c((double)(this.field_70163_u - 0.5 + this.field_70146_Z.nextDouble() * 2.5));
                int z = MathHelper.func_76128_c((double)(this.field_70161_v - 1.5 + this.field_70146_Z.nextDouble() * 4.0));
                Block block = this.field_70170_p.func_147439_a(x, y, z);
                Block block1 = this.field_70170_p.func_147439_a(x, y - 1, z);
                if (block == Blocks.field_150350_a && block1 != Blocks.field_150350_a && block1.func_149686_d()) {
                    this.field_70170_p.func_147465_d(x, y, z, Block.func_149729_e((int)this.heldBlock[i]), this.heldBlockData[i], 3);
                    this.sendHoldBlock(i, 0, 0);
                    continue;
                }
                if (this.field_70146_Z.nextInt(50) != 0) continue;
                this.sendHoldBlock(i, 0, 0);
            }
        }
        this.hasTarget = Math.max(0, this.hasTarget - 1);
    }

    protected void updateScreamEntities() {
        this.screamDelayTick = Math.max(0, this.screamDelayTick - 1);
        if (this.currentAttackID != 5 || this.animTick < 40 || this.animTick > 160) {
            return;
        }
        if (this.animTick == 160) {
            this.screamEntities = null;
            return;
        }
        if (this.screamEntities == null) {
            this.screamEntities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(20.0, 12.0, 20.0));
            ArrayList list = new ArrayList();
            list.addAll(this.screamEntities);
            this.screamEntities = list;
        }
        for (int i = 0; i < this.screamEntities.size(); ++i) {
            Entity entity = (Entity)this.screamEntities.get(i);
            if (this.func_70068_e(entity) > 400.0) {
                this.screamEntities.remove(i);
                --i;
                continue;
            }
            entity.field_70125_A += (this.field_70146_Z.nextFloat() - 0.3f) * 6.0f;
        }
    }

    public void func_70071_h_() {
        this.field_70703_bu = false;
        super.func_70071_h_();
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
        if (this.currentAttackID != 0) {
            ++this.animTick;
        }
        this.updateTargetTick();
        this.updateScreamEntities();
    }

    public void func_70636_d() {
        boolean targetBlind;
        super.func_70636_d();
        double h = this.currentAttackID != 10 ? (double)this.field_70131_O : (double)(this.field_70131_O + 1.0f);
        double w = this.currentAttackID != 10 ? (double)this.field_70130_N : (double)(this.field_70130_N * 1.5f);
        boolean bl = targetBlind = this.func_70638_az() != null && this.func_70638_az().func_70660_b(Potion.field_76440_q) != null;
        if (!targetBlind) {
            for (int i = 0; i < 3; ++i) {
                double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * w;
                double y = this.field_70163_u + this.field_70146_Z.nextDouble() * h - 0.25;
                double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * w;
                this.field_70170_p.func_72869_a("portal", x, y, z, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    private void updateDirtyHands() {
        if (this.dirty >= 0) {
            ++this.dirty;
        }
        if (this.dirty >= 8) {
            this.dirty = -1;
            for (int i = 1; i < this.heldBlock.length; ++i) {
                if (this.heldBlock[i] <= 0) continue;
                this.sendHoldBlock(i, this.heldBlock[i], this.heldBlockData[i]);
            }
            if (this.preTargetA != 0L && this.preTargetB != 0L) {
                List list = this.field_70170_p.field_72996_f;
                for (int i = 0; i < list.size(); ++i) {
                    EntityLivingBase living;
                    Entity entity = (Entity)list.get(i);
                    if (!(entity instanceof EntityLivingBase) || (living = (EntityLivingBase)entity).getPersistentID() == null || living.getPersistentID().getLeastSignificantBits() != this.preTargetA || living.getPersistentID().getMostSignificantBits() != this.preTargetB) continue;
                    this.func_70604_c(living);
                    break;
                }
                this.preTargetA = 0L;
                this.preTargetB = 0L;
            }
        }
    }

    protected void updateBlockFrenzy() {
        this.blockFrenzy = Math.max(0, this.blockFrenzy - 1);
        if (this.func_70638_az() != null && this.currentAttackID == 0) {
            if (this.blockFrenzy == 0 && this.field_70146_Z.nextInt(600) == 0) {
                this.blockFrenzy = 200 + this.field_70146_Z.nextInt(80);
            }
            if (this.blockFrenzy > 0 && this.field_70146_Z.nextInt(8) == 0) {
                int x = MathHelper.func_76128_c((double)(this.field_70165_t - 2.5 + this.field_70146_Z.nextDouble() * 5.0));
                int y = MathHelper.func_76128_c((double)(this.field_70163_u - 0.5 + this.field_70146_Z.nextDouble() * 3.0));
                int z = MathHelper.func_76128_c((double)(this.field_70161_v - 2.5 + this.field_70146_Z.nextDouble() * 5.0));
                int id = Block.func_149682_b((Block)this.field_70170_p.func_147439_a(x, y, z));
                int index = this.getFavorableHand();
                if (index != -1 && carriableBlocks[id]) {
                    this.sendHoldBlock(index, id, this.field_70170_p.func_72805_g(x, y, z));
                    if (this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        this.field_70170_p.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
                    }
                }
            }
        }
    }

    protected void updateTeleport() {
        double d;
        EntityLivingBase entity = this.func_70638_az();
        this.teleportByChance(entity == null ? 1600 : 800, (Entity)entity);
        if (entity != null && (d = this.func_70068_e((Entity)entity)) > 1024.0) {
            this.teleportByChance(10, (Entity)entity);
        }
    }

    protected void updateClone() {
        if (this.currentAttackID == 6) {
            this.aiAttackPlayer.moveSpeed = 1.0f;
            this.aiAttack.moveSpeed = 1.0f;
        } else {
            this.aiAttackPlayer.moveSpeed = 1.2f;
            this.aiAttack.moveSpeed = 1.2f;
        }
    }

    public void func_70629_bd() {
        super.func_70629_bd();
        if (this.func_70026_G() && this.field_70173_aa % 100 == 0) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        this.updateDirtyHands();
        this.updateBlockFrenzy();
        this.updateTeleport();
        this.updateClone();
    }

    public int getAvailableHand() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 1; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            list.add(i);
        }
        if (list.isEmpty()) {
            return -1;
        }
        return (Integer)list.get(this.field_70146_Z.nextInt(list.size()));
    }

    public int getFavorableHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 1; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            if (i <= 2) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!outer.isEmpty()) {
            return (Integer)outer.get(this.field_70146_Z.nextInt(outer.size()));
        }
        return (Integer)inner.get(this.field_70146_Z.nextInt(inner.size()));
    }

    public boolean func_70652_k(Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.currentAttackID == 0) {
            int i = this.getAvailableHand();
            if (!this.teleportByChance(6, entity)) {
                if (i != -1) {
                    boolean allHandsFree;
                    boolean bl = allHandsFree = this.heldBlock[1] == 0 && this.heldBlock[2] == 0;
                    if (allHandsFree && this.field_70146_Z.nextInt(10) == 0) {
                        this.sendAttackPacket(6);
                    } else if (allHandsFree && this.field_70146_Z.nextInt(7) == 0) {
                        this.sendAttackPacket(7);
                    } else {
                        this.setMeleeArm(i);
                        this.sendAttackPacket(1);
                    }
                } else {
                    this.triggerThrowBlock = true;
                }
            }
        }
        if (this.currentAttackID == 6) {
            boolean flag = super.func_70652_k(entity);
            if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(2) == 0) {
                double x = entity.field_70165_t + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 24.0f);
                double z = entity.field_70161_v + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 24.0f);
                double y = entity.field_70163_u + (double)this.field_70146_Z.nextInt(5) + 4.0;
                MutantCreatures.teleportTo((EntityLivingBase)this, x, y, z);
            }
            if (flag) {
                this.func_70691_i(2.0f);
            }
            return flag;
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float f) {
        Entity entity = source.func_76346_g();
        if (entity != null && entity instanceof EntityDragon) {
            return false;
        }
        if (this.currentAttackID == 4 || this.currentAttackID == 5) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean betterDodge;
            if (this.currentAttackID == 6) {
                this.aiClone.func_75251_c();
            }
            boolean bl = betterDodge = entity == null;
            if (source.func_76352_a()) {
                betterDodge = true;
            }
            if (this.teleportByChance(betterDodge ? 3 : 6, entity)) {
                if (entity != null && entity instanceof EntityLivingBase) {
                    this.func_70604_c((EntityLivingBase)entity);
                }
                return false;
            }
            boolean betterTeleport = false;
            if (source == DamageSource.field_76369_e) {
                betterTeleport = true;
            }
            this.teleportByChance(betterTeleport ? 3 : 5, entity);
        }
        return super.func_70097_a(source, f);
    }

    public boolean teleportByChance(int chance, Entity entity) {
        if (this.currentAttackID != 0) {
            return false;
        }
        if (this.field_70146_Z.nextInt(chance = Math.max(1, chance)) == 0) {
            if (entity == null) {
                return this.teleportRandomly();
            }
            return this.teleportToEntity(entity);
        }
        return false;
    }

    public boolean teleportRandomly() {
        if (this.currentAttackID != 0) {
            return false;
        }
        double radius = 24.0;
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
        double y = this.field_70163_u + (double)this.field_70146_Z.nextInt((int)radius * 2) - radius;
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
        return this.sendTeleportPacket(x, y, z);
    }

    public boolean teleportToEntity(Entity entity) {
        if (this.currentAttackID != 0) {
            return false;
        }
        double d = this.func_70068_e(entity);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double radius = 16.0;
        if (d < 100.0) {
            x = entity.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
            y = entity.field_70163_u + this.field_70146_Z.nextDouble() * radius;
            z = entity.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
        } else {
            Vec3 vec = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t - entity.field_70165_t, this.field_70121_D.field_72338_b + (double)this.field_70131_O / 2.0 - entity.field_70163_u + (double)entity.func_70047_e(), this.field_70161_v - entity.field_70161_v);
            vec = vec.func_72432_b();
            x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec.field_72450_a * radius;
            y = this.field_70163_u + (double)this.field_70146_Z.nextInt(8) - vec.field_72448_b * radius;
            z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec.field_72449_c * radius;
        }
        return this.sendTeleportPacket(x, y, z);
    }

    public void func_70653_a(Entity entity, float dmg, double d, double d1) {
    }

    public int maxDeathTick() {
        return 280;
    }

    protected void func_70609_aI() {
        ++this.deathTick;
        this.field_70159_w = 0.0;
        this.field_70181_x = Math.min(this.field_70181_x, 0.0);
        this.field_70179_y = 0.0;
        if (this.currentAttackID != 10) {
            this.sendAttackPacket(10);
        }
        if (this.deathTick == 80) {
            this.func_85030_a("MutantCreatures:mutantenderman.death", this.func_70599_aP(), this.func_70647_i());
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTick >= 60 && this.deathTick < 80 && this.deathEntities == null) {
                this.deathEntities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(10.0, 8.0, 10.0));
                ArrayList temp = new ArrayList();
                temp.addAll(this.deathEntities);
                this.deathEntities = temp;
            }
            if (this.deathTick >= 60 && this.field_70146_Z.nextInt(3) != 0) {
                EndersoulFragment orb = new EndersoulFragment(this.field_70170_p);
                orb.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() - 1.0, this.field_70161_v);
                orb.field_70159_w = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
                orb.field_70181_x = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
                orb.field_70179_y = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
                this.field_70170_p.func_72838_d((Entity)orb);
            }
            if (this.deathTick >= 80 && this.deathTick < this.maxDeathTick() - 20 && this.deathEntities != null) {
                for (int i = 0; i < this.deathEntities.size(); ++i) {
                    Entity entity = (Entity)this.deathEntities.get(i);
                    if (entity instanceof EndersoulFragment || entity instanceof EntityItem || entity instanceof MutantEnderman) continue;
                    if (entity.field_70143_R > 4.5f) {
                        entity.field_70143_R = 4.5f;
                    }
                    if (this.func_70068_e(entity) <= 64.0) continue;
                    boolean protectedPlayer = EndersoulFragment.isProtectedPlayer(entity);
                    if (protectedPlayer) {
                        this.deathEntities.remove(i);
                        --i;
                        continue;
                    }
                    double x = this.field_70165_t - entity.field_70165_t;
                    double z = this.field_70161_v - entity.field_70161_v;
                    double d = Math.sqrt(x * x + z * z);
                    entity.field_70159_w = (double)0.8f * x / d;
                    if (this.field_70163_u + 4.0 > entity.field_70163_u) {
                        entity.field_70181_x = Math.max(entity.field_70181_x, (double)0.4f);
                    }
                    entity.field_70179_y = (double)0.8f * z / d;
                    if (!(entity instanceof EntityPlayerMP)) continue;
                    EntityPlayerMP player = (EntityPlayerMP)entity;
                    MutantCreatures.sendPacketToAll((EntityPlayer)player, (Packet)new S12PacketEntityVelocity((Entity)player));
                }
            }
            if (this.deathTick >= 100 && this.deathTick < 150 && this.deathTick % 6 == 0) {
                Item item = Items.field_151079_bi;
                if (this.field_70146_Z.nextBoolean()) {
                    item = Items.field_151061_bv;
                }
                EntityItem itemEntity = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)(this.func_70047_e() * 0.8f), this.field_70161_v, new ItemStack(item, 1, 0));
                this.field_70170_p.func_72838_d((Entity)itemEntity);
            }
        }
        if (this.deathTick >= this.maxDeathTick()) {
            if (!(this.field_70170_p.field_72995_K || this.field_70718_bc <= 0 && !this.func_70684_aJ() || this.func_70631_g_())) {
                int k;
                for (int i = this.func_70693_a(this.field_70717_bb); i > 0; i -= k) {
                    k = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, k));
                }
            }
            this.func_70106_y();
        }
    }

    public boolean func_70601_bi() {
        if (this.field_70146_Z.nextInt(3) == 0) {
            return false;
        }
        if (this.field_70170_p.field_73011_w.field_76574_g == 1 && this.field_70146_Z.nextInt(2600) != 0) {
            return false;
        }
        return super.func_70601_bi() && MutantCreatures.getRandomSpawnChance();
    }

    public float func_70013_c(float f) {
        float f1 = ((float)this.field_70737_aN - f) / (float)this.field_70738_aO;
        return super.func_70013_c(f) * f1;
    }

    public void func_70014_b(NBTTagCompound tagcompound) {
        super.func_70014_b(tagcompound);
        for (int i = 1; i < this.heldBlock.length; ++i) {
            tagcompound.func_74768_a("heldBlockID_" + i, this.heldBlock[i]);
            tagcompound.func_74768_a("heldBlockData_" + i, this.heldBlockData[i]);
        }
        EntityLivingBase target = this.func_70638_az();
        if (target != null) {
            tagcompound.func_74772_a("targetA", target.getPersistentID().getLeastSignificantBits());
            tagcompound.func_74772_a("targetB", target.getPersistentID().getMostSignificantBits());
        }
    }

    public void func_70037_a(NBTTagCompound tagcompound) {
        super.func_70037_a(tagcompound);
        for (int i = 1; i < this.heldBlock.length; ++i) {
            this.heldBlock[i] = tagcompound.func_74762_e("heldBlockID_" + i);
            this.heldBlockData[i] = tagcompound.func_74762_e("heldBlockData_" + i);
            this.dirty = 0;
        }
        if (tagcompound.func_74764_b("targetA") && tagcompound.func_74764_b("targetB")) {
            this.preTargetA = tagcompound.func_74763_f("targetA");
            this.preTargetB = tagcompound.func_74763_f("targetB");
        }
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public String func_70639_aQ() {
        return "MutantCreatures:mutantenderman.living";
    }

    public String func_70621_aR() {
        return "MutantCreatures:mutantenderman.hit";
    }

    public String func_70673_aS() {
        return "none";
    }

    public int func_70627_aG() {
        return 200;
    }

    public void sendAttackPacket(int id) {
        if (MutantCreatures.isEffectiveClient()) {
            return;
        }
        this.currentAttackID = id;
        MutantCreatures.packetPipeline.sendToAll(new PacketEnderAttack(id, this));
    }

    public void sendHoldBlock(int blockId, int blockIndex, int blockData) {
        if (MutantCreatures.isEffectiveClient()) {
            return;
        }
        this.heldBlock[blockIndex] = blockId;
        this.heldBlockData[blockIndex] = blockData;
        this.heldBlockTick[blockIndex] = 0;
        MutantCreatures.packetPipeline.sendToAll(new PacketEnderBlock(this, blockId, blockIndex, blockData));
    }

    public boolean sendTeleportPacket(double targetX, double targetY, double targetZ) {
        if (MutantCreatures.isEffectiveClient() || this.currentAttackID != 0) {
            return false;
        }
        this.currentAttackID = 4;
        double oldX = this.field_70165_t;
        double oldY = this.field_70163_u;
        double oldZ = this.field_70161_v;
        this.teleX = MathHelper.func_76128_c((double)targetX);
        this.teleY = MathHelper.func_76128_c((double)targetY);
        this.teleZ = MathHelper.func_76128_c((double)targetZ);
        this.field_70165_t = (double)this.teleX + 0.5;
        this.field_70163_u = this.teleY;
        this.field_70161_v = (double)this.teleZ + 0.5;
        boolean success = false;
        if (this.field_70170_p.func_72899_e(this.teleX, this.teleY, this.teleZ)) {
            boolean temp = false;
            while (!temp && this.teleY > 0) {
                Block block = this.field_70170_p.func_147439_a(this.teleX, this.teleY - 1, this.teleZ);
                if (block != Blocks.field_150350_a && block.func_149688_o().func_76230_c()) {
                    temp = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --this.teleY;
            }
            if (temp) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    success = true;
                }
            }
        }
        this.func_70107_b(oldX, oldY, oldZ);
        if (!success) {
            this.currentAttackID = 0;
            return false;
        }
        MutantCreatures.packetPipeline.sendToAll(new PacketEnderTeleport(this, this.teleX, this.teleY, this.teleZ));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleTeleport(int x, int y, int z) {
        this.currentAttackID = 4;
        this.animTick = 0;
        this.teleX = x;
        this.teleY = y;
        this.teleZ = z;
        this.spawnBigParticles();
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnBigParticles() {
        this.spawnBigParticles(256, 1.8f);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnBigParticles(int temp, float speed) {
        EffectRenderer renderer = FMLClientHandler.instance().getClient().field_71452_i;
        if (this.currentAttackID == 4) {
            temp *= 2;
        }
        for (int i = 0; i < temp; ++i) {
            boolean flag;
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * speed;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * speed;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * speed;
            boolean bl = flag = i < temp / 2;
            if (this.currentAttackID != 4) {
                flag = true;
            }
            boolean death = this.currentAttackID != 10;
            double h = death ? (double)this.field_70131_O : (double)(this.field_70131_O + 1.0f);
            double w = death ? (double)this.field_70130_N : (double)(this.field_70130_N * 1.5f);
            double tempX = (flag ? this.field_70165_t : (double)this.teleX) + (this.field_70146_Z.nextDouble() - 0.5) * w;
            double tempY = (flag ? this.field_70163_u : (double)this.teleY) + (this.field_70146_Z.nextDouble() - 0.5) * h + (double)(death ? 1.5f : 0.5f);
            double tempZ = (flag ? this.field_70161_v : (double)this.teleZ) + (this.field_70146_Z.nextDouble() - 0.5) * w;
            renderer.func_78873_a((EntityFX)new FXEnder(this.field_70170_p, tempX, tempY, tempZ, f, f1, f2, true));
        }
    }

    static {
        MutantEnderman.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150349_c)] = true;
        MutantEnderman.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150346_d)] = true;
        MutantEnderman.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150354_m)] = true;
        MutantEnderman.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150351_n)] = true;
        MutantEnderman.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150327_N)] = true;
        MutantEnderman.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150328_O)] = true;
        MutantEnderman.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150338_P)] = true;
        MutantEnderman.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150337_Q)] = true;
        MutantEnderman.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150335_W)] = true;
        MutantEnderman.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150434_aF)] = true;
        MutantEnderman.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150435_aG)] = true;
        MutantEnderman.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150423_aK)] = true;
        MutantEnderman.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150440_ba)] = true;
        MutantEnderman.carriableBlocks[Block.func_149682_b((Block)Blocks.field_150391_bh)] = true;
    }
}

