/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.MutantCreatures;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import thehippomaster.MutantCreatures.MutantZombie;
import thehippomaster.MutantCreatures.Zombie;

public class ZombieResurrect {
    private int posX;
    private int posY;
    private int posZ;
    private int blockID;
    private int metadata;
    private int tick;
    private EntityLivingBase target;
    private World worldObj;
    private Random rand;

    public ZombieResurrect(EntityLivingBase living, int x, int y, int z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.target = living;
        this.worldObj = living.field_70170_p;
        this.rand = living.func_70681_au();
        this.blockID = Block.func_149682_b((Block)this.worldObj.func_147439_a(x, y, z));
        this.metadata = this.worldObj.func_72805_g(x, y, z);
        this.tick = 100 + this.rand.nextInt(40);
    }

    private boolean canResurrect() {
        int id = Block.func_149682_b((Block)this.worldObj.func_147439_a(this.posX, this.posY, this.posZ));
        int data = this.worldObj.func_72805_g(this.posX, this.posY, this.posZ);
        return this.blockID == id && this.metadata == data;
    }

    public boolean update(MutantZombie mutantZombie) {
        if (!this.canResurrect()) {
            return false;
        }
        if (this.rand.nextInt(15) == 0) {
            this.worldObj.func_72926_e(2001, this.posX, this.posY + 1, this.posZ, this.blockID);
        }
        --this.tick;
        if (!this.worldObj.field_72995_K && this.tick <= 0) {
            Zombie zombie = new Zombie(this.worldObj);
            zombie.leader = mutantZombie;
            if (mutantZombie.getVillager() && this.rand.nextInt(3) == 0) {
                zombie.func_82229_g(true);
            }
            zombie.func_70642_aH();
            if (!this.target.func_70089_S()) {
                this.target = null;
            }
            zombie.func_70624_b(this.target);
            zombie.func_70604_c(this.target);
            zombie.func_70107_b((double)this.posX + 0.5, (double)this.posY + 1.0, (double)this.posZ + 0.5);
            this.worldObj.func_72838_d((Entity)zombie);
            return false;
        }
        return true;
    }

    public static int getSuitableGround(World world, int x, int y, int z) {
        return ZombieResurrect.getSuitableGround(world, x, y, z, 4, true);
    }

    public static int getSuitableGround(World world, int x, int y, int z, int range, boolean checkDay) {
        float f;
        int i = y;
        while (true) {
            if (Math.abs(y - i) > range) {
                return -1;
            }
            Block block = world.func_147439_a(x, i, z);
            Block block1 = world.func_147439_a(x, i + 1, z);
            if (block == Blocks.field_150353_l || block == Blocks.field_150356_k || block == Blocks.field_150480_ab) {
                return -1;
            }
            if (block == Blocks.field_150355_j) break;
            if (block == Blocks.field_150350_a) {
                --i;
                continue;
            }
            if (block != Blocks.field_150350_a && block1 == Blocks.field_150350_a && block.func_149668_a(world, x, i, z) == null) {
                --i;
                break;
            }
            if (block == Blocks.field_150350_a || block1 == Blocks.field_150350_a || block1.func_149668_a(world, x, i + 1, z) == null) break;
            ++i;
        }
        if (checkDay && world.func_72935_r() && (f = world.func_72801_o(x, y + 1, z)) > 0.5f && world.func_72937_j(x, y + 1, z) && world.field_73012_v.nextInt(3) != 0) {
            return -1;
        }
        return i;
    }
}

