/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.handshake;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.FMLNetworkException;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.handshake.ChannelRegistrationHandler;
import cpw.mods.fml.common.network.handshake.FMLHandshakeClientState;
import cpw.mods.fml.common.network.handshake.FMLHandshakeCodec;
import cpw.mods.fml.common.network.handshake.FMLHandshakeServerState;
import cpw.mods.fml.common.network.handshake.HandshakeInjector;
import cpw.mods.fml.common.network.handshake.HandshakeMessageHandler;
import cpw.mods.fml.common.network.internal.FMLMessage;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;

public class NetworkDispatcher
extends SimpleChannelInboundHandler<fk>
implements ChannelOutboundHandler {
    public static final AttributeKey<NetworkDispatcher> FML_DISPATCHER = new AttributeKey("fml:dispatcher");
    public static final AttributeKey<Boolean> IS_LOCAL = new AttributeKey("fml:isLocal");
    public final ef manager;
    private final ld scm;
    private mm player;
    private ConnectionState state;
    private ConnectionType connectionType;
    private final Side side;
    private final EmbeddedChannel handshakeChannel;
    private mx serverHandler;
    private es netHandler;

    public static NetworkDispatcher get(ef manager) {
        return (NetworkDispatcher)((Object)manager.channel().attr(FML_DISPATCHER).get());
    }

    public static NetworkDispatcher allocAndSet(ef manager) {
        NetworkDispatcher net = new NetworkDispatcher(manager);
        manager.channel().attr(FML_DISPATCHER).getAndSet((Object)net);
        return net;
    }

    public static NetworkDispatcher allocAndSet(ef manager, ld scm) {
        NetworkDispatcher net = new NetworkDispatcher(manager, scm);
        manager.channel().attr(FML_DISPATCHER).getAndSet((Object)net);
        return net;
    }

    public NetworkDispatcher(ef manager) {
        super(fk.class, false);
        this.manager = manager;
        this.scm = null;
        this.side = Side.CLIENT;
        this.handshakeChannel = new EmbeddedChannel(new ChannelHandler[]{new HandshakeInjector(this), new ChannelRegistrationHandler(), new FMLHandshakeCodec(), new HandshakeMessageHandler<FMLHandshakeClientState>(FMLHandshakeClientState.class)});
        this.handshakeChannel.attr(FML_DISPATCHER).set((Object)this);
        this.handshakeChannel.attr(NetworkRegistry.CHANNEL_SOURCE).set((Object)Side.SERVER);
        this.handshakeChannel.attr(NetworkRegistry.FML_CHANNEL).set((Object)"FML|HS");
        this.handshakeChannel.attr(IS_LOCAL).set((Object)manager.c());
    }

    public NetworkDispatcher(ef manager, ld scm) {
        super(fk.class, false);
        this.manager = manager;
        this.scm = scm;
        this.side = Side.SERVER;
        this.handshakeChannel = new EmbeddedChannel(new ChannelHandler[]{new HandshakeInjector(this), new ChannelRegistrationHandler(), new FMLHandshakeCodec(), new HandshakeMessageHandler<FMLHandshakeServerState>(FMLHandshakeServerState.class)});
        this.handshakeChannel.attr(FML_DISPATCHER).set((Object)this);
        this.handshakeChannel.attr(NetworkRegistry.CHANNEL_SOURCE).set((Object)Side.CLIENT);
        this.handshakeChannel.attr(NetworkRegistry.FML_CHANNEL).set((Object)"FML|HS");
        this.handshakeChannel.attr(IS_LOCAL).set((Object)manager.c());
    }

    public void serverToClientHandshake(mm player) {
        this.player = player;
        this.insertIntoChannel();
    }

    private void insertIntoChannel() {
        this.manager.channel().config().setAutoRead(false);
        this.manager.channel().pipeline().addBefore("packet_handler", "fml:packet_handler", (ChannelHandler)this);
    }

    public void clientToServerHandshake() {
        this.insertIntoChannel();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.state = ConnectionState.OPENING;
        this.handshakeChannel.pipeline().fireUserEventTriggered((Object)this);
        this.manager.channel().config().setAutoRead(true);
    }

    void serverInitiateHandshake() {
        this.state = ConnectionState.AWAITING_HANDSHAKE;
        this.manager.channel().pipeline().addFirst("fml:vanilla_detector", (ChannelHandler)new VanillaTimeoutWaiter());
        this.serverHandler = new mx(this.scm.p(), this.manager, this.player);
        this.netHandler = this.serverHandler;
        this.player.a = null;
        this.manager.a(ek.b);
    }

    void clientListenForServerHandshake() {
        this.manager.a(ek.b);
        FMLCommonHandler.instance().waitForPlayClient();
        this.netHandler = FMLCommonHandler.instance().getClientPlayHandler();
        this.state = ConnectionState.AWAITING_HANDSHAKE;
    }

    private void completeClientSideConnection(ConnectionType type) {
        this.connectionType = type;
        FMLLog.info("[%s] Client side %s connection established", Thread.currentThread().getName(), this.connectionType.name().toLowerCase(Locale.ENGLISH));
        this.state = ConnectionState.CONNECTED;
        FMLCommonHandler.instance().bus().post(new FMLNetworkEvent.ClientConnectedToServerEvent(this.manager, this.connectionType.name()));
    }

    private void completeServerSideConnection(ConnectionType type) {
        this.connectionType = type;
        FMLLog.info("[%s] Server side %s connection established", Thread.currentThread().getName(), this.connectionType.name().toLowerCase(Locale.ENGLISH));
        this.state = ConnectionState.CONNECTED;
        FMLCommonHandler.instance().bus().post(new FMLNetworkEvent.ServerConnectionFromClientEvent(this.manager));
        this.scm.initializeConnectionToPlayer(this.manager, this.player, this.serverHandler);
    }

    protected void channelRead0(ChannelHandlerContext ctx, fk msg) throws Exception {
        boolean handled = false;
        if (msg instanceof in) {
            handled = this.handleServerSideCustomPacket((in)msg, ctx);
        } else if (msg instanceof gi) {
            handled = this.handleClientSideCustomPacket((gi)msg, ctx);
        } else if (this.state != ConnectionState.CONNECTED && this.state != ConnectionState.HANDSHAKECOMPLETE) {
            handled = this.handleVanilla(msg);
        }
        if (!handled) {
            ctx.fireChannelRead((Object)msg);
        }
    }

    private boolean handleVanilla(fk msg) {
        if (this.state == ConnectionState.AWAITING_HANDSHAKE && msg instanceof gu) {
            this.handshakeChannel.pipeline().fireUserEventTriggered((Object)msg);
        } else {
            FMLLog.info("Unexpected packet during modded negotiation - assuming vanilla or keepalives : %s", msg.getClass().getName());
        }
        return false;
    }

    public es getNetHandler() {
        return this.netHandler;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ConnectionType && this.side == Side.SERVER) {
            FMLLog.info("Timeout occurred, assuming a vanilla client", new Object[0]);
            this.kickVanilla();
        }
    }

    private void kickVanilla() {
        this.kickWithMessage("This is modded. No modded response received. Bye!");
    }

    private void kickWithMessage(String message) {
        final fh chatcomponenttext = new fh(message);
        this.manager.a((fk)new gj((fa)chatcomponenttext), new GenericFutureListener[]{new GenericFutureListener<Future<?>>(){

            public void operationComplete(Future<?> result) {
                NetworkDispatcher.this.manager.a((fa)chatcomponenttext);
            }
        }});
        this.manager.channel().config().setAutoRead(false);
    }

    private boolean handleClientSideCustomPacket(gi msg, ChannelHandlerContext context) {
        String channelName = msg.c();
        if ("FML|HS".equals(channelName) || "REGISTER".equals(channelName) || "UNREGISTER".equals(channelName)) {
            FMLProxyPacket proxy = new FMLProxyPacket(msg);
            proxy.setDispatcher(this);
            this.handshakeChannel.writeInbound(new Object[]{proxy});
            for (Object push : this.handshakeChannel.inboundMessages()) {
                List<FMLProxyPacket> messageResult = FMLNetworkHandler.forwardHandshake((FMLMessage.CompleteHandshake)push, this, Side.CLIENT);
                for (FMLProxyPacket result : messageResult) {
                    result.setTarget(Side.CLIENT);
                    result.payload().resetReaderIndex();
                    context.fireChannelRead((Object)result);
                }
            }
            this.handshakeChannel.inboundMessages().clear();
            return true;
        }
        if (NetworkRegistry.INSTANCE.hasChannel(channelName, Side.CLIENT)) {
            FMLProxyPacket proxy = new FMLProxyPacket(msg);
            proxy.setDispatcher(this);
            context.fireChannelRead((Object)proxy);
            return true;
        }
        return false;
    }

    private boolean handleServerSideCustomPacket(in msg, ChannelHandlerContext context) {
        String channelName;
        if (this.state == ConnectionState.AWAITING_HANDSHAKE) {
            this.manager.channel().pipeline().remove("fml:vanilla_detector");
            this.state = ConnectionState.HANDSHAKING;
        }
        if ("FML|HS".equals(channelName = msg.c()) || "REGISTER".equals(channelName) || "UNREGISTER".equals(channelName)) {
            FMLProxyPacket proxy = new FMLProxyPacket(msg);
            proxy.setDispatcher(this);
            this.handshakeChannel.writeInbound(new Object[]{proxy});
            for (Object push : this.handshakeChannel.inboundMessages()) {
                List<FMLProxyPacket> messageResult = FMLNetworkHandler.forwardHandshake((FMLMessage.CompleteHandshake)push, this, Side.SERVER);
                for (FMLProxyPacket result : messageResult) {
                    result.setTarget(Side.SERVER);
                    result.payload().resetReaderIndex();
                    context.fireChannelRead((Object)result);
                }
            }
            this.handshakeChannel.inboundMessages().clear();
            return true;
        }
        if (NetworkRegistry.INSTANCE.hasChannel(channelName, Side.SERVER)) {
            FMLProxyPacket proxy = new FMLProxyPacket(msg);
            proxy.setDispatcher(this);
            context.fireChannelRead((Object)proxy);
            return true;
        }
        return false;
    }

    public void sendProxy(FMLProxyPacket msg) {
        this.manager.a((fk)msg, new GenericFutureListener[0]);
    }

    public void rejectHandshake(String result) {
        this.kickWithMessage(result);
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (this.side == Side.CLIENT) {
            FMLCommonHandler.instance().bus().post(new FMLNetworkEvent.ClientDisconnectionFromServerEvent(this.manager));
        } else {
            FMLCommonHandler.instance().bus().post(new FMLNetworkEvent.ServerDisconnectionFromClientEvent(this.manager));
        }
        ctx.disconnect(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close(promise);
    }

    @Deprecated
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof FMLProxyPacket) {
            if (this.side == Side.CLIENT) {
                ctx.write((Object)((FMLProxyPacket)((Object)msg)).toC17Packet(), promise);
            } else {
                ctx.write((Object)((FMLProxyPacket)((Object)msg)).toS3FPacket(), promise);
            }
        } else {
            ctx.write(msg, promise);
        }
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void completeHandshake(Side target) {
        if (this.state == ConnectionState.CONNECTED) {
            FMLLog.severe("Attempt to double complete the network connection!", new Object[0]);
            throw new FMLNetworkException("Attempt to double complete!");
        }
        if (this.side == Side.CLIENT) {
            this.completeClientSideConnection(ConnectionType.MODDED);
        } else {
            this.completeServerSideConnection(ConnectionType.MODDED);
        }
    }

    public void completeClientHandshake() {
        this.state = ConnectionState.HANDSHAKECOMPLETE;
    }

    public void abortClientHandshake(String type) {
        this.completeClientSideConnection(ConnectionType.valueOf(type));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!(cause instanceof ClosedChannelException)) {
            FMLLog.log(Level.ERROR, cause, "NetworkDispatcher exception", new Object[0]);
        }
        super.exceptionCaught(ctx, cause);
    }

    private class VanillaTimeoutWaiter
    extends ChannelInboundHandlerAdapter {
        private ScheduledFuture<Void> future;

        private VanillaTimeoutWaiter() {
        }

        public void handlerAdded(final ChannelHandlerContext ctx) throws Exception {
            this.future = ctx.executor().schedule((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (NetworkDispatcher.this.state != ConnectionState.CONNECTED) {
                        FMLLog.info("Timeout occurred waiting for response, assuming vanilla connection", new Object[0]);
                        ctx.fireUserEventTriggered((Object)ConnectionType.VANILLA);
                    }
                    return null;
                }
            }, 10L, TimeUnit.HOURS);
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            this.future.cancel(true);
        }
    }

    private static enum ConnectionType {
        MODDED,
        BUKKIT,
        VANILLA;

    }

    private static enum ConnectionState {
        OPENING,
        AWAITING_HANDSHAKE,
        HANDSHAKING,
        HANDSHAKECOMPLETE,
        CONNECTED;

    }
}

