/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.gui;

import com.thevoxelbox.voxelmap.VoxelMap;
import com.thevoxelbox.voxelmap.gui.GuiScreenAddWaypoint;
import com.thevoxelbox.voxelmap.gui.overridden.GuiSlotMinimap;
import com.thevoxelbox.voxelmap.util.Dimension;
import com.thevoxelbox.voxelmap.util.DimensionManager;
import com.thevoxelbox.voxelmap.util.GLUtils;
import com.thevoxelbox.voxelmap.util.TranslateUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

class GuiSlotDimensions
extends GuiSlotMinimap {
    private VoxelMap minimap;
    private DimensionManager dimensionManager;
    final GuiScreenAddWaypoint parentGui;

    public GuiSlotDimensions(GuiScreenAddWaypoint par1GuiWaypoints) {
        super(par1GuiWaypoints.minimap.game, par1GuiWaypoints.getWidth(), par1GuiWaypoints.getHeight(), par1GuiWaypoints.getHeight() / 6 + 123 - 14, par1GuiWaypoints.getHeight() / 6 + 164 + 3, 18);
        this.parentGui = par1GuiWaypoints;
        this.setSlotWidth(175);
        this.setLeftRight((this.parentGui.getWidth() - this.slotWidth) / 2, (this.parentGui.getWidth() + this.slotWidth) / 2);
        this.setShowSelectionBox(false);
        this.setShowTopBottomBG(false);
        this.setShowSlotBG(false);
        this.minimap = this.parentGui.minimap;
        this.dimensionManager = this.minimap.dimensionManager;
        this.func_77208_b(this.dimensionManager.dimensions.indexOf(this.dimensionManager.getDimensionByID(this.parentGui.waypoint.dimensions.first())) * this.slotHeight);
    }

    @Override
    protected int getSize() {
        return this.dimensionManager.dimensions.size();
    }

    @Override
    protected void elementClicked(int par1, boolean par2) {
        this.parentGui.setSelectedDimension(this.dimensionManager.dimensions.get(par1));
        int leftEdge = this.parentGui.getWidth() / 2 - this.slotWidth / 2;
        int padding = 4;
        int iconWidth = 16;
        int width = this.slotWidth;
        if (this.mouseX >= leftEdge + width - iconWidth - padding && this.mouseX <= leftEdge + width) {
            this.parentGui.toggleDimensionSelected();
        } else if (par2) {
            Mouse.next();
            this.parentGui.toggleDimensionSelected();
            return;
        }
    }

    @Override
    protected boolean isSelected(int par1) {
        return this.dimensionManager.dimensions.get(par1).equals(this.parentGui.selectedDimension);
    }

    @Override
    protected int getContentHeight() {
        return this.getSize() * 18;
    }

    @Override
    protected void drawBackground() {
    }

    @Override
    protected void overlayBackground(int par1, int par2, int par3, int par4) {
    }

    @Override
    protected void drawSlot(int par1, int par2, int par3, int par4, blz par5Tessellator) {
        Dimension dim = this.dimensionManager.dimensions.get(par1);
        String name = dim.name;
        if (name.equals("notLoaded") || name.equals("failedToLoad")) {
            name = "dimension " + dim.ID + "(" + this.minimap.getWorld().t.getClass().getSimpleName() + ")";
        }
        this.parentGui.a(this.parentGui.getFontRenderer(), dim.name, this.parentGui.getWidth() / 2, par3 + 3, 0xFFFFFF);
        int padding = 4;
        int iconWidth = 16;
        par2 = this.parentGui.getWidth() / 2 - this.slotWidth / 2;
        int width = this.slotWidth;
        if (this.mouseX >= par2 + padding && this.mouseY >= par3 && this.mouseX <= par2 + width + padding && this.mouseY <= par3 + this.slotHeight) {
            String tooltip = null;
            tooltip = this.mouseX >= par2 + width - iconWidth - padding && this.mouseX <= par2 + width ? (this.parentGui.waypoint.dimensions.contains(dim.ID) ? TranslateUtils.getString("minimap.waypoints.dimension.applies") : TranslateUtils.getString("minimap.waypoints.dimension.notapplies")) : null;
            GuiScreenAddWaypoint.setTooltip(this.parentGui, tooltip);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLUtils.img("textures/gui/container/beacon.png");
        int xOffset = this.parentGui.waypoint.dimensions.contains(dim.ID) ? 91 : 113;
        int yOffset = 222;
        this.parentGui.b(par2 + width - iconWidth, par3 - 2, xOffset, yOffset, 16, 16);
    }
}

