/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.FMLInjectionData;
import java.net.URL;
import mods.battlegear2.CommonProxy;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.api.core.BattlegearUtils;
import mods.battlegear2.api.quiver.IArrowFireHandler;
import mods.battlegear2.api.quiver.IQuiverSelection;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.api.weapons.WeaponRegistry;
import mods.battlegear2.gui.BattlegearGUIHandeler;
import mods.battlegear2.items.ItemMBArrow;
import mods.battlegear2.packet.BattlegearPacketHandeler;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import org.apache.logging.log4j.Logger;

@Mod(modid="battlegear2", useMetadata=true, guiFactory="mods.battlegear2.gui.BattlegearGuiFactory")
public class Battlegear {
    @Mod.Instance(value="battlegear2")
    public static Battlegear INSTANCE;
    @SidedProxy(modId="battlegear2", clientSide="mods.battlegear2.client.ClientProxy", serverSide="mods.battlegear2.CommonProxy")
    public static CommonProxy proxy;
    public static final String imageFolder = "battlegear2:textures/";
    public static final String CUSTOM_DAMAGE_SOURCE = "battlegearExtra";
    public static ItemArmor.ArmorMaterial knightArmourMaterial;
    public static boolean battlegearEnabled;
    public static boolean debug;
    public static Logger logger;
    public static BattlegearPacketHandeler packetHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        BattlegearTranslator.setup("/deobfuscation_data-" + FMLInjectionData.data()[4] + ".lzma");
        knightArmourMaterial = EnumHelper.addArmorMaterial((String)"knights.armour", (int)25, (int[])new int[]{3, 7, 5, 3}, (int)15);
        BattlegearConfig.getConfig(new Configuration(event.getSuggestedConfigurationFile()));
        if ((event.getSourceFile().getName().endsWith(".jar") || debug) && event.getSide().isClient()) {
            try {
                Class.forName("mods.mud.ModUpdateDetector").getDeclaredMethod("registerMod", ModContainer.class, URL.class, URL.class).invoke(null, FMLCommonHandler.instance().findContainerFor((Object)this), new URL("https://raw.github.com/Mine-and-blade-admin/Battlegear2/master/battlegear_update.xml"), new URL("https://raw.github.com/Mine-and-blade-admin/Battlegear2/master/changelog.md"));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        logger = event.getModLog();
        proxy.registerKeyHandelers();
        proxy.registerTickHandelers();
        proxy.registerItemRenderers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        BattlegearConfig.registerRecipes();
        QuiverArrowRegistry.addArrowToRegistry(Items.field_151032_g, 0, EntityArrow.class);
        if (BattlegearConfig.MbArrows != null) {
            for (int i = 0; i < ItemMBArrow.arrows.length; ++i) {
                QuiverArrowRegistry.addArrowToRegistry(BattlegearConfig.MbArrows, i, ItemMBArrow.arrows[i]);
            }
        }
        packetHandler = new BattlegearPacketHandeler();
        for (String channel : Battlegear.packetHandler.map.keySet()) {
            FMLEventChannel eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channel);
            eventChannel.register((Object)packetHandler);
            Battlegear.packetHandler.channels.put(channel, eventChannel);
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new BattlegearGUIHandeler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"TConstruct")) {
            proxy.tryUseTConstruct();
        }
    }

    @Mod.EventHandler
    public void onMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message == null) continue;
            boolean success = false;
            if (message.isItemStackMessage()) {
                ItemStack stack = message.getItemStackValue();
                if (stack != null) {
                    if (message.key.equals("Dual")) {
                        if (!BattlegearUtils.checkForRightClickFunction(stack.func_77973_b(), stack)) {
                            WeaponRegistry.addDualWeapon(stack);
                            success = true;
                        }
                    } else if (message.key.equals("MainHand")) {
                        WeaponRegistry.addTwoHanded(stack);
                        success = true;
                    } else if (message.key.equals("OffHand")) {
                        if (!BattlegearUtils.checkForRightClickFunction(stack.func_77973_b(), stack)) {
                            WeaponRegistry.addOffhandWeapon(stack);
                            success = true;
                        }
                    } else if (message.key.startsWith("Arrow:")) {
                        Class<?> clazz = null;
                        try {
                            clazz = Class.forName(message.key.split(":")[1]);
                        }
                        catch (ClassNotFoundException ignored) {
                            // empty catch block
                        }
                        if (clazz != null && EntityArrow.class.isAssignableFrom(clazz)) {
                            QuiverArrowRegistry.addArrowToRegistry(stack, clazz);
                            success = true;
                        }
                    }
                }
            } else if (message.isStringMessage()) {
                try {
                    Class<?> clazz = Class.forName(message.getStringValue());
                    if (clazz != null) {
                        if (message.key.equals("QuiverSelection") && IQuiverSelection.class.isAssignableFrom(clazz)) {
                            QuiverArrowRegistry.addQuiverSelection((IQuiverSelection)clazz.newInstance());
                            success = true;
                        } else if (message.key.equals("FireHandler") && IArrowFireHandler.class.isAssignableFrom(clazz)) {
                            QuiverArrowRegistry.addArrowFireHandler((IArrowFireHandler)clazz.newInstance());
                            success = true;
                        }
                    }
                }
                catch (Exception logged) {
                    // empty catch block
                }
            }
            if (success) {
                logger.trace("Mine&Blade:Battlegear2 successfully managed message from " + message.getSender());
                continue;
            }
            logger.warn(message.getSender() + " tried to communicate with Mine&Blade:Battlegear2, but message was not supported!");
        }
    }

    static {
        battlegearEnabled = true;
        debug = false;
    }
}

