/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.utils;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import net.minecraft.item.ItemDye;

public class ImageData {
    public static final int IMAGE_RES = 32;
    private int[] pixels;
    public static final ImageData defaultImage = new ImageData(ItemDye.field_150922_c[0] | 0xFF000000, ItemDye.field_150922_c[15] | 0xFF000000, ItemDye.field_150922_c[15] | 0xFF000000, ItemDye.field_150922_c[0] | 0xFF000000);
    public static byte[] defaultData = defaultImage.getByteArray();

    public ImageData(int c1, int c2, int c3, int c4) {
        int x;
        int y;
        this.pixels = new int[1024];
        c1 = ImageData.roundColour(c1);
        c2 = ImageData.roundColour(c2);
        c3 = ImageData.roundColour(c3);
        c4 = ImageData.roundColour(c4);
        for (y = 0; y < 16; ++y) {
            for (x = 0; x < 16; ++x) {
                this.pixels[x * 32 + y] = c1;
            }
            for (x = 16; x < 32; ++x) {
                this.pixels[x * 32 + y] = c3;
            }
        }
        for (y = 16; y < 32; ++y) {
            for (x = 0; x < 16; ++x) {
                this.pixels[x * 32 + y] = c2;
            }
            for (x = 16; x < 32; ++x) {
                this.pixels[x * 32 + y] = c4;
            }
        }
    }

    public ImageData(BufferedImage before, int width, int height) {
        BufferedImage scaled = before;
        if (before.getWidth() != width || before.getHeight() != height) {
            scaled = new BufferedImage(width, height, 2);
            AffineTransform at = new AffineTransform();
            at.scale((float)width / (float)before.getWidth(), (float)height / (float)before.getHeight());
            AffineTransformOp scaleOp = new AffineTransformOp(at, 3);
            scaled = scaleOp.filter(before, scaled);
        }
        this.pixels = new int[width * height];
        for (int x = 0; x < scaled.getWidth(); ++x) {
            for (int y = 0; y < scaled.getHeight(); ++y) {
                this.pixels[x + y * width] = ImageData.roundColour(scaled.getRGB(x, y));
            }
        }
    }

    public ImageData(byte[] bytes) {
        this.pixels = new int[bytes.length / 2];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = this.getRgb(bb.getShort(i * 2));
        }
    }

    public ImageData(int[] ints, int imageRes, int imageRes1) {
        this.pixels = ints;
    }

    public byte[] getByteArray() {
        ByteBuffer bb = ByteBuffer.allocate(this.pixels.length * 2);
        for (int i = 0; i < this.pixels.length; ++i) {
            bb.putShort(this.getShortColour(this.pixels[i]));
        }
        return bb.array();
    }

    public static final String getHexArray(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X ", b));
        }
        return sb.toString();
    }

    public static int roundColour(int rgb) {
        return rgb & 0xF0F0F0F0 | 0xF080808;
    }

    private short getShortColour(int rgb) {
        return (short)((rgb & 0xF0000000) >> 16 | (rgb & 0xF00000) >> 12 | (rgb & 0xF000) >> 8 | (rgb & 0xF0) >> 4);
    }

    private int getRgb(short rgb) {
        return (rgb & 0xF000) << 16 | (rgb & 0xF00) << 12 | (rgb & 0xF0) << 8 | (rgb & 0xF) << 4 | 0xF080808;
    }

    public void setTexture(int[] pixalArray) {
        for (int i = 0; i < pixalArray.length; ++i) {
            pixalArray[i] = this.pixels[i];
        }
    }
}

