/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerMethodProcess;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ItemInWorldTransformer
extends TransformerMethodProcess {
    private String entityPlayerClassName;
    private String inventoryPlayerClassName;
    private String itemStackClassName;
    private String playerInventoryFieldName;
    private String mainInventoryArrayFieldName;
    private String setInventorySlotMethodName;
    private String setInventorySlotMethodDesc;

    public ItemInWorldTransformer() {
        super("net.minecraft.server.management.ItemInWorldManager", "func_73085_a", new String[]{"tryUseItem", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;)Z"});
    }

    @Override
    void processMethod(MethodNode mn) {
        this.sendPatchLog("tryUseItem");
        ItemInWorldTransformer.replaceInventoryArrayAccess(mn, this.entityPlayerClassName, this.playerInventoryFieldName, 5, 7);
        InsnList newList = new InsnList();
        for (AbstractInsnNode node : mn.instructions) {
            if (node instanceof FieldInsnNode && ((FieldInsnNode)node).owner.equals(this.inventoryPlayerClassName) && ((FieldInsnNode)node).name.equals(this.mainInventoryArrayFieldName) && ((FieldInsnNode)node).desc.equals("[L" + this.itemStackClassName + ";")) continue;
            if (node.getOpcode() == 83) {
                newList.add((AbstractInsnNode)new MethodInsnNode(182, this.inventoryPlayerClassName, this.setInventorySlotMethodName, this.setInventorySlotMethodDesc));
                continue;
            }
            newList.add(node);
        }
        mn.instructions = newList;
    }

    @Override
    void setupMappings() {
        super.setupMappings();
        this.entityPlayerClassName = BattlegearTranslator.getMapedClassName("entity.player.EntityPlayer");
        this.inventoryPlayerClassName = BattlegearTranslator.getMapedClassName("entity.player.InventoryPlayer");
        this.itemStackClassName = BattlegearTranslator.getMapedClassName("item.ItemStack");
        this.playerInventoryFieldName = BattlegearTranslator.getMapedFieldName("EntityPlayer", "field_71071_by", "inventory");
        this.mainInventoryArrayFieldName = BattlegearTranslator.getMapedFieldName("InventoryPlayer", "field_70462_a", "mainInventory");
        this.setInventorySlotMethodName = BattlegearTranslator.getMapedMethodName("InventoryPlayer", "func_70299_a", "setInventorySlotContents");
        this.setInventorySlotMethodDesc = BattlegearTranslator.getMapedMethodDesc("InventoryPlayer", "func_70299_a", "(IL" + this.itemStackClassName + ";)V");
    }
}

