/*
 * Decompiled with CFR 0.152.
 */
package mods.mud;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mods.mud.ModUpdateDetectorTickHandeler;
import mods.mud.MudCommands;
import mods.mud.UpdateChecker;
import mods.mud.UpdateEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ModUpdateDetector {
    private static boolean hasInitialised = false;
    private static Map<String, UpdateEntry> updateMap;
    public static boolean hasChecked;
    private static Property check;
    public static boolean enabled;
    private static ICommandSender sender;

    public static void registerMod(ModContainer mc, URL updateXML, URL changelog) {
        if (!hasInitialised) {
            ModUpdateDetector.initialise();
            hasInitialised = true;
        }
        updateMap.put(mc.getModId(), new UpdateEntry(mc, updateXML, changelog));
    }

    public static void registerMod(ModContainer mc, String updateXML, String changelog) throws MalformedURLException {
        ModUpdateDetector.registerMod(mc, new URL(updateXML), changelog != null ? new URL(changelog) : null);
    }

    public static void registerMod(Object mod, String updateXML, String changelog) throws MalformedURLException {
        ModUpdateDetector.registerMod(FMLCommonHandler.instance().findContainerFor(mod), updateXML, changelog);
    }

    public static void runUpdateChecker() {
        if (enabled) {
            ICommandSender sender = ModUpdateDetector.getSender();
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"mud.name") + EnumChatFormatting.WHITE + ": " + StatCollector.func_74838_a((String)"message.checking")));
            Thread t = new Thread(new UpdateChecker(updateMap.values()));
            t.run();
        }
    }

    public static Collection<UpdateEntry> getAllUpdateEntries() {
        return updateMap.values();
    }

    private static void initialise() {
        updateMap = new HashMap<String, UpdateEntry>();
        int Timer = 72000;
        try {
            Configuration config = new Configuration(new File(Loader.instance().getConfigDir(), "MUD.cfg"));
            Timer = config.get("general", "Update Time", 60, "The time in minutes between update checks").getInt() * 60 * 20;
            check = config.get("general", "Update Check Enabled", true, "Should MUD automatically check for updates");
            enabled = check.getBoolean(true);
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception handled) {
            handled.printStackTrace();
        }
        FMLCommonHandler.instance().bus().register((Object)new ModUpdateDetectorTickHandeler(Timer));
        ClientCommandHandler.instance.func_71560_a((ICommand)new MudCommands());
    }

    public static void toggleState() {
        enabled = !enabled;
        check.set(enabled);
    }

    public static ICommandSender getSender() {
        if (sender == null) {
            sender = Minecraft.func_71410_x().field_71439_g;
        }
        return sender;
    }

    public static void notifyUpdateDone() {
        ChatComponentTranslation chat;
        ICommandSender sender = ModUpdateDetector.getSender();
        if (sender != null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"mud.name") + EnumChatFormatting.WHITE + ": " + StatCollector.func_74838_a((String)"message.check.done")));
        }
        int outOfDateCount = 0;
        int failedCount = 0;
        for (UpdateEntry e : updateMap.values()) {
            try {
                if (e.isUpToDate()) continue;
                ++outOfDateCount;
            }
            catch (Exception e1) {
                ++failedCount;
            }
        }
        if (outOfDateCount > 0) {
            if (sender != null) {
                chat = new ChatComponentTranslation("message.you.have.outdated", new Object[]{outOfDateCount});
                chat.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                sender.func_145747_a((IChatComponent)chat);
                chat = new ChatComponentTranslation("message.type.to.view", new Object[0]);
                chat.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                sender.func_145747_a((IChatComponent)chat);
            }
        } else if (sender != null) {
            chat = new ChatComponentTranslation("message.up.to.date", new Object[0]);
            chat.func_150256_b().func_150238_a(EnumChatFormatting.DARK_GREEN);
            sender.func_145747_a((IChatComponent)chat);
        }
        hasChecked = true;
    }

    static {
        hasChecked = false;
        enabled = true;
        sender = null;
    }
}

