/*
 * Decompiled with CFR 0.152.
 */
package mods.mud;

import cpw.mods.fml.client.GuiModList;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.List;
import mods.mud.ModUpdateDetector;
import mods.mud.gui.GuiModUpdateButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;

public class ModUpdateDetectorTickHandeler {
    private final int timer_interval;
    private int timer;
    private GuiScreen lastScreen;

    public ModUpdateDetectorTickHandeler(int timer) {
        this.timer_interval = timer;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (this.timer == 0) {
                ModUpdateDetector.runUpdateChecker();
            }
            this.timer = this.timer_interval > 0 ? (this.timer + 1) % this.timer_interval : -1;
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && (Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof GuiIngameMenu || Minecraft.func_71410_x().field_71462_r instanceof GuiModList)) {
            this.lastScreen = Minecraft.func_71410_x().field_71462_r;
            List buttonList = this.getButtonList(this.lastScreen);
            if (buttonList != null) {
                boolean hasMumButton = false;
                for (Object o : buttonList) {
                    if (!(o instanceof GuiModUpdateButton)) continue;
                    hasMumButton = true;
                    break;
                }
                if (!hasMumButton) {
                    int x = this.lastScreen.field_146294_l / 2 + 105;
                    int y = this.lastScreen.field_146295_m / 4 + 8;
                    if (this.lastScreen instanceof GuiModList) {
                        x = this.lastScreen.field_146294_l - 110;
                        y = 10;
                    }
                    buttonList.add(new GuiModUpdateButton(99, x, y, this.lastScreen));
                }
            }
        }
    }

    private List getButtonList(GuiScreen currentScreen) {
        try {
            return (List)ObfuscationReflectionHelper.getPrivateValue(GuiScreen.class, (Object)currentScreen, (String[])new String[]{"buttonList", "field_146292_n"});
        }
        catch (Exception e) {
            return null;
        }
    }
}

