#version 120

const int 		R8 						= 0;
const int 		RGB8 					= 1;
const int 		RGB16 					= 2;
const int 		gcolorFormat 			= RGB8;
const int 		gnormalFormat 			= RGB16;
const int 		compositeFormat 		= RGB8;

/* DRAWBUFFERS:0N2N4 */


const int MAX_OCCLUSION_POINTS = 14;
const float bump_distance = 70.0;
const float pom_distance = 30.0;

uniform sampler2D texture;
uniform sampler2D normals;
uniform sampler2D specular;

uniform float wetness;
uniform int worldTime;
uniform vec3 sunPosition;
uniform vec3 moonPosition;

varying vec3 viewVectorRaw;

varying vec4 color;
varying vec2 texcoord;
varying vec2 lmcoord;

varying vec3 tangent;
varying vec3 normal;
varying vec3 binormal;

varying float translucent;
varying float distance;
varying float test;

/*
const int GL_LINEAR = 9729;
const int GL_EXP = 2048;
uniform int fogMode;
uniform sampler2D lightmap;
*/



const float fademult = 0.1;

void main() {	

	
	vec2 adjustedTexCoord = texcoord.st;
	float texinterval = 0.0625;
	float pomsample = 0.0;
/*	
	vec3 ambient = texture2D(lightmap, vec2(lmcoord.s,0.5/16.)).rgb + texture2D(lightmap, vec2(0.5/16., lmcoord.t)).rgb * 0.6;
*/


	vec3 lightVector;
	if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	} else {
		lightVector = normalize(moonPosition);
	}
	vec3 indlmap = mix(pow(min(lmcoord.t+0.1,1.0),2.0),1.0,lmcoord.s)*texture2D(texture,adjustedTexCoord).rgb*color.rgb;
	gl_FragData[0] = vec4(indlmap,texture2D(texture,adjustedTexCoord).a*color.a);
	

	vec4 frag2 = vec4(vec3(normal) * 0.5 + 0.5, 1.0f);
	float dirtest;
	if (translucent > 0.01) dirtest = 0.4;
	else {
	dirtest = 1.0-0.8*step(dot(frag2.xyz*2.0-1.0,lightVector),-0.02);
	}
	
	
	
	//Specular mapping
	gl_FragData[2] = frag2;	

	vec3 specularity = texture2D(specular,texcoord.xy).rgb;	
	float totalspec = (specularity.r + specularity.g * clamp(wetness, 0.0f, 1.0)/1.0 + specularity.b) * 0.333 * mix(min(lmcoord.t+0.1,1.0),1.0,lmcoord.s);
	
	gl_FragData[4] = vec4(totalspec, dirtest, lmcoord.s, 0.0);
/*	
	float fogFactor; // 0.0 = full fog.  1.0 = no fog.
	if (fogMode == GL_EXP) {
		fogFactor = clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0);
	} else if (fogMode == GL_LINEAR) {
		fogFactor = 1.0 - clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0);
	} else {
		fogFactor = 1.0;
	}
	gl_FragData[1] = vec4(ambient, fogFactor);
*/	
}