#version 120





//#define BOKEH_DOF							//Cannot be applied to water
	//#define HQ_DOF								//Enable for higher quality DOF

    
#define FOG_DENSITY 0.0
  
#define GODRAYS
	#define GODRAYS_EXPOSURE 0.02
	#define GODRAYS_SAMPLES 6
	#define GODRAYS_DECAY 0.99
	#define GODRAYS_DENSITY 0.30

#define LENS								
	#define LENS_POWER 0.26
  
//#define CEL_SHADING
    #define CEL_SHADING_THRESHOLD 0.5
    #define CEL_SHADING_THICKNESS 0.002

//COLOURS
//#define VIGNETTE							// Doesn't work
  #define CROSSPROCESS
  #define HIGHDESATURATE
  #define BANDING_FIX_FACTOR 5.5f	
  #define COLOURFIX							//You better don't disable this.	  
  #define NIGHT_EXPOSURE_BIAS 0.0f
  #define BRIGHTMULT 1.00                 	// 1.0 = default brightness. Higher values mean brighter. 0 would be black.
  #define DARKMULT 0.0						// 0.0 = normal image. Higher values will darken dark colors.
  #define COLOR_BOOST	0.08					// 0.0 = normal saturation. Higher values mean more saturated image.
  #define GAMMA 1.00f						//1.0 is default brightness. lower values will brighten image, higher values will darken image	
//END OF COLOURS

#define WATER_SHADER
	//#define WATER_REFLECTIONS
	//#define REFLECTION_LENGTH 0.9f
	//#define HQ_REFLECTIONS
	#define REFRACT_AMOUNT 0.2f
	#define ABERRATION_AMOUNT 0.105f
	
//#define GLOSSY_REFLECTIONS


//X-CUSTOM-BEGIN
#define REFLECTIONS
#define QUALITY 5.01
#define RANGE 0.55
//X-CUSTOM-END




// DOF Constants - DO NOT CHANGE
// HYPERFOCAL = (Focal Distance ^ 2)/(Circle of Confusion * F Stop) + Focal Distance
#ifdef USE_DOF
const float HYPERFOCAL = 3.132;
const float PICONSTANT = 3.14159;
#endif





//uniform sampler2D texture;
uniform sampler2D gdepth;
uniform sampler2D gdepthtex;
uniform sampler2D gcolor;
uniform sampler2D gnormal;
uniform sampler2D composite;
uniform sampler2D gaux1;
//uniform sampler2D gaux2;
//uniform sampler2D gaux3; 
//uniform sampler2D gaux4; 

varying vec3 lightVector;

uniform mat4 gbufferProjection;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;

uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

uniform vec3 sunPosition;

uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;

uniform int   isEyeInWater;
uniform float eyeAltitude;
uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;

uniform int fogMode;

varying vec4 texcoord;



//Raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);

//Water mask
float iswater = texture2D(gaux1, texcoord.st).g;
float isice   = 0.0f;

float specularity = texture2D(composite, texcoord.st).g;


// Standard depth function.
float getDepth(vec2 coord) {
    return 2.0 * near * far / (far + near - (2.0 * texture2D(gdepth, coord).x - 1.0) * (far - near));
}
float getWaterDepth(vec2 coord) {
    return 2.0 * near * far / (far + near - (2.0 * texture2D(gdepthtex, coord).x - 1.0) * (far - near));
}
float eDepth(vec2 coord) {
	return texture2D(gdepth, coord).x;
}


//Detect materials

	float getMaterial(vec2 coord, const int matID) {		
		float tex = texture2D(composite, coord).r;								//Call the texture carrying material
			  tex *= 255.0f; 												//Scale material info back into 0-255
			  tex = floor(tex);												//Round materials down to make sure they're integers
		
		float isMaterial;													//Create boolean for material mask
		
		if (tex == matID){
			isMaterial = 1.0f;
		} else {
			isMaterial = 0.0f;
		}
		
		return isMaterial;
	}
	
	
//Detect sky

	float getLand(vec2 coord) {		
		float tex = texture2D(composite, coord).r;								//Call the texture carrying material
			  tex *= 255.0f; 												//Scale material info back into 0-255
			  tex = floor(tex);												//Round materials down to make sure they're integers
		
		float isMaterial;													//Create boolean for material mask
		
		if (tex == 0.0f){
			isMaterial = 0.0f;
		} else {
			isMaterial = 1.0f;
		}
		
		return isMaterial;
	}
	
	
	float getWaterSunOcclusion(vec2 coord) {
		float tex = texture2D(composite, coord).r;								//Call the texture carrying material
			  tex *= 255.0f; 												//Scale material info back into 0-255
			  tex = floor(tex);												//Round materials down to make sure they're integers
		
		float isMaterial;													//Create boolean for material mask
		
		if (tex == 8.0f){
			isMaterial = 1.0f;
		} else {
			isMaterial = 0.0f;
		}
		
		return isMaterial;
	}


//Calculate Time of Day

	float timefract = worldTime;
	float timePow = 1000.0f;

	float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
	float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
	float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
	float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);


vec3 albedo = texture2D(gcolor, texcoord.st).rgb;

	
#ifdef BOKEH_DOF

	//compare dof depth function
	float dofWeight(vec2 blur, vec2 coord) {
		float dthresh = 500.0;
		float dthresh2 = 1.0f;
		return (1.0f - (clamp((texture2D(gdepth, texcoord.st).x - texture2D(gdepth, texcoord.st + coord).x) * dthresh, 0.0f, 1.0f)) * (1.0f - clamp(abs(blur.x) * dthresh2, 0.0f, 1.0f)));	
		//return 1.0f;	
	}

#endif

#ifdef GODRAYS

vec3 sunPos = sunPosition;



	float addGodRays(in float nc, in vec2 tx, in float noise, in float noise2, in float noise3, in float noise4, in float noise5, in float noise6, in float noise7, in float noise8, in float noise9) {
			float GDTimeMult = 0.0f;
			if (sunPos.z > 0.0f) {
				sunPos.z = -sunPos.z;
				sunPos.x = -sunPos.x;
				sunPos.y = -sunPos.y;
				GDTimeMult = TimeMidnight;	
			} else {
				GDTimeMult = TimeSunrise + TimeNoon + TimeSunset;
			}
			vec2 lightPos = sunPos.xy / -sunPos.z;
			lightPos.x *= 1.0f/aspectRatio;
			lightPos.xy *= 1.40f;
			lightPos = (lightPos + 1.0f)/2.0f;
			vec2 delta = (tx - lightPos) * GODRAYS_DENSITY / float(2.0);
			delta *= -sunPos.z*0.01f;
			float decay = -sunPos.z / 100.0f;
			float colorGD = 0.0f;
			
			for (int i = 0; i < 2; ++i) {
			
			if (texcoord.s > 1.0f || texcoord.s < 0.0f || texcoord.t > 1.0f || texcoord.t < 0.0f) {
				break;
			}
			
				
				float sample = 0.0f;

					sample = 1.0f - texture2D(composite, tx + vec2(noise*delta.x, noise*delta.y)).b;
					sample += 1.0f - texture2D(composite, tx + vec2(noise2*delta.x, noise2*delta.y)).b;
					sample += 1.0f - texture2D(composite, tx + vec2(noise3*delta.x, noise3*delta.y)).b;
					sample += 1.0f - texture2D(composite, tx + vec2(noise4*delta.x, noise4*delta.y)).b;
					sample += 1.0f - texture2D(composite, tx + vec2(noise5*delta.x, noise5*delta.y)).b;

				sample *= decay;

					colorGD += sample;
					decay *= GODRAYS_DECAY;
					tx -= delta;
			}
	
			return (nc + GODRAYS_EXPOSURE * (colorGD))*GDTimeMult;
	}
#endif 

#ifdef LENS
	
	vec3 DoLens(float scale, vec3 color, float power, float offset, float curve){
			vec3 sP = sunPosition;
			vec3 c;

			vec2 lPos = sP.xy / -sP.z;
			lPos.x *= 1.0f/aspectRatio;
			lPos.xy *= 1.40f;						
			lPos = (lPos + 1.0f)/2.0f;
			
			

			vec2 flare1scale = vec2(1.7f*scale, 1.7f*scale);
			float flare1pow = 12.0f;
			vec2 flare1pos = vec2((1.0f - lPos.x)*(offset + 1.0f) - (offset * 0.5f), (1.0f - lPos.y)*(offset + 1.0f) - (offset * 0.5f)) * vec2(aspectRatio*flare1scale.x, flare1scale.y);
			
			float flare1 = distance(flare1pos, vec2(texcoord.s*aspectRatio*flare1scale.x, texcoord.t*flare1scale.y));
												
			
				  flare1 = 0.5 - flare1;
				  flare1 = clamp(flare1, 0.0, 10.0) * clamp(-sP.z, 0.0, 1.0);
				  flare1 = pow(flare1, curve);
				  
				  flare1 *= flare1pow;
				  
				  	c = flare1 * color * power;
		return c;			
	}

#endif

#ifdef CEL_SHADING
	float getCellShaderFactor(vec2 coord) {
    float d = getDepth(coord);
    vec3 n = normalize(vec3(getDepth(coord+vec2(CEL_SHADING_THICKNESS,0.0))-d,getDepth(coord+vec2(0.0,CEL_SHADING_THICKNESS))-d , CEL_SHADING_THRESHOLD));
    return n.z; 
	}
#endif



//fake albedo
vec3 DoFakeAlbedo(vec3 color) {
	color.rgb *= 90.0f;
	
	//Properties
		float tonemapContrast 		= 0.1f;
		float tonemapSaturation 	= 6.2f; 
		float tonemapDecay			= 400.0f;
		float tonemapCurve			= 0.1f;
		

	color.rgb += 0.001f;
	
	vec3 colorN = normalize(color.rgb);
	
	vec3 clrfr = color.rgb/colorN.rgb;
	     clrfr = pow(clrfr.rgb, vec3(tonemapContrast));
		 
	colorN.rgb = pow(colorN.rgb, vec3(tonemapSaturation));
	
	color.rgb = clrfr.rgb * colorN.rgb;

	return (color.rgb * (1.0 + color.rgb/tonemapDecay))/(color.rgb + tonemapCurve);
}



//X-CUSTOM-ADDON
#ifdef REFLECTIONS

float fresnelPower = 2.5f;
float subpixelRoughness = getWaterDepth(texcoord.st) / far;
float waterWaviness = 2.0f;

vec3 convertScreenSpaceToWorldSpace(vec2 co) {
    vec4 fragposition = gbufferProjectionInverse * vec4(vec3(co, texture2D(gdepthtex, co).x) * 2.0 - 1.0, 1.0);
    fragposition /= fragposition.w;
    return fragposition.xyz;
}

vec3 convertScreenSpaceToWorldSpaceFake(vec2 co) {
    vec4 fragposition = gbufferProjectionInverse * vec4(vec3(co, 0.0f) * 2.0 - 1.0, 1.0);
    fragposition /= fragposition.w;
    return fragposition.xyz;
}

vec3 convertCameraSpaceToScreenSpace(vec3 cameraSpace) {
    vec4 clipSpace = gbufferProjection * vec4(cameraSpace, 1.0);
    vec3 NDCSpace = clipSpace.xyz / clipSpace.w;
    vec3 screenSpace = 0.5 * NDCSpace + 0.5;
		 screenSpace.z = 0.1f;
    return screenSpace;
}



vec4 ComputeFakeSkyReflection(vec3 col, vec2 waves) {

    vec3 cameraSpacePosition = convertScreenSpaceToWorldSpace(texcoord.st);
    vec3 cameraSpaceNormal = texture2D(gnormal, texcoord.st).rgb * 2.0f - 1.0f;
		 cameraSpaceNormal -= vec3(waves, 0.0f) * waterWaviness;
    vec3 cameraSpaceViewDir = normalize(cameraSpacePosition);
	vec4 color = vec4(0.0f);
	
	float skylight = 1.0f;
	   color.rgb = col * skylight;
	   color.a   = pow(clamp(1.0f + dot(cameraSpaceViewDir, cameraSpaceNormal), 0.0f, 1.0f), fresnelPower) * 0.8f + 0.1f;
	   
	return color;
	
}

vec4 ComputeFakeReflection(float noise1, float noise2, float noise3, vec2 waves) {
	
	float stochasticAmount = 0.05f * subpixelRoughness;
    float initialStepAmount = 1.0 - clamp(0.01 / 100.0, 0.0, 0.99);
		  initialStepAmount *= 50.0f;
	float stepRefinementAmount = 0.7f;
	int maxRefinements = 0;
	
    vec2 screenSpacePosition2D = texcoord.st;
    vec3 cameraSpacePosition = convertScreenSpaceToWorldSpaceFake(screenSpacePosition2D);
	
    vec3 cameraSpaceNormal = texture2D(gnormal, screenSpacePosition2D).rgb * 2.0f - 1.0f;
		 cameraSpaceNormal += vec3(noise1, noise2, noise3) * stochasticAmount;
		 cameraSpaceNormal += cameraSpaceNormal * noise1 * stochasticAmount * 0.0f;
		 cameraSpaceNormal += vec3(waves, 0.0f) * 5.0f;
		 
    vec3 cameraSpaceViewDir = normalize(cameraSpacePosition);
    vec3 cameraSpaceVector = initialStepAmount * normalize(reflect(cameraSpaceViewDir,cameraSpaceNormal));
	vec3 oldPosition = cameraSpacePosition;
    vec3 cameraSpaceVectorPosition = oldPosition + cameraSpaceVector;
    vec3 currentPosition = convertCameraSpaceToScreenSpace(cameraSpaceVectorPosition);
    vec4 color = vec4(texture2D(gcolor, screenSpacePosition2D).rgb, 0.0);
	int numRefinements = 0;
    int count = 0;

        vec2 samplePos = currentPosition.xy;
        float sampleDepth = convertScreenSpaceToWorldSpaceFake(samplePos).z;
        float currentDepth = cameraSpaceVectorPosition.z;
        float diff = sampleDepth - currentDepth;
        float error = length(cameraSpaceVector);
        if(diff >= 0 && diff <= error) {
			cameraSpaceVector *= stepRefinementAmount;
			cameraSpaceVectorPosition = oldPosition;
			numRefinements++;
			if(numRefinements >= maxRefinements){
				vec3 normalAtPos = texture2D(gnormal, samplePos).xyz * 2.0 - 1.0;
				float orientation = dot(cameraSpaceVector,normalAtPos);
				color = texture2D(gcolor, samplePos);
				color.a *= pow(clamp(1 + dot(cameraSpaceViewDir,cameraSpaceNormal), 0.0, 1.0), fresnelPower);
				color.a *= clamp(1 - pow(distance(vec2(0.5), samplePos)*2.0, 2.0), 0.0, 2.0);
				//break;
			}
		}
		
		oldPosition = cameraSpaceVectorPosition;
        cameraSpaceVectorPosition += cameraSpaceVector;
		currentPosition = convertCameraSpaceToScreenSpace(cameraSpaceVectorPosition);

	
    return color * vec4(1.0f, 1.0f, 1.0f, 1.0f);
	
}

vec4 ComputeReflection(float noise1, float noise2, float noise3, float specularity) {
	float reflectionRange = RANGE * 0.10f;
	float stochasticAmount = 0.0f;
    float initialStepAmount = 1.0 - clamp(0.01f / 100.0, 0.0, 0.99) + noise1 *  0.0f;
	float stepRefinementAmount = .1;
	int maxRefinements = 0;
	
    vec2 screenSpacePosition2D = texcoord.st;
    vec3 cameraSpacePosition = convertScreenSpaceToWorldSpace(screenSpacePosition2D);
	
    vec3 cameraSpaceNormal = texture2D(gnormal, screenSpacePosition2D).rgb * 2.0f - 1.0f;
		 cameraSpaceNormal += vec3(noise1, noise2, noise3) * stochasticAmount;

    vec3 cameraSpaceViewDir = normalize(cameraSpacePosition);
    vec3 cameraSpaceVector = initialStepAmount * normalize(reflect(cameraSpaceViewDir,cameraSpaceNormal));
	vec3 oldPosition = cameraSpacePosition;
    vec3 cameraSpaceVectorPosition = oldPosition + cameraSpaceVector;
    vec3 currentPosition = convertCameraSpaceToScreenSpace(cameraSpaceVectorPosition);
    vec4 color = vec4(texture2D(gcolor, screenSpacePosition2D).rgb, 0.0);
	int numRefinements = 0;
    int count = 0;

    while(count < far/initialStepAmount*reflectionRange)
    {
        if(currentPosition.x < 0 || currentPosition.x > 1 ||
           currentPosition.y < 0 || currentPosition.y > 1 ||
           currentPosition.z < 0 || currentPosition.z > 1) { 

		   break;
		   
		   }

        vec2 samplePos = currentPosition.xy;
        float sampleDepth = convertScreenSpaceToWorldSpace(samplePos).z;
        float currentDepth = cameraSpaceVectorPosition.z;
        float diff = sampleDepth - currentDepth;
        float error = length(cameraSpaceVector);
        if(diff >= 0 && diff <= error) {
			cameraSpaceVector *= stepRefinementAmount;
			cameraSpaceVectorPosition = oldPosition;
			numRefinements++;
				color = texture2D(gcolor, samplePos);
				color.a *= mix(pow(clamp(1 + dot(cameraSpaceViewDir,cameraSpaceNormal), 0.0, 2.0), 3.0f), 1.0f, 0.1f);
				color.a *= clamp(1 - pow(distance(vec2(0.5), samplePos)*2.0, 2.0), 0.0, 1.0);
				break;

		}
		
		cameraSpaceVector *= 2.5f;	//Each step gets bigger
		
		oldPosition = cameraSpaceVectorPosition;
        cameraSpaceVectorPosition += cameraSpaceVector;
		currentPosition = convertCameraSpaceToScreenSpace(cameraSpaceVectorPosition);
        count++;
    }
	
	
    return color;
}

vec4 ComputeWaterReflection(float noise1, float noise2, float noise3, vec2 waves, vec2 offset) {
	float reflectionRange = RANGE * 0.45f;
	float stochasticAmount = 0.0f * subpixelRoughness + 0.00f;
    float initialStepAmount = 1.0 - clamp(0.01f / 100.0, 0.0, 0.99) + noise1 *  0.0f;
		  initialStepAmount *= 2.0f;
	float stepRefinementAmount = .1;
	int maxRefinements = 0;
	
    vec2 screenSpacePosition2D = texcoord.st + offset * 1.0f;
    vec3 cameraSpacePosition = convertScreenSpaceToWorldSpace(screenSpacePosition2D);
	
    vec3 cameraSpaceNormal = texture2D(gnormal, screenSpacePosition2D).rgb * 2.0f - 1.0f;
		 cameraSpaceNormal += vec3(noise1, noise2, noise3) * stochasticAmount;
		 cameraSpaceNormal += cameraSpaceNormal * noise1 * stochasticAmount * 0.0f;
		 cameraSpaceNormal -= vec3(waves, -(1.0f - normalize(distance(waves, vec2(0.0f)))) * 0.0f) * waterWaviness;
		 cameraSpaceNormal += vec3(offset, 0.0f) * 0.0f;
		 
    vec3 cameraSpaceViewDir = normalize(cameraSpacePosition);
    vec3 cameraSpaceVector = initialStepAmount * normalize(reflect(cameraSpaceViewDir,cameraSpaceNormal));
	vec3 oldPosition = cameraSpacePosition;
    vec3 cameraSpaceVectorPosition = oldPosition + cameraSpaceVector;
    vec3 currentPosition = convertCameraSpaceToScreenSpace(cameraSpaceVectorPosition);
    vec4 color = vec4(texture2D(gcolor, screenSpacePosition2D).rgb, 0.0);
	int numRefinements = 0;
    int count = 0;

    while(count < far/initialStepAmount*reflectionRange)
    {
        if(currentPosition.x < 0 || currentPosition.x > 1 ||
           currentPosition.y < 0 || currentPosition.y > 1 ||
           currentPosition.z < 0 || currentPosition.z > 1) { 

		   break;
		   
		   }

        vec2 samplePos = currentPosition.xy;
        float sampleDepth = convertScreenSpaceToWorldSpace(samplePos).z;
        float currentDepth = cameraSpaceVectorPosition.z;
        float diff = sampleDepth - currentDepth;
        float error = length(cameraSpaceVector);
        if(diff >= 0 && diff <= error) {
			cameraSpaceVector *= stepRefinementAmount;
			cameraSpaceVectorPosition = oldPosition;
			numRefinements++;

				color = texture2D(gcolor, samplePos);
				color.a *= clamp(1 - pow(distance(vec2(0.5), samplePos)*2.0, 2.0), 0.0, 1.0);
				break;

		}
		
		cameraSpaceVector *= 1.25f;	//Each step gets bigger
		
		oldPosition = cameraSpaceVectorPosition;
        cameraSpaceVectorPosition += cameraSpaceVector;
		currentPosition = convertCameraSpaceToScreenSpace(cameraSpaceVectorPosition);
        count++;
    }
	
    return color;
}
#endif
//X-CUSTON-END


// Main --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void main() {

	vec4 color = texture2D(gcolor, texcoord.st);
	


	//Attempt to hide LDR artifacts
		color.r = pow(color.r, BANDING_FIX_FACTOR);
		color.g = pow(color.g, BANDING_FIX_FACTOR);
		color.b = pow(color.b, BANDING_FIX_FACTOR);
	
	int iswater;
	
	if(texture2D(gaux1, texcoord.st).r > 0.15f){
		iswater = 1;
	} else {
		iswater = 0;
	}
	
	//Land/sky mask
	float land = getLand(texcoord.st);
	
	//Eye sky factor
	float eyeSkylightFactor = eyeBrightnessSmooth.y / 16.0f;
	
		  eyeSkylightFactor = min(eyeSkylightFactor, 16.0f) / 16.0f;
	
	
//Curve times
		  TimeSunrise  = pow(TimeSunrise, timePow);
		  TimeNoon     = pow(TimeNoon, 1.0f/timePow);
		  TimeSunset   = pow(TimeSunset, timePow);
		  TimeMidnight = pow(TimeMidnight, 1.0f/timePow);
	
//Common variables

	float depth = eDepth(texcoord.xy);
	vec2 Texcoord2 = texcoord.st;
	float linDepth = getDepth(texcoord.st);
	vec3 normal = texture2D(gnormal, texcoord.st).rgb;
	vec3 normalBiased = normal * 2.0f - 1.0f;
	
	
	
//Fragposition
	vec4 currentPosition = vec4(texcoord.x * 2.0f - 1.0f, texcoord.y * 2.0f - 1.0f, 2.0f * depth - 1.0f, 1.0f);

	vec4 fragposition = gbufferProjectionInverse * vec4(texcoord.s * 2.0f - 1.0f, texcoord.t * 2.0f - 1.0f, 2.0f * texture2D(gdepth, texcoord.st).x - 1.0f, 1.0f);
	fragposition /= fragposition.w;
	
	vec3 npos = normalize(fragposition.xyz);
	
	vec3 specular = reflect(npos, normalBiased);


	
const float rayleigh = 0.0f;

//colors for shadows/sunlight and sky
	
	vec3 sunrise_sun;
	 sunrise_sun.r = 1.0 * TimeSunrise;
	 sunrise_sun.g = 0.46 * TimeSunrise;
	 sunrise_sun.b = 0.00 * TimeSunrise;
	
	vec3 sunrise_amb;
	 sunrise_amb.r = 0.00 * TimeSunrise;
	 sunrise_amb.g = 0.23 * TimeSunrise;
	 sunrise_amb.b = 0.999 * TimeSunrise;	 
	 
	
	vec3 noon_sun;
	 noon_sun.r = mix(1.00, 1.00, rayleigh) * TimeNoon;
	 noon_sun.g = mix(1.00, 0.48, rayleigh) * TimeNoon;
	 noon_sun.b = mix(0.98, 0.00, rayleigh) * TimeNoon;	 
	
	
	vec3 noon_amb;
	 noon_amb.r = 0.00 * TimeNoon * 1.0;
	 noon_amb.g = 0.18 * TimeNoon * 1.0;
	 noon_amb.b = 0.999 * TimeNoon * 1.0;
	
	vec3 sunset_sun;
	 sunset_sun.r = 1.0 * TimeSunset;
	 sunset_sun.g = 0.38 * TimeSunset;
	 sunset_sun.b = 0.0 * TimeSunset;
	
	vec3 sunset_amb;
	 sunset_amb.r = 0.252 * TimeSunset;
	 sunset_amb.g = 0.427 * TimeSunset;
	 sunset_amb.b = 0.999 * TimeSunset;
	
	vec3 midnight_sun;
	 midnight_sun.r = 0.45 * 0.8 * 0.325 * TimeMidnight;
	 midnight_sun.g = 0.6 * 0.8 * 0.325 * TimeMidnight;
	 midnight_sun.b = 0.8 * 0.8 * 0.325 * TimeMidnight;
	
	vec3 midnight_amb;
	 midnight_amb.r = 0.3 * 0.005 * TimeMidnight;
	 midnight_amb.g = 0.4 * 0.005 * TimeMidnight;
	 midnight_amb.b = 0.8 * 0.005 * TimeMidnight;


	vec3 sunlight_color;
	 sunlight_color.r = sunrise_sun.r + noon_sun.r + sunset_sun.r + midnight_sun.r;
	 sunlight_color.g = sunrise_sun.g + noon_sun.g + sunset_sun.g + midnight_sun.g;
	 sunlight_color.b = sunrise_sun.b + noon_sun.b + sunset_sun.b + midnight_sun.b;
	
	vec3 ambient_color;
	 ambient_color.r = sunrise_amb.r + noon_amb.r + sunset_amb.r + midnight_amb.r;
	 ambient_color.g = sunrise_amb.g + noon_amb.g + sunset_amb.g + midnight_amb.g;
	 ambient_color.b = sunrise_amb.b + noon_amb.b + sunset_amb.b + midnight_amb.b;
	 
	vec3 reflected_color;
	 reflected_color = mix(sunlight_color, ambient_color, 0.5f);
	 
	vec3 ambfill_color;
	 ambfill_color = mix(sunlight_color, ambient_color, 0.55f);
	 
	 
	vec3 skycolor = mix(sunlight_color, vec3(1.0f), 0.5f);
	 
	 float sun_fill = 0.251f * (1.0f - TimeMidnight);
	
	 ambient_color = mix(ambient_color, sunlight_color, sun_fill);
	 vec3 ambient_color_rain = vec3(0.09, 0.09, 0.09) * (1.0f - TimeMidnight * 0.95f); //rain
	 ambient_color = mix(ambient_color, ambient_color_rain, rainx); //rain
	 
	 //Linearize colors
	 
	 ambient_color = pow(ambient_color, vec3(0.454545f));
	 sunlight_color = pow(sunlight_color, vec3(1.454545f));
	 reflected_color = pow(reflected_color, vec3(0.454545f));
	 ambfill_color = pow(ambfill_color, vec3(0.454545f));


const float noiseamp = 5.5f;



						const float width3 = 2.0f;
						const float height3 = 2.0f;
						float noiseX3 = ((fract(1.0f-Texcoord2.s*(width3/2.0f))*0.25f)+(fract(Texcoord2.t*(height3/2.0f))*0.75f))*2.0f-1.0f;

						
							noiseX3 = clamp(fract(sin(dot(Texcoord2 ,vec2(18.9898f,28.633f))) * 4378.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX3 *= (0.10f*noiseamp);

						const float width2 = 1.0f;
						const float height2 = 1.0f;
						float noiseX2 = ((fract(1.0f-Texcoord2.s*(width2/2.0f))*0.25f)+(fract(Texcoord2.t*(height2/2.0f))*0.75f))*2.0f-1.0f;
						float noiseY2 = ((fract(1.0f-Texcoord2.s*(width2/2.0f))*0.75f)+(fract(Texcoord2.t*(height2/2.0f))*0.25f))*2.0f-1.0f;

						
							noiseX2 = clamp(fract(sin(dot(Texcoord2 ,vec2(12.9898f,78.233f))) * 43758.5453f),0.0f,1.0f)*2.0f-1.0f;
							noiseY2 = clamp(fract(sin(dot(Texcoord2 ,vec2(12.9898f,78.233f)*2.0f)) * 43758.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX2 *= (0.10f*noiseamp);
						noiseY2 *= (0.10f*noiseamp);
						

						const float width4 = 3.0f;
						const float height4 = 3.0f;
						float noiseX4 = ((fract(1.0f-Texcoord2.s*(width4/2.0f))*0.25f)+(fract(Texcoord2.t*(height4/2.0f))*0.75f))*2.0f-1.0f;
						float noiseY4 = ((fract(1.0f-Texcoord2.s*(width4/2.0f))*0.75f)+(fract(Texcoord2.t*(height4/2.0f))*0.25f))*2.0f-1.0f;

						
							noiseX4 = clamp(fract(sin(dot(Texcoord2 ,vec2(16.9898f,38.633f))) * 41178.5453f),0.0f,1.0f)*2.0f-1.0f;
							noiseY4 = clamp(fract(sin(dot(Texcoord2 ,vec2(21.9898f,66.233f)*2.0f)) * 9758.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX4 *= (0.10f*noiseamp);
						noiseY4 *= (0.10f*noiseamp);	

						const float width5 = 4.0f;
						const float height5 = 4.0f;
						float noiseX5 = ((fract(1.0f-Texcoord2.s*(width5/2.0f))*0.25f)+(fract(Texcoord2.t*(height5/2.0f))*0.75f))*2.0f-1.0f;
						float noiseY5 = ((fract(1.0f-Texcoord2.s*(width5/2.0f))*0.75f)+(fract(Texcoord2.t*(height5/2.0f))*0.25f))*2.0f-1.0f;

						
							noiseX5 = clamp(fract(sin(dot(Texcoord2 ,vec2(11.9898f,68.633f))) * 21178.5453f),0.0f,1.0f)*2.0f-1.0f;
							noiseY5 = clamp(fract(sin(dot(Texcoord2 ,vec2(26.9898f,71.233f)*2.0f)) * 6958.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX5 *= (0.10f*noiseamp);
						noiseY5 *= (0.10f*noiseamp);							
						
						const float width6 = 4.0f;
						const float height6 = 4.0f;
						float noiseX6 = ((fract(1.0f-Texcoord2.s*(width6/2.0f))*0.25f)+(fract(Texcoord2.t*(height6/2.0f))*0.75f))*2.0f-1.0f;
						float noiseY6 = ((fract(1.0f-Texcoord2.s*(width6/2.0f))*0.75f)+(fract(Texcoord2.t*(height6/2.0f))*0.25f))*2.0f-1.0f;

						
							noiseX6 = clamp(fract(sin(dot(Texcoord2 ,vec2(21.9898f,78.633f))) * 29178.5453f),0.0f,1.0f)*2.0f-1.0f;
							noiseY6 = clamp(fract(sin(dot(Texcoord2 ,vec2(36.9898f,81.233f)*2.0f)) * 16958.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX6 *= (0.10f*noiseamp);
						noiseY6 *= (0.10f*noiseamp);						
					
						float width7 = 6.0;
						float height7 = 6.0;
						float noiseX7 = ((fract(1.0-Texcoord2.s*(width7/2.0))*0.25)+(fract(Texcoord2.t*(height7/2.0))*0.75))*2.0-1.0;
						float noiseY7 = ((fract(1.0-Texcoord2.s*(width7/2.0))*0.75)+(fract(Texcoord2.t*(height7/2.0))*0.25))*2.0-1.0;

						
							noiseX7 = clamp(fract(sin(dot(Texcoord2 ,vec2(12.9898,44.633))) * 51178.5453),0.0,1.0)*2.0-1.0;
							noiseY7 = clamp(fract(sin(dot(Texcoord2 ,vec2(43.9898,61.233)*2.0)) * 9958.5453),0.0,1.0)*2.0-1.0;
						
						noiseX7 *= (0.10f*noiseamp);
						noiseY7 *= (0.10f*noiseamp);
						
						float width8 = 7.0;
						float height8 = 7.0;
						float noiseX8 = ((fract(1.0-Texcoord2.s*(width8/2.0))*0.25)+(fract(Texcoord2.t*(height8/2.0))*0.75))*2.0-1.0;
						float noiseY8 = ((fract(1.0-Texcoord2.s*(width8/2.0))*0.75)+(fract(Texcoord2.t*(height8/2.0))*0.25))*2.0-1.0;

						
							noiseX8 = clamp(fract(sin(dot(Texcoord2 ,vec2(14.9898,47.633))) * 51468.5453),0.0,1.0)*2.0-1.0;
							noiseY8 = clamp(fract(sin(dot(Texcoord2 ,vec2(13.9898,81.233)*2.0)) * 6388.5453),0.0,1.0)*2.0-1.0;
						
						noiseX8 *= (0.10f*noiseamp);
						noiseY8 *= (0.10f*noiseamp);
						
						float width9 = 8.0;
						float height9 = 8.0;
						float noiseX9 = ((fract(1.0-Texcoord2.s*(width9/2.0))*0.25)+(fract(Texcoord2.t*(height9/2.0))*0.75))*2.0-1.0;
						float noiseY9 = ((fract(1.0-Texcoord2.s*(width9/2.0))*0.75)+(fract(Texcoord2.t*(height9/2.0))*0.25))*2.0-1.0;

						
							noiseX9 = clamp(fract(sin(dot(Texcoord2 ,vec2(24.9898,59.633))) * 55468.5453),0.0,1.0)*2.0-1.0;
							noiseY9 = clamp(fract(sin(dot(Texcoord2 ,vec2(23.9898,95.233)*2.0)) * 16388.5453),0.0,1.0)*2.0-1.0;
						
						noiseX9 *= (0.10f*noiseamp);
						noiseY9 *= (0.10f*noiseamp);
						
						float width10 = 9.0;
						float height10 = 9.0;
						float noiseX10 = ((fract(1.0-Texcoord2.s*(width10/2.0))*0.25)+(fract(Texcoord2.t*(height10/2.0))*0.75))*2.0-1.0;
						float noiseY10 = ((fract(1.0-Texcoord2.s*(width10/2.0))*0.75)+(fract(Texcoord2.t*(height10/2.0))*0.25))*2.0-1.0;

						
							noiseX10 = clamp(fract(sin(dot(Texcoord2 ,vec2(26.9898,59.633))) * 57468.5453),0.0,1.0)*2.0-1.0;
							noiseY10 = clamp(fract(sin(dot(Texcoord2 ,vec2(25.9898,95.233)*2.0)) * 18388.5453),0.0,1.0)*2.0-1.0;
						
						noiseX10 *= (0.10f*noiseamp);
						noiseY10 *= (0.10f*noiseamp);
					
					
						float width11 = 10.0;
						float height11 = 10.0;
						float noiseX11 = ((fract(1.0-Texcoord2.s*(width11/2.0))*0.25)+(fract(Texcoord2.t*(height11/2.0))*0.75))*2.0-1.0;
						float noiseY11 = ((fract(1.0-Texcoord2.s*(width11/2.0))*0.75)+(fract(Texcoord2.t*(height11/2.0))*0.25))*2.0-1.0;

						
							noiseX11 = clamp(fract(sin(dot(Texcoord2 ,vec2(28.9898,61.633))) * 59468.5453),0.0,1.0)*2.0-1.0;
							noiseY11 = clamp(fract(sin(dot(Texcoord2 ,vec2(26.9898,97.233)*2.0)) * 21388.5453),0.0,1.0)*2.0-1.0;
						
						noiseX11 *= (0.10f*noiseamp);
						noiseY11 *= (0.10f*noiseamp);
						
						float width12 = 11.0;
						float height12 = 11.0;
						float noiseX12 = ((fract(1.0-Texcoord2.s*(width12/2.0))*0.25)+(fract(Texcoord2.t*(height12/2.0))*0.75))*2.0-1.0;
						float noiseY12 = ((fract(1.0-Texcoord2.s*(width12/2.0))*0.75)+(fract(Texcoord2.t*(height12/2.0))*0.25))*2.0-1.0;

						
							noiseX12 = clamp(fract(sin(dot(Texcoord2 ,vec2(30.9898,64.633))) * 61468.5453),0.0,1.0)*2.0-1.0;
							noiseY12 = clamp(fract(sin(dot(Texcoord2 ,vec2(34.9898,99.233)*2.0)) * 23388.5453),0.0,1.0)*2.0-1.0;
						
						noiseX12 *= (0.10f*noiseamp);
						noiseY12 *= (0.10f*noiseamp);		

						float width13 = 12.0;
						float height13 = 12.0;
						float noiseX13 = ((fract(1.0-Texcoord2.s*(width13/2.0))*0.25)+(fract(Texcoord2.t*(height13/2.0))*0.75))*2.0-1.0;
						float noiseY13 = ((fract(1.0-Texcoord2.s*(width13/2.0))*0.75)+(fract(Texcoord2.t*(height13/2.0))*0.25))*2.0-1.0;

						
							noiseX13 = clamp(fract(sin(dot(Texcoord2 ,vec2(32.9898,66.633))) * 63468.5453),0.0,1.0)*2.0-1.0;
							noiseY13 = clamp(fract(sin(dot(Texcoord2 ,vec2(36.9898,101.233)*2.0)) * 25388.5453),0.0,1.0)*2.0-1.0;
						
						noiseX13 *= (0.10f*noiseamp);
						noiseY13 *= (0.10f*noiseamp);		

						float width14 = 13.0;
						float height14 = 13.0;
						float noiseX14 = ((fract(1.0-Texcoord2.s*(width14/2.0))*0.25)+(fract(Texcoord2.t*(height14/2.0))*0.75))*2.0-1.0;
						float noiseY14 = ((fract(1.0-Texcoord2.s*(width14/2.0))*0.75)+(fract(Texcoord2.t*(height14/2.0))*0.25))*2.0-1.0;

						
							noiseX14 = clamp(fract(sin(dot(Texcoord2 ,vec2(34.9898,68.633))) * 65468.5453),0.0,1.0)*2.0-1.0;
							noiseY14 = clamp(fract(sin(dot(Texcoord2 ,vec2(38.9898,103.233)*2.0)) * 27388.5453),0.0,1.0)*2.0-1.0;
						
						noiseX14 *= (0.10f*noiseamp);
						noiseY14 *= (0.10f*noiseamp);	

						float width15 = 14.0;
						float height15 = 14.0;
						float noiseX15 = ((fract(1.0-Texcoord2.s*(width15/2.0))*0.25)+(fract(Texcoord2.t*(height15/2.0))*0.75))*2.0-1.0;
						float noiseY15 = ((fract(1.0-Texcoord2.s*(width15/2.0))*0.75)+(fract(Texcoord2.t*(height15/2.0))*0.25))*2.0-1.0;

						
							noiseX15 = clamp(fract(sin(dot(Texcoord2 ,vec2(36.9898,70.633))) * 67468.5453),0.0,1.0)*2.0-1.0;
							noiseY15 = clamp(fract(sin(dot(Texcoord2 ,vec2(40.9898,105.233)*2.0)) * 29388.5453),0.0,1.0)*2.0-1.0;
						
						noiseX15 *= (0.10f*noiseamp);
						noiseY15 *= (0.10f*noiseamp);	

						float width16 = 15.0;
						float height16 = 15.0;
						float noiseX16 = ((fract(1.0-Texcoord2.s*(width16/2.0))*0.25)+(fract(Texcoord2.t*(height16/2.0))*0.75))*2.0-1.0;
						float noiseY16 = ((fract(1.0-Texcoord2.s*(width16/2.0))*0.75)+(fract(Texcoord2.t*(height16/2.0))*0.25))*2.0-1.0;

						
							noiseX16 = clamp(fract(sin(dot(Texcoord2 ,vec2(38.9898,72.633))) * 69468.5453),0.0,1.0)*2.0-1.0;
							noiseY16 = clamp(fract(sin(dot(Texcoord2 ,vec2(42.9898,107.233)*2.0)) * 31388.5453),0.0,1.0)*2.0-1.0;
						
						noiseX16 *= (0.10f*noiseamp);
						noiseY16 *= (0.10f*noiseamp);		

						float width17 = 16.0;
						float height17 = 16.0;
						float noiseX17 = ((fract(1.0-Texcoord2.s*(width17/2.0))*0.25)+(fract(Texcoord2.t*(height17/2.0))*0.75))*2.0-1.0;
						float noiseY17 = ((fract(1.0-Texcoord2.s*(width17/2.0))*0.75)+(fract(Texcoord2.t*(height17/2.0))*0.25))*2.0-1.0;

						
							noiseX17 = clamp(fract(sin(dot(Texcoord2 ,vec2(40.9898,74.633))) * 70468.5453),0.0,1.0)*2.0-1.0;
							noiseY17 = clamp(fract(sin(dot(Texcoord2 ,vec2(44.9898,109.233)*2.0)) * 33388.5453),0.0,1.0)*2.0-1.0;
						
						noiseX17 *= 0.002;
						noiseY17 *= 0.002;

						float width18 = 17.0;
						float height18 = 17.0;
						float noiseX18 = ((fract(1.0-Texcoord2.s*(width18/2.0))*0.25)+(fract(Texcoord2.t*(height18/2.0))*0.75))*2.0-1.0;
						float noiseY18 = ((fract(1.0-Texcoord2.s*(width18/2.0))*0.75)+(fract(Texcoord2.t*(height18/2.0))*0.25))*2.0-1.0;

						
							noiseX18 = clamp(fract(sin(dot(Texcoord2 ,vec2(42.9898,76.633))) * 72468.5453),0.0,1.0)*2.0-1.0;
							noiseY18 = clamp(fract(sin(dot(Texcoord2 ,vec2(46.9898,111.233)*2.0)) * 35388.5453),0.0,1.0)*2.0-1.0;
						
						noiseX18 *= 0.002;
						noiseY18 *= 0.002;	

						float width19 = 18.0;
						float height19 = 18.0;
						float noiseX19 = ((fract(1.0-Texcoord2.s*(width19/2.0))*0.25)+(fract(Texcoord2.t*(height19/2.0))*0.75))*2.0-1.0;
						float noiseY19 = ((fract(1.0-Texcoord2.s*(width19/2.0))*0.75)+(fract(Texcoord2.t*(height19/2.0))*0.25))*2.0-1.0;

						
							noiseX19 = clamp(fract(sin(dot(Texcoord2 ,vec2(44.9898,78.633))) * 75468.5453),0.0,1.0)*2.0-1.0;
							noiseY19 = clamp(fract(sin(dot(Texcoord2 ,vec2(48.9898,115.233)*2.0)) * 38388.5453),0.0,1.0)*2.0-1.0;
						
						noiseX19 *= 0.002;
						noiseY19 *= 0.002;		

						float width20 = 19.0;
						float height20 = 19.0;
						float noiseX20 = ((fract(1.0-Texcoord2.s*(width20/2.0))*0.25)+(fract(Texcoord2.t*(height20/2.0))*0.75))*2.0-1.0;
						float noiseY20 = ((fract(1.0-Texcoord2.s*(width20/2.0))*0.75)+(fract(Texcoord2.t*(height20/2.0))*0.25))*2.0-1.0;

						
							noiseX20 = clamp(fract(sin(dot(Texcoord2 ,vec2(46.9898,81.633))) * 77468.5453),0.0,1.0)*2.0-1.0;
							noiseY20 = clamp(fract(sin(dot(Texcoord2 ,vec2(51.9898,118.233)*2.0)) * 41188.5453),0.0,1.0)*2.0-1.0;
						
						noiseX20 *= 0.002;
						noiseY20 *= 0.002;		

#ifdef BOKEH_DOF
	
	if (depth > 0.9999f) {
		depth = 1.0f;
	}
	

	float cursorDepth = eDepth(vec2(0.5f, 0.5f));
	
	if (cursorDepth > 0.9999f) {
		cursorDepth = 1.0f;
	}
	
float blurclamp = 0.014;  // max blur amount
float bias = 0.3;	//aperture - bigger values for shallower depth of field

	
	
	vec2 aspectcorrect = vec2(1.0, aspectRatio) * 1.5;
	
	float factor = (depth - cursorDepth);
	 
	vec2 dofblur = (vec2 (clamp( factor * bias, -blurclamp, blurclamp )))*0.6;

	
	#ifdef HQ_DOF
	


	//HQ
	vec3 col = vec3(0.0);
	float dweight;
	float dweightall;
	
	col += texture2D(gcolor, texcoord.st).rgb;
						  
						  
						dweight =   dofWeight(dofblur, (vec2( 0.0, 0.4)*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.0, 0.4)*aspectcorrect) * dofblur).rgb * dweight;

						dweight =   dofWeight(dofblur, (vec2( 0.15,0.37 )*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.15,0.37 )*aspectcorrect) * dofblur).rgb * dweight;
						
						dweight =   dofWeight(dofblur, (vec2( 0.29,0.29 )*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.29,0.29 )*aspectcorrect) * dofblur).rgb * dweight;

						dweight =   dofWeight(dofblur, (vec2( -0.37,0.15 )*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.37,0.15 )*aspectcorrect) * dofblur).rgb * dweight;

						dweight =   dofWeight(dofblur, (vec2( 0.4,0.0 )*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.4,0.0 )*aspectcorrect) * dofblur).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( 0.37,-0.15 )*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.37,-0.15 )*aspectcorrect) * dofblur).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( 0.29,-0.29 )*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.29,-0.29 )*aspectcorrect) * dofblur).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( -0.15,-0.37 )*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.15,-0.37 )*aspectcorrect) * dofblur).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( 0.0,-0.4 )*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.0,-0.4 )*aspectcorrect) * dofblur).rgb * dweight;	
	
						dweight =   dofWeight(dofblur, (vec2( -0.15,0.37 )*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.15,0.37 )*aspectcorrect) * dofblur).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( -0.29,0.29 )*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.29,0.29 )*aspectcorrect) * dofblur).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( 0.37,0.15 )*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.37,0.15 )*aspectcorrect) * dofblur).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( -0.4,0.0 )*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.4,0.0 )*aspectcorrect) * dofblur).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( -0.37,-0.15 )*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.37,-0.15 )*aspectcorrect) * dofblur).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( -0.29,-0.29 )*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.29,-0.29 )*aspectcorrect) * dofblur).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( 0.15,-0.37 )*aspectcorrect) * dofblur);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.15,-0.37 )*aspectcorrect) * dofblur).rgb * dweight;
	
	
	
						dweight =   dofWeight(dofblur, (vec2( 0.15,0.37 )*aspectcorrect) * dofblur*0.9);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.15,0.37 )*aspectcorrect) * dofblur*0.9).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( -0.37,0.15 )*aspectcorrect) * dofblur*0.9);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.37,0.15 )*aspectcorrect) * dofblur*0.9).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( 0.37,-0.15 )*aspectcorrect) * dofblur*0.9);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.37,-0.15 )*aspectcorrect) * dofblur*0.9).rgb * dweight;	
	
						dweight =   dofWeight(dofblur, (vec2( -0.15,-0.37 )*aspectcorrect) * dofblur*0.9);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.15,-0.37 )*aspectcorrect) * dofblur*0.9).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( -0.15,0.37 )*aspectcorrect) * dofblur*0.9);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.15,0.37 )*aspectcorrect) * dofblur*0.9).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( 0.37,-0.15 )*aspectcorrect) * dofblur*0.9);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.37,-0.15 )*aspectcorrect) * dofblur*0.9).rgb * dweight;	
	
						dweight =   dofWeight(dofblur, (vec2( -0.37,-0.15 )*aspectcorrect) * dofblur*0.9);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.37,-0.15 )*aspectcorrect) * dofblur*0.9).rgb * dweight;	
	
						dweight =   dofWeight(dofblur, (vec2( 0.15,-0.37 )*aspectcorrect) * dofblur*0.9);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.15,-0.37 )*aspectcorrect) * dofblur*0.9).rgb * dweight;	
	
	
	
						dweight =   dofWeight(dofblur, (vec2( 0.37,-0.15 )*aspectcorrect) * dofblur*0.7);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.37,-0.15 )*aspectcorrect) * dofblur*0.7).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( 0.4,0.0 )*aspectcorrect) * dofblur*0.7);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.4,0.0 )*aspectcorrect) * dofblur*0.7).rgb * dweight;	
	
						dweight =   dofWeight(dofblur, (vec2( 0.29,-0.29 )*aspectcorrect) * dofblur*0.7);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.29,-0.29 )*aspectcorrect) * dofblur*0.7).rgb * dweight;	
	
						dweight =   dofWeight(dofblur, (vec2( 0.0,-0.4 )*aspectcorrect) * dofblur*0.7);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.0,-0.4 )*aspectcorrect) * dofblur*0.7).rgb * dweight;	
	
						dweight =   dofWeight(dofblur, (vec2( -0.29,0.29 )*aspectcorrect) * dofblur*0.7);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.29,0.29 )*aspectcorrect) * dofblur*0.7).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( -0.4,0.0 )*aspectcorrect) * dofblur*0.7);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.4,0.0 )*aspectcorrect) * dofblur*0.7).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( -0.29,-0.29 )*aspectcorrect) * dofblur*0.7);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.29,-0.29 )*aspectcorrect) * dofblur*0.7).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( 0.0,0.4 )*aspectcorrect) * dofblur*0.7);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.0,0.4 )*aspectcorrect) * dofblur*0.7).rgb * dweight;
	
	
						dweight =   dofWeight(dofblur, (vec2( 0.29,0.29 )*aspectcorrect) * dofblur*0.4);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.29,0.29 )*aspectcorrect) * dofblur*0.4).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( 0.4,0.0 )*aspectcorrect) * dofblur*0.4);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.4,0.0 )*aspectcorrect) * dofblur*0.4).rgb * dweight;	
	
						dweight =   dofWeight(dofblur, (vec2( 0.29,-0.29 )*aspectcorrect) * dofblur*0.4);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.29,-0.29 )*aspectcorrect) * dofblur*0.4).rgb * dweight;	
	
						dweight =   dofWeight(dofblur, (vec2( 0.0,-0.4 )*aspectcorrect) * dofblur*0.4);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.0,-0.4 )*aspectcorrect) * dofblur*0.4).rgb * dweight;	
	
						dweight =   dofWeight(dofblur, (vec2( -0.29,0.29 )*aspectcorrect) * dofblur*0.4);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.29,0.29 )*aspectcorrect) * dofblur*0.4).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( -0.4,0.0 )*aspectcorrect) * dofblur*0.4);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.4,0.0 )*aspectcorrect) * dofblur*0.4).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( -0.29,-0.29 )*aspectcorrect) * dofblur*0.4);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( -0.29,-0.29 )*aspectcorrect) * dofblur*0.4).rgb * dweight;
	
						dweight =   dofWeight(dofblur, (vec2( 0.0,0.4 )*aspectcorrect) * dofblur*0.4);
						dweightall += dweight;
	col += texture2D(gcolor, texcoord.st + (vec2( 0.0,0.4 )*aspectcorrect) * dofblur*0.4).rgb * dweight;	

	color.rgb = col/(dweightall + 0.001);	
	
	
	
	#else
	
	//LQ
	vec4 col = vec4(0.0);
	col += texture2D(gcolor, texcoord.st);
	
	col += texture2D(gcolor, texcoord.st + (vec2( 0.0,0.4 )*aspectcorrect) * dofblur);
	col += texture2D(gcolor, texcoord.st + (vec2( 0.15,0.37 )*aspectcorrect) * dofblur);
	col += texture2D(gcolor, texcoord.st + (vec2( 0.29,0.29 )*aspectcorrect) * dofblur);
	col += texture2D(gcolor, texcoord.st + (vec2( -0.37,0.15 )*aspectcorrect) * dofblur);	
	col += texture2D(gcolor, texcoord.st + (vec2( 0.4,0.0 )*aspectcorrect) * dofblur);	
	col += texture2D(gcolor, texcoord.st + (vec2( 0.37,-0.15 )*aspectcorrect) * dofblur);	
	col += texture2D(gcolor, texcoord.st + (vec2( 0.29,-0.29 )*aspectcorrect) * dofblur);	
	col += texture2D(gcolor, texcoord.st + (vec2( -0.15,-0.37 )*aspectcorrect) * dofblur);
	col += texture2D(gcolor, texcoord.st + (vec2( 0.0,-0.4 )*aspectcorrect) * dofblur);	
	col += texture2D(gcolor, texcoord.st + (vec2( -0.15,0.37 )*aspectcorrect) * dofblur);
	col += texture2D(gcolor, texcoord.st + (vec2( -0.29,0.29 )*aspectcorrect) * dofblur);
	col += texture2D(gcolor, texcoord.st + (vec2( 0.37,0.15 )*aspectcorrect) * dofblur);	
	col += texture2D(gcolor, texcoord.st + (vec2( -0.4,0.0 )*aspectcorrect) * dofblur);	
	col += texture2D(gcolor, texcoord.st + (vec2( -0.37,-0.15 )*aspectcorrect) * dofblur);	
	col += texture2D(gcolor, texcoord.st + (vec2( -0.29,-0.29 )*aspectcorrect) * dofblur);	
	col += texture2D(gcolor, texcoord.st + (vec2( 0.15,-0.37 )*aspectcorrect) * dofblur);
	
	col += texture2D(gcolor, texcoord.st + (vec2( 0.15,0.37 )*aspectcorrect) * dofblur*0.9);
	col += texture2D(gcolor, texcoord.st + (vec2( -0.37,0.15 )*aspectcorrect) * dofblur*0.9);		
	col += texture2D(gcolor, texcoord.st + (vec2( 0.37,-0.15 )*aspectcorrect) * dofblur*0.9);		
	col += texture2D(gcolor, texcoord.st + (vec2( -0.15,-0.37 )*aspectcorrect) * dofblur*0.9);
	col += texture2D(gcolor, texcoord.st + (vec2( -0.15,0.37 )*aspectcorrect) * dofblur*0.9);
	col += texture2D(gcolor, texcoord.st + (vec2( 0.37,0.15 )*aspectcorrect) * dofblur*0.9);		
	col += texture2D(gcolor, texcoord.st + (vec2( -0.37,-0.15 )*aspectcorrect) * dofblur*0.9);	
	col += texture2D(gcolor, texcoord.st + (vec2( 0.15,-0.37 )*aspectcorrect) * dofblur*0.9);	
	
	col += texture2D(gcolor, texcoord.st + (vec2( 0.29,0.29 )*aspectcorrect) * dofblur*0.7);
	col += texture2D(gcolor, texcoord.st + (vec2( 0.4,0.0 )*aspectcorrect) * dofblur*0.7);	
	col += texture2D(gcolor, texcoord.st + (vec2( 0.29,-0.29 )*aspectcorrect) * dofblur*0.7);	
	col += texture2D(gcolor, texcoord.st + (vec2( 0.0,-0.4 )*aspectcorrect) * dofblur*0.7);	
	col += texture2D(gcolor, texcoord.st + (vec2( -0.29,0.29 )*aspectcorrect) * dofblur*0.7);
	col += texture2D(gcolor, texcoord.st + (vec2( -0.4,0.0 )*aspectcorrect) * dofblur*0.7);	
	col += texture2D(gcolor, texcoord.st + (vec2( -0.29,-0.29 )*aspectcorrect) * dofblur*0.7);	
	col += texture2D(gcolor, texcoord.st + (vec2( 0.0,0.4 )*aspectcorrect) * dofblur*0.7);
			 
	col += texture2D(gcolor, texcoord.st + (vec2( 0.29,0.29 )*aspectcorrect) * dofblur*0.4);
	col += texture2D(gcolor, texcoord.st + (vec2( 0.4,0.0 )*aspectcorrect) * dofblur*0.4);	
	col += texture2D(gcolor, texcoord.st + (vec2( 0.29,-0.29 )*aspectcorrect) * dofblur*0.4);	
	col += texture2D(gcolor, texcoord.st + (vec2( 0.0,-0.4 )*aspectcorrect) * dofblur*0.4);	
	col += texture2D(gcolor, texcoord.st + (vec2( -0.29,0.29 )*aspectcorrect) * dofblur*0.4);
	col += texture2D(gcolor, texcoord.st + (vec2( -0.4,0.0 )*aspectcorrect) * dofblur*0.4);	
	col += texture2D(gcolor, texcoord.st + (vec2( -0.29,-0.29 )*aspectcorrect) * dofblur*0.4);	
	col += texture2D(gcolor, texcoord.st + (vec2( 0.0,0.4 )*aspectcorrect) * dofblur*0.4);	

	color = col/41;
	
	#endif
	
#endif



/////////////////////////////////////////////////////WATER//////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////WATER//////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////WATER//////////////////////////////////////////////////////////////////////////
#ifdef WATER_SHADER
	
	const float rspread = 0.30f;						//How long reflections are spread across the screen
	
	float rdepth = texture2D(gdepthtex, texcoord.st).x;


float pix_x = 1.0f / viewWidth;
float pix_y = 1.0f / viewHeight;

	rdepth = pow(rdepth, 1.0f);

const float wnormalclamp = 0.05f;
	
//Detect water surface normals

	//Compare change in depth texture over 1 pixel and return an angle
		float wnormal_x1 = texture2D(gdepthtex, texcoord.st + vec2(pix_x, 0.0f)).x - texture2D(gdepthtex, texcoord.st).x;

		
		float wnormal_x2 = texture2D(gdepthtex, texcoord.st).x - texture2D(gdepthtex, texcoord.st + vec2(-pix_x, 0.0f)).x;			
		float wnormal_x = 0.0f;
		
		if(abs(wnormal_x1) > abs(wnormal_x2)){
			wnormal_x = wnormal_x2;
		} else {
			wnormal_x = wnormal_x1;
		}
		wnormal_x /= 1.0f - rdepth;	

		wnormal_x = clamp(wnormal_x, -wnormalclamp, wnormalclamp);
		
		wnormal_x *= rspread*1.0f;
		

			  
			  
		float wnormal_y1  = texture2D(gdepthtex, texcoord.st + vec2(0.0f, pix_y*1.0f)).x - texture2D(gdepthtex, texcoord.st).x;
		float wnormal_y2  = texture2D(gdepthtex, texcoord.st).x - texture2D(gdepthtex, texcoord.st + vec2(0.0f, -pix_y)).x;		
		float wnormal_y;
		
		if(abs(wnormal_y1) > abs(wnormal_y2)){
			wnormal_y = wnormal_y2;
		} else {
			wnormal_y = wnormal_y1;
		}	
		wnormal_y /= 1.0f - rdepth;			

		wnormal_y = clamp(wnormal_y, -wnormalclamp, wnormalclamp);
		
		wnormal_y *= rspread*1.0f*aspectRatio;
		
          
		  
//REFRACTION

	//Heightmap of small waves
	float waves = texture2D(gaux1, texcoord.st).g;
	float wavesraw = waves;
		  waves -= 0.5f;
		  waves *= 1.0 - rdepth;
		  waves *= 100.0f;

	//Detect angle of waves by comparing 1 pixel difference and resolving discontinuities
	float wavesdeltax1 = texture2D(gaux1, texcoord.st).g - texture2D(gaux1, texcoord.st + vec2(-pix_x, 0.0f)).g;
	float wavesdeltax2 = texture2D(gaux1, texcoord.st + vec2(pix_x, 0.0f)).g - texture2D(gaux1, texcoord.st).g;
	float wavesdeltax;
	
		if(abs(wavesdeltax1) > abs(wavesdeltax2)){
			wavesdeltax = wavesdeltax2;
		} else {
			wavesdeltax = wavesdeltax1;
		}
		
		wavesdeltax = clamp(wavesdeltax, -0.1f, 0.1f);
		
		wavesdeltax *= 1.0f - rdepth;
		wavesdeltax *= 30.0f;
		  
		  
	float wavesdeltay1 = texture2D(gaux1, texcoord.st).g - texture2D(gaux1, texcoord.st + vec2(0.0f, -pix_y)).g;
	float wavesdeltay2 = texture2D(gaux1, texcoord.st + vec2(0.0f, pix_y)).g - texture2D(gaux1, texcoord.st).g;
	float wavesdeltay = 0.0f;
	
		if(abs(wavesdeltay1) > abs(wavesdeltay2)){
			wavesdeltay = wavesdeltay2;
		} else {
			wavesdeltay = wavesdeltay1;
		}
		wavesdeltay *= 1.0f - rdepth;
		wavesdeltay *= 30.0f;
		
		wavesdeltay = clamp(wavesdeltay, -0.1f, 0.1f);
		  


//Calculate distance of objects behind water
float waterDepthDiff = min(abs(getDepth(texcoord.st) - getWaterDepth(texcoord.st)), 3.0f) / 3.0f;
	  waterDepthDiff = pow(waterDepthDiff, 0.5f);
float refractdist = waterDepthDiff * REFRACT_AMOUNT * 10.0f;

//Perform refraction
float refractamount = 500.1154f*0.35f*refractdist;
float refractamount2 = 0.0214f*0.05f*refractdist;
float refractamount3 = 0.214f*0.15f*refractdist;
float waberration = ABERRATION_AMOUNT;

	vec3 refracted = vec3(0.0f);
	vec3 refractedmask = vec3(0.0f);
	float bigWaveRefract = 600.0f * (1.0f - rdepth)*refractdist;
	float bigWaveRefractScale = 1000.0f * (1.0f - rdepth)*refractdist;
	
	vec2 bigRefract = vec2(wnormal_x*bigWaveRefract, wnormal_y*bigWaveRefract);
	
	vec2 refractcoord_r = texcoord.st;
	vec2 refractcoord_g = texcoord.st;
	vec2 refractcoord_b = texcoord.st;
	
	for (int i = 0; i < 1; ++i) {
			
				if(iswater != 1.0f) {
					break;
				}
	
			 refractcoord_r = texcoord.st * (1.0f + waves*refractamount3) - (waves*refractamount3/2.0f) + vec2(wavesdeltax*refractamount*(-wnormal_x*0.3f) + waves*refractamount2 + (-wnormal_x*0.4f) - bigRefract.x, wavesdeltay*refractamount*(-wnormal_y*0.3f) + waves*refractamount2 + (-wnormal_y*0.4f) - bigRefract.y) * (waberration * 2.0f + 1.0f);
				refractcoord_r = refractcoord_r * vec2(1.0f - abs(wnormal_x) * bigWaveRefractScale, 1.0f - abs(wnormal_y) * bigWaveRefractScale) + vec2(abs(wnormal_x) * bigWaveRefractScale * 0.5f, abs(wnormal_y) * bigWaveRefractScale * 0.5f);

			
			refractcoord_r.s = clamp(refractcoord_r.s, 0.001f, 0.999f);
			refractcoord_r.t = clamp(refractcoord_r.t, 0.001f, 0.999f);	
			
			
			
			if (refractcoord_r.s > 1.0 || refractcoord_r.s < 0.0 || refractcoord_r.t > 1.0 || refractcoord_r.t < 0.0 /*||
				refractcoord_g.s > 1.0 || refractcoord_g.s < 0.0 || refractcoord_g.t > 1.0 || refractcoord_g.t < 0.0 ||
				refractcoord_b.s > 1.0 || refractcoord_b.s < 0.0 || refractcoord_b.t > 1.0 || refractcoord_b.t < 0.0*/) {
					break;
				}
			
			if (refractcoord_r.st * vec2(iswater) == vec2(0.0f)) {
				break;
			}			
			
			
			refracted.rgb = texture2D(gcolor, refractcoord_r).rgb;
			
			refracted.rgb = pow(refracted.rgb, vec3(BANDING_FIX_FACTOR));
			
			
			refractedmask.r = texture2D(gaux1, refractcoord_r).r;
	
			}
			
	color.rgb = mix(color.rgb, refracted.rgb, vec3(refractedmask.r));


	
float depthRefracted = getDepth(mix(texcoord.st, refractcoord_r.st, vec2(refractedmask.r)));
float waterDepthRefracted = getWaterDepth(mix(texcoord.st, refractcoord_r.st, vec2(refractedmask.r)));
	
float waterDepthDiffRefract = min( abs( depthRefracted - waterDepthRefracted ), 20.0f ) / 20.0f;

			
float wfresnel = pow(distance(vec2(wnormal_x, wnormal_y) + vec2(wavesdeltax, wavesdeltay) * 0.1, vec2(0.0f)), 0.7f) * 15.0f;

	  
	  
	  
	  
	  
//REFLECTION

	#ifdef WATER_REFLECTIONS
		//color.rgb = worldposition.g;
		
		vec3 reflection = vec3(0.0f);
		float rtransy = 0.01f * rspread;
		float rtransin = 0.05f;
		
		//Water Fog Properties
			//vec3 waterColor = vec3(0.1f, 0.2f, 0.35f);
			vec3  waterColor 			= vec3(60.0f, 50.0f, 100.0f)/255.0f;
				  waterColor 			= pow(waterColor, vec3(1.0f/BANDING_FIX_FACTOR));
			float waterColorDecay		= 0.175f;
			//float waterLightmap 		= mix(texture2D(gnormal, texcoord.st).g, texture2D(gaux2, texcoord.st).b, 0.5f);
			float waterMaxFogDensity	= 0.00f;
			float waterFogDensity 		= mix(0.9f, 0.0f, isEyeInWater);
			float waterFog				= min((waterDepthDiffRefract * waterFogDensity), waterMaxFogDensity);
			waterColor		   		   -= waterFog * waterColorDecay;

		
		#ifdef HQ_REFLECTIONS
		const float rstrong = 3.9f;
		#else
		const float rstrong = 4.0f;
		#endif
		const float reflectwaviness = 0.00095f;
		const float rcurve = 1.0f;
		
		//coordinates for translating reflection
		vec2 coordnormal = vec2(0.0f);
		vec2 coordin = texcoord.st;
		vec2 rcoord = vec2(0.0f);
		
		float dwaves = waves * 0.4f * reflectwaviness;
		float dwavesdeltax = wavesdeltax * 7.3f * reflectwaviness;
		float dwavesdeltay = wavesdeltay * 7.3f * reflectwaviness;
		float reflectmask = 0.0f;
		float reflectmaskhold = 0.0f;
		float rnoise = 0.0f;
		
		float depthcheck = 0.0f;
		float depthcheck2 = 0.0f;
		float depthpass = 0.0f;
		float prevdepth;
		float thisdepth;
		
		int samples = 1;
		
		
				float redge = distance(texcoord.s, 0.5f);
				  redge = max(redge, distance(texcoord.t, 0.5f));
				  redge *= 2.0f;
				  redge = clamp(redge * 4.0f - 3.0f, 0.0f, 1.0f);
				  redge = 1.0f;
		
		
				#ifdef HQ_REFLECTIONS
				
					for (int i = 0; i < 16; ++i) {
				
						if(iswater != 1.0f) {
							samples += 1;
							break;
						}
						
						rcoord = coordnormal + vec2(dwavesdeltax*4.0f + wnormal_x, dwavesdeltay*9.0f + wnormal_y)*(samples * samples - 1)*0.3f*REFLECTION_LENGTH;
						
						thisdepth = texture2D(gdepth, clamp(texcoord.st + rcoord, 0.001f, 0.999f)).x;
						
						depthcheck = (rdepth - thisdepth);
						depthcheck = 1.0f - depthcheck;
						depthcheck = clamp(depthcheck * 140.0 - 139.0f, 0.0f, 1.0f);
						depthcheck2 = clamp(depthcheck * 70.0 - 69.0f, 0.0f, 1.0f);

							reflectmask   = ((1.0 - texture2D(gaux1, clamp(texcoord.st + (rcoord*depthcheck), 0.001f, 0.999f)).r) * ((17 - samples)/17.0f));
							reflection  += 	((pow(texture2D(gcolor, clamp(texcoord.st + (rcoord*depthcheck), 0.001f, 0.999f)).rgb, vec3(BANDING_FIX_FACTOR)) * reflectmask) * ((17 - samples)/17.0f));

						
						reflectmaskhold += reflectmask;

						samples += 1;
					}
				
				#else
				
					for (int i = 0; i < 8; ++i) {
				
						if(iswater != 1.0f) {
							samples += 1;
							break;
						}
						
						rcoord = coordnormal + vec2(dwavesdeltax*4.0f + wnormal_x, dwavesdeltay*4.0f + wnormal_y)*(samples * samples - 1)*0.3f*REFLECTION_LENGTH;
						
						thisdepth = texture2D(gdepth, clamp(texcoord.st + rcoord, 0.001f, 0.999f)).x;
						
						depthcheck = (rdepth - thisdepth);
						depthcheck = 1.0f - depthcheck;
						depthcheck = clamp(depthcheck * 140.0 - 139.0f, 0.0f, 1.0f);
						depthcheck2 = clamp(depthcheck * 70.0 - 69.0f, 0.0f, 1.0f);

							reflectmask   = ((1.0 - texture2D(gaux1, clamp(texcoord.st + (rcoord*depthcheck), 0.001f, 0.999f)).r) * ((9 - samples)/9.0f));
							reflection  += 	((pow(texture2D(gcolor, clamp(texcoord.st + (rcoord*depthcheck), 0.001f, 0.999f)).rgb, vec3(BANDING_FIX_FACTOR)) * reflectmask) * ((9 - samples)/9.0f));

						
						reflectmaskhold += reflectmask;

						samples += 1;
					}
				
				#endif
				
				reflection /= samples - 1;
				reflectmaskhold /= samples - 1;
				
				reflectmaskhold = pow(reflectmaskhold, 1.0f)*2.5f;
				

				/*
				//compensate for dark water plane
				color.rgb *= mix(1.0f, 1.3f, iswater);
							
				//Darken objects behind water
				color.rgb = mix(color.rgb, vec3(color.r * 0.02f, color.g * 0.18f, color.b * 0.45f) * (1.0 - reflectmaskhold), iswater);
				
				//Water Fog with conservation of energy considered
				color.rgb = mix(color.rgb, waterColor * (1.0 - reflectmaskhold), iswater * waterFog);
				
				//Add reflections to water only
				reflection *= iswater;
				
				color.rgb = color.rgb + (reflection * rstrong);
				*/

	#endif
	
	
	color.rgb *= mix(1.0f, 0.9f, iswater);
	
	//New Reflections
	if (iswater >= 0.5f) {
	
		vec2 offset1 = vec2(0.5f, 0.0f) / viewWidth;
		vec2 offset2 = vec2(-0.5f, 0.0f) / viewWidth;
		vec2 offset3 = vec2(0.0f, 0.5f) / viewHeight;
		vec2 offset4 = vec2(0.0f, -0.5f) / viewHeight;
	
		vec4 waterReflections  = ComputeWaterReflection(noiseX2, noiseX5, noiseX7, vec2(wavesdeltax, wavesdeltay) * 0.9f, offset1);
		
		vec4 reflectionsAverage = waterReflections / 1.0f;
		
		float waterSkylight = max(0.0f, texture2D(gaux1, texcoord.st).r * 2.0f - 1.0f);
			  waterSkylight *= 1.0f;
		vec3 fakeSkyColor = pow(ambient_color, vec3(0.2f)) * 0.9f * waterSkylight * (1.0f - isEyeInWater);
		
		vec4 fakeSkyReflection = ComputeFakeSkyReflection(fakeSkyColor, vec2(wavesdeltax, wavesdeltay));
			 
			 reflectionsAverage.rgb = mix(fakeSkyReflection.rgb, reflectionsAverage.rgb, pow(reflectionsAverage.a, 0.5f));
	
		color.rgb = mix(color.rgb, pow(reflectionsAverage.rgb, vec3(BANDING_FIX_FACTOR)), fakeSkyReflection.a);

	}
		
		float waterRoughness = clamp(1.0f - texture2D(gdepthtex, texcoord.st).x, 0.0f, 1.0f);
		float waterRoughness2 = clamp(texture2D(gdepthtex, texcoord.st).x, 0.0f, 1.0f);
		
		vec3 wnormalsLocal = normalize(normalBiased.rgb + vec3(wavesdeltax, wavesdeltay, 0.0f) * (40.0f * waterRoughness2));
		
		float NdotL = max(dot(wnormalsLocal, lightVector), 0.0f);
		vec3 halfVector;
		float HdotN;
		
			
				halfVector = normalize(lightVector - normalize(fragposition.xyz));
				HdotN = max(0.0f, dot(halfVector, wnormalsLocal));
			
		
		//Water specular highlight
		float waterSpec = HdotN;
		  waterSpec = pow(waterSpec, 111151.0f * waterRoughness + 50.0f);
		  
		  if (waterSpec < 0.0f * pow(waterRoughness, 0.5f)) {
			waterSpec = 0.0f;
		  }
		  
		  waterSpec *= 5.01f * (wfresnel + 0.2);
		  waterSpec *= mix(1.0f, 0.0f, rainx);
		  waterSpec *= mix(0.0f, 1.0f, iswater);
		  waterSpec *= getWaterSunOcclusion(texcoord.st);
		  
		  
		  
		 color.rgb += waterSpec * sunlight_color;
		 
#endif



#ifdef GLOSSY_REFLECTIONS

//color.rgb = texture2D(composite, texcoord.st).rgb;

/*
const float glosslength = 0.020; //0.095
const float glosslength2 = 0.00575f;
const float g_distance = 50.0f;
const float fadefactor = 0.10f;
float gweight = 0.0f;
float gweight_add = 0.0f;
float compositepass = 0.0f;
float gdepthcheck = 0.0f;
const float gnoise = 0.0f;
float gnoise2 = 0.025f;
float gdepthdetect = 0.0f;
float gdepthr = texture2D(gdepth, texcoord.st).x;
float spreadx;
float spready;
float glossiness = 0.0f;


vec3 gloss = vec3(0.0f);
vec2 glosscoord = vec2(0.0f);
vec2 gcoord = texcoord.st;
*/
//float gfresnel = pow(distance(normalBiased, vec3(0.0, 0.0, 1.0))*1.5f, 1.0f);
			
			//vec3 fakeAlbedo = DoFakeAlbedo(color.rgb);
	  
	  		float wetmask = clamp(texture2D(gaux1, texcoord.st).b - 0.25f, 0.0f, 0.1f) / 0.1f * wetx;
			//float distmask = clamp(g_distance * fadefactor - linDepth * fadefactor, 0.0f, 1.0f);
			float g_spec = specularity;
			float g_irr = 0.0f;
			
			float totalspec = g_spec + g_irr;

#ifdef REFLECTIONS
if(totalspec > 0.0f){
	vec4 reflected = ComputeReflection(noiseX2, noiseY2, noiseX4, specularity);
	color.rgb = mix(color.rgb, pow(reflected.rgb, vec3(BANDING_FIX_FACTOR)), reflected.a * 1.0f * totalspec);
}
#else



/*
		
			for (int i = 0; i < 8; ++i) {
			
				if (linDepth > g_distance || totalspec < 0.001f) {
					break;
				}
				
				if (land == 0.0f) {
					break;
				}
						
				glosscoord += ((vec2(normalBiased.x + (noiseX2 * gnoise * normalBiased.x) * aspectRatio, normalBiased.y * 2.0f + (noiseX2 * gnoise * normalBiased.y * 2.0f)))*glosslength);

				
				gdepthdetect = texture2D(gdepth, clamp(gcoord.st + glosscoord, 0.001f, 0.999f)).x;

				gdepthcheck = (gdepthr - gdepthdetect);
				gdepthcheck = 1.0f - gdepthcheck;
				gdepthcheck = clamp(gdepthcheck * 480.0 - 479.0f, 0.0f, 1.0f);
				
				
				compositepass = clamp(distance(texture2D(gnormal, clamp(gcoord.st + glosscoord, 0.001f, 0.999f)).rgb, normal.rgb) * 2.5f - 0.5f, 0.0f, 2.0f);
				
				gweight = 1.0f * compositepass * gfresnel * gdepthcheck * (9 - i);
				
				gweight_add += gweight;


				
				gloss += pow(max((texture2D(gcolor, clamp(gcoord.st + glosscoord, 0.001f, 0.999f)).rgb - 0.0f) * gweight, 0.0f), vec3(BANDING_FIX_FACTOR));

			}		
		//}

			float finalweight =  (((gweight_add/105.0)*land) * (1.0f - iswater)) * 1.1;

			gloss /= gweight_add * 8811151.0f;
			gloss = max(gloss, 0.0f);
			
			//reflect
			color.rgb = mix(color.rgb, gloss, clamp(finalweight * distmask * g_spec, 0.0f, 1.0f) * pow(dot(gloss, vec3(1.0f)), 0.2f));

			//metallic reflect
			color.rgb += gloss * albedo.rgb * finalweight * distmask * g_irr * pow(dot(gloss, vec3(1.0f)), 0.2f);

	*/		
#endif
#endif



#ifdef GODRAYS

	float GR = addGodRays(0.0f, Texcoord2, noiseX3, noiseX4, noiseY4, noiseX2, noiseY2, noiseX5, noiseY5, noiseX6, noiseY6)/2.0;

	float GRr = 1.0 - texture2D(composite, texcoord.st).b;
	
	
	GR = pow(GR, 1.0f)*2.5f;
	
	color.r += pow(GR*sunlight_color.r, 1.0f);
	color.g += pow(GR*sunlight_color.g, 1.0f);
	color.b += pow(GR*sunlight_color.b, 1.0f);
	
	

	
#endif



#ifdef LENS

vec3 sP = sunPosition;

			vec2 lPos = sP.xy / -sP.z;
			lPos.x *= 1.0f/aspectRatio;
			lPos.xy *= 1.40f;						
			lPos = (lPos + 1.0f)/2.0f;
			

			
			float sunmask = 0.0f;
					

					sunmask += 1.0f - getLand(lPos);
					
					if (lPos.x > 1.0f || lPos.x < 0.0f || lPos.y > 1.0f || lPos.y < 0.0f) {
							sunmask = 0.0f;
					}

					sunmask *= LENS_POWER * (1.0f - TimeMidnight);
					sunmask *= 1.0 - rainx;
			
			//Detect if sun is on edge of screen
				float edgemaskx = clamp(distance(lPos.x, 0.5f)*8.0f - 3.0f, 0.0f, 1.0f);
				float edgemasky = clamp(distance(lPos.y, 0.5f)*8.0f - 3.0f, 0.0f, 1.0f);
			
						
						
			////Darken colors if the sun is visible
				float centermask = 1.0 - clamp(distance(lPos.xy, vec2(0.5f, 0.5f))*2.0, 0.0, 1.0);
						centermask = pow(centermask, 1.0f);
						centermask *= sunmask;
			
				color.r *= (1.0 - centermask * (1.0f - TimeMidnight));
				color.g *= (1.0 - centermask * (1.0f - TimeMidnight));
				color.b *= (1.0 - centermask * (1.0f - TimeMidnight));
			
			
			//Adjust global flare settings
				const float flaremultR = 0.8f;
				const float flaremultG = 1.0f;
				const float flaremultB = 1.5f;
			
				float flarescale = 1.0f;
				const float flarescaleconst = 1.0f;
			
			
			//Flare gets bigger at center of screen
			
				flarescale *= (1.0 - centermask);

				//INGO 
				vec2 flare3INGOscale = vec2(0.9f*flarescale, 70.0f*flarescale);
			  float flare3INGOpow = 1.0f;
			  float flare3INGOfill = 2.0f;
			  float flare3INGOoffset = -2.0f;
			vec2 flare3INGOpos = vec2(  ((1.0 - lPos.x)*(flare3INGOoffset + 1.0) - (flare3INGOoffset*0.5))  *aspectRatio*flare3INGOscale.x,  ((1.0 - lPos.y)*(flare3INGOoffset + 1.0) - (flare3INGOoffset*0.5))  *flare3INGOscale.y);
			
			
			float flare3INGO  = distance(flare3INGOpos, vec2(texcoord.s*aspectRatio*flare3INGOscale.x, texcoord.t*flare3INGOscale.y));
				  flare3INGO  = 0.5 - flare3INGO;
				  flare3INGO  = clamp(flare3INGO*flare3INGOfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare3INGO  = sin(flare3INGO*1.57075);
				  flare3INGO  *= sunmask;
				  flare3INGO  = pow(flare3INGO, 1.1f);
				  
				  flare3INGO  *= flare3INGOpow;			
				  
				  
				 				  
				  
				  	color.r += flare3INGO *0.6f*flaremultR;
					color.g += flare3INGO *0.2f*flaremultG;
					color.b += flare3INGO *1.0f*flaremultB;				
			
			//Center white flare
			vec2 flare1scale = vec2(1.7f*flarescale, 1.7f*flarescale);
			float flare1pow = 12.0f;
			vec2 flare1pos = vec2(lPos.x*aspectRatio*flare1scale.x, lPos.y*flare1scale.y);
			
			
			float flare1 = distance(flare1pos, vec2(texcoord.s*aspectRatio*flare1scale.x, texcoord.t*flare1scale.y));
				  flare1 = 0.5 - flare1;
				  flare1 = clamp(flare1, 0.0, 10.0) * clamp(-sP.z, 0.0, 1.0);
				  flare1 *= sunmask;
				  flare1 = pow(flare1, 1.8f);
				  
				  flare1 *= flare1pow;
				  
				  	color.r += flare1*0.7f*flaremultR;
					color.g += flare1*0.4f*flaremultG;
					color.b += flare1*0.2f*flaremultB;	
				  			
							
							
			//Center white flare
			  vec2 flare1Bscale = vec2(0.5f*flarescale, 0.5f*flarescale);
			  float flare1Bpow = 6.0f;
			vec2 flare1Bpos = vec2(lPos.x*aspectRatio*flare1Bscale.x, lPos.y*flare1Bscale.y);
			
			
			float flare1B = distance(flare1Bpos, vec2(texcoord.s*aspectRatio*flare1Bscale.x, texcoord.t*flare1Bscale.y));
				  flare1B = 0.5 - flare1B;
				  flare1B = clamp(flare1B, 0.0, 10.0) * clamp(-sP.z, 0.0, 1.0);
				  flare1B *= sunmask;
				  flare1B = pow(flare1B, 1.8f);
				  
				  flare1B *= flare1Bpow;
				  
				  	color.r += flare1B*0.7f*flaremultR;
					color.g += flare1B*0.2f*flaremultG;
					color.b += flare1B*0.0f*flaremultB;	
				  
				  
			//Wide red flare
			vec2 flare2pos = vec2(lPos.x*aspectRatio*0.2, lPos.y);
			
			float flare2 = distance(flare2pos, vec2(texcoord.s*aspectRatio*0.2, texcoord.t));
				  flare2 = 0.3 - flare2;
				  flare2 = clamp(flare2, 0.0, 10.0) * clamp(-sP.z, 0.0, 1.0);
				  flare2 *= sunmask;
				  flare2 = pow(flare2, 1.8f);
				  	
					color.r += flare2*1.8f*flaremultR;
					color.g += flare2*0.6f*flaremultG;
					color.b += flare2*0.0f*flaremultB;
					
					
					
			//Wide red flare
			vec2 flare2posB = vec2(lPos.x*aspectRatio*0.2, lPos.y*4.0);
			
			float flare2B = distance(flare2posB, vec2(texcoord.s*aspectRatio*0.2, texcoord.t*4.0));
				  flare2B = 0.3 - flare2B;
				  flare2B = clamp(flare2B, 0.0, 10.0) * clamp(-sP.z, 0.0, 1.0);
				  flare2B *= sunmask;
				  flare2B = pow(flare2B, 1.8f);
				  	
					color.r += flare2B*1.2f*flaremultR;
					color.g += flare2B*0.5f*flaremultG;
					color.b += flare2B*0.0f*flaremultB;
					
					
					
			//Far blue flare MAIN
			  vec2 flare3scale = vec2(2.0f*flarescale, 2.0f*flarescale);
			  float flare3pow = 0.7f;
			  float flare3fill = 10.0f;
			  float flare3offset = -0.5f;
			vec2 flare3pos = vec2(  ((1.0 - lPos.x)*(flare3offset + 1.0) - (flare3offset*0.5))  *aspectRatio*flare3scale.x,  ((1.0 - lPos.y)*(flare3offset + 1.0) - (flare3offset*0.5))  *flare3scale.y);
			
			
			float flare3 = distance(flare3pos, vec2(texcoord.s*aspectRatio*flare3scale.x, texcoord.t*flare3scale.y));
				  flare3 = 0.5 - flare3;
				  flare3 = clamp(flare3*flare3fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare3 = sin(flare3*1.57075);
				  flare3 *= sunmask;
				  flare3 = pow(flare3, 1.1f);
				  
				  flare3 *= flare3pow;			
				  
				  
				  //subtract from blue flare
				  vec2 flare3Bscale = vec2(1.4f*flarescale, 1.4f*flarescale);
				  float flare3Bpow = 1.0f;
				  float flare3Bfill = 2.0f;
				  float flare3Boffset = -0.65f;
				vec2 flare3Bpos = vec2(  ((1.0 - lPos.x)*(flare3Boffset + 1.0) - (flare3Boffset*0.5))  *aspectRatio*flare3Bscale.x,  ((1.0 - lPos.y)*(flare3Boffset + 1.0) - (flare3Boffset*0.5))  *flare3Bscale.y);
			
			
				float flare3B = distance(flare3Bpos, vec2(texcoord.s*aspectRatio*flare3Bscale.x, texcoord.t*flare3Bscale.y));
					flare3B = 0.5 - flare3B;
					flare3B = clamp(flare3B*flare3Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
					flare3B = sin(flare3B*1.57075);
					flare3B *= sunmask;
					flare3B = pow(flare3B, 0.9f);
				  
					flare3B *= flare3Bpow;
				  
				flare3 = clamp(flare3 - flare3B, 0.0, 10.0);
				  
				  
				  	color.r += flare3*0.0f*flaremultR;
					color.g += flare3*0.3f*flaremultG;
					color.b += flare3*1.0f*flaremultB;

					
					
					
			//Far blue flare MAIN 2
			  vec2 flare3Cscale = vec2(3.2f*flarescale, 3.2f*flarescale);
			  float flare3Cpow = 1.4f;
			  float flare3Cfill = 10.0f;
			  float flare3Coffset = -0.0f;
			vec2 flare3Cpos = vec2(  ((1.0 - lPos.x)*(flare3Coffset + 1.0) - (flare3Coffset*0.5))  *aspectRatio*flare3Cscale.x,  ((1.0 - lPos.y)*(flare3Coffset + 1.0) - (flare3Coffset*0.5))  *flare3Cscale.y);
			
			
			float flare3C = distance(flare3Cpos, vec2(texcoord.s*aspectRatio*flare3Cscale.x, texcoord.t*flare3Cscale.y));
				  flare3C = 0.5 - flare3C;
				  flare3C = clamp(flare3C*flare3Cfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare3C = sin(flare3C*1.57075);
				  
				  flare3C = pow(flare3C, 1.1f);
				  
				  flare3C *= flare3Cpow;			
				  
				  
				  //subtract from blue flare
				  vec2 flare3Dscale = vec2(2.1f*flarescale, 2.1f*flarescale);
				  float flare3Dpow = 2.7f;
				  float flare3Dfill = 1.4f;
				  float flare3Doffset = -0.05f;
				vec2 flare3Dpos = vec2(  ((1.0 - lPos.x)*(flare3Doffset + 1.0) - (flare3Doffset*0.5))  *aspectRatio*flare3Dscale.x,  ((1.0 - lPos.y)*(flare3Doffset + 1.0) - (flare3Doffset*0.5))  *flare3Dscale.y);
			
			
				float flare3D = distance(flare3Dpos, vec2(texcoord.s*aspectRatio*flare3Dscale.x, texcoord.t*flare3Dscale.y));
					flare3D = 0.5 - flare3D;
					flare3D = clamp(flare3D*flare3Dfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
					flare3D = sin(flare3D*1.57075);
					flare3D = pow(flare3D, 0.9f);
				  
					flare3D *= flare3Dpow;
				  
				flare3C = clamp(flare3C - flare3D, 0.0, 10.0);
				flare3C *= sunmask;
				  
				  	color.r += flare3C*0.4f*flaremultR;
					color.g += flare3C*0.7f*flaremultG;
					color.b += flare3C*1.0f*flaremultB;							
					
					
					
					
					
					
					
					
					
			//far small pink flare
			  vec2 flare4scale = vec2(4.5f*flarescale, 4.5f*flarescale);
			  float flare4pow = 0.3f;
			  float flare4fill = 3.0f;
			  float flare4offset = -0.1f;
			vec2 flare4pos = vec2(  ((1.0 - lPos.x)*(flare4offset + 1.0) - (flare4offset*0.5))  *aspectRatio*flare4scale.x,  ((1.0 - lPos.y)*(flare4offset + 1.0) - (flare4offset*0.5))  *flare4scale.y);
			
			
			float flare4 = distance(flare4pos, vec2(texcoord.s*aspectRatio*flare4scale.x, texcoord.t*flare4scale.y));
				  flare4 = 0.5 - flare4;
				  flare4 = clamp(flare4*flare4fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4 = sin(flare4*1.57075);
				  flare4 *= sunmask;
				  flare4 = pow(flare4, 1.1f);
				  
				  flare4 *= flare4pow;
				  
				  	color.r += flare4*0.6f*flaremultR;
					color.g += flare4*0.0f*flaremultG;
					color.b += flare4*0.8f*flaremultB;							
					
					
					
			//far small pink flare2
			  vec2 flare4Bscale = vec2(7.5f*flarescale, 7.5f*flarescale);
			  float flare4Bpow = 0.4f;
			  float flare4Bfill = 2.0f;
			  float flare4Boffset = 0.0f;
			vec2 flare4Bpos = vec2(  ((1.0 - lPos.x)*(flare4Boffset + 1.0) - (flare4Boffset*0.5))  *aspectRatio*flare4Bscale.x,  ((1.0 - lPos.y)*(flare4Boffset + 1.0) - (flare4Boffset*0.5))  *flare4Bscale.y);
			
			
			float flare4B = distance(flare4Bpos, vec2(texcoord.s*aspectRatio*flare4Bscale.x, texcoord.t*flare4Bscale.y));
				  flare4B = 0.5 - flare4B;
				  flare4B = clamp(flare4B*flare4Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4B = sin(flare4B*1.57075);
				  flare4B *= sunmask;
				  flare4B = pow(flare4B, 1.1f);
				  
				  flare4B *= flare4Bpow;
				  
				  	color.r += flare4B*0.4f*flaremultR;
					color.g += flare4B*0.0f*flaremultG;
					color.b += flare4B*0.8f*flaremultB;						
					
					
					
			//far small pink flare3
			  vec2 flare4Cscale = vec2(37.5f*flarescale, 37.5f*flarescale);
			  float flare4Cpow = 2.0f;
			  float flare4Cfill = 2.0f;
			  float flare4Coffset = -0.3f;
			vec2 flare4Cpos = vec2(  ((1.0 - lPos.x)*(flare4Coffset + 1.0) - (flare4Coffset*0.5))  *aspectRatio*flare4Cscale.x,  ((1.0 - lPos.y)*(flare4Coffset + 1.0) - (flare4Coffset*0.5))  *flare4Cscale.y);
			
			
			float flare4C = distance(flare4Cpos, vec2(texcoord.s*aspectRatio*flare4Cscale.x, texcoord.t*flare4Cscale.y));
				  flare4C = 0.5 - flare4C;
				  flare4C = clamp(flare4C*flare4Cfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4C = sin(flare4C*1.57075);
				  flare4C *= sunmask;
				  flare4C = pow(flare4C, 1.1f);
				  
				  flare4C *= flare4Cpow;
				  
				  	color.r += flare4C*0.2f*flaremultR;
					color.g += flare4C*0.6f*flaremultG;
					color.b += flare4C*0.8f*flaremultB;						
					
					
					
			//far small pink flare4
			  vec2 flare4Dscale = vec2(67.5f*flarescale, 67.5f*flarescale);
			  float flare4Dpow = 1.0f;
			  float flare4Dfill = 2.0f;
			  float flare4Doffset = -0.35f;
			vec2 flare4Dpos = vec2(  ((1.0 - lPos.x)*(flare4Doffset + 1.0) - (flare4Doffset*0.5))  *aspectRatio*flare4Dscale.x,  ((1.0 - lPos.y)*(flare4Doffset + 1.0) - (flare4Doffset*0.5))  *flare4Dscale.y);
			
			
			float flare4D = distance(flare4Dpos, vec2(texcoord.s*aspectRatio*flare4Dscale.x, texcoord.t*flare4Dscale.y));
				  flare4D = 0.5 - flare4D;
				  flare4D = clamp(flare4D*flare4Dfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4D = sin(flare4D*1.57075);
				  flare4D *= sunmask;
				  flare4D = pow(flare4D, 1.1f);
				  
				  flare4D *= flare4Dpow;
				  
				  	color.r += flare4D*0.2f*flaremultR;
					color.g += flare4D*0.2f*flaremultG;
					color.b += flare4D*0.8f*flaremultB;						
					
					
								
			//far small pink flare5
			  vec2 flare4Escale = vec2(60.5f*flarescale, 60.5f*flarescale);
			  float flare4Epow = 1.0f;
			  float flare4Efill = 3.0f;
			  float flare4Eoffset = -0.3393f;
			vec2 flare4Epos = vec2(  ((1.0 - lPos.x)*(flare4Eoffset + 1.0) - (flare4Eoffset*0.5))  *aspectRatio*flare4Escale.x,  ((1.0 - lPos.y)*(flare4Eoffset + 1.0) - (flare4Eoffset*0.5))  *flare4Escale.y);
			
			
			float flare4E = distance(flare4Epos, vec2(texcoord.s*aspectRatio*flare4Escale.x, texcoord.t*flare4Escale.y));
				  flare4E = 0.5 - flare4E;
				  flare4E = clamp(flare4E*flare4Efill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4E = sin(flare4E*1.57075);
				  flare4E *= sunmask;
				  flare4E = pow(flare4E, 1.1f);
				  
				  flare4E *= flare4Epow;
				  
				  	color.r += flare4E*0.2f*flaremultR;
					color.g += flare4E*0.2f*flaremultG;
					color.b += flare4E*0.6f*flaremultB;					
					
								
								
			//far small pink flare5
			  vec2 flare4Fscale = vec2(20.5f*flarescale, 20.5f*flarescale);
			  float flare4Fpow = 3.0f;
			  float flare4Ffill = 3.0f;
			  float flare4Foffset = -0.4713f;
			vec2 flare4Fpos = vec2(  ((1.0 - lPos.x)*(flare4Foffset + 1.0) - (flare4Foffset*0.5))  *aspectRatio*flare4Fscale.x,  ((1.0 - lPos.y)*(flare4Foffset + 1.0) - (flare4Foffset*0.5))  *flare4Fscale.y);
			
			
			float flare4F = distance(flare4Fpos, vec2(texcoord.s*aspectRatio*flare4Fscale.x, texcoord.t*flare4Fscale.y));
				  flare4F = 0.5 - flare4F;
				  flare4F = clamp(flare4F*flare4Ffill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4F = sin(flare4F*1.57075);
				  flare4F *= sunmask;
				  flare4F = pow(flare4F, 1.1f);
				  
				  flare4F *= flare4Fpow;
				  
				  	color.r += flare4F*0.6f*flaremultR;
					color.g += flare4F*0.1f*flaremultG;
					color.b += flare4F*0.1f*flaremultB;						
					
					
					
					
					
					
					
					
					
					
					
					
			//
			  vec2 flare5scale = vec2(3.2f*flarescale , 3.2f*flarescale );
			  float flare5pow = 13.4f;
			  float flare5fill = 1.0f;
			  float flare5offset = -2.0f;
			vec2 flare5pos = vec2(  ((1.0 - lPos.x)*(flare5offset + 1.0) - (flare5offset*0.5))  *aspectRatio*flare5scale.x,  ((1.0 - lPos.y)*(flare5offset + 1.0) - (flare5offset*0.5))  *flare5scale.y);
			
			
			float flare5 = distance(flare5pos, vec2(texcoord.s*aspectRatio*flare5scale.x, texcoord.t*flare5scale.y));
				  flare5 = 0.5 - flare5;
				  flare5 = clamp(flare5*flare5fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare5 *= sunmask;
				  flare5 = pow(flare5, 1.9f);
				  
				  flare5 *= flare5pow;
				  
				  	color.r += flare5*0.9f*flaremultR;
					color.g += flare5*0.4f*flaremultG;
					color.b += flare5*0.3f*flaremultB;						
					
					
					
					
					
			//close ring flare red
			  vec2 flare6scale = vec2(1.2f*flarescale, 1.2f*flarescale);
			  float flare6pow = 0.2f;
			  float flare6fill = 5.0f;
			  float flare6offset = -1.9f;
			vec2 flare6pos = vec2(  ((1.0 - lPos.x)*(flare6offset + 1.0) - (flare6offset*0.5))  *aspectRatio*flare6scale.x,  ((1.0 - lPos.y)*(flare6offset + 1.0) - (flare6offset*0.5))  *flare6scale.y);
			
			
			float flare6 = distance(flare6pos, vec2(texcoord.s*aspectRatio*flare6scale.x, texcoord.t*flare6scale.y));
				  flare6 = 0.5 - flare6;
				  flare6 = clamp(flare6*flare6fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare6 = pow(flare6, 1.6f);
				  flare6 = sin(flare6*3.1415);
				  flare6 *= sunmask;

				  
				  flare6 *= flare6pow;
				  
				  	color.r += flare6*0.6f*flaremultR;
					color.g += flare6*0.0f*flaremultG;
					color.b += flare6*0.0f*flaremultB;						
					
					
					
			//close ring flare green
			  vec2 flare6Bscale = vec2(1.1f*flarescale, 1.1f*flarescale);
			  float flare6Bpow = 0.2f;
			  float flare6Bfill = 5.0f;
			  float flare6Boffset = -1.9f;
			vec2 flare6Bpos = vec2(  ((1.0 - lPos.x)*(flare6Boffset + 1.0) - (flare6Boffset*0.5))  *aspectRatio*flare6Bscale.x,  ((1.0 - lPos.y)*(flare6Boffset + 1.0) - (flare6Boffset*0.5))  *flare6Bscale.y);
			
			
			float flare6B = distance(flare6Bpos, vec2(texcoord.s*aspectRatio*flare6Bscale.x, texcoord.t*flare6Bscale.y));
				  flare6B = 0.5 - flare6B;
				  flare6B = clamp(flare6B*flare6Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare6B = pow(flare6B, 1.6f);
				  flare6B = sin(flare6B*3.1415);
				  flare6B *= sunmask;

				  
				  flare6B *= flare6Bpow;
				  
				  	color.r += flare6B*0.0f*flaremultR;
					color.g += flare6B*0.4f*flaremultG;
					color.b += flare6B*0.0f*flaremultB;						
					
					
			
			//close ring flare blue
			  vec2 flare6Cscale = vec2(0.9f*flarescale, 0.9f*flarescale);
			  float flare6Cpow = 0.2f;
			  float flare6Cfill = 5.0f;
			  float flare6Coffset = -1.9f;
			vec2 flare6Cpos = vec2(  ((1.0 - lPos.x)*(flare6Coffset + 1.0) - (flare6Coffset*0.5))  *aspectRatio*flare6Cscale.x,  ((1.0 - lPos.y)*(flare6Coffset + 1.0) - (flare6Coffset*0.5))  *flare6Cscale.y);
			
			
			float flare6C = distance(flare6Cpos, vec2(texcoord.s*aspectRatio*flare6Cscale.x, texcoord.t*flare6Cscale.y));
				  flare6C = 0.5 - flare6C;
				  flare6C = clamp(flare6C*flare6Cfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare6C = pow(flare6C, 1.8f);
				  flare6C = sin(flare6C*3.1415);
				  flare6C *= sunmask;

				  
				  flare6C *= flare6Cpow;
				  
				  	color.r += flare6C*0.0f*flaremultR;
					color.g += flare6C*0.0f*flaremultG;
					color.b += flare6C*0.4f*flaremultB;						
					
					
					
					
			//far red ring

			  vec2 flare7scale = vec2(0.4f*flarescale, 0.4f*flarescale);
			  float flare7pow = 0.2f;
			  float flare7fill = 10.0f;
			  float flare7offset = 2.6f;
			vec2 flare7pos = vec2(  ((1.0 - lPos.x)*(flare7offset + 1.0) - (flare7offset*0.5))  *aspectRatio*flare7scale.x,  ((1.0 - lPos.y)*(flare7offset + 1.0) - (flare7offset*0.5))  *flare7scale.y);
			
			
			float flare7 = distance(flare7pos, vec2(texcoord.s*aspectRatio*flare7scale.x, texcoord.t*flare7scale.y));
				  flare7 = 0.5 - flare7;
				  flare7 = clamp(flare7*flare7fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare7 = pow(flare7, 1.9f);
				  flare7 = sin(flare7*3.1415);
				  flare7 *= sunmask;

				  
				  flare7 *= flare7pow;
				  
				  	color.r += flare7*1.0f*flaremultR;
					color.g += flare7*0.0f*flaremultG;
					color.b += flare7*0.0f*flaremultB;				
					
					
					
			//far blue ring

			  vec2 flare7Dscale = vec2(0.39f*flarescale, 0.39f*flarescale);
			  float flare7Dpow = 0.1f;
			  float flare7Dfill = 10.0f;
			  float flare7Doffset = 2.6f;
			vec2 flare7Dpos = vec2(  ((1.0 - lPos.x)*(flare7Doffset + 1.0) - (flare7Doffset*0.5))  *aspectRatio*flare7Dscale.x,  ((1.0 - lPos.y)*(flare7Doffset + 1.0) - (flare7Doffset*0.5))  *flare7Dscale.y);
			
			
			float flare7D = distance(flare7Dpos, vec2(texcoord.s*aspectRatio*flare7Dscale.x, texcoord.t*flare7Dscale.y));
				  flare7D = 0.5 - flare7D;
				  flare7D = clamp(flare7D*flare7Dfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare7D = pow(flare7D, 1.9f);
				  flare7D = sin(flare7D*3.1415);
				  flare7D *= sunmask;

				  
				  flare7D *= flare7Dpow;
				  
				  	color.r += flare7D*0.0f*flaremultR;
					color.g += flare7D*0.6f*flaremultG;
					color.b += flare7D*0.0f*flaremultB;				
					
					
					
			//far red glow

			  vec2 flare7Bscale = vec2(0.2f*flarescale, 0.2f*flarescale);
			  float flare7Bpow = 0.1f;
			  float flare7Bfill = 2.0f;
			  float flare7Boffset = 2.9f;
			vec2 flare7Bpos = vec2(  ((1.0 - lPos.x)*(flare7Boffset + 1.0) - (flare7Boffset*0.5))  *aspectRatio*flare7Bscale.x,  ((1.0 - lPos.y)*(flare7Boffset + 1.0) - (flare7Boffset*0.5))  *flare7Bscale.y);
			
			
			float flare7B = distance(flare7Bpos, vec2(texcoord.s*aspectRatio*flare7Bscale.x, texcoord.t*flare7Bscale.y));
				  flare7B = 0.5 - flare7B;
				  flare7B = clamp(flare7B*flare7Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare7B = pow(flare7B, 1.9f);
				  flare7B = sin(flare7B*3.1415*0.5);
				  flare7B *= sunmask;

				  
				  flare7B *= flare7Bpow;
				  
				  	color.r += flare7B*1.0f*flaremultR;
					color.g += flare7B*0.0f*flaremultG;
					color.b += flare7B*0.0f*flaremultB;	
			
			
			
		
					
					
					
		//SMALL SWEEPS		///////////////////////////////						
					
					
			//mid orange sweep
			  vec2 flare10scale = vec2(6.0f*flarescale, 6.0f*flarescale);
			  float flare10pow = 1.9f;
			  float flare10fill = 1.1f;
			  float flare10offset = -0.7f;
			vec2 flare10pos = vec2(  ((1.0 - lPos.x)*(flare10offset + 1.0) - (flare10offset*0.5))  *aspectRatio*flare10scale.x,  ((1.0 - lPos.y)*(flare10offset + 1.0) - (flare10offset*0.5))  *flare10scale.y);
			
			
			float flare10 = distance(flare10pos, vec2(texcoord.s*aspectRatio*flare10scale.x, texcoord.t*flare10scale.y));
				  flare10 = 0.5 - flare10;
				  flare10 = clamp(flare10*flare10fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare10 = sin(flare10*1.57075);
				  flare10 *= sunmask;
				  flare10 = pow(flare10, 1.1f);
				  
				  flare10 *= flare10pow;			
				  
				  
				  //subtract
				  vec2 flare10Bscale = vec2(5.1f*flarescale, 5.1f*flarescale);
				  float flare10Bpow = 1.5f;
				  float flare10Bfill = 1.0f;
				  float flare10Boffset = -0.77f;
				vec2 flare10Bpos = vec2(  ((1.0 - lPos.x)*(flare10Boffset + 1.0) - (flare10Boffset*0.5))  *aspectRatio*flare10Bscale.x,  ((1.0 - lPos.y)*(flare10Boffset + 1.0) - (flare10Boffset*0.5))  *flare10Bscale.y);
			
			
				float flare10B = distance(flare10Bpos, vec2(texcoord.s*aspectRatio*flare10Bscale.x, texcoord.t*flare10Bscale.y));
					flare10B = 0.5 - flare10B;
					flare10B = clamp(flare10B*flare10Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
					flare10B = sin(flare10B*1.57075);
					flare10B *= sunmask;
					flare10B = pow(flare10B, 0.9f);
				  
					flare10B *= flare10Bpow;
				  
				flare10 = clamp(flare10 - flare10B, 0.0, 10.0);
				  
				  
				  	color.r += flare10*0.8f*flaremultR;
					color.g += flare10*0.2f*flaremultG;
					color.b += flare10*0.0f*flaremultB;				
					
					
			//mid blue sweep
			  vec2 flare10Cscale = vec2(6.0f*flarescale, 6.0f*flarescale);
			  float flare10Cpow = 1.9f;
			  float flare10Cfill = 1.1f;
			  float flare10Coffset = -0.6f;
			vec2 flare10Cpos = vec2(  ((1.0 - lPos.x)*(flare10Coffset + 1.0) - (flare10Coffset*0.5))  *aspectRatio*flare10Cscale.x,  ((1.0 - lPos.y)*(flare10Coffset + 1.0) - (flare10Coffset*0.5))  *flare10Cscale.y);
			
			
			float flare10C = distance(flare10Cpos, vec2(texcoord.s*aspectRatio*flare10Cscale.x, texcoord.t*flare10Cscale.y));
				  flare10C = 0.5 - flare10C;
				  flare10C = clamp(flare10C*flare10Cfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare10C = sin(flare10C*1.57075);
				  flare10C *= sunmask;
				  flare10C = pow(flare10C, 1.1f);
				  
				  flare10C *= flare10Cpow;			
				  
				  
				  //subtract
				  vec2 flare10Dscale = vec2(5.1f*flarescale, 5.1f*flarescale);
				  float flare10Dpow = 1.5f;
				  float flare10Dfill = 1.0f;
				  float flare10Doffset = -0.67f;
				vec2 flare10Dpos = vec2(  ((1.0 - lPos.x)*(flare10Doffset + 1.0) - (flare10Doffset*0.5))  *aspectRatio*flare10Dscale.x,  ((1.0 - lPos.y)*(flare10Doffset + 1.0) - (flare10Doffset*0.5))  *flare10Dscale.y);
			
			
				float flare10D = distance(flare10Dpos, vec2(texcoord.s*aspectRatio*flare10Dscale.x, texcoord.t*flare10Dscale.y));
					flare10D = 0.5 - flare10D;
					flare10D = clamp(flare10D*flare10Dfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
					flare10D = sin(flare10D*1.57075);
					flare10D *= sunmask;
					flare10D = pow(flare10D, 0.9f);
				  
					flare10D *= flare10Dpow;
				  
				flare10C = clamp(flare10C - flare10D, 0.0, 10.0);
				  
				  
				  	color.r += flare10C*0.0f*flaremultR;
					color.g += flare10C*0.2f*flaremultG;
					color.b += flare10C*0.9f*flaremultB;	
		//////////////////////////////////////////////////////////
		
		
		
		
		
		//Pointy fuzzy glow dots////////////////////////////////////////////////
			//RedGlow1

			  vec2 flare11scale = vec2(1.5f*flarescale, 1.5f*flarescale);
			  float flare11pow = 1.1f;
			  float flare11fill = 2.0f;
			  float flare11offset = -0.523f;
			vec2 flare11pos = vec2(  ((1.0 - lPos.x)*(flare11offset + 1.0) - (flare11offset*0.5))  *aspectRatio*flare11scale.x,  ((1.0 - lPos.y)*(flare11offset + 1.0) - (flare11offset*0.5))  *flare11scale.y);
			
			
			float flare11 = distance(flare11pos, vec2(texcoord.s*aspectRatio*flare11scale.x, texcoord.t*flare11scale.y));
				  flare11 = 0.5 - flare11;
				  flare11 = clamp(flare11*flare11fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare11 = pow(flare11, 2.9f);
				  flare11 *= sunmask;

				  
				  flare11 *= flare11pow;
				  
				  	color.r += flare11*1.0f*flaremultR;
					color.g += flare11*0.2f*flaremultG;
					color.b += flare11*0.0f*flaremultB;		
					
					
			//PurpleGlow2

			  vec2 flare12scale = vec2(2.5f*flarescale, 2.5f*flarescale);
			  float flare12pow = 0.5f;
			  float flare12fill = 2.0f;
			  float flare12offset = -0.323f;
			vec2 flare12pos = vec2(  ((1.0 - lPos.x)*(flare12offset + 1.0) - (flare12offset*0.5))  *aspectRatio*flare12scale.x,  ((1.0 - lPos.y)*(flare12offset + 1.0) - (flare12offset*0.5))  *flare12scale.y);
			
			
			float flare12 = distance(flare12pos, vec2(texcoord.s*aspectRatio*flare12scale.x, texcoord.t*flare12scale.y));
				  flare12 = 0.5 - flare12;
				  flare12 = clamp(flare12*flare12fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare12 = pow(flare12, 2.9f);
				  flare12 *= sunmask;

				  
				  flare12 *= flare12pow;
				  
				  	color.r += flare12*0.8f*flaremultR;
					color.g += flare12*0.2f*flaremultG;
					color.b += flare12*1.0f*flaremultB;		
					
					
					
			//BlueGlow3

			  vec2 flare13scale = vec2(1.0f*flarescale, 1.0f*flarescale);
			  float flare13pow = 0.5f;
			  float flare13fill = 2.0f;
			  float flare13offset = +0.138f;
			vec2 flare13pos = vec2(  ((1.0 - lPos.x)*(flare13offset + 1.0) - (flare13offset*0.5))  *aspectRatio*flare13scale.x,  ((1.0 - lPos.y)*(flare13offset + 1.0) - (flare13offset*0.5))  *flare13scale.y);
			
			
			float flare13 = distance(flare13pos, vec2(texcoord.s*aspectRatio*flare13scale.x, texcoord.t*flare13scale.y));
				  flare13 = 0.5 - flare13;
				  flare13 = clamp(flare13*flare13fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare13 = pow(flare13, 2.9f);
				  flare13 *= sunmask;

				  
				  flare13 *= flare13pow;
				  
				  	color.r += flare13*0.0f*flaremultR;
					color.g += flare13*0.2f*flaremultG;
					color.b += flare13*1.0f*flaremultB;		
						
				
			//Do flares. DoLens(float scale, vec3 color, float power, float offset, float curve);
				
			color.rgb += DoLens(0.2f, sunlight_color, 0.0f, 0.0f, 0.0f) * sunmask;
			

			color.rgb = clamp(color.rgb, 0.0, 10.0);

#endif



#ifdef CEL_SHADING
	color.rgb *= (getCellShaderFactor(texcoord.st));
#endif


color = color * BRIGHTMULT;


color.rgb *= 1.25f;

#ifdef COLOURFIX
	
	
	color.rgb *= 80.0f;
	
	//Properties
		float tonemapContrast 		= 1.0f;
		float tonemapSaturation 	= 1.3f; 
		float tonemapDecay			= 300.0f;
		float tonemapCurve			= 30.0f;
		

	color.rgb += 0.001f;
	
	vec3 colorN = normalize(color.rgb);
	
	vec3 clrfr = color.rgb/colorN.rgb;
	     clrfr = pow(clrfr.rgb, vec3(tonemapContrast));
		 
	colorN.rgb = pow(colorN.rgb, vec3(tonemapSaturation));
	
	color.rgb = clrfr.rgb * colorN.rgb;

	color.rgb = (color.rgb * (1.0 + color.rgb/tonemapDecay))/(color.rgb + tonemapCurve);

#endif

#ifdef VIGNETTE

float dv = distance(texcoord.st, vec2(0.5, 0.5));

dv *= VIGNETTE_STRENGTH;

dv = 1.0 - dv;

dv = pow(dv, 0.2);

dv *= 1.9;
dv -= 0.9;

color *= dv;
#endif


color = color * BRIGHTMULT;

#ifdef CROSSPROCESS
	//pre-gain
	color = color * (BRIGHTMULT) + 0.03;
	
	//compensate for low-light artifacts
	color = color+0.029;
 
	//calculate double curve
	float dbr = -color.r + 1.4;
	float dbg = -color.g + 1.4;
	float dbb = -color.b + 1.4;
	
	//fade between simple gamma up curve and double curve
	float pr = mix(dbr, 0.65, 0.5);
	float pg = mix(dbg, 0.65, 0.5);
	float pb = mix(dbb, 0.65, 0.5);
	
	color.r = pow((color.r * 0.95 - 0.002), pr);
	color.g = pow((color.g * 0.95 - 0.002), pg);
	color.b = pow((color.b * 0.99 + 0.000), pb);
#endif

#ifdef HIGHDESATURATE


	//average
	float rgb = max(color.r, max(color.g, color.b))/2 + min(color.r, min(color.g, color.b))/2;

	//adjust black and white image to be brighter
	float bw = pow(rgb, 0.7);

	//mix between per-channel analysis and average analysis
	float rgbr = mix(rgb, color.r, 0.7);
	float rgbg = mix(rgb, color.g, 0.7);
	float rgbb = mix(rgb, color.b, 0.7);

	//calculate crossfade based on lum
	float mixfactorr = max(0.0, (rgbr*2 - 1));
	float mixfactorg = max(0.0, (rgbg*2 - 1));
	float mixfactorb = max(0.0, (rgbb*2 - 1));

	//crossfade between saturated and desaturated image
	float mixr = mix(color.r, bw, mixfactorr);
	float mixg = mix(color.g, bw, mixfactorg);
	float mixb = mix(color.b, bw, mixfactorb);

	//adjust level of desaturation
	color.r = clamp((mix(mixr, color.r, 0.0)), 0.0, 1.0);
	color.g = clamp((mix(mixg, color.g, 0.0)), 0.0, 1.0);
	color.b = clamp((mix(mixb, color.b, 0.0)), 0.0, 1.0);
	
	//desaturate blue channel
	color.b = color.b*0.8 + ((color.r + color.g)/2.0)*0.2;
	

	
	

	
	//undo artifact compensation
	color = max(((color*1.10) - 0.06), 0.0);
	
	//color = color * BRIGHTMULT;

	color.r = pow(color.r, GAMMA);
	color.g = pow(color.g, GAMMA);
	color.b = pow(color.b, GAMMA);
	
	color = color*(1.0 + DARKMULT) - DARKMULT;
	
#endif


	//Color boosting
	color.r = (color.r)*(COLOR_BOOST + 1.0f) + (color.g + color.b)*(-COLOR_BOOST);
	color.g = (color.g)*(COLOR_BOOST + 1.0f) + (color.r + color.b)*(-COLOR_BOOST);
	color.b = (color.b)*(COLOR_BOOST + 1.0f) + (color.r + color.g)*(-COLOR_BOOST);
	
	color.r = pow(color.r, GAMMA);
	color.g = pow(color.g, GAMMA);
	color.b = pow(color.b, GAMMA);
	
	gl_FragColor = color;
	
// End of Main. -----------------
}
