#version 120
/* DRAWBUFFERS:0N2N4 */


uniform sampler2D texture;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;

varying vec3 viewVector;
varying vec3 normal;
varying vec3 tangent;
varying vec3 binormal;

varying float translucent;
varying float distance;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;




void main() {	

	vec2 adjustedTexCoord = texcoord.st;
	vec3 indlmap = mix(pow(min(lmcoord.t+0.1,1.0),2.0),1.0,lmcoord.s)*texture2D(texture,adjustedTexCoord).rgb*color.rgb;
	gl_FragData[0] = vec4(indlmap,texture2D(texture,adjustedTexCoord).a*color.a);	
	gl_FragData[4] = vec4(0.0, 1.0f, lmcoord.s, 0.0f);
	

}