#version 120






/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////ADJUSTABLE FUNCTIONS////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define SHADOW_DARKNESS 1.0
#define SHADOWRES 1024
#define SHADOWHPL 80

/* SHADOWRES:1024 */
/* SHADOWHPL:80 */

#define SUNLIGHTCOLOR
    #define SUNLIGHT_AMOUNT 1.0

	
	
	

	
	
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////GET MATERIAL////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

uniform sampler2D gcolor;
uniform sampler2D gnormal;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D colortex1;
uniform sampler2D shadow;
uniform sampler2D watershadow;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D shadowcolor;

varying vec4 texcoord;
varying vec3 lightVector;


uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

uniform int fogMode;
uniform int worldTime;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform float sunAngle;
uniform float rainStrength;

varying vec3 heldLightSpecMultiplier;
varying float heldLightMagnitude;

#define GL_LINEAR 9729
#define GL_EXP 2048
const float PI = 3.1415927;

float timefract = worldTime;

float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;

vec4 fcolor   = texture2D(gcolor, texcoord.st);
vec4 fnormal  = texture2D(gnormal, texcoord.st);
vec4 faux1    = texture2D(gaux1, texcoord.st);
vec4 faux2    = texture2D(gaux2, texcoord.st);
vec4 fambient = texture2D(colortex1, texcoord.st);
float depth0  = texture2D(depthtex0, texcoord.st).x;
float depth1  = texture2D(depthtex1, texcoord.st).x;







/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////CODE////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* DRAWBUFFERS:3 */

void calcShadowShading(in vec3 prjpos, out vec3 nfpos, out vec3 shading)
{
	vec4 fragposition = gbufferProjectionInverse * vec4(prjpos.x * 2.0 - 1.0, prjpos.y * 2.0 - 1.0, prjpos.z * 2.0 - 1.0, 1.0);
	fragposition /= fragposition.w;
	nfpos = normalize(fragposition.xyz);

	float distance = sqrt(fragposition.x * fragposition.x + fragposition.y * fragposition.y + fragposition.z * fragposition.z);

	shading = vec3(1.0);
	
	vec4 shadowColorSample = vec4(1.0);

	if (distance < SHADOWHPL && distance > 0.1) {
		// shadows
		vec4 worldposition = gbufferModelViewInverse * fragposition;

		float xzDistanceSquared = worldposition.x * worldposition.x + worldposition.z * worldposition.z;
		float yDistanceSquared  = worldposition.y * worldposition.y;
		
		if (yDistanceSquared < (SHADOWHPL*SHADOWHPL*0.75)) {
			worldposition = shadowModelView * worldposition;
			float comparedepth = -worldposition.z;
			worldposition = shadowProjection * worldposition;
			worldposition /= worldposition.w;
			
			worldposition.st = worldposition.st * 0.5 + 0.5;
				
			if (comparedepth > 0.0 && worldposition.s < 1.0 && worldposition.s > 0.0 && worldposition.t < 1.0 && worldposition.t > 0.0){
				float shadowMult = clamp(1.0 - xzDistanceSquared / (SHADOWHPL*SHADOWHPL*1.0), 0.0, 1.0) * clamp(1.0*SHADOW_DARKNESS - yDistanceSquared / (SHADOWHPL*SHADOWHPL*1.0), 0.0, 1.0*SHADOW_DARKNESS);
				float sampleDistance = 0.25 / SHADOWRES;

				vec2 shadowPos = worldposition.st;
				float shadowSample = texture2D(shadow, shadowPos).r;
				float waterShadowSample = texture2D(watershadow, shadowPos).r;
				
				float shadowDepth = 0.05 + shadowSample * (256.0 - 0.05);
				float waterShadowDepth = 0.05 + waterShadowSample * (256.0 - 0.05);
				
				float shading1 = 1.0 - shadowMult * (clamp(comparedepth - shadowDepth      - 0.05, 0.0, 1.0)) * clamp(1.0 - rainStrength,0.1,1.0);
				float shading2 = 1.0 - shadowMult * (clamp(comparedepth - waterShadowDepth - 0.05, 0.0, 1.0)) * clamp(1.0 - rainStrength,0.1,1.0);
				
				vec4 shadowColorSample = texture2D(shadowcolor, shadowPos);
				shading = shadowColorSample.rgb*(shading1-shading2) + shading2;
			}
		}
	}
}

void main() {
	//gl_FragData[0] = texture2D(gcolor, texcoord.st);
	//gl_FragData[2] = texture2D(gnormal, texcoord.st);
	//gl_FragData[4] = texture2D(gaux1, texcoord.st);
	float depth = depth1;
	vec3 normal = fnormal.xyz * 2.0 - 1.0;
	vec3 dcolor = fcolor.rgb;
	vec3 ambient = fambient.rgb;
	vec4 comp;
	
	if (normal==vec3(0.0) || normal==vec3(-1.0))
	{
		comp = vec4(dcolor * ambient,1.0);
	}
	else
	{
		vec3 tsnfpos;
		vec3 tsshading;
		calcShadowShading(vec3(texcoord.st,depth0), tsnfpos, tsshading);

		vec3 specularColor = faux1.rgb;
		float sunlight = sin(sunAngle*(2*PI));
		if (sunlight < 0) // night
		{
			sunlight *= (-0.5);
		}
		
	#ifdef SUNLIGHTCOLOR
		vec3 sunlightColor = vec3
		
		    // color.r
		   (sunlight*3.55*TimeSunrise*SUNLIGHT_AMOUNT* clamp(1.0 - rainStrength,0.1,1.0)
		            +1.0*TimeNoon*SUNLIGHT_AMOUNT* clamp(1.0 - rainStrength,0.1,1.0)
		            +1.63*TimeSunset*SUNLIGHT_AMOUNT* clamp(1.0 - rainStrength,0.1,1.0)
		            +0.0*TimeMidnight*SUNLIGHT_AMOUNT* clamp(1.0 - rainStrength,0.1,1.0),
								
			// color.g
		    sunlight*1.3*TimeSunrise*SUNLIGHT_AMOUNT* clamp(1.0 - rainStrength,0.1,1.0)
					+1.0*TimeNoon*SUNLIGHT_AMOUNT* clamp(1.0 - rainStrength,0.1,1.0)
					+0.5*TimeSunset*SUNLIGHT_AMOUNT* clamp(1.0 - rainStrength,0.1,1.0)
					+0.09*TimeMidnight*SUNLIGHT_AMOUNT* clamp(1.0 - rainStrength,0.1,1.0),
								 
			// color.b
			sunlight*0.0*TimeSunrise*SUNLIGHT_AMOUNT* clamp(1.0 - rainStrength,0.1,1.0)
					+1.0*TimeNoon*SUNLIGHT_AMOUNT* clamp(1.0 - rainStrength,0.1,1.0)
				    +0.0*TimeSunset*SUNLIGHT_AMOUNT* clamp(1.0 - rainStrength,0.1,1.0)
				    +0.22*TimeMidnight*SUNLIGHT_AMOUNT* clamp(1.0 - rainStrength,0.1,1.0));
	#else
		vec3 sunlightColor = vec3(sunlight*0.5* clamp(1.0 - rainStrength,0.1,1.0)
		                                 +0.15* clamp(1.0 - rainStrength,0.1,1.0),
		                          sunlight*0.5* clamp(1.0 - rainStrength,0.1,1.0)
		                                 +0.10* clamp(1.0 - rainStrength,0.1,1.0),
		                          sunlight*0.5* clamp(1.0 - rainStrength,0.1,1.0)
		                                 +0.05* clamp(1.0 - rainStrength,0.1,1.0));
	#endif
		
		float s;
		
		normal = normalize(normal);
		s = max(dot(reflect(tsnfpos, normal), lightVector), 0.0);
		comp = vec4(min(
			dcolor * (ambient + max(dot(normal, lightVector),0.0) * sunlightColor * tsshading)
			+ specularColor * s * s * s * sunlightColor * tsshading
			, 1.0), 1.0);
			
		if (depth1 > depth0) {
			vec3 uwnfpos;
			vec3 uwshading;
			calcShadowShading(vec3(texcoord.st,depth1), uwnfpos, uwshading);
			//s = max(dot(reflect(uwnfpos, normal), lightVector), 0.0);
			comp  = comp * 0.5 + vec4(min(
				dcolor * (ambient + ambient * sunlightColor * uwshading)
		//	+ specularColor * s * s * s * sunlightColor * uwshading
			, 1.0), 1.0) * 0.5;
		}

		//gl_FragData[3] = vec4(max(dot(normal, lightVector),0.0));
		
		//if (heldLightMagnitude > 0.0) {
		//	if (distance < heldLightMagnitude && distance > 0.1) {
		//		float intensity = 1.0 - min(distance / heldLightMagnitude, 1.0);
		//		s = max(dot(bump, -npos), 0.0);
		//		gl_FragData[3].rgb = min(gl_FragData[3].rgb + intensity * specularColor * s * s * s * heldLightSpecMultiplier, 1.0);
		//	}
		//}
		
		//gl_FragData[3].rgb *= shading;
	}
	
	comp.rgb = mix(comp.rgb, gl_Fog.color.rgb, 1.0-fambient.a);
	
	// rain
	comp.rgb = mix(comp.rgb, faux2.rgb, faux2.a);

#if 0
	float fogDepth = abs(depth);
	if (fogMode == GL_EXP) {
		comp.rgb = mix(gl_FragData[3].rgb, gl_Fog.color.rgb, 1.0 - clamp(exp(-gl_Fog.density * fogDepth), 0.0, 1.0));
	} else if (fogMode == GL_LINEAR) {
		comp.rgb = mix(gl_FragData[3].rgb, gl_Fog.color.rgb, clamp((fogDepth - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0));
	} else {
		comp.rgb = mix(gl_FragData[3].rgb, gl_Fog.color.rgb, 0.5);
	}
#endif

	gl_FragData[0] = comp;

#if 0
	if (texcoord.s < 0.18)
	{
		if (texcoord.t < 0.32)
		{
			gl_FragData[0] = vec4(
				texcoord.t*(1.0/0.32),
				texture2D(shadow,     texcoord.st*vec2(1.0/0.18,1.0/0.32)).r,
				texture2D(watershadow,texcoord.st*vec2(1.0/0.18,1.0/0.32)).r,
				1.0);
		}
		else if (texcoord.t < 0.64)
		{
			gl_FragData[0] = texture2D(shadowcolor,(texcoord.st-vec2(0.0,0.32))*vec2(1.0/0.18,1.0/0.32));
		}
	}
#endif
}
