#version 120
varying vec4 texcoord;

uniform vec3 sunPosition;
uniform vec3 moonPosition;

uniform int worldTime;

varying vec3 lightVector;
varying vec3 specMultiplier;

varying float TimeMidnight;
varying float TimeSunset;
varying float TimeNoon;
varying float TimeSunrise;

uniform float rainStrength;
uniform float wetness;

varying vec3 sunlight_color;
varying vec3 ambient_color;
varying vec3 skycolor;
varying vec3 sunlight;
varying vec3 fogclr;

void main() {
	gl_Position = ftransform();
	
	texcoord = gl_MultiTexCoord0;

	if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
		specMultiplier = vec3(1.0, 1.0, 1.0);
	} else {
		lightVector = normalize(moonPosition);
		specMultiplier = vec3(0.5, 0.5, 0.5);
	}
	
	specMultiplier *= clamp(abs(float(worldTime) / 500.0 - 46.0), 0.0, 1.0) * clamp(abs(float(worldTime) / 500.0 - 24.5), 0.0, 1.0);
	
	
	float timefract = float(worldTime);

	 float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0-(clamp(timefract, 0.0, 6000.0)/6000.0));
		  
	 float TimeNoon     = ((clamp(timefract, 0.0, 6000.0)) / 6000.0) - ((clamp(timefract, 6000.0, 12000.0) - 6000.0) / 6000.0);
	  
	 float TimeSunset   = ((clamp(timefract, 6000.0, 12000.0) - 6000.0) / 6000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
		  
	 float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);
	
	
	
	
	//water specular color
	vec3 sunrise_sun;
	 sunrise_sun.r = 1.0 * TimeSunrise;
	 sunrise_sun.g = 0.75 * TimeSunrise;
	 sunrise_sun.b = 0.35*TimeSunrise;
	 
	
	vec3 noon_sun;
	 noon_sun.r = 1.00 * TimeNoon;
	 noon_sun.g = 0.82 * TimeNoon;
	 noon_sun.b = 0.72 * TimeNoon;	 
	
	

	
	vec3 sunset_sun;
	 sunset_sun.r = 1.0 * TimeSunset;
	 sunset_sun.g = 0.75 * TimeSunset;
	 sunset_sun.b = 0.35* TimeSunset;

	
	vec3 midnight_sun;
	 midnight_sun.r = 0.2  * TimeMidnight;
	 midnight_sun.g = 0.24  * TimeMidnight;
	 midnight_sun.b = 0.37  * TimeMidnight;



	
	 sunlight.r = sunrise_sun.r + noon_sun.r + sunset_sun.r + midnight_sun.r;
	 sunlight.g = sunrise_sun.g + noon_sun.g + sunset_sun.g + midnight_sun.g;
	 sunlight.b = sunrise_sun.b + noon_sun.b + sunset_sun.b + midnight_sun.b;
	
	//fog color
	vec3 fogsunrise_sun;
	 fogsunrise_sun.r = TimeSunrise;
	 fogsunrise_sun.g = 0.4 * TimeSunrise;
	 fogsunrise_sun.b = 0.3 * TimeSunrise;
	
	vec3 fognoon_sun;
	 fognoon_sun.r = 1.0 * TimeNoon;
	 fognoon_sun.g = 0.8 * TimeNoon;
	 fognoon_sun.b = 0.7 * TimeNoon;
	
	vec3 fogsunset_sun;
	 fogsunset_sun.r = TimeSunset;
	 fogsunset_sun.g = 0.25 * TimeSunset;
	 fogsunset_sun.b = 0.1 * TimeSunset;
	
	vec3 fogmidnight_sun;
	 fogmidnight_sun.r = 0.45 * TimeMidnight * 0.20f;
	 fogmidnight_sun.g = 0.70 * TimeMidnight * 0.20f;
	 fogmidnight_sun.b = 1.00 * TimeMidnight * 0.20f;
	 
	vec3 rain_sun_day;
	 rain_sun_day.r = 1.0f * (1.0f - TimeMidnight) * 0.1f; 
	 rain_sun_day.g = 1.0f * (1.0f - TimeMidnight) * 0.1f;
	 rain_sun_day.b = 1.0f * (1.0f - TimeMidnight) * 0.1f;	
	 
	vec3 rain_sun_night;
	 rain_sun_night.r = 1.0f * (TimeMidnight) * 0.0f;
	 rain_sun_night.g = 1.0f * (TimeMidnight) * 0.0f;
	 rain_sun_night.b = 1.0f * (TimeMidnight) * 0.0f;
	
	fogclr = mix(fogsunrise_sun + fognoon_sun + fogsunset_sun + fogmidnight_sun, rain_sun_day + rain_sun_night, rainStrength);
}
