#version 120


const int 		R8 						= 0;
const int 		RGB8 					= 1;
const int 		RGB16 					= 2;
const int 		gcolorFormat 			= RGB8;
const int 		gnormalFormat 			= RGB16;
const int 		compositeFormat 		= RGB8;
const bool gcolorMipmapEnabled = false;
const bool gdepthMipmapEnabled = false;
const bool gnormalMipmapEnabled = false;
const bool compositeMipmapEnabled = false;
const bool gaux1MipmapEnabled = false;
const bool gaux2MipmapEnabled = false;
const bool gaux3MipmapEnabled = false;
const bool gaux4MipmapEnabled = false;
const bool depthtex0MipmapEnabled = false;

#define WATER_REFLECTIONS
#define REFLECTION_STRENGTH 2.0

//#define FAKE_HDR

uniform int worldTime;
uniform sampler2D composite;
uniform sampler2D gaux2;
uniform sampler2D gaux1;
uniform sampler2D depthtex0;
uniform sampler2D gnormal;

varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 fogclr;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform float far;
uniform float near;

uniform int isEyeInWater;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;

//don't touch these lines if you don't know what you do!
const float stp = 1.0;			//size of one step for raytracing algorithm
const float ref = 0.1;			//refinement multiplier
const float inc = 1.57;			//increasement factor at each step
const int maxf = 5;				//number of refinements

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

vec3 nvec3(vec4 pos){
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos){
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord){
    return distance(coord,vec2(0.5))*2.0;
}

float luma(vec3 color) {
return dot(color.rgb,vec3(0.299, 0.587, 0.114));
}
/*
vec4 raytrace(vec3 fragpos, vec3 normal){
	vec3 startpos = fragpos;
    vec4 color = vec4(0.0);
    vec3 start = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 vector = stp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
    int sr = 0;
    for(int i=0;i<30;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
        if(pos.x < 0 || pos.x > 1.001 || pos.y < 0 || pos.y > 1.001 || pos.z < 0 || pos.z > 1.001) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex0, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = abs(spos.x-fragpos.x)+abs(spos.z-fragpos.z);
        if(err < length(vector)*2.0){
                sr++;
                if(sr >= maxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 1.5), 0.0, 1.0);
                    color = texture2D(composite, pos.st);
					color.a = 1.0;
                    color.a *= border;
                    break;
                }
                fragpos = oldpos;
                vector *=ref;
				
}
        vector *= inc;
        oldpos = fragpos;
        fragpos += vector;
		
    }
    return color;
}
*/
vec3 convertScreenSpaceToWorldSpace(vec2 co) {
    vec4 fragposition = gbufferProjectionInverse * vec4(vec3(co, texture2D(depthtex0,co).x) * 2.0 - 1.0, 1.0);
    fragposition /= fragposition.w;
    return fragposition.xyz;
}

vec3 convertCameraSpaceToScreenSpace(vec3 cameraSpace) {
    vec4 clipSpace = gbufferProjection * vec4(cameraSpace, 1.0);
    vec3 NDCSpace = clipSpace.xyz / clipSpace.w;
    vec3 screenSpace = 0.5 * NDCSpace + 0.5;
		 screenSpace.z = 0.1f;
    return screenSpace;
}
vec4 	raytrace(vec3 fragpos, vec3 normal) {
	float reflectionRange = 1.0f;
    float initialStepAmount = 1.0 - clamp(1.0f / 100.0, 0.0, 0.99);
		  initialStepAmount *= 4.0f;
	float stepRefinementAmount = .1;
	int maxRefinements = 0;
	
    vec2 screenSpacePosition2D = texcoord.st;
    vec3 cameraSpacePosition = convertScreenSpaceToWorldSpace(screenSpacePosition2D);
	
    vec3 cameraSpaceNormal = normal;
		 
    vec3 cameraSpaceViewDir = normalize(cameraSpacePosition);
    vec3 cameraSpaceVector = initialStepAmount * normalize(reflect(cameraSpaceViewDir,cameraSpaceNormal));
	vec3 oldPosition = cameraSpacePosition;
    vec3 cameraSpaceVectorPosition = oldPosition + cameraSpaceVector;
    vec3 currentPosition = convertCameraSpaceToScreenSpace(cameraSpaceVectorPosition);
    vec4 color = vec4(texture2D(composite, screenSpacePosition2D).rgb, 0.0);
	int numRefinements = 0;
    int count = 0;
	vec2 finalSamplePos = vec2(0.0f);

    while(count < 50)
    {
        if(currentPosition.x < 0 || currentPosition.x > 1 ||
           currentPosition.y < 0 || currentPosition.y > 1 ||
           currentPosition.z < 0 || currentPosition.z > 1) { 

		   break;
		   
		   }

        vec2 samplePos = currentPosition.xy;
        float sampleDepth = convertScreenSpaceToWorldSpace(samplePos).z;

        // if (sampleDepth <= -far) {
        // 	break;
        // }

        float currentDepth = cameraSpaceVectorPosition.z;
        float diff = sampleDepth - currentDepth;
        float error = length(cameraSpaceVector);
        if(diff >= 0 && diff <= error * 2.00f) {

			finalSamplePos = samplePos;
			break;
			}
		
		
		cameraSpaceVector *= 1.5f;	//Each step gets bigger
		
        cameraSpaceVectorPosition += cameraSpaceVector;
		currentPosition = convertCameraSpaceToScreenSpace(cameraSpaceVectorPosition);
        count++;
    }
	
	color = texture2D(composite, finalSamplePos);
	
	if (finalSamplePos.x == 0.0f || finalSamplePos.y == 0.0f) {
		color.a = 0.0f;
	}
	
	color.a *= clamp(1 - pow(distance(vec2(0.5), finalSamplePos)*2.0, 2.0), 0.0, 1.0);

    return color;
}

void main() {

float spec = texture2D(gaux2,texcoord.xy).r;
float wave = texture2D(gaux2,texcoord.xy).g;




float iswater = 0.0;
if (wave > 0.0) {
iswater = 1.0;
wave = (wave-0.02)*2.0-1.0;
}

    vec3 fragpos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);
    fragpos = nvec3(gbufferProjectionInverse * nvec4(fragpos * 2.0 - 1.0));
    vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0 - 1.0;
    vec4 color = texture2D(composite,texcoord.xy);
			color.rgb *= mix(vec3(1.0),vec3(0.3,0.4,0.6),isEyeInWater);
    if (iswater > 0.9) {
#ifdef WATER_REFLECTIONS
            vec4 reflection = raytrace(fragpos, normalize(normal+vec3(wave*0.1,0.0,0.0)));
			float normalDotEye = dot(normal, normalize(fragpos));
			float fresnel = pow(1.0 + normalDotEye,2.5);
            reflection.rgb = mix(gl_Fog.color.rgb, reflection.rgb, reflection.a);			//fake sky reflection, avoid empty spaces
			color.rgb += reflection.rgb*fresnel * (1.0-isEyeInWater) * (abs(wave)+2.0)*0.25;
			//color.rgb += (1.0+fresnel)*spec*sunlight*(1.0-isEyeInWater)*8.0;
#endif

    }

/* DRAWBUFFERS:NNNNNN6 */

float land = color.a;
float lum = 0.0;
#ifdef FAKE_HDR
float temp;
float nb = 0;
vec2 coord;
//calculate average light intensity (only on one pixel) 
if (texcoord.x > 1.0-pw && texcoord.x > 1.0-ph) {
	for (int i = 0; i < 31;i++) {
		for (int j = 0; j < 31 ;j++) {
		coord = vec2(0.5)+vec2((i-16.0f)/32.0,(j-16.0f)/32.0);
		lum += luma(texture2D(composite,coord).rgb)*pow(1.0-distance(coord,vec2(0.5))/sqrt(2.0),15.0);
		nb += pow(1.0-distance(coord,vec2(0.5))/sqrt(2.0),15.0);
		}
	}
	lum /= nb;

}		
#endif


float timefract = float(worldTime);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

float fogfactor = pow(length(fragpos.xyz)/far,0.5);
color.rgb = mix(color.rgb,(fogclr+vec3(0.9-TimeMidnight*0.8))*0.5*(1.0-rainStrength*0.5),fogfactor*land*rainStrength);

vec2 rainmask = texture2D(gaux1,texcoord.xy).xy;
float alpha = 1.0;
if (rainmask.y > 0.65 && rainmask.y < 0.75) {
rainmask.y = 1.0;
alpha = rainmask.x;
}
else rainmask.y = 0.0;

vec3 rainclr = vec3(0.15,0.15,0.4);
color.rgb = mix(color.rgb,rainclr,(alpha-0.08)*rainmask.y);

	gl_FragData[6] = vec4(color.rgb,lum);
}
