#version 120

uniform sampler2D texture;
uniform sampler2D lightmap;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;

uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

uniform float rainStrength;

varying vec3 normal;
varying vec3 globalNormal;
varying vec3 tangent;
varying vec3 binormal;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;

varying float iswater;
varying float isice;

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;

void main() {

    vec4 tex = texture2D(texture, texcoord.xy);
	
	float zero = 1.0f;
	float transx = 0.0f;
	float transy = 0.0f;
	
	float texblock = 0.0625f;

	
	if (iswater > 0.5f) {
		tex = vec4(0.0f, 0.0f, 0.0f, 40.0f/255.0f);
	}
	
	vec4 frag2;
	

			frag2 = vec4((normal) * 0.5f + 0.5f, 1.0f);			
	
	vec3 indlmap = mix(lmcoord.t,1.0,lmcoord.s)*texture2D(texture,texcoord.xy).rgb*color.rgb;
	gl_FragData[0] = vec4(indlmap,texture2D(texture,texcoord.xy).a*color);
	gl_FragDepth = gl_FragCoord.z;
	gl_FragData[1] = vec4(vec3(gl_FragCoord.z), 0.0);
	gl_FragData[2] = frag2;	
	gl_FragData[3] = vec4(1.0f / 255.0f, 0.0f, iswater, 1.0);
	gl_FragData[4] = vec4(0.0, mix(1.0,0.05,iswater), lmcoord.s, 1.0);

	
}