#version 120

#define WAVING_LEAVES
#define WAVING_VINES
#define WAVING_GRASS
#define WAVING_WHEAT
#define WAVING_FLOWERS
#define WAVING_FIRE
#define WAVING_LAVA
#define WAVING_LILYPAD

#define ENTITY_LEAVES        18.0
#define ENTITY_VINES        106.0
#define ENTITY_TALLGRASS     31.0
#define ENTITY_DANDELION     37.0
#define ENTITY_ROSE          38.0
#define ENTITY_WHEAT         59.0
#define ENTITY_LILYPAD      111.0
#define ENTITY_FIRE          51.0
#define ENTITY_LAVAFLOWING   10.0
#define ENTITY_LAVASTILL     11.0

//uniform sampler2D lightmap;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

attribute vec4 mc_Entity;
attribute vec4 mc_midTexCoord;

varying vec4 color;
varying vec4 lmcoord;
varying vec4 vtexcoordam; // .st for add, .pq for mul
varying vec4 vtexcoord;

varying vec4 viewVector;
varying vec4 normal;
varying vec4 tangent;
varying vec4 binormal;

varying float distance;

const float PI = 3.1415927;


/*
vec3 calcWave(in vec3 worldpos, in vec3 ampw, in vec4 freq1, in vec3 amp1, in vec4 freq2, in vec3 amp2)
{
	const vec4 freqw = vec4(10.0/256.0,0.25/256.0,15.0/256.0,2.0/1000.0);
	float magn = sin(PI*2.0*dot(freqw,vec4(worldpos,worldTime)));
	vec3 ret = (
	      sin(PI*2.0*dot(freq1,vec4(worldpos,worldTime))) * amp1
	    + sin(PI*2.0*dot(freq2,vec4(worldpos,worldTime))) * amp2
		+ ampw ) * magn;
	return ret;
}
*/

float pi2ft = PI*2*frameTimeCounter;

vec3 calcWave(in vec3 pos, in float fm, in float mm, in float ma, in float f0, in float f1, in float f2, in float f3, in float f4, in float f5)
{
    vec3 ret;
    float magnitude,d0,d1,d2,d3;
    magnitude = sin(pi2ft*fm + pos.x*0.5 + pos.z*0.5 + pos.y*0.5) * mm + ma;
    d0 = sin(pi2ft*f0);
    d1 = sin(pi2ft*f1);
    d2 = sin(pi2ft*f2);
    ret.x = sin(pi2ft*f3 + d0 + d1 - pos.x + pos.z + pos.y) * magnitude;
    ret.z = sin(pi2ft*f4 + d1 + d2 + pos.x - pos.z + pos.y) * magnitude;
	ret.y = sin(pi2ft*f5 + d2 + d0 + pos.z + pos.y - pos.y) * magnitude;
    return ret;
}

vec3 calcMove(in vec3 pos, in float f1, in float f2, in float f3, in float f4, in vec3 amp1, in vec3 amp2)
{
    const vec3 v1 = vec3( 2.0/16.0,2.0/16.0,2.0/16.0);
	const vec3 v2 = vec3(-3.0/16.0,3.0/16.0,3.0/16.0);
	float pi2t = 2*PI*frameTimeCounter;
	float s1 = sin(pi2t*f1 + dot(2*PI*v1,pos));
	float s2 = sin(pi2t*f2 + dot(2*PI*v2,pos));
	vec3 move1 = (normalize(v1)*s1 + normalize(v2)*s2)*amp1;
	pos += move1;
    const vec3 v3 = vec3( 5.0/16.0,5.0/16.0,6.0/16.0);
	const vec3 v4 = vec3(-6.0/16.0,5.0/16.0,5.0/16.0);
	float s3 = sin(pi2t*f3 + dot(2*PI*v3,pos));
	float s4 = sin(pi2t*f4 + dot(2*PI*v4,pos));
	vec3 move2 = (normalize(v3)*s3 + normalize(v4)*s4)*(abs(s1*s2)*0.6+0.4)*amp2;
    return move1+move2;
}

vec3 calcWaterMove(in vec3 pos)
{
	float fy = fract(pos.y + 0.001);
	if (fy > 0.002)
	{
		float wave = 0.05 * sin(2*PI/4*frameTimeCounter + 2*PI*2/16*pos.x + 2*PI*5/16*pos.z)
				   + 0.05 * sin(2*PI/3*frameTimeCounter - 2*PI*3/16*pos.x + 2*PI*4/16*pos.z);
		return vec3(0, clamp(wave, -fy, 1.0-fy), 0);
	}
	else
	{
		return vec3(0);
	}
}

void main() {
	vec2 texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).st;
	vec2 midcoord = (gl_TextureMatrix[0] * mc_midTexCoord).st;
	vec2 texcoordminusmid = texcoord-midcoord;
	vtexcoordam.pq  = abs(texcoordminusmid)*2;
	vtexcoordam.st  = min(texcoord,midcoord-texcoordminusmid);
	vtexcoord.st    = sign(texcoordminusmid)*0.5+0.5;

	lmcoord.st = (gl_TextureMatrix[1] * gl_MultiTexCoord1).st;

	color = gl_Color;

	bool istopv = gl_MultiTexCoord0.t < mc_midTexCoord.t;

	/* un-rotate */
	vec4 position = gbufferModelViewInverse * gl_ModelViewMatrix * gl_Vertex;
	vec3 worldpos = position.xyz + cameraPosition;
	
	#ifdef WAVING_LEAVES
	if ( mc_Entity.x == ENTITY_LEAVES ) {
			position.xyz += calcMove(worldpos.xyz, 0.30, 0.31, 1.5, 1.6, vec3(0.03,0.03,0.03), vec3(0.01,0.01,0.01));
	} else
	#endif
	#ifdef WAVING_VINES
	if ( mc_Entity.x == ENTITY_VINES ) {
			position.xyz += calcMove(worldpos.xyz, 0.30, 0.31, 1.7, 1.8, vec3(0.03,0.03,0.03), vec3(0.01,0.01,0.01));
	} else
	#endif
	#ifdef WAVING_LAVA
	if ( mc_Entity.x == ENTITY_LAVAFLOWING || mc_Entity.x == ENTITY_LAVASTILL ) {
			position.xyz += calcWaterMove(worldpos.xyz) * 0.25;
	} else
	#endif
	#ifdef WAVING_LILYPAD
	if ( mc_Entity.x == ENTITY_LILYPAD ) {
			position.xyz += calcWaterMove(worldpos.xyz);
	} else
	#endif
	if (istopv) {
		#ifdef WAVING_GRASS
		if ( mc_Entity.x == ENTITY_TALLGRASS) {
				position.xyz += calcMove(worldpos.xyz, 0.30, 0.31, 1.9, 2.0, vec3(0.03,0.00,0.03), vec3(0.03,0.00,0.03));
		} else
		#endif
		#ifdef WAVING_FLOWERS
		if ((mc_Entity.x == ENTITY_DANDELION || mc_Entity.x == ENTITY_ROSE)) {
				position.xyz += calcMove(worldpos.xyz, 0.30, 0.31, 1.9, 2.0, vec3(0.03,0.00,0.03), vec3(0.03,0.00,0.03));
		} else
		#endif
		#ifdef WAVING_WHEAT
		if ( mc_Entity.x == ENTITY_WHEAT) {
				position.xyz += calcMove(worldpos.xyz, 0.30, 0.31, 1.9, 2.0, vec3(0.03,0.00,0.03), vec3(0.03,0.00,0.03));
		} else
		#endif
		#ifdef WAVING_FIRE
		if ( mc_Entity.x == ENTITY_FIRE) {
				position.xyz += calcMove(worldpos.xyz, 0.30, 0.31, 2.0, 2.1, vec3(0.03,0.03,0.03), vec3(0.030,0.03,0.03));
		} else
		#endif
		{}
	}
	
	/* re-rotate */
	vec4 viewVertex = gbufferModelView * position;

	distance = length(viewVertex);

	/* projectify */
	gl_Position = gl_ProjectionMatrix * viewVertex;

	//gl_FogFragCoord = gl_Position.z;
	gl_FogFragCoord = distance;

	normal.xyz = normalize(gl_NormalMatrix * gl_Normal);

	if (gl_Normal.y > 0.5) {
		//  0.0,  1.0,  0.0
		tangent.xyz  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal.xyz = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
	} else if (gl_Normal.x > 0.5) {
		//  1.0,  0.0,  0.0
		tangent.xyz  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0, -1.0));
		binormal.xyz = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	} else if (gl_Normal.x < -0.5) {
		// -1.0,  0.0,  0.0
		tangent.xyz  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
		binormal.xyz = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	} else if (gl_Normal.z > 0.5) {
		//  0.0,  0.0,  1.0
		tangent.xyz  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal.xyz = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	} else if (gl_Normal.z < -0.5) {
		//  0.0,  0.0, -1.0
		tangent.xyz  = normalize(gl_NormalMatrix * vec3(-1.0,  0.0,  0.0));
		binormal.xyz = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	} else if (gl_Normal.y < -0.5) {
		//  0.0, -1.0,  0.0
		tangent.xyz  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal.xyz = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
	}

	mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
                          tangent.y, binormal.y, normal.y,
                          tangent.z, binormal.z, normal.z);
	
	viewVector.xyz = normalize(tbnMatrix * (gl_ModelViewMatrix * gl_Vertex).xyz);
}
