#version 120





//to increase shadow draw distance, edit SHADOWDISTANCE and SHADOWHPL below. Both should be equal. Needs decimal point.
//disabling is done by adding "//" to the beginning of a line.





//ADJUSTABLE VARIABLES

#define BLURFACTOR 3.5
#define SHADOW_DARKNESS 1.650   // 1.0 Is defualt darkness. 2.0 is black shadows. 0.0 is no shadows.
#define SHADOWDISTANCE 80.0 
#define SHADOW_FILTER

/* SHADOWRES:1024 */
/* SHADOWHPL:80.0 */

#define SSAO
#define SSAO_STRENGTH 2.4               // Too much strength causes white highlights on extruding edges and behind objects
#define SSAO_LOOP 1						// Integer affecting samples that are taken to calculate SSAO. Higher values mean more accurate shadowing but bigger performance impact
#define SSAO_NOISE true					// Randomize SSAO sample gathering. With noise enabled and SSAO_LOOP set to 1, you will see higher performance at the cost of fuzzy dots in shaded areas.
#define SSAO_NOISE_AMP 1.7				// Multiplier of noise. Higher values mean SSAO takes random samples from a larger radius. Big performance hit at higher values.
#define SSAO_GAREA 4.0f					// How deep any object is assumed to be in the z-axis in eye space when calculating SSAO. Higher values make shadows persist "deeper" into the image and causes a halo/drop shadow effect
#define SSAO_MAX_DEPTH 0.6				// View distance of SSAO
#define SSAO_SAMPLE_DELTA 0.75			// Radius of SSAO shadows. Higher values cause more performance hit.
#define CORRECTSHADOWCOLORS				// Colors sunlight and ambient light correctly
#define SHADOWOFFSET 0.0				// Shadow offset multiplier. Values that are too low will cause artefacts.
//#define FXAA							// FXAA shader. Broken, but you can give it a try if you want.
#define GODRAYS
#define GODRAYS_EXPOSURE 0.15
#define GODRAYS_SAMPLES 6
#define GODRAYS_DECAY 0.45
#define GODRAYS_DENSITY 0.85
#define GAMMA_FIX 2.2

//#define PRESERVE_COLOR_RANGE

//END OF ADJUSTABLE VARIABLES






uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D gnormal;
uniform sampler2D composite;
uniform sampler2D shadow;
uniform sampler2D gaux1;
uniform sampler2D gaux2;

varying vec4 texcoord;
varying vec4 lmcoord;
varying vec3 lightVector;

uniform int worldTime;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform vec3 sunPosition;

uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float aspectRatio;



// Standard depth function.
float getDepth(vec2 coord) {
    return 2.0f * near * far / (far + near - (2.0f * texture2D(gdepth, coord).x - 1.0f) * (far - near));
}

//Auxilliary variables
float	land 			 = texture2D(gaux1, texcoord.st).b;
//float	noblur 			 = texture2D(gaux1, texcoord.st).r;
vec3	sunPos			 = sunPosition;
vec2 	Texcoord2		 = texcoord.st;
float 	iswater			 = texture2D(gaux1, texcoord.st).g;
vec3 	normal         	 = texture2D(gnormal, texcoord.st).rgb * 2.0f - 1.0f;
float 	translucent		 = texture2D(gaux1, texcoord.st).r;

//Crossfading conditionals

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float landx = land;

//Lightmaps

float sky_lightmap = texture2D(gaux2, texcoord.st).b;
float torch_lightmap = texture2D(gaux2, texcoord.st).r;
float lightning_lightmap = texture2D(gaux2, texcoord.st).g;


//Calculate Time of Day

	float timefract = worldTime;

	float TimeSunrise  = ((clamp(timefract, 23000.0f, 24000.0f) - 23000.0f) / 1000.0f) + (1.0f - (clamp(timefract, 0.0f, 2000.0f)/2000.0f));
	float TimeNoon     = ((clamp(timefract, 0.0f, 2000.0f)) / 2000.0f) - ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f);
	float TimeSunset   = ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f) - ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f);
	float TimeMidnight = ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f) - ((clamp(timefract, 23000.0f, 24000.0f) - 23000.0f) / 1000.0f);


	
	
	
#ifdef SSAO

// Alternate projected depth (used by SSAO, probably AA too)
float getProDepth(vec2 coord) {
	float depth = texture2D(gdepth, coord).x;
	return ( 2.0f * near ) / ( far + near - depth * ( far - near ) );
}

float znear = near; //Z-near
float zfar = far; //Z-far

float diffarea = 0.5f; //self-shadowing reduction
float gdisplace = 0.30f; //gauss bell center

//bool noise = SSAO_NOISE; //use noise instead of pattern for sample dithering?
bool onlyAO = false; //use only ambient occlusion pass?

vec2 texCoord = texcoord.st;


vec2 rand(vec2 coord) { //generating noise/pattern texture for dithering
  const float width = 1.0f;
  const float height = 1.0f;
  float noiseX = ((fract(1.0f-coord.s*(width/2.0f))*0.25f)+(fract(coord.t*(height/2.0f))*0.75f))*2.0f-1.0f;
  float noiseY = ((fract(1.0f-coord.s*(width/2.0f))*0.75f)+(fract(coord.t*(height/2.0f))*0.25f))*2.0f-1.0f;

  //generate SSAO noise
  noiseX = clamp(fract(sin(dot(coord ,vec2(12.9898f,78.233f))) * 43758.5453f),0.0f,1.0f)*2.0f-1.0f;
  noiseY = clamp(fract(sin(dot(coord ,vec2(12.9898f,78.233f)*2.0f)) * 43758.5453f),0.0f,1.0f)*2.0f-1.0f;
  
  return vec2(noiseX,noiseY)*0.002f*SSAO_NOISE_AMP;
}


float compareDepths(in float depth1, in float depth2, in int zfar) {  
  float garea = SSAO_GAREA; //gauss bell width    
  float diff = (depth1 - depth2) * 100.0f; //depth difference (0-100)
  //reduce left bell width to avoid self-shadowing 
  
  if (diff < gdisplace) {
    garea = diffarea;
  } else {
    zfar = 1;
  }


  float gauss = pow(2.1182f,-2.0f*(diff-gdisplace)*(diff-gdisplace)/(garea*garea));
  return gauss;
} 

float calAO(float depth, float dw, float dh) {  
  float temp = 0.0f;
  float temp2 = 0.0f;
  dw *= 2.0f;
  dh *= 2.0f;
  float coordw = texCoord.x + dw/(depth*0.5f + 0.1f);
  float coordh = texCoord.y + dh/(depth*0.5f + 0.1f);
  float coordw2 = texCoord.x - dw/(depth*0.5f + 0.1f);
  float coordh2 = texCoord.y - dh/(depth*0.5f + 0.1f);

  if (coordw  < 1.0f && coordw  > 0.0f && coordh < 1.0f && coordh  > 0.0f){
    vec2 coord = vec2(coordw , coordh);
    vec2 coord2 = vec2(coordw2, coordh2);
    int zfar = 0;
    temp = compareDepths(depth, getProDepth(coord),zfar);

    //DEPTH EXTRAPOLATION:
    if (zfar > 0){
      temp2 = compareDepths(getProDepth(coord2),depth,zfar);
      temp += (1.0f-temp)*temp2; 
    }
  }

  return temp;  
}  



float getSSAOFactor() {

  float incx = 1.0f / viewWidth * SSAO_SAMPLE_DELTA;
  float incy = 1.0f / viewHeight * SSAO_SAMPLE_DELTA;
  
  
	vec2 noise1 = rand(texCoord)*2.0f; 
	
	/*
	vec2 noise2 = rand(texCoord + vec2(incx, incy)*10); 
	vec2 noise3 = rand(texCoord + vec2(incx, -incy)*10); 
	vec2 noise4 = rand(texCoord + vec2(-incx, incy)*10); 
	vec2 noise5 = rand(texCoord + vec2(-incx, -incy)*10); 
	*/
	
	
	float depth = getProDepth(texCoord);
  if (depth > SSAO_MAX_DEPTH) {
    return 1.0f;
  }
  float cdepth = texture2D(gdepth,texCoord).g;
	
	float ao;
	float s;
	

  float pw = incx;
  float ph = incy;
  float aoMult = SSAO_STRENGTH;
  int aaLoop = SSAO_LOOP;
  float aaDiff = (1.0f + 2.0f / 1.0f); // 1.0 is samples

    float npw  = (pw + 0.05f * noise1.x) / cdepth;
    float nph  = (ph + 0.05f * noise1.y) / cdepth;
	

	float npw2  = (pw*2.0f + 0.05f * noise1.x) / cdepth;
    float nph2  = (ph*2.0f + 0.05f * noise1.y) / cdepth;
	
	float npw3  = (pw*3.0f + 0.05f * noise1.x) / cdepth;
    float nph3  = (ph*3.0f + 0.05f * noise1.y) / cdepth;
	
	float npw4  = (pw*4.0f + 0.05f * noise1.x) / cdepth;
    float nph4  = (ph*4.0f + 0.05f * noise1.y) / cdepth;

    ao += calAO(depth, npw, nph) * aoMult;
    ao += calAO(depth, npw, -nph) * aoMult;
    ao += calAO(depth, -npw, nph) * aoMult;
    ao += calAO(depth, -npw, -nph) * aoMult;
	
	ao += calAO(depth, npw2, 0.0) * aoMult/1.5f;
    ao += calAO(depth, -npw2, 0.0) * aoMult/1.5f;
    ao += calAO(depth, 0.0f, nph2) * aoMult/1.5f;
    ao += calAO(depth, 0.0f, -nph2) * aoMult/1.5f;
	
	ao += calAO(depth, npw3, nph3) * aoMult/2.0f;
    ao += calAO(depth, npw3, -nph3) * aoMult/2.0f;
    ao += calAO(depth, -npw3, nph3) * aoMult/2.0f;
    ao += calAO(depth, -npw3, -nph3) * aoMult/2.0f;
	
	
	/*
	ao += calAO(depth, npw4, 0.0f) * aoMult/2.5f;
    ao += calAO(depth, -npw4, 0.0f) * aoMult/2.5f;
    ao += calAO(depth, 0.0f, nph4) * aoMult/2.5f;
    ao += calAO(depth, 0.0f, -nph4) * aoMult/2.5f;
	
	
	 ao += calAO(depth, 2.0*npw2, 2.0*nph2) * aoMult/3.0;
    ao += calAO(depth, 2.0*npw2, -2.0*nph2) * aoMult/3.0;
    ao += calAO(depth, -2.0*npw2, 2.0*nph2) * aoMult/3.0;
    ao += calAO(depth, -2.0*npw2, -2.0*nph2) * aoMult/3.0;
	
	 ao += calAO(depth, 2.0*npw3, 0.0*nph3) * aoMult/3.5;
    ao += calAO(depth, -2.0*npw3, 0.0*nph3) * aoMult/3.5;
    ao += calAO(depth, 0.0*npw3, 2.0*nph3) * aoMult/3.5;
    ao += calAO(depth, 0.0*npw3, -2.0*nph3) * aoMult/3.5;
	
	 ao += calAO(depth, 2.0*npw4, 2.0*nph4) * aoMult/4.0;
    ao += calAO(depth, 2.0*npw4, -2.0*nph4) * aoMult/4.0;
    ao += calAO(depth, -2.0*npw4, 2.0*nph4) * aoMult/4.0;
    ao += calAO(depth, -2.0*npw4, -2.0*nph4) * aoMult/4.0;
	*/
	
	ao /= 16.0f;
	ao = 1.0f-ao;	
  ao = clamp(ao * 1.5, 0.0f, 1.0f) * 1.0f;
	
  return ao;
}

#endif


#ifdef FXAA

vec4 fxaa() { 
	float pw = 1.0 / viewWidth;
	float ph = 1.0 / viewHeight;
	
	vec3 rgbNW = texture2D(gcolor, texcoord.xy + vec2(-pw,-ph)).xyz;
	vec3 rgbNE = texture2D(gcolor, texcoord.xy + vec2(pw,-ph)).xyz;
	vec3 rgbSW = texture2D(gcolor, texcoord.xy + vec2(-pw,ph)).xyz;
	vec3 rgbSE = texture2D(gcolor, texcoord.xy + vec2(pw,ph)).xyz;
	vec3 rgbM =  texture2D(gcolor, texcoord.xy).xyz;
	
	vec3 luma = vec3(0.299, 0.587, 0.114);
	float lumaNW = dot(rgbNW, luma);
	float lumaNE = dot(rgbNE, luma);
	float lumaSW = dot(rgbSW, luma);
	float lumaSE = dot(rgbSE, luma);
	float lumaM = dot(rgbM, luma);
	
	float lumaMin = min(lumaM, min(min(lumaNW,lumaNE),min(lumaSW,lumaSE)));
	float lumaMax = max(lumaM, max(max(lumaNW,lumaNE),max(lumaSW,lumaSE)));
	
	vec2 dir;
	dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));
	dir.y = ((lumaNW + lumaSW) - (lumaNE + lumaSE));
	
	float dirReduce = max((lumaNW + lumaNE + lumaSW + lumaSE) * (0.25 * 1.0/8.0), 1.0/128.0);
	
	float rcpDirMin = 1.0 /(min(abs(dir.x), abs(dir.y)) + dirReduce);
	
	dir = min(vec2(4.0,4.0),max(vec2(-4.0,-4.0),dir * rcpDirMin)) * vec2(pw,ph);
	
	vec3 rgbA = (1.0/2.0) * (texture2D(gcolor, texcoord.xy + dir * (1.0/3,0 - 0.5)).xyz + 
							texture2D(gcolor, texcoord.xy + dir * (2.0/3.0 - 0.5)).xyz);
							
	vec3 rgbB = rgbA * (1.0/2.0) + (1.0/4.0) * (texture2D(gcolor, texcoord.xy + dir * (0.0/3.0 - 0.5)).xyz + 
												texture2D(gcolor, texcoord.xy + dir * (3.0/3.0 - 0.5)).xyz);
	
	float lumaB = dot(rgbB, luma);
	
	if((lumaB < lumaMin) || (lumaB > lumaMax)) {
		return vec4(rgbA , 1.0);
	}
	return vec4(rgbB, 1.0);
}



#endif


#ifdef GODRAYS



	float addGodRays(in float nc, in vec2 tx, in float noise, in float noise2, in float noise3, in float noise4, in float noise5) {
			float GDTimeMult = 0.0f;
			if (sunPos.z > 0.0f) {
				sunPos.z = -sunPos.z;
				sunPos.x = -sunPos.x;
				sunPos.y = -sunPos.y;
				GDTimeMult = TimeMidnight;
			} else {
				GDTimeMult = TimeSunrise + TimeNoon + TimeSunset;
			}
			vec2 lightPos = sunPos.xy / -sunPos.z;
			lightPos.y *= 1.39f;
			lightPos.x *= 0.76f;
			lightPos = (lightPos + 1.0f)/2.0f;
			//vec2 coord = tx;
			vec2 delta = (tx - lightPos) * GODRAYS_DENSITY / float(3.0);
			delta *= -sunPos.z*0.01f;
			//delta *= -sunPos.z*0.01;
			float decay = -sunPos.z / 100.0f;
				 // decay *= -sunPos.z*0.01;
			float colorGD = 0.0f;
			
			for (int i = 0; i < 3; i++) {
			
			if (texcoord.s > 1.0f || texcoord.s < 0.0f || texcoord.t > 1.0f || texcoord.t < 0.0f) {
				break;
			}
			
				tx -= delta;
				tx.x = clamp(tx.x, 0.0f, 1.0f);
				tx.y = clamp(tx.y, 0.0f, 1.0f);
				float sample = 0.0f;

					sample = 1.0f - texture2D(gaux1, tx + vec2(noise*delta.x, noise*delta.y)).b;
					sample += 1.0f - texture2D(gaux1, tx + vec2(noise2*delta.x, noise2*delta.y)).b;
					sample += 1.0f - texture2D(gaux1, tx + vec2(noise3*delta.x, noise3*delta.y)).b;
					sample += 1.0f - texture2D(gaux1, tx + vec2(noise4*delta.x, noise4*delta.y)).b;
					sample += 1.0f - texture2D(gaux1, tx + vec2(noise5*delta.x, noise5*delta.y)).b;
				sample *= decay;

					colorGD += sample;
					decay *= GODRAYS_DECAY;
			}
			
			float bubble = distance(vec2(delta.x*aspectRatio, delta.y), vec2(0.0f, 0.0f))*3.0f;
				  bubble = clamp(bubble, 0.0f, 1.0f);
				  bubble = 1.0f - bubble;
				  bubble = pow(bubble, 2.0f);
				  
			return (nc + GODRAYS_EXPOSURE * (colorGD*bubble))*GDTimeMult;
        
	}
#endif 










void main() {

float noiseamp = 0.3f;
					
						float width2 = 1.0f;
						float height2 = 1.0f;
						float noiseX2 = ((fract(1.0f-Texcoord2.s*(width2/2.0f))*0.25f)+(fract(Texcoord2.t*(height2/2.0f))*0.75f))*2.0f-1.0f;
						float noiseY2 = ((fract(1.0f-Texcoord2.s*(width2/2.0f))*0.75f)+(fract(Texcoord2.t*(height2/2.0f))*0.25f))*2.0f-1.0f;

						
							noiseX2 = clamp(fract(sin(dot(Texcoord2 ,vec2(12.9898f,78.233f))) * 43758.5453f),0.0f,1.0f)*2.0f-1.0f;
							noiseY2 = clamp(fract(sin(dot(Texcoord2 ,vec2(12.9898f,78.233f)*2.0f)) * 43758.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX2 *= (0.0005f*noiseamp);
						noiseY2 *= (0.0005f*noiseamp);
						
						float width3 = 2.0f;
						float height3 = 2.0f;
						float noiseX3 = ((fract(1.0f-Texcoord2.s*(width3/2.0f))*0.25f)+(fract(Texcoord2.t*(height3/2.0f))*0.75f))*2.0f-1.0f;
						float noiseY3 = ((fract(1.0f-Texcoord2.s*(width3/2.0f))*0.75f)+(fract(Texcoord2.t*(height3/2.0f))*0.25f))*2.0f-1.0f;

						
							noiseX3 = clamp(fract(sin(dot(Texcoord2 ,vec2(18.9898f,28.633f))) * 4378.5453f),0.0f,1.0f)*2.0f-1.0f;
							noiseY3 = clamp(fract(sin(dot(Texcoord2 ,vec2(11.9898f,59.233f)*2.0f)) * 3758.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX3 *= (0.0005f*noiseamp);
						noiseY3 *= (0.0005f*noiseamp);
						
						float width4 = 3.0f;
						float height4 = 3.0f;
						float noiseX4 = ((fract(1.0f-Texcoord2.s*(width4/2.0f))*0.25f)+(fract(Texcoord2.t*(height4/2.0f))*0.75f))*2.0f-1.0f;
						float noiseY4 = ((fract(1.0f-Texcoord2.s*(width4/2.0f))*0.75f)+(fract(Texcoord2.t*(height4/2.0f))*0.25f))*2.0f-1.0f;

						
							noiseX4 = clamp(fract(sin(dot(Texcoord2 ,vec2(16.9898f,38.633f))) * 41178.5453f),0.0f,1.0f)*2.0f-1.0f;
							noiseY4 = clamp(fract(sin(dot(Texcoord2 ,vec2(21.9898f,66.233f)*2.0f)) * 9758.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX4 *= (0.0005f*noiseamp);
						noiseY4 *= (0.0005f*noiseamp);
						
						//float width5 = 4.0f;
						//float height5 = 4.0f;
						//float noiseX5 = ((fract(1.0f-Texcoord2.s*(width5/2.0f))*0.25f)+(fract(Texcoord2.t*(height5/2.0f))*0.75f))*2.0f-1.0f;
						//float noiseY5 = ((fract(1.0f-Texcoord2.s*(width5/2.0f))*0.75f)+(fract(Texcoord2.t*(height5/2.0f))*0.25f))*2.0f-1.0f;

						
							//noiseX5 = clamp(fract(sin(dot(Texcoord2 ,vec2(11.9898f,68.633f))) * 21178.5453f),0.0f,1.0f)*2.0f-1.0f;
							//noiseY5 = clamp(fract(sin(dot(Texcoord2 ,vec2(26.9898f,71.233f)*2.0f)) * 6958.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						//noiseX5 *= (0.0005f*noiseamp);
						//noiseY5 *= (0.0005f*noiseamp);
						

//



	vec4 fragposition = gbufferProjectionInverse * vec4(texcoord.s * 2.0f - 1.0f, texcoord.t * 2.0f - 1.0f, 2.0f * texture2D(gdepth, texcoord.st).y - 1.0f, 1.0f);
	fragposition /= fragposition.w;
	
	#ifdef SHADOWDISTANCE
	float drawdistance = SHADOWDISTANCE;
	float drawdistancesquared = pow(drawdistance, 2.0f);
	#endif
	
	float distance = sqrt(fragposition.x * fragposition.x + fragposition.y * fragposition.y + fragposition.z * fragposition.z);

	float shading = 1.0f;
	float shadingsharp = 1.0f;
	
	
	vec4 worldposition = vec4(0.0);
	vec4 worldpositionraw = vec4(0.0);
			
	worldposition = gbufferModelViewInverse * fragposition;	
	
	float xzDistanceSquared = worldposition.x * worldposition.x + worldposition.z * worldposition.z;
	float yDistanceSquared  = worldposition.y * worldposition.y;
	
	worldpositionraw = worldposition;
	
			worldposition = shadowModelView * worldposition;
			float comparedepth = -worldposition.z;
			worldposition = shadowProjection * worldposition;
			worldposition /= worldposition.w;
			
			worldposition.st = worldposition.st * 0.5f + 0.5f;
			
			
			
			
			////////////////////////////////////WAVES////////////////////////////
			////////////////////////////////////WAVES////////////////////////////
			////////////////////////////////////WAVES////////////////////////////
float wsize = 5.0f*3.0;
float wspeed = 0.3f;

float rs0 = abs(sin((worldTime*wspeed/5.0) + (worldposition.s*wsize) * 20.0 + (worldposition.z*4.0))+0.2);
float rs1 = abs(sin((worldTime*wspeed/7.0) + (worldposition.t*wsize) * 27.0));
float rs2 = abs(sin((worldTime*wspeed/2.0) + (worldposition.t*wsize) * 60.0 - sin(worldposition.s*wsize) * 13.0)+0.4);
float rs3 = abs(sin((worldTime*wspeed/1.0) - (worldposition.s*wsize) * 20.0 + cos(worldposition.t*wsize) * 83.0)+0.1);

float wsize2 = 5.4f*1.5;
float wspeed2 = 0.2f;

float rs0a = abs(sin((worldTime*wspeed2/4.0) + (worldposition.s*wsize2) * 24.0));
float rs1a = abs(sin((worldTime*wspeed2/11.0) + (worldposition.t*wsize2) * 77.0  - (worldposition.z*6.0))+0.3);
float rs2a = abs(sin((worldTime*wspeed2/6.0) + (worldposition.s*wsize2) * 50.0 - (worldposition.t*wsize2) * 23.0)+0.12);
float rs3a = abs(sin((worldTime*wspeed2/14.0) - (worldposition.t*wsize2) * 4.0 + (worldposition.s*wsize2) * 98.0));

float wsize3 = 2.0f*0.75;
float wspeed3 = 0.3f;

float rs0b = abs(sin((worldTime*wspeed3/4.0) + (worldposition.s*wsize3) * 14.0));
float rs1b = abs(sin((worldTime*wspeed3/11.0) + (worldposition.t*wsize3) * 37.0 + (worldposition.z*1.0)));
float rs2b = abs(sin((worldTime*wspeed3/6.0) + (worldposition.t*wsize3) * 47.0 - cos(worldposition.s*wsize3) * 33.0 + rs0a + rs0b));
float rs3b = abs(sin((worldTime*wspeed3/14.0) - (worldposition.s*wsize3) * 13.0 + sin(worldposition.t*wsize3) * 98.0 + rs0 + rs1));

float waves = (rs1 * rs0 + rs2 * rs3)/2.0f;
float waves2 = (rs0a * rs1a + rs2a * rs3a)/2.0f;
float waves3 = (rs0b + rs1b + rs2b + rs3b)*0.25;

float allwaves = (waves + waves2 + waves3)/3.0f;
	  allwaves *= 1.0;
	  
float shadingsoft = 1.0f;

float shadowMult = 0.0f;

	
	if (distance < drawdistance && distance > 0.0f) {
		
		
		if (yDistanceSquared < drawdistancesquared) {
			

				
			if (comparedepth > 0.0f && worldposition.s < 1.0f && worldposition.s > 0.0f && worldposition.t < 1.0f && worldposition.t > 0.0f){
				shadowMult = min(1.0f - xzDistanceSquared / drawdistancesquared, 1.0f) * min(1.0f - yDistanceSquared / drawdistancesquared, 1.0f);
				shadowMult = pow(shadowMult, 0.3f);
				float sampleDistance = 1.0f / 2048.0f;
					
					
					
			
					
				
				
					float zoffset = 0.01f;
					float offsetx = -0.0000f*BLURFACTOR*SHADOWOFFSET*(TimeSunset * 2.0f - 1.0f);
					float offsety = 0.0000f*BLURFACTOR*SHADOWOFFSET;
				
					
					//shadow filtering
					
					float step = 1.0f/2048.0f;
					float shadowdarkness = 0.5f*SHADOW_DARKNESS;
					float diffthresh = 0.45f;
					float bluramount = 0.00009f*BLURFACTOR;
					
					
					
					
					
					
					//shading += -0.02 - shadowMult * (clamp(comparedepth - (0.05f + (texture2D(shadow, worldposition.st + vec2(1.0f*bluramount+offsetx, 1.0f*bluramount+offsety)).z) * (256.0f - 0.05f)) - zoffset, 0.0f, diffthresh)/diffthresh * shadowdarkness - zoffset);

				#ifdef SHADOW_FILTER
				
						shading = 1.0f;
			
					
						
							
							float xfadescale = 8.0f;
							
							/*
							if (rainStrength > 0.1) {
								xfadescale = 0.0;
							}
							*/
							
							xfadescale = mix(xfadescale, 5.0f, rainx);


							float trans = 0.0005f * xfadescale;
							
							float neg = 0.0f;
							
							float diffthresh2 = 1.0f;
							
							
					//bluramount *= xfadescale;
					
				/*
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX2*xfadescale + offsetx + trans*0.5, noiseY2*xfadescale + offsety + trans*0.5)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*9.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX3*xfadescale + offsetx + trans*0.5, noiseY3*xfadescale + offsety - trans*0.5)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*9.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX4*xfadescale + offsetx - trans*0.5, noiseY4*xfadescale + offsety + trans*0.5)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*9.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX5*xfadescale + offsetx - trans*0.5, noiseY5*xfadescale + offsety - trans*0.5)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*9.0;
					
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX2*xfadescale + offsetx + trans, noiseY2*xfadescale + offsety + trans)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*8.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX3*xfadescale + offsetx + trans, noiseY3*xfadescale + offsety - trans)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*8.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX4*xfadescale + offsetx - trans, noiseY4*xfadescale + offsety + trans)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*8.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX5*xfadescale + offsetx - trans, noiseY5*xfadescale + offsety - trans)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*8.0;
					
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX2*xfadescale + offsetx + trans*2.0, noiseY2*xfadescale + offsety + trans*2.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*7.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX3*xfadescale + offsetx + trans*2.0, noiseY3*xfadescale + offsety - trans*2.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*7.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX4*xfadescale + offsetx - trans*2.0, noiseY4*xfadescale + offsety + trans*2.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*7.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX5*xfadescale + offsetx - trans*2.0, noiseY5*xfadescale + offsety - trans*2.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*7.0;
					
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX2*xfadescale + offsetx + trans*0.0, noiseY2*xfadescale + offsety + trans*2.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*7.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX3*xfadescale + offsetx + trans*0.0, noiseY3*xfadescale + offsety - trans*2.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*7.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX4*xfadescale + offsetx + trans*2.0, noiseY4*xfadescale + offsety + trans*0.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*7.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX5*xfadescale + offsetx - trans*2.0, noiseY5*xfadescale + offsety - trans*0.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*7.0;
					
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX2*xfadescale + offsetx + trans*3.0, noiseY2*xfadescale + offsety + trans*3.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*6.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX3*xfadescale + offsetx + trans*3.0, noiseY3*xfadescale + offsety - trans*3.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*6.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX4*xfadescale + offsetx - trans*3.0, noiseY4*xfadescale + offsety + trans*3.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*6.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX5*xfadescale + offsetx - trans*3.0, noiseY5*xfadescale + offsety - trans*3.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*6.0;
					
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX2*xfadescale + offsetx + trans*3.0, noiseY2*xfadescale + offsety + trans*0.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*6.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX3*xfadescale + offsetx - trans*3.0, noiseY3*xfadescale + offsety - trans*0.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*6.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX4*xfadescale + offsetx - trans*0.0, noiseY4*xfadescale + offsety + trans*3.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*6.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX5*xfadescale + offsetx - trans*0.0, noiseY5*xfadescale + offsety - trans*3.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*6.0;
					
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX2*xfadescale + offsetx + trans*4.0, noiseY2*xfadescale + offsety + trans*4.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*5.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX3*xfadescale + offsetx + trans*4.0, noiseY3*xfadescale + offsety - trans*4.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*5.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX4*xfadescale + offsetx - trans*4.0, noiseY4*xfadescale + offsety + trans*4.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*5.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX5*xfadescale + offsetx - trans*4.0, noiseY5*xfadescale + offsety - trans*4.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*5.0;
					
					
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX2*xfadescale + offsetx + trans*0.0, noiseY2*xfadescale + offsety + trans*4.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*5.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX3*xfadescale + offsetx + trans*0.0, noiseY3*xfadescale + offsety - trans*4.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*5.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX4*xfadescale + offsetx + trans*4.0, noiseY4*xfadescale + offsety + trans*0.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*5.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX5*xfadescale + offsetx - trans*4.0, noiseY5*xfadescale + offsety - trans*0.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*5.0;
					
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX2*xfadescale + offsetx + trans*5.0, noiseY2*xfadescale + offsety + trans*5.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*4.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX3*xfadescale + offsetx + trans*5.0, noiseY3*xfadescale + offsety - trans*5.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*4.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX4*xfadescale + offsetx - trans*5.0, noiseY4*xfadescale + offsety + trans*5.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*4.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX5*xfadescale + offsetx - trans*5.0, noiseY5*xfadescale + offsety - trans*5.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*4.0;
				
				
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX2*xfadescale + offsetx + trans*0.0, noiseY2*xfadescale + offsety + trans*5.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*4.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX3*xfadescale + offsetx + trans*0.0, noiseY3*xfadescale + offsety - trans*5.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*4.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX4*xfadescale + offsetx + trans*5.0, noiseY4*xfadescale + offsety + trans*0.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*4.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX5*xfadescale + offsetx - trans*5.0, noiseY5*xfadescale + offsety - trans*0.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*4.0;
					
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX2*xfadescale + offsetx + trans*6.0, noiseY2*xfadescale + offsety + trans*6.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*3.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX3*xfadescale + offsetx + trans*6.0, noiseY3*xfadescale + offsety - trans*6.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*3.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX4*xfadescale + offsetx - trans*6.0, noiseY4*xfadescale + offsety + trans*6.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*3.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX5*xfadescale + offsetx - trans*6.0, noiseY5*xfadescale + offsety - trans*6.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*3.0;
					
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX2*xfadescale + offsetx + trans*6.0, noiseY2*xfadescale + offsety + trans*0.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*3.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX3*xfadescale + offsetx - trans*6.0, noiseY3*xfadescale + offsety - trans*0.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*3.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX4*xfadescale + offsetx - trans*0.0, noiseY4*xfadescale + offsety + trans*6.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*3.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX5*xfadescale + offsetx - trans*0.0, noiseY5*xfadescale + offsety - trans*6.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*3.0;
					
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX2*xfadescale + offsetx + trans*7.0, noiseY2*xfadescale + offsety + trans*7.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*2.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX3*xfadescale + offsetx + trans*7.0, noiseY3*xfadescale + offsety - trans*7.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*2.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX4*xfadescale + offsetx - trans*7.0, noiseY4*xfadescale + offsety + trans*7.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*2.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX5*xfadescale + offsetx - trans*7.0, noiseY5*xfadescale + offsety - trans*7.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*2.0;
					
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX2*xfadescale + offsetx + trans*7.0, noiseY2*xfadescale + offsety + trans*0.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*2.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX3*xfadescale + offsetx - trans*7.0, noiseY3*xfadescale + offsety - trans*0.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*2.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX4*xfadescale + offsetx - trans*0.0, noiseY4*xfadescale + offsety + trans*7.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*2.0;
					shading +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(noiseX5*xfadescale + offsetx - trans*0.0, noiseY5*xfadescale + offsety - trans*7.0)).z) * (256.0 - 0.05)) - zoffset, neg, diffthresh2)/diffthresh2 * shadowdarkness - zoffset)*2.0;
					

					shading = (shading/57.0)/6.0;
					
					shading = 1.0f - shading;
					
					shading *= 3.0; 
					shading += 2.7;
					
					*/
					
					shadingsoft = shading;
					
					const float confusion = 1.0f;
					
					
					//determine shadow depth
					float shaddepth = 0.0;
					float sds = 0.0f;
					float shaddepthspread = 0.85f * confusion;
					float stxd = -0.0010f * shaddepthspread;
					float styd = -0.0010f * shaddepthspread;
					
					for (int i = 0; i < 5; ++i) {
						stxd = -0.0010f * shaddepthspread;
						
							for (int j = 0; j < 5; ++j) {
								//shaddepth =   max(shaddepth, shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(offsetx + stxd, offsety + styd) + vec2(0.0001f, 0.0001f)).z) * (256.0 - 0.05)) - zoffset, 0.0, 30.0f)/30.0f - zoffset));
								shaddepth +=   pow(shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(offsetx + stxd, offsety + styd) + vec2(0.0001f, 0.0001f)).z) * (256.0 - 0.05)), 0.0, 20.0f)/20.0f), 2.0f);
								stxd += 0.0005f * shaddepthspread;
								sds += 1.0f;
							}
						styd += 0.0005f * shaddepthspread;
					}
					shaddepth /= sds;
					shaddepth = pow(shaddepth, 0.50f);
					
					
					//fix shadow threshold
					diffthresh = 3.9f * shaddepth * confusion + 0.75f;

					
					//do shadows with variable blur
					shadingsharp = 1.0;
					
					int ssamp = 0;
					float shadspread = 1.7f * confusion;
					float stx = -0.0015f * shadspread;
					float sty = -0.0015f * shadspread;
					float nx = 1.4f * confusion;
					
					for (int i = 0; i < 7; ++i) {
						stx = -0.0015f * shadspread;
						
							for (int j = 0; j < 7; ++j) {
								shadingsharp +=   shadowMult * (clamp(comparedepth - (0.05 + (texture2D(shadow, worldposition.st + vec2(offsetx + stx * shaddepth + noiseX2*nx* shaddepth, offsety + sty * shaddepth + noiseX2*nx* shaddepth) + vec2(0.0001f, 0.0001f)).z) * (256.0 - 0.05)), 0.0, diffthresh)/diffthresh);
								ssamp += 1;
								stx += 0.0005f * shadspread;
							}
						sty += 0.0005f * shadspread;
					}
					
					shadingsharp /= (ssamp * 1.0f);
					shadingsharp = 1.0f - shadingsharp;


					shadingsharp *= 1.0;
					shadingsharp -= 0.0;
					
					
					/*
										if (rainStrength > 0.1) {
											
											shading = 2.2;
											shadingsharp = 0.8;
										}
										*/
										
										//raining
										shading = mix(shading, shading, rainx);
										shadingsharp = mix(shadingsharp, 0.2, rainx);
										//remove sharp shadows from water
										shadingsharp = mix(shadingsharp, 0.2f, iswater);
										
										shading = shadingsharp;
										shading *= 1.15;
										//shading -= 0.2f;
										shading = clamp(shading, 0.0, 1.0);
										
									
									
										
										
				#endif
					

					//shading = mix(shading, 1.0f, iswater);
					
/*
				float caustic1 = allwaves - clamp(allwaves - 0.5f, 0.0f, 1.0f)*2.0f;				
					  caustic1 *= 2.0f;
					  caustic1 = pow(caustic1, 20.0f);
					  float allwaves1 = pow(allwaves, 1.0f);
				float caustic2 = fwidth(allwaves1)*10.0f;
					  
					  
				float caustics = caustic2;
				
					  caustics *= clamp(iswater + isunderwater, 0.0f, 1.0f);
					  caustics = pow(caustics, 2.0f);


				shading *= caustics + 1.0f;
					
					
				shading = clamp(shading, 0.0, 1.5);
					*/	

								//remove shadows from sky
					
					shading *= shadingsoft;
			
			
			}
		}
	}
	
	//////////////////DIRECTIONAL LIGHTING WITH NORMAL MAPPING////////////////////
	//////////////////DIRECTIONAL LIGHTING WITH NORMAL MAPPING////////////////////
	//////////////////DIRECTIONAL LIGHTING WITH NORMAL MAPPING////////////////////

					
					vec3 npos = normalize(fragposition.xyz);

					
					//vec3 specular = reflect(npos, normal);
	
					//float fresnel = distance(normal.xy, vec2(0.0f));
					//	fresnel = pow(fresnel, 6.0f);
					//	fresnel *= 3.0f;
					
					float sunlight = dot(normal, lightVector);
	

					float direct  = clamp(sunlight + 0.02f, 0.0, 1.02f);
						  direct = pow(direct, 1.1f);
						  //direct += max(1.0f - dot(normal, lightVector) * 3.0f - 2.0f, 0.0) * 0.05f;
						  
					float reflected = clamp(-sunlight + 0.15f + (TimeNoon * 0.20f), 0.0f, 1.1f);
						  reflected = pow(reflected, 0.8f);
						   
						  
					//float spec = max(dot(specular, lightVector), 0.0f);
					//	  spec = pow(spec, 5.0f);
					//	  spec *= 1.0f;
					//	  spec = mix(0.0f, spec, clamp(((shading-0.05)*3.0-1.1), 0.0, 1.0));
					//	  spec = mix(0.0f, spec, shadowMult);
						
					float sunlight_direct = 0.00f + direct*1.25f;
						  //sunlight_direct = mix(1.0f, sunlight_direct, clamp(((shading-0.05)*3.0-1.1), 0.0, 1.0));
						  sunlight_direct = mix(1.0f, sunlight_direct, landx);
						  sunlight_direct = mix(sunlight_direct, 0.55f, translucent);
						  sunlight_direct += translucent * 0.6f;
						  sunlight_direct = mix(1.0f, sunlight_direct, shadowMult);

						  
					float sunlight_reflected = 1.2f + reflected*(0.45f + TimeNoon*0.30f);
						  //sunlight_reflected = mix(1.0f, sunlight_reflected, clamp(((shading+0.0)*1.0-0.0), 0.0, 1.0));
						  sunlight_reflected = mix(1.0f, sunlight_reflected, landx);
						  sunlight_reflected = mix(sunlight_reflected, 0.5f, translucent);
						  sunlight_reflected += translucent * 0.6f;

						  sunlight_reflected = mix(1.0f, sunlight_reflected, shadowMult);
					
					shading *= sunlight_direct;
					//shading *= sunlight_reflected;
					//shading += spec;
					
					shading += 0.10f;
					
					shading = mix(1.0, shading, landx);
				
 
vec4 color = texture2D(gcolor, texcoord.st);
	color.r = pow(color.r, GAMMA_FIX);
	color.g = pow(color.g, GAMMA_FIX);
	color.b = pow(color.b, GAMMA_FIX);
	

	
	
	

float sun_amb2 = clamp(((shading-0.05)*3.0-1.1), 0.0, 1.0);


	
	
#ifdef FXAA

color = fxaa();

#endif

#ifdef SSAO

  float AO = getSSAOFactor();
  
  AO = AO * 0.60f + 0.40f;
  
  //AO = mix(AO, 1.0f, noblur);
  
  AO = mix(AO * 1.5f, 2.5f - AO*1.5f, sun_amb2);
  
  AO = mix(AO, 1.0f, iswater);
  
  //remove AO from sky
  AO = mix(1.0, AO, landx);
  AO = mix(1.0f, AO, shadowMult);
  
  //color.rgb = vec3(0.75f);

  color.r *= AO * 0.5 + 0.5;
  color.g *= AO * 0.5 + 0.5;
  color.b *= AO * 0.5 + 0.5;
  
  //color.r *= (AO*0.5 + 0.5);
  //color.g *= (AO*0.5 + 0.5);
  //color.b *= (AO*0.5 + 0.5);
  
  sunlight_reflected *= clamp(AO * 1.0f, 0.0f, 1.0f);
  torch_lightmap *= AO * 0.8f + 0.2f;
  //color.rgb *= (clamp((AO*1.0), 0.0, 1.0));
  
  //Saturate AO areas
  
#endif







//Apply fake GI//
//Apply fake GI//
//Apply fake GI//

shading *= sunlight_reflected;







//Determine what is being illuminated by the sun. 1 = sunlight. 0 = shadow.
float sun_amb = clamp(((shading-0.01)*3.0-1.1), 0.0, 1.0);
	  sun_amb = max(sun_amb, 0.0f);
	  sun_amb += (sunlight_reflected - 1.0f)*0.7f;

//raining
sun_amb = mix(sun_amb, 0.4, rainx);







//Calculate lightmap colors
sky_lightmap = max(sky_lightmap, 1.0 - landx);
sky_lightmap = pow(sky_lightmap, 1.0f);
//sky_lightmap = max(sky_lightmap, iswater);
torch_lightmap = pow(torch_lightmap, 1.2f);

 float torchwhitebalance = 0.00f;


 float torchcolor_r = mix(1.0f, 1.0f, torchwhitebalance);
 float torchcolor_g = mix(0.18f, 1.0f, torchwhitebalance);
 float torchcolor_b = mix(0.0f, 1.0f, torchwhitebalance);

 
  /*
 float torchcolor_r = mix(0.0f, 1.0f, torchwhitebalance);
 float torchcolor_g = mix(0.35f, 1.0f, torchwhitebalance);
 float torchcolor_b = mix(0.98f, 1.0f, torchwhitebalance);
*/
vec3 Skylight_lightmap = vec3(sky_lightmap * 	  1.0f, sky_lightmap * 	  1.0f, sky_lightmap * 	  1.0f);
vec3 Torchlight_lightmap = vec3(torch_lightmap *  torchcolor_r, torch_lightmap *  torchcolor_g, torch_lightmap *  torchcolor_b);
vec3 LightningFlash_lightmap = vec3(lightning_lightmap *  0.8f, lightning_lightmap *  0.7f, lightning_lightmap *  1.0f);

Torchlight_lightmap.r = pow(Torchlight_lightmap.r, 1.4f);
Torchlight_lightmap.g = pow(Torchlight_lightmap.g, 1.4f);
Torchlight_lightmap.b = pow(Torchlight_lightmap.b, 1.4f);

//Apply Shadows to sky light
Skylight_lightmap *= shading;
LightningFlash_lightmap *= shading;






//Correct colors for shadows/sunlight and sky
//color.r *= 1.35;
//color.g *= 1.25;

	float sunrise_sun_r = 0.9 * TimeSunrise;
	float sunrise_sun_g = 0.839 * TimeSunrise;
	float sunrise_sun_b = 0.666 * TimeSunrise;
	
	float sunrise_amb_r = 0.352 * TimeSunrise;
	float sunrise_amb_g = 0.667 * TimeSunrise;
	float sunrise_amb_b = 0.999 * TimeSunrise;
	
	
	float noon_sun_r = 1.0 * TimeNoon;
	float noon_sun_g = 1.0 * TimeNoon;
	float noon_sun_b = 0.98 * TimeNoon;
	
	float noon_amb_r = 0.258 * TimeNoon;
	float noon_amb_g = 0.615 * TimeNoon;
	float noon_amb_b = 0.999 * TimeNoon;
	
	
	float sunset_sun_r = 0.9 * TimeSunset;
	float sunset_sun_g = 0.839 * TimeSunset;
	float sunset_sun_b = 0.666 * TimeSunset;
	
	float sunset_amb_r = 0.325 * TimeSunset;
	float sunset_amb_g = 0.650 * TimeSunset;
	float sunset_amb_b = 0.999 * TimeSunset;
	
	
	float midnight_sun_r = 0.3 * 0.8 * 0.2 * TimeMidnight;
	float midnight_sun_g = 0.4 * 0.8 * 0.2 * TimeMidnight;
	float midnight_sun_b = 0.8 * 0.8 * 0.2 * TimeMidnight;
	
	float midnight_amb_r = 0.3 * 0.2 * TimeMidnight;
	float midnight_amb_g = 0.4 * 0.2 * TimeMidnight;
	float midnight_amb_b = 0.8 * 0.2 * TimeMidnight;


	float sunlight_r = sunrise_sun_r + noon_sun_r + sunset_sun_r + midnight_sun_r;
	float sunlight_g = sunrise_sun_g + noon_sun_g + sunset_sun_g + midnight_sun_g;
	float sunlight_b = sunrise_sun_b + noon_sun_b + sunset_sun_b + midnight_sun_b;
	
	float ambient_r = sunrise_amb_r + noon_amb_r + sunset_amb_r + midnight_amb_r;
	float ambient_g = sunrise_amb_g + noon_amb_g + sunset_amb_g + midnight_amb_g;
	float ambient_b = sunrise_amb_b + noon_amb_b + sunset_amb_b + midnight_amb_b;
	
	
	Skylight_lightmap.r = mix(Skylight_lightmap.r * ambient_r, Skylight_lightmap.r * sunlight_r, sun_amb);
	Skylight_lightmap.g = mix(Skylight_lightmap.g * ambient_g, Skylight_lightmap.g * sunlight_g, sun_amb);
	Skylight_lightmap.b = mix(Skylight_lightmap.b * ambient_b, Skylight_lightmap.b * sunlight_b, sun_amb);

	

	
	
		float colorskyclearr = ((color.r * 1.8 - 0.0) * (TimeSunrise))   +   ((color.r * 1.8 - 0.05) * (TimeNoon))   +   ((color.r * 1.4 - 0.0) * (TimeSunset))   +   (color.r * 4.0f * TimeMidnight);
		float colorskyclearg = ((color.g * 1.8 - 0.0) * (TimeSunrise))   +   ((color.g * 1.8 - 0.05) * (TimeNoon))   +   ((color.g * 1.4 - 0.0) * (TimeSunset))   +   (color.g * 4.0f * TimeMidnight);
		float colorskyclearb = ((color.b * 1.8 - 0.0) * (TimeSunrise))   +   ((color.b * 1.8 - 0.05) * (TimeNoon))   +   ((color.b * 1.4 - 0.0) * (TimeSunset))   +   (color.b * 4.0f * TimeMidnight);
			
			float colorskyrainr = ((color.r * 0.8 + 0.2) * (TimeSunrise))   +   ((color.r * 0.8 + 0.3) * (TimeNoon))   +   ((color.r * 0.8 + 0.2) * (TimeSunset))   +   (color.r * TimeMidnight);
			float colorskyraing = ((color.g * 0.8 + 0.2) * (TimeSunrise))   +   ((color.g * 0.8 + 0.3) * (TimeNoon))   +   ((color.g * 0.8 + 0.2) * (TimeSunset))   +   (color.g * TimeMidnight);
			float colorskyrainb = ((color.b * 0.8 + 0.2) * (TimeSunrise))   +   ((color.b * 0.8 + 0.3) * (TimeNoon))   +   ((color.b * 0.8 + 0.2) * (TimeSunset))   +   (color.b * TimeMidnight);
		
			float colorskyr = mix(colorskyclearr, colorskyrainr, rainx);
			float colorskyg = mix(colorskyclearg, colorskyraing, rainx);
			float colorskyb = mix(colorskyclearb, colorskyrainb, rainx);
			
			color.r = mix(colorskyr, color.r, landx);
			color.g = mix(colorskyg, color.g, landx);
			color.b = mix(colorskyb, color.b, landx);
			
			
//Specular highlight


/*
	vec3 npos = normalize(fragposition.xyz);

	vec3 bump = reflect(npos, normal);
	
	float fresnel = distance(normal.xy, vec2(0.0f));
		  fresnel = pow(fresnel, 6.0f);
		  fresnel *= 3.0f;

	vec3 specularColor = vec3(sunlight_r, sunlight_g, sunlight_b) * 2.1f;
	

	float s = max(dot(normal, lightVector), 0.0);
	
	vec3 bump = specularColor * s;
		 bump *= sun_amb;
		 bump *= landx;
	*/



//Apply different lightmaps to image

vec3 color_skylight = color.rgb * Skylight_lightmap;
vec3 color_torchlight = color.rgb * Torchlight_lightmap;
vec3 color_lightning = color.rgb * LightningFlash_lightmap;
vec3 color_nolight = color.rgb * vec3(0.015, 0.01, 0.005) * 0.05f;

color_skylight *= 0.65f;
color_torchlight *= 1.9f;
color_lightning *= 2.0f;

color.rgb = color_skylight + color_torchlight + color_lightning + color_nolight;



//raining
color.rgb = mix(color.rgb, color.rgb*0.8, rainx);
color.rgb = mix(color.rgb*1.0f, color.rgb, landx);

/*
//PSEUDO SUN////////////////////

vec3 sP = sunPosition;

			vec2 lPos = sP.xy / -sP.z;
			lPos.y *= 1.2f;
			lPos.x *= 0.70f;
			lPos = (lPos + 1.0f)/2.0f;
			
			
			
			//Rain glow
			vec2 glow1scale = vec2(0.5f, 0.5f);
			float glow1pow = 1.5f;
			float glow1fill = 1.0f;
			float glow1offset = -2.0f;
			vec2 glow1pos = vec2(  ((1.0 - lPos.x)*(glow1offset + 1.0) - (glow1offset*0.5))  *aspectRatio*glow1scale.x,  ((1.0 - lPos.y)*(glow1offset + 1.0) - (glow1offset*0.5))  *glow1scale.y);
			
			
			float glow1 = distance(glow1pos, vec2(texcoord.s*aspectRatio*glow1scale.x, texcoord.t*glow1scale.y));
				  glow1 = 0.5 - glow1;
				  glow1 = clamp(glow1*glow1fill, 0.0, 1.0);
				  glow1 = sin(glow1*1.57075);
				  glow1 *= (1.0f - landx);
				  glow1 = pow(glow1, 2.5f);
				  
				  glow1 *= glow1pow;
				  glow1 *= rainx;
				  
				  	color.r += glow1*sunlight_r * (1.0f - (TimeMidnight));
					color.g += glow1*sunlight_g * (1.0f - (TimeMidnight));
					color.b += glow1*sunlight_b * (1.0f - (TimeMidnight));				
			
			
			
			//Sunny glow
			vec2 glow2scale = vec2(0.8f, 0.8f);
			float glow2pow = 1.29f;
			float glow2fill = 1.0f;
			float glow2offset = -2.0f;
			vec2 glow2pos = vec2(  ((1.0 - lPos.x)*(glow2offset + 1.0) - (glow2offset*0.5))  *aspectRatio*glow2scale.x,  ((1.0 - lPos.y)*(glow2offset + 1.0) - (glow2offset*0.5))  *glow2scale.y);
			
			
			float glow2 = distance(glow2pos, vec2(texcoord.s*aspectRatio*glow2scale.x, texcoord.t*glow2scale.y));
				  glow2 = 0.5 - glow2;
				  glow2 = clamp(glow2*glow2fill, 0.0, 1.0);
				  glow2 = sin(glow2*1.57075);
				  glow2 *= (1.0f - landx);
				  glow2 = pow(glow2, 2.5f);
				  
				  glow2 *= glow2pow;
				  glow2 *= 1.0 - rainx;
				  
				  if (sP.z > 0.0f) {
						glow2 = 0.0f;
				  }
				  
				  	color.r += glow2*sunlight_r * (1.0f - (TimeMidnight*1.0f));
					color.g += glow2*sunlight_g * (1.0f - (TimeMidnight*1.0f));
					color.b += glow2*sunlight_b * (1.0f - (TimeMidnight*1.0f));	

*/

float GRa = 0.0f;

#ifdef GODRAYS
	const float grna = 3300.0f;

	 GRa = addGodRays(0.0f, Texcoord2, noiseX3*grna, noiseX4*grna, noiseY4*grna, noiseX2*grna, noiseY2*grna)/2.0;
	 GRa = 1.0f - GRa;
	 //GRa += allwaves;
	 //GRa *= allwaves;
	 //GRa += iswater*0.25f;
#endif



//worldposition.s *= 1.0 + TimeSunrise*4.0f + TimeSunset*4.0f;
//worldposition.st += sin(worldposition.z);

worldposition.st -= worldposition.z;

color.rgb *= 1.3f;
color.g *= 0.85f;
color.b *= 1.0f;


	  //allwaves = 1.0 - allwaves;
	  
#ifdef PRESERVE_COLOR_RANGE

	color.rgb *= 0.4f;
	//color.rgb += 0.05f;

#endif

	//gl_FragData[0] = texture2D(gcolor, texcoord.st);
	gl_FragData[1] = texture2D(gdepth, texcoord.st);
	gl_FragData[3] = vec4(color.rgb, 1.0);
	gl_FragData[4] = texture2D(gaux1, texcoord.st);
	gl_FragData[5] = vec4(GRa, allwaves, 0.0f, 1.0f);
	//gl_FragData[6] = vec4(0.0f, 0.0f, 0.0f, 1.0f);
}


/* notes


LUT


	vec3 final_frag = color.rgb * (shading);
    vec4 relit_fragment = texture(colortable, final_frag);
    gl_FragData[3] = vec4(relit_fragment.rgb, 1.0);
	
	
	
*/