#version 120

uniform sampler2D texture;
uniform sampler2D lightmap;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;

uniform int fogMode;

void main() {

	//gl_FragData[0] = texture2D(texture, texcoord.st) * color;
	//gl_FragData[1] = vec4(vec3(gl_FragCoord.z), 1.0);
	//gl_FragData[1] = vec4(0.0);
	//gl_FragData[4] = vec4(0.0, 1.0, 1.0, 0.0);
	//gl_FragData[5] = vec4(texture2D(lightmap, lmcoord.st).r, texture2D(lightmap, lmcoord.st).g, texture2D(lightmap, lmcoord.st).b * 1.0f, 0.0);
	//gl_FragData[6] = vec4(0.0f, 0.0f, 0.0f, 1.0f);

	
		
	if (fogMode == GL_EXP) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, 1.0 - clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0));
	} else if (fogMode == GL_LINEAR) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0));
	}
}