#version 120

/* DRAWBUFFERS:0N2N4 */

uniform sampler2D texture;
uniform sampler2D normals;
uniform float rainStrength;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;

varying vec3 normal;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;

uniform int fogMode;

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;

void main() {	
	
	vec2 adjustedTexCoord = texcoord.st;

	vec3 indlmap = mix(pow(min(lmcoord.t+0.1,1.0),2.0),1.0,lmcoord.s)*texture2D(texture,adjustedTexCoord).rgb*color.rgb;
	gl_FragData[0] = vec4(indlmap,texture2D(texture,adjustedTexCoord).a*color.a);
	gl_FragDepth = gl_FragCoord.z;
	
	gl_FragData[2] = vec4(normal,1.0);	
	gl_FragData[4] = vec4(0.0, 0.8, lmcoord.s, 0.0f);
	
	

}