#version 120

/* GNORMALFORMAT:RGBA32F */
/* GAUX4FORMAT:RGBA32F */

//#define BLOCK_REFLECTIONS
#define WATER_REFLECTIONS

uniform sampler2D composite;
uniform sampler2D gaux2;
uniform sampler2D gaux1;
uniform sampler2D depthtex0;
uniform sampler2D gnormal;

varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 skycolor;
varying vec3 ambient_color;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform float far;

uniform int isEyeInWater;

const float stp = 0.1;
const float ref = 0.1;
const float inc = 1.6;
const int maxf = 6;

vec3 nvec3(vec4 pos){
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos){
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord){
    return max(abs(coord.s - 0.5), abs(coord.t - 0.5)) * 2.0;
}

vec4 raytrace(vec3 fragpos, vec3 normal){
    normal *= -(isEyeInWater * 2.0 - 1.0);
    float fade_rate = clamp(1 + dot(normalize(fragpos), normalize(normal)), 0.0, 1.0);
    float fade = mix(0.4, 1.0, fade_rate);
    vec4 color = vec4(0.0);
    vec3 start = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
    vec3 vector = stp * normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 oldpos = fragpos;
    fragpos += vector;
    vector *= inc;
    int sr = 0;
    for(int i=0;i<30;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
        if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.1) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex0, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float diff = abs(spos.z - fragpos.z);
        float dist = distance(fragpos, spos);
        float orientation = dot(normalize(texture2D(gnormal, pos.st).xyz * 2.0 - 1.0), vector);
        if(min(dist, diff) <= pow(length(vector), 0.9) && (orientation < 0 || texture2D(composite, pos.st).a < 0.01)){
                sr++;
                fragpos = oldpos;
                vector *= ref;
                if(sr >= maxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 3.0), 0.0, 1.0);
                    color = vec4(texture2D(composite, pos.st).rgb, 1.0);
                    color.rgb = pow(color.rgb, vec3(5.5));
                    color.a *= border;
                    break;
                }
        }
        oldpos = fragpos;
        fragpos += vector;
        vector *= inc;
    }
    //color.rgb = mix(pow(skycolor, vec3(1.0)), color.rgb, color.a);
    color.a *= fade;
    return color;
}



void main() {


vec3 aux = texture2D(gaux1, texcoord.st).rgb;
float totalspec = aux.r*3.0;
float spec = texture2D(gaux2,texcoord.xy).r;
float wave = texture2D(gaux2,texcoord.xy).g;
float land = texture2D(composite,texcoord.xy);




float iswater = 0.0;
if (wave > 0.0) {
iswater = 1.0;
wave = (wave-0.02)*2.0-1.0;
}

    vec3 fragpos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);
    fragpos = nvec3(gbufferProjectionInverse * nvec4(fragpos * 2.0 - 1.0));
    vec3 normal = normalize(texture2D(gnormal, texcoord.st).rgb * 2.0 - 1.0);
    vec3 color = texture2D(composite,texcoord.xy).rgb;
    color.rgb = pow(color.rgb, vec3(5.5));

    if (iswater > 0.9) {
        color += spec*sunlight;
#ifdef WATER_REFLECTIONS
        float brigtness = 1.0 - clamp(color.r * 0.3 + color.g * 0.59 + color.b * 0.11, 0.0, 1.0);
        float reflectmask = clamp(0.8f * (1 - isEyeInWater), 0.0, 1.0);
        if(reflectmask >= 0.01){
            vec4 reflection = raytrace(fragpos, normalize(normal+wave*0.05));
            color.rgb = mix(color.rgb, reflection.rgb, reflection.a * reflectmask);
        }
#endif
    } else {
#ifdef BLOCK_REFLECTIONS
        float brigtness = 1.0 - clamp(color.r * 0.3 + color.g * 0.59 + color.b * 0.11, 0.0, 1.0);
        float reflectmask = clamp(totalspec * brigtness * 0.8f, 0.0, 1.0);
        if(reflectmask >= 0.01){
            vec4 reflection = raytrace(fragpos, normal);
            color.rgb = mix(color.rgb, reflection.rgb, reflection.a * reflectmask);
        }
#endif
    }

/* DRAWBUFFERS:NNNNNN7 */

	gl_FragData[6] = vec4(color,land);
}
