#version 120






/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////ADJUSTABLE FUNCTIONS////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//#define DEPTH_OF_FIELD
    #define BLUR_AMOUNT 1.0
    #define USE_HIGH_QUALITY_BLUR

//#define GODRAYS
//#define MOONRAYS                        // Really buggy!
    #define GODRAYS_DECAY 0.90
    #define GODRAYS_LENGHT 1.0
    #define GODRAYS_BRIGHTNESS 0.2
    #define GODRAYS_SAMPLES 32            // More samples are finer, but need more performance.

//#define BLOOM

//#define CINEMATIC_SHADERS

#define COLOR_FILTER                      // Add better colors.
    #define RAIN_COLOR_FILTER
    #define NIGHT_COLOR_FILTER

//#define USE_COSTUM_BRIGHTNESS           // Activate this and you can change the brightness.
    #define BRIGHTNESS 1.00               // 1.00 is the normal brightness.
    #define CONTRAST 0.0                  // Higher values will be darker. Add a "-" for a higher brightness.
    #define GAMMA 1.00                    // 1.00 is the normal brightness. Higher values will be darker.
    #define SATURATION 0.0	              // Is the same as color boost. Add a "-" to remove colors.
	
	
	

	
	
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////GET MATERIAL////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

uniform sampler2D depthtex0;
uniform sampler2D gcolor;
uniform sampler2D composite;
uniform sampler2D gaux1;
uniform vec3 sunPosition;
uniform vec3 moonPsotion;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
varying vec4 texcoord;

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float iswater = texture2D(gaux1, texcoord.st).g;

float getDepth(vec2 coord) {
    return 2.0 * near * far / (far + near - (2.0 * texture2D(depthtex0, coord).x - 1.0) * (far - near));
}

float timefract = worldTime;
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);
	
	
	

	
	
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////CODE////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef DEPTH_OF_FIELD
// HYPERFOCAL = (Focal Distance ^ 2)/(Circle of Confusion * F Stop) + Focal Distance
const float HYPERFOCAL = 3.132;
const float PICONSTANT = 3.14159;

float getDepth(vec2 coord);
vec4 getBlurredColor();
vec4 getSample(vec2 coord, vec2 aspectCorrection);
vec4 getSampleWithBoundsCheck(vec2 offset);

float samples = 0.0;
float fragDepth;
float cursorDepth;
vec2 space;
#endif

void main() {
	vec4 color = texture2D(composite, texcoord.st);

#ifdef DEPTH_OF_FIELD
	float depth = getDepth(texcoord.st);
	    
	float cursorDepth = getDepth(vec2(0.5, 0.5));
    
    // foreground blur = 1/2 background blur. Blur should follow exponential pattern until cursor = hyperfocal -- Cursor before hyperfocal
    // Blur should go from 0 to 1/2 hyperfocal then clear to infinity -- Cursor @ hyperfocal.
    // hyperfocal to inifity is clear though DEPTH_OF_FIELD extends from 1/2 hyper to hyper -- Cursor beyond hyperfocal
    
    float mixAmount = 0.0;
    
    if (depth < cursorDepth) {
    	mixAmount = clamp(2.0 * ((clamp(cursorDepth, 0.0, HYPERFOCAL) - depth) / (clamp(cursorDepth, 0.0, HYPERFOCAL))), 0.0, 1.0);
	} else if (cursorDepth == HYPERFOCAL) {
		mixAmount = 0.0;
	} else {
		mixAmount =  1.0 - clamp((((cursorDepth * HYPERFOCAL) / (HYPERFOCAL - cursorDepth)) - (depth - cursorDepth)) / ((cursorDepth * HYPERFOCAL) / (HYPERFOCAL - cursorDepth)), 0.0, 1.0);
	}
    
    if (mixAmount != 0.0) {
		color = mix(color, getBlurredColor(), mixAmount);
   	}
#endif
	
#ifdef GODRAYS
const float GR_DECAY    = 1.0*GODRAYS_DECAY;
const float GR_DENSITY  = 1.0*GODRAYS_LENGHT;
const float GR_EXPOSURE = 1.0*GODRAYS_BRIGHTNESS;
const int GR_SAMPLES    = 1*GODRAYS_SAMPLES;
#endif

#ifdef GODRAYS
    float threshold = 0.99 * far;
    bool foreground = true;
    float depthGR = getDepth(texcoord.st);
	#ifdef MOONRAYS
	
	#else
    if ((worldTime < 14000 || worldTime > 22000) && sunPosition.z < 0 && depthGR < threshold)
	#endif
        {
                vec2 lightPos = sunPosition.xy / -sunPosition.z;
                lightPos.y *= aspectRatio;
                lightPos = (lightPos + 1.0)/2.0;
                vec2 texCoord = texcoord.st;
                vec2 delta = (texCoord - lightPos) * GR_DENSITY / float(GR_SAMPLES);
                float decay = -sunPosition.z / 100.0;
                vec3 colorGR = vec3(0.0);
                for (int i = 0; i < GR_SAMPLES; i++) {
                        texCoord -= delta;
                        if (texCoord.x < 0.0 || texCoord.x > 1.0) {
                                if (texCoord.y < 0.0 || texCoord.y > 1.0) {
                                        break;
                                }
                        }
                        vec3 sample = vec3(0.0);
                        if (getDepth(texCoord) > threshold) {
                                sample = texture2D(composite, texCoord).rgb;
                        }
                        sample *= vec3(decay);
                        if (distance(texCoord, lightPos) > 0.05) sample *= 0.2;
                        colorGR += sample;
                        decay *= GR_DECAY;
                }
			
		colorGR.r = colorGR.r, 2.0;
	    colorGR.g = colorGR.g, 2.0;
	    colorGR.b = colorGR.b, 2.0;
        color = (color + GR_EXPOSURE * vec4(colorGR.r * 2.55, colorGR.g * 1.12, colorGR.b * 0.50, 0.01)*(TimeSunrise+TimeSunset)* clamp(1.0 - rainStrength,0.1,1.0));
        color = (color + GR_EXPOSURE * vec4(colorGR.r * 1.02, colorGR.g * 0.71, colorGR.b * 0.51, 0.01)*TimeNoon* clamp(1.0 - rainStrength,0.1,1.0));
		#ifdef MOONRAYS
        color = (color + GR_EXPOSURE * vec4(colorGR.r * 2.0, colorGR.g * 2.0, colorGR.b * 2.00, 0.01)*TimeMidnight* clamp(1.0 - rainStrength,0.1,1.0));
		#else
        color = (color + GR_EXPOSURE * vec4(colorGR.r * 2.55, colorGR.g * 1.12, colorGR.b * 0.50, 0.01)*TimeMidnight* clamp(1.0 - rainStrength,0.1,1.0));
		#endif
        }
#endif 	

#ifdef USE_COSTUM_BRIGHTNESS

	color.r = pow(color.r, GAMMA);
	color.g = pow(color.g, GAMMA);
	color.b = pow(color.b, GAMMA);
	
	color.r = (color.r)*(SATURATION + 1.0f) + (color.g + color.b)*(-SATURATION);
	color.g = (color.g)*(SATURATION + 1.0f) + (color.r + color.b)*(-SATURATION);
	color.b = (color.b)*(SATURATION + 1.0f) + (color.r + color.g)*(-SATURATION);

	color = color * BRIGHTNESS;
	
	color = color*(1.0f + CONTRAST*1.2) - CONTRAST*1.2;

#endif

#ifdef BLOOM
	int j;
	int i;
	vec4 sum = vec4(0);
        float count = 0;
    for( i= -4 ;i < 4; i++) {
        for (j = -3; j < 3; j++) {
            vec2 coord = texcoord.st + vec2(j,i) * 0.004;
                if(coord.x > 0 && coord.x < 1 && coord.y > 0 && coord.y < 1){
				#ifdef CINEMATIC_SHADERS
                    sum += texture2D(composite, coord) * 7;
				#else
                    sum += texture2D(composite, coord) * 6*(TimeSunset+TimeSunrise);
				#endif
                    count += 1;
                }
            }
    }
    sum = sum / vec4(count);
	if (color.r < 0.3)
	{
		color += sum*sum*0.012;
	}
	else
	{
		if (color.r < 0.5)
		{
			color += sum*sum*0.009;
		}
		else
		{
			color += sum*sum*0.0075;
		}
	}
#endif		

#ifdef COLOR_FILTER	

    #define DARKNESS 0.07

	color.r += 0.00;
	color.g += 0.02;
	color.b += 0.05;

	color.r = pow(color.r, 0.66);
	color.g = pow(color.g, 0.66);
	color.b = pow(color.b, 0.66);
	
	color = color*(1.0f + DARKNESS*1.2) - DARKNESS*1.2;
	
	color = color * 1.3;
	
    color.rgb -= 0.05;
		
    #ifdef RAIN_COLOR_FILTER

        #define COLOR -0.10*rainx
	
	    color.r -= color.r*0.20*rainx;
	    color.g -= color.g*0.20*rainx;
	    color.b -= color.b*0.20*rainx;

	    color.r = (color.r)*(COLOR + 1.0f) + (color.g + color.b)*(-COLOR);
	    color.g = (color.g)*(COLOR + 1.0f) + (color.r + color.b)*(-COLOR);
	    color.b = (color.b)*(COLOR + 1.0f) + (color.r + color.g)*(-COLOR);
	
    #endif

    #ifdef NIGHT_COLOR_FILTER	
	
	    #define COLOR -0.10*TimeMidnight

	    color.r = (color.r)*(COLOR + 1.0f) + (color.g + color.b)*(-COLOR);
	    color.g = (color.g)*(COLOR + 1.0f) + (color.r + color.b)*(-COLOR);
	    color.b = (color.b)*(COLOR + 1.0f) + (color.r + color.g)*(-COLOR);
	
    #endif		

#endif

#ifdef CINEMATIC_SHADERS

	color.r += 0.0*TimeMidnight;
	color.g += 0.05*TimeMidnight;
	color.b += 0.15*TimeMidnight;

	color.r += 0.14*(TimeSunrise+TimeNoon+TimeSunset);
	color.g += 0.17*(TimeSunrise+TimeNoon+TimeSunset);
	color.b += 0.25*(TimeSunrise+TimeNoon+TimeSunset);

#endif	
	gl_FragColor = color;
}

#ifdef DEPTH_OF_FIELD
vec4 getBlurredColor() {
	vec4 blurredColor = vec4(0.0);
	float depth = getDepth(texcoord.xy);
	vec2 aspectCorrection = vec2(1.0, aspectRatio) * 0.005*BLUR_AMOUNT;

	vec2 ac0_4 = 0.4 * aspectCorrection;	// 0.4
#ifdef USE_HIGH_QUALITY_BLUR
	vec2 ac0_4x0_4 = 0.4 * ac0_4;			// 0.16
	vec2 ac0_4x0_7 = 0.7 * ac0_4;			// 0.28
#endif
	
	vec2 ac0_29 = 0.29 * aspectCorrection;	// 0.29
#ifdef USE_HIGH_QUALITY_BLUR
	vec2 ac0_29x0_7 = 0.7 * ac0_29;			// 0.203
	vec2 ac0_29x0_4 = 0.4 * ac0_29;			// 0.116
#endif
	
	vec2 ac0_15 = 0.15 * aspectCorrection;	// 0.15
	vec2 ac0_37 = 0.37 * aspectCorrection;	// 0.37
#ifdef USE_HIGH_QUALITY_BLUR
	vec2 ac0_15x0_9 = 0.9 * ac0_15;			// 0.135
	vec2 ac0_37x0_9 = 0.37 * ac0_37;		// 0.1369
#endif
	
	vec2 lowSpace = texcoord.st;
	vec2 highSpace = 1.0 - lowSpace;
	space = vec2(min(lowSpace.s, highSpace.s), min(lowSpace.t, highSpace.t));
		
	if (space.s >= ac0_4.s && space.t >= ac0_4.t) {

		blurredColor += texture2D(composite, texcoord.st + vec2(0.0, ac0_4.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_4.s, 0.0));   
		blurredColor += texture2D(composite, texcoord.st + vec2(0.0, -ac0_4.t)); 
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_4.s, 0.0)); 
		
#ifdef USE_HIGH_QUALITY_BLUR
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_4x0_7.s, 0.0));       
		blurredColor += texture2D(composite, texcoord.st + vec2(0.0, -ac0_4x0_7.t));     
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_4x0_7.s, 0.0));     
		blurredColor += texture2D(composite, texcoord.st + vec2(0.0, ac0_4x0_7.t));
	
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_4x0_4.s, 0.0));
		blurredColor += texture2D(composite, texcoord.st + vec2(0.0, -ac0_4x0_4.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_4x0_4.s, 0.0));
		blurredColor += texture2D(composite, texcoord.st + vec2(0.0, ac0_4x0_4.t));
#endif

		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_29.s, -ac0_29.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_29.s, ac0_29.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_29.s, ac0_29.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_29.s, -ac0_29.t));
	
#ifdef USE_HIGH_QUALITY_BLUR
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_29x0_7.s, ac0_29x0_7.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_29x0_7.s, -ac0_29x0_7.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_29x0_7.s, ac0_29x0_7.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_29x0_7.s, -ac0_29x0_7.t));
		
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_29x0_4.s, ac0_29x0_4.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_29x0_4.s, -ac0_29x0_4.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_29x0_4.s, ac0_29x0_4.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_29x0_4.s, -ac0_29x0_4.t));
#endif		
		
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_15.s, ac0_37.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_37.s, ac0_15.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_37.s, -ac0_15.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_15.s, -ac0_37.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_15.s, ac0_37.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_37.s, ac0_15.t)); 
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_37.s, -ac0_15.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_15.s, -ac0_37.t));

#ifdef USE_HIGH_QUALITY_BLUR
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_15x0_9.s, ac0_37x0_9.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_37x0_9.s, ac0_15x0_9.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_37x0_9.s, -ac0_15x0_9.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_15x0_9.s, -ac0_37x0_9.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_15x0_9.s, ac0_37x0_9.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_37x0_9.s, ac0_15x0_9.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(-ac0_37x0_9.s, -ac0_15x0_9.t));
		blurredColor += texture2D(composite, texcoord.st + vec2(ac0_15x0_9.s, -ac0_37x0_9.t));
#endif

#ifdef USE_HIGH_QUALITY_BLUR
	    blurredColor /= 41.0;
#else
	    blurredColor /= 16.0;
#endif
	    
	} else {
		
		blurredColor += getSampleWithBoundsCheck(vec2(0.0, ac0_4.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_4.s, 0.0));   
		blurredColor += getSampleWithBoundsCheck(vec2(0.0, -ac0_4.t)); 
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_4.s, 0.0)); 
		
#ifdef USE_HIGH_QUALITY_BLUR
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_4x0_7.s, 0.0));       
		blurredColor += getSampleWithBoundsCheck(vec2(0.0, -ac0_4x0_7.t));     
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_4x0_7.s, 0.0));     
		blurredColor += getSampleWithBoundsCheck(vec2(0.0, ac0_4x0_7.t));
	
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_4x0_4.s, 0.0));
		blurredColor += getSampleWithBoundsCheck(vec2(0.0, -ac0_4x0_4.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_4x0_4.s, 0.0));
		blurredColor += getSampleWithBoundsCheck(vec2(0.0, ac0_4x0_4.t));
#endif

		blurredColor += getSampleWithBoundsCheck(vec2(ac0_29.s, -ac0_29.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_29.s, ac0_29.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_29.s, ac0_29.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_29.s, -ac0_29.t));
	
#ifdef USE_HIGH_QUALITY_BLUR
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_29x0_7.s, ac0_29x0_7.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_29x0_7.s, -ac0_29x0_7.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_29x0_7.s, ac0_29x0_7.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_29x0_7.s, -ac0_29x0_7.t));
		
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_29x0_4.s, ac0_29x0_4.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_29x0_4.s, -ac0_29x0_4.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_29x0_4.s, ac0_29x0_4.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_29x0_4.s, -ac0_29x0_4.t));
#endif
				
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_15.s, ac0_37.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_37.s, ac0_15.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_37.s, -ac0_15.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_15.s, -ac0_37.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_15.s, ac0_37.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_37.s, ac0_15.t)); 
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_37.s, -ac0_15.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_15.s, -ac0_37.t));
		
#ifdef USE_HIGH_QUALITY_BLUR
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_15x0_9.s, ac0_37x0_9.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_37x0_9.s, ac0_15x0_9.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_37x0_9.s, -ac0_15x0_9.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_15x0_9.s, -ac0_37x0_9.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_15x0_9.s, ac0_37x0_9.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_37x0_9.s, ac0_15x0_9.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_37x0_9.s, -ac0_15x0_9.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_15x0_9.s, -ac0_37x0_9.t));
#endif
	
	    blurredColor /= samples;
	    
	}

    return blurredColor;
}

vec4 getSampleWithBoundsCheck(vec2 offset) {
	vec2 coord = texcoord.st + offset;
	if (coord.s <= 1.0 && coord.s >= 0.0 && coord.t <= 1.0 && coord.t >= 0.0) {
		samples += 1.0;
		return texture2D(composite, coord);
	} else {
		return vec4(0.0);
	}
}
#endif

