#version 120

/* DRAWBUFFERS:0124 */



varying vec4 color;

varying vec3 normal;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;

uniform int fogMode;
uniform int worldTime;
uniform float rainStrength;

float timefract = worldTime;
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;

void main() {

	vec3 skyColor = color.rgb * 1.0;
/*
		 skyColor.r = skyColor.r * 0.45f*TimeMidnight;
		 skyColor.g = skyColor.g * 0.6f*TimeMidnight;
		 skyColor.b = skyColor.b * 0.8f*TimeMidnight;
*/
	gl_FragData[0] = vec4(skyColor.rgb, color.a);
	gl_FragDepth = 1.0;
	gl_FragData[1] = vec4(0.0f, 0.0f, 1.0f, 1.0f);
	gl_FragData[2] = vec4(0.0, 0.0, 0.0, 1.0);
	gl_FragData[3] = vec4(0.0, 0.0, 0.0, 1.0);

	float fogFactor;
	if (fogMode == GL_EXP) {
		fogFactor = clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0);
	} else if (fogMode == GL_LINEAR) {
		fogFactor = 1.0 - clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0);
	} else {
		fogFactor = 1.0;
	}
	gl_FragData[1] = vec4(1.0,1.0,1.0, /*fogFactor*/1.0);
	gl_FragData[0] = mix(gl_FragData[0],gl_Fog.color,1.0-fogFactor);
}