/*
 * Decompiled with CFR 0.152.
 */
package wa.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import wa.api.IWaBrewingRecipe;
import wa.api.RecipeManagerWa;
import wa.block.FluidTankEx;

public abstract class TileEntityBrewingBase
extends TileEntity
implements ISidedInventory {
    public FluidTankEx productTank = new FluidTankEx(1000);
    private int age = 0;
    private boolean isAged = false;
    private int grade = 0;
    private int recipeID = 0;
    private int lastDay = 0;
    private int lastAmount = 0;
    public ItemStack[] itemstacks = new ItemStack[this.func_70302_i_()];

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            boolean update = false;
            if (this.isAged) {
                if (this.productTank.isEmpty()) {
                    this.resetBarrel();
                } else if (this.lastDay != this.getDay()) {
                    if (this.isConfortablePlace() && this.recipeID > 0) {
                        ++this.grade;
                    }
                    this.lastDay = this.getDay();
                }
            } else if (this.isConfortablePlace()) {
                if (this.recipeID > 0) {
                    if (this.completeBrewing()) {
                        if (this.onBrewing()) {
                            update = true;
                            this.setAged(true);
                            this.setAgingTime(0);
                        }
                    } else if (this.onProgress()) {
                        ++this.age;
                    } else {
                        this.resetBarrel();
                    }
                } else {
                    int id = this.getCurrentRecipeID();
                    if (id > 0) {
                        this.recipeID = id;
                        update = true;
                    }
                }
            }
            if (this.fillFluidContainerItem()) {
                update = true;
            }
            if (this.lastAmount != this.productTank.getFluidAmount()) {
                this.lastAmount = this.productTank.getFluidAmount();
                update = true;
            }
            if (update) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    protected boolean isConfortablePlace() {
        return !this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getDay() {
        long day = this.field_145850_b.func_72912_H().func_76073_f() / 24000L + 1L;
        if (day > Integer.MAX_VALUE) {
            day -= Integer.MAX_VALUE;
        }
        return (int)day;
    }

    protected boolean onProgress() {
        IWaBrewingRecipe recipe = RecipeManagerWa.brewingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null) {
            return false;
        }
        ItemStack input = this.func_70301_a(0);
        ItemStack second = this.func_70301_a(1);
        ItemStack[] checks = new ItemStack[]{input, second};
        return recipe.matches(checks);
    }

    protected boolean completeBrewing() {
        IWaBrewingRecipe recipe = RecipeManagerWa.brewingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null) {
            return false;
        }
        ItemStack input = this.func_70301_a(0);
        ItemStack second = this.func_70301_a(1);
        ItemStack[] checks = new ItemStack[]{input, second};
        boolean a = recipe.matches(checks);
        boolean b = this.age > recipe.getBrewingTime();
        return a && b;
    }

    protected boolean onBrewing() {
        IWaBrewingRecipe recipe = RecipeManagerWa.brewingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null || !this.productTank.isEmpty()) {
            return false;
        }
        FluidStack output = recipe.getOutput();
        this.fill(ForgeDirection.UNKNOWN, output, true);
        ItemStack slot1 = this.func_70301_a(0);
        ItemStack slot2 = this.func_70301_a(1);
        int i1 = 0;
        int i2 = 0;
        if (slot1 != null) {
            i1 += slot1.field_77994_a;
        }
        if (slot2 != null) {
            i2 += slot2.field_77994_a;
        }
        int grade = recipe.getOutputGrade(this, i1, i2);
        this.setGrade(grade);
        this.func_70299_a(0, null);
        this.func_70299_a(1, null);
        for (ItemStack input : new ItemStack[]{slot1, slot2}) {
            EntityItem entityItem;
            ItemStack emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)input);
            ItemStack emptyContainerSlot = this.func_70301_a(2);
            if (emptyContainer != null) {
                if (emptyContainerSlot == null) {
                    emptyContainer.field_77994_a = i1 + i2;
                    this.func_70299_a(2, emptyContainer);
                    continue;
                }
                if (emptyContainer.func_77969_a(emptyContainerSlot)) {
                    emptyContainerSlot.field_77994_a += i1 + i2;
                    this.func_70299_a(2, emptyContainerSlot);
                    continue;
                }
                entityItem = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, emptyContainer);
                this.field_145850_b.func_72838_d((Entity)entityItem);
                continue;
            }
            if (input == null || input.func_77973_b() != Items.field_151117_aB) continue;
            emptyContainer = new ItemStack(Items.field_151133_ar);
            if (emptyContainerSlot == null) {
                this.func_70299_a(2, emptyContainer);
                continue;
            }
            entityItem = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, emptyContainer);
            this.field_145850_b.func_72838_d((Entity)entityItem);
        }
        return true;
    }

    protected int getCurrentRecipeID() {
        ItemStack input = this.func_70301_a(0);
        ItemStack second = this.func_70301_a(1);
        if (input == null) {
            return -1;
        }
        int id = RecipeManagerWa.brewingRegistry.getRecipeID(input, second);
        return id;
    }

    protected void resetBarrel() {
        this.setAged(false);
        this.setAgingTime(0);
        this.setGrade(0);
        this.setRecipeID(0);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected boolean fillFluidContainerItem() {
        ItemStack in = this.func_70301_a(2);
        ItemStack current = this.func_70301_a(3);
        FluidStack fluid = this.productTank.getFluid();
        if (in == null || fluid == null) {
            return false;
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)in)) {
            ItemStack ret = FluidContainerRegistry.fillFluidContainer((FluidStack)fluid, (ItemStack)in);
            boolean flag1 = ret != null;
            boolean flag2 = false;
            if (current == null) {
                flag2 = true;
            } else if (TileEntityBrewingBase.isItemStackable(ret, current)) {
                flag2 = true;
            }
            if (flag1 && flag2) {
                NBTTagCompound tag = ret.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                tag.func_74777_a("Grade", (short)this.grade);
                ret.func_77982_d(tag);
                this.drain(ForgeDirection.UNKNOWN, FluidContainerRegistry.getContainerCapacity((ItemStack)ret), true);
                this.incrStackInSlot(3, ret);
                if (this.func_70298_a(2, 1) == null) {
                    this.func_70296_d();
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isItemStackable(ItemStack target, ItemStack current) {
        if (target == null || current == null) {
            return false;
        }
        if (target.func_77973_b() == current.func_77973_b() && target.func_77960_j() == current.func_77960_j()) {
            return current.field_77994_a + target.field_77994_a <= current.func_77976_d();
        }
        return false;
    }

    private void incrStackInSlot(int i, ItemStack input) {
        if (i < this.func_70302_i_() && input != null && this.itemstacks[i] != null) {
            if (this.itemstacks[i].func_77973_b() == input.func_77973_b() && this.itemstacks[i].func_77960_j() == input.func_77960_j()) {
                this.itemstacks[i].field_77994_a += input.field_77994_a;
                if (this.itemstacks[i].field_77994_a > this.func_70297_j_()) {
                    this.itemstacks[i].field_77994_a = this.func_70297_j_();
                }
            }
        } else {
            this.func_70299_a(i, input);
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Items", 10);
        this.itemstacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.itemstacks.length) continue;
            this.itemstacks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.age = par1NBTTagCompound.func_74762_e("Age");
        this.grade = par1NBTTagCompound.func_74762_e("Grade");
        this.recipeID = par1NBTTagCompound.func_74762_e("ID");
        this.isAged = par1NBTTagCompound.func_74767_n("IsAged");
        this.productTank = new FluidTankEx(1000);
        if (par1NBTTagCompound.func_74764_b("productTank")) {
            this.productTank.readFromNBT(par1NBTTagCompound.func_74775_l("productTank"));
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Age", this.age);
        par1NBTTagCompound.func_74768_a("Grade", this.grade);
        par1NBTTagCompound.func_74768_a("ID", this.recipeID);
        par1NBTTagCompound.func_74757_a("IsAged", this.isAged);
        NBTTagCompound tank = new NBTTagCompound();
        this.productTank.writeToNBT(tank);
        par1NBTTagCompound.func_74782_a("productTank", (NBTBase)tank);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.itemstacks.length; ++i) {
            if (this.itemstacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.itemstacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int getAgingTime() {
        return this.age;
    }

    public void setAgingTime(int par1) {
        this.age = par1;
    }

    public boolean getAged() {
        return this.isAged;
    }

    public void setAged(boolean par1) {
        this.isAged = par1;
    }

    public int getGrade() {
        return this.grade;
    }

    public void setGrade(int par1) {
        this.grade = par1;
    }

    public int getRecipeID() {
        return this.recipeID;
    }

    public void setRecipeID(int par1) {
        this.recipeID = par1;
    }

    public int getAgingProgress(int i) {
        IWaBrewingRecipe recipe = RecipeManagerWa.brewingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null) {
            return 0;
        }
        int ret = this.age * i / recipe.getBrewingTime();
        return ret;
    }

    public int getBrewingTime() {
        IWaBrewingRecipe recipe = RecipeManagerWa.brewingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null) {
            return 0;
        }
        return recipe.getBrewingTime();
    }

    public int getMetadata() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getUpper() {
        int i = this.age;
        int get = i >>> 4;
        return get;
    }

    public int getUnder() {
        int i = this.age;
        int get = i & 0xF;
        return get;
    }

    public void setUpper(int i) {
        int current = this.age & 0xF;
        int get = i << 4;
        this.age = get += current;
    }

    public void setUnder(int i) {
        int currentUpper = this.age >>> 4;
        int cur = currentUpper << 4;
        int get = i & 0xF;
        this.age = get += cur;
    }

    public void getGuiFluidUpdate(int id, int val) {
        if (id == 2) {
            if (this.productTank.getFluid() == null) {
                this.productTank.setFluidById(val);
            } else {
                int amo = this.productTank.getFluidAmount();
                this.productTank.setFluidById(val);
            }
        } else if (id == 3) {
            if (this.productTank.getFluid() == null) {
                this.productTank.setFluid(null);
            } else {
                this.productTank.getFluid().amount = val;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getFluidAmountScaled(int par1) {
        return this.productTank.getFluidAmount() * par1 / 1000;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.isAged) {
            return null;
        }
        if (this.productTank.getFluidType() == resource.getFluid()) {
            FluidStack ret = this.productTank.drain(resource.amount, doDrain);
            return ret;
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.productTank.drain(maxDrain, doDrain);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() == null) {
            return 0;
        }
        FluidStack current = this.productTank.getFluid();
        FluidStack resourceCopy = resource.copy();
        if (current != null && current.amount > 0 && !current.isFluidEqual(resourceCopy)) {
            return 0;
        }
        int i = 0;
        int used = this.productTank.fill(resourceCopy, doFill);
        resourceCopy.amount -= used;
        return i += used;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return !this.isAged && fluid != null && this.productTank.isEmpty();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.isAged;
    }

    protected int[] slotsTop() {
        return new int[]{0, 1, 2};
    }

    protected int[] slotsBottom() {
        return new int[]{3};
    }

    protected int[] slotsSides() {
        return new int[]{0, 1, 2, 3};
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int par1) {
        return par1 < this.func_70302_i_() ? this.itemstacks[par1] : null;
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.itemstacks[par1] != null) {
            if (this.itemstacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.itemstacks[par1];
                this.itemstacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.itemstacks[par1].func_77979_a(par2);
            if (this.itemstacks[par1].field_77994_a == 0) {
                this.itemstacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.itemstacks[par1] != null) {
            ItemStack itemstack = this.itemstacks[par1];
            this.itemstacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        if (par1 > this.func_70302_i_()) {
            par1 = 0;
        }
        this.itemstacks[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public abstract String func_145825_b();

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 0 || i == 1) {
            return true;
        }
        return i == 2 ? FluidContainerRegistry.isEmptyContainer((ItemStack)stack) : false;
    }

    public int[] func_94128_d(int par1) {
        return par1 == 0 ? this.slotsBottom() : (par1 == 1 ? this.slotsTop() : this.slotsSides());
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return true;
    }
}

