/*
 * Decompiled with CFR 0.152.
 */
package wa.block;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import wa.block.FluidTankEx;

public class TileEntitySpiritLamp
extends TileEntity {
    public FluidTankEx fuelTank = new FluidTankEx(1000);
    private boolean ignited = false;
    private int lastAmount = 0;
    private int tickCount = 0;

    public void func_145845_h() {
        boolean update = false;
        if (this.ignited) {
            if (this.fuelTank.isEmpty()) {
                this.setIgnited(false);
                update = true;
            } else {
                this.tickCount = (this.tickCount + 1) % 20;
                if (this.tickCount == 0) {
                    this.drain(ForgeDirection.UNKNOWN, new FluidStack(this.fuelTank.getFluidType(), 1), true);
                }
            }
        }
        if (this.lastAmount != this.fuelTank.getFluidAmount() && Math.abs(this.lastAmount - this.fuelTank.getFluidAmount()) > 5) {
            this.lastAmount = this.fuelTank.getFluidAmount();
            update = true;
        }
        if (update) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
        super.func_145845_h();
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.ignited = par1NBTTagCompound.func_74767_n("ignited");
        this.fuelTank = new FluidTankEx(1000);
        if (par1NBTTagCompound.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(par1NBTTagCompound.func_74775_l("fuelTank"));
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("ignited", this.ignited);
        NBTTagCompound tank = new NBTTagCompound();
        this.fuelTank.writeToNBT(tank);
        par1NBTTagCompound.func_74782_a("fuelTank", (NBTBase)tank);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean getIgnited() {
        return this.ignited;
    }

    public void setIgnited(boolean par1) {
        if (this.ignited != par1) {
            this.ignited = par1;
        }
    }

    public int getAmount() {
        return this.fuelTank.getFluidAmount();
    }

    public void setAmount(int amount) {
        this.fuelTank.setAmount(amount);
    }

    public int getCapacity() {
        return this.fuelTank.getCapacity();
    }

    public int getMetadata() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || from != ForgeDirection.UNKNOWN) {
            return null;
        }
        if (this.fuelTank.getFluidType() == resource.getFluid()) {
            FluidStack ret = this.fuelTank.drain(resource.amount, doDrain);
            return ret;
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.fuelTank.drain(maxDrain, doDrain);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() == null) {
            return 0;
        }
        FluidStack current = this.fuelTank.getFluid();
        FluidStack resourceCopy = resource.copy();
        if (current != null && current.amount > 0 && !current.isFluidEqual(resourceCopy)) {
            return 0;
        }
        if (resourceCopy.getFluid() != FluidRegistry.getFluid((String)"wa.fluid.alcohol")) {
            return 0;
        }
        return this.fuelTank.fill(resourceCopy, doFill);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return !this.fuelTank.isFull();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UNKNOWN;
    }
}

