/*
 * Decompiled with CFR 0.152.
 */
package wa.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import wa.api.IWaSqueezingRecipe;
import wa.api.RecipeManagerWa;
import wa.block.FluidTankEx;

public abstract class TileEntitySqueezerBase
extends TileEntity
implements ISidedInventory {
    public FluidTankEx productTank = new FluidTankEx(10000);
    private int age = 0;
    private boolean isAged = false;
    private int grade = 0;
    private int recipeID = 0;
    private int lastDay = 0;
    private int lastAmount = 0;
    public int furnaceBurnTime = 0;
    public int currentItemBurnTime = 0;
    public ItemStack[] itemstacks = new ItemStack[this.func_70302_i_()];

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            boolean update = false;
            if (this.recipeID > 0) {
                if (this.completeSqueeze()) {
                    if (this.onSqueeze()) {
                        this.resetBarrel();
                        update = true;
                    }
                } else if (this.onProgress()) {
                    update = true;
                } else {
                    this.resetBarrel();
                    update = true;
                }
            } else if (this.startSqueeze()) {
                update = true;
            } else if (this.furnaceBurnTime > 0) {
                --this.furnaceBurnTime;
                update = true;
            }
            if (this.fillFluidContainerItem()) {
                update = true;
            }
            if (this.lastAmount != this.productTank.getFluidAmount()) {
                this.lastAmount = this.productTank.getFluidAmount();
                update = true;
            }
            if (update) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    private boolean consumeIngredient() {
        int id = this.getCurrentRecipeID();
        if (id <= 0) {
            return false;
        }
        IWaSqueezingRecipe recipe = RecipeManagerWa.squeezingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack input = this.func_70301_a(i);
            boolean a = recipe.matches(input);
            if (!a) continue;
            --input.field_77994_a;
            if (input.field_77994_a == 0) {
                this.func_70299_a(i, null);
            } else {
                this.func_70299_a(i, input);
            }
            return true;
        }
        return false;
    }

    private boolean startSqueeze() {
        int id = this.getCurrentRecipeID();
        if (id <= 0) {
            return false;
        }
        IWaSqueezingRecipe recipe = RecipeManagerWa.squeezingRegistry.getRecipeFromID(id);
        if (recipe == null) {
            return false;
        }
        if (this.furnaceBurnTime == 0 && TileEntityFurnace.func_145952_a((ItemStack)this.itemstacks[this.getFuelSlotIndex()]) <= 0) {
            return false;
        }
        boolean resource = false;
        for (int i : this.getInputSlotIndex()) {
            ItemStack input = this.func_70301_a(i);
            boolean a = recipe.matches(input);
            if (!a) continue;
            resource = true;
            break;
        }
        if (!resource) {
            return false;
        }
        if (!this.productTank.isEmpty() && this.productTank.getFluidAmount() > 0 && !recipe.getOutput().isFluidEqual(this.productTank.getFluid())) {
            return false;
        }
        if (this.productTank.isFull()) {
            return false;
        }
        if (this.furnaceBurnTime == 0 && TileEntityFurnace.func_145952_a((ItemStack)this.itemstacks[this.getFuelSlotIndex()]) > 0) {
            this.burnFuelItem();
        }
        this.recipeID = id;
        this.consumeIngredient();
        this.setGrade(recipe.getOutputGrade(this, 1));
        return true;
    }

    private void burnFuelItem() {
        if (this.furnaceBurnTime == 0) {
            this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.itemstacks[this.getFuelSlotIndex()]);
            if (this.itemstacks[this.getFuelSlotIndex()] != null) {
                --this.itemstacks[this.getFuelSlotIndex()].field_77994_a;
                if (this.itemstacks[this.getFuelSlotIndex()].field_77994_a == 0) {
                    this.itemstacks[this.getFuelSlotIndex()] = this.itemstacks[this.getFuelSlotIndex()].func_77973_b().getContainerItem(this.itemstacks[this.getFuelSlotIndex()]);
                }
            }
        }
    }

    public int getDay() {
        long day = this.field_145850_b.func_72912_H().func_76073_f() / 24000L + 1L;
        if (day > Integer.MAX_VALUE) {
            day -= Integer.MAX_VALUE;
        }
        return (int)day;
    }

    protected boolean onProgress() {
        IWaSqueezingRecipe recipe = RecipeManagerWa.squeezingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null) {
            return false;
        }
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        } else {
            this.burnFuelItem();
        }
        if (this.isBurning()) {
            ++this.age;
        }
        return true;
    }

    protected boolean completeSqueeze() {
        IWaSqueezingRecipe recipe = RecipeManagerWa.squeezingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null) {
            return false;
        }
        return this.age > recipe.getSqueezingTime();
    }

    protected boolean onSqueeze() {
        IWaSqueezingRecipe recipe = RecipeManagerWa.squeezingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null) {
            return false;
        }
        FluidStack output = recipe.getOutput();
        this.fill(ForgeDirection.UNKNOWN, output, true);
        this.setAgingTime(0);
        return true;
    }

    protected int getCurrentRecipeID() {
        int i;
        ItemStack input;
        int id = -1;
        int[] nArray = this.getInputSlotIndex();
        int n = nArray.length;
        for (int j = 0; j < n && ((input = this.func_70301_a(i = nArray[j])) == null || (id = RecipeManagerWa.squeezingRegistry.getRecipeID(input)) == -1); ++j) {
        }
        return id;
    }

    protected void resetBarrel() {
        this.setAged(false);
        this.setAgingTime(0);
        this.setGrade(0);
        this.setRecipeID(0);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected boolean fillFluidContainerItem() {
        ItemStack emptyContainer = this.func_70301_a(this.getEmptyContainerSlotIndex());
        ItemStack output = this.func_70301_a(this.getOutputSlotIndex());
        FluidStack fluid = this.productTank.getFluid();
        if (emptyContainer == null || fluid == null) {
            return false;
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)emptyContainer)) {
            ItemStack ret = FluidContainerRegistry.fillFluidContainer((FluidStack)fluid, (ItemStack)emptyContainer);
            boolean flag1 = ret != null;
            boolean flag2 = false;
            if (output == null) {
                flag2 = true;
            } else if (TileEntitySqueezerBase.isItemStackable(ret, output)) {
                flag2 = true;
            }
            if (flag1 && flag2) {
                NBTTagCompound tag = ret.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                tag.func_74777_a("Grade", (short)this.grade);
                ret.func_77982_d(tag);
                this.drain(ForgeDirection.UNKNOWN, FluidContainerRegistry.getContainerCapacity((ItemStack)ret), true);
                this.incrStackInSlot(this.getOutputSlotIndex(), ret);
                if (this.func_70298_a(this.getEmptyContainerSlotIndex(), 1) == null) {
                    this.func_70296_d();
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isItemStackable(ItemStack target, ItemStack current) {
        if (target == null || current == null) {
            return false;
        }
        if (target.func_77973_b() == current.func_77973_b() && target.func_77960_j() == current.func_77960_j()) {
            return current.field_77994_a + target.field_77994_a <= current.func_77976_d();
        }
        return false;
    }

    private void incrStackInSlot(int i, ItemStack input) {
        if (i < this.func_70302_i_() && input != null && this.itemstacks[i] != null) {
            if (this.itemstacks[i].func_77973_b() == input.func_77973_b() && this.itemstacks[i].func_77960_j() == input.func_77960_j()) {
                this.itemstacks[i].field_77994_a += input.field_77994_a;
                if (this.itemstacks[i].field_77994_a > this.func_70297_j_()) {
                    this.itemstacks[i].field_77994_a = this.func_70297_j_();
                }
            }
        } else {
            this.func_70299_a(i, input);
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Items", 10);
        this.itemstacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.itemstacks.length) continue;
            this.itemstacks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.furnaceBurnTime = par1NBTTagCompound.func_74765_d("BurnTime");
        this.currentItemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.itemstacks[1]);
        this.age = par1NBTTagCompound.func_74762_e("Age");
        this.grade = par1NBTTagCompound.func_74762_e("Grade");
        this.recipeID = par1NBTTagCompound.func_74762_e("ID");
        this.isAged = par1NBTTagCompound.func_74767_n("IsAged");
        this.productTank = new FluidTankEx(10000);
        if (par1NBTTagCompound.func_74764_b("productTank")) {
            this.productTank.readFromNBT(par1NBTTagCompound.func_74775_l("productTank"));
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Age", this.age);
        par1NBTTagCompound.func_74768_a("Grade", this.grade);
        par1NBTTagCompound.func_74768_a("ID", this.recipeID);
        par1NBTTagCompound.func_74757_a("IsAged", this.isAged);
        NBTTagCompound tank = new NBTTagCompound();
        this.productTank.writeToNBT(tank);
        par1NBTTagCompound.func_74782_a("productTank", (NBTBase)tank);
        par1NBTTagCompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.itemstacks.length; ++i) {
            if (this.itemstacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.itemstacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int getAgingTime() {
        return this.age;
    }

    public void setAgingTime(int par1) {
        this.age = par1;
    }

    public boolean getAged() {
        return this.isAged;
    }

    public void setAged(boolean par1) {
        this.isAged = par1;
    }

    public int getGrade() {
        return this.grade;
    }

    public void setGrade(int par1) {
        this.grade = par1;
    }

    public int getRecipeID() {
        return this.recipeID;
    }

    public void setRecipeID(int par1) {
        this.recipeID = par1;
    }

    public int getAgingProgress(int i) {
        IWaSqueezingRecipe recipe = RecipeManagerWa.squeezingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null) {
            return 0;
        }
        int ret = this.age * i / recipe.getSqueezingTime();
        return ret;
    }

    public int getSqueezingTime() {
        IWaSqueezingRecipe recipe = RecipeManagerWa.squeezingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null) {
            return 0;
        }
        return recipe.getSqueezingTime();
    }

    public int getMetadata() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getUpper() {
        int i = this.age;
        int get = i >>> 4;
        return get;
    }

    public int getUnder() {
        int i = this.age;
        int get = i & 0xF;
        return get;
    }

    public void setUpper(int i) {
        int current = this.age & 0xF;
        int get = i << 4;
        this.age = get += current;
    }

    public void setUnder(int i) {
        int currentUpper = this.age >>> 4;
        int cur = currentUpper << 4;
        int get = i & 0xF;
        this.age = get += cur;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int p_145955_1_) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * p_145955_1_ / this.currentItemBurnTime;
    }

    public void getGuiFluidUpdate(int id, int val) {
        if (id == 2) {
            if (this.productTank.getFluid() == null) {
                this.productTank.setFluidById(val);
            } else {
                int amo = this.productTank.getFluidAmount();
                this.productTank.setFluidById(val);
            }
        } else if (id == 3) {
            if (this.productTank.getFluid() == null) {
                this.productTank.setFluid(null);
            } else {
                this.productTank.getFluid().amount = val;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getFluidAmountScaled(int par1) {
        return this.productTank.getFluidAmount() * par1 / 10000;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.isAged) {
            return null;
        }
        if (this.productTank.getFluidType() == resource.getFluid()) {
            FluidStack ret = this.productTank.drain(resource.amount, doDrain);
            return ret;
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.productTank.drain(maxDrain, doDrain);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() == null) {
            return 0;
        }
        FluidStack current = this.productTank.getFluid();
        FluidStack resourceCopy = resource.copy();
        if (current != null && current.amount > 0 && !current.isFluidEqual(resourceCopy)) {
            return 0;
        }
        int i = 0;
        int used = this.productTank.fill(resourceCopy, doFill);
        resourceCopy.amount -= used;
        return i += used;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return !this.isAged && fluid != null && this.productTank.isEmpty();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.isAged;
    }

    int[] getInputSlotIndex() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    int getFuelSlotIndex() {
        return 9;
    }

    int getEmptyContainerSlotIndex() {
        return 10;
    }

    int getOutputSlotIndex() {
        return 11;
    }

    protected int[] slotsTop() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 10};
    }

    protected int[] slotsBottom() {
        return new int[]{11};
    }

    protected int[] slotsSides() {
        return new int[]{9};
    }

    public int func_70302_i_() {
        return 12;
    }

    public ItemStack func_70301_a(int par1) {
        return par1 < this.func_70302_i_() ? this.itemstacks[par1] : null;
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.itemstacks[par1] != null) {
            if (this.itemstacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.itemstacks[par1];
                this.itemstacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.itemstacks[par1].func_77979_a(par2);
            if (this.itemstacks[par1].field_77994_a == 0) {
                this.itemstacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.itemstacks[par1] != null) {
            ItemStack itemstack = this.itemstacks[par1];
            this.itemstacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        if (par1 > this.func_70302_i_()) {
            par1 = 0;
        }
        this.itemstacks[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public abstract String func_145825_b();

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (Arrays.asList(new int[][]{this.getInputSlotIndex()}).contains(i)) {
            return true;
        }
        if (i == this.getFuelSlotIndex()) {
            return TileEntityFurnace.func_145954_b((ItemStack)stack);
        }
        if (i == this.getEmptyContainerSlotIndex()) {
            return FluidContainerRegistry.isEmptyContainer((ItemStack)stack);
        }
        return false;
    }

    public int[] func_94128_d(int par1) {
        return par1 == 0 ? this.slotsBottom() : (par1 == 1 ? this.slotsTop() : this.slotsSides());
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return true;
    }
}

