/*
 * Decompiled with CFR 0.152.
 */
package wa.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import wa.api.IWaDistillingRecipe;
import wa.api.RecipeManagerWa;
import wa.block.Blocks;
import wa.block.FluidTankEx;
import wa.block.TileEntitySpiritLamp;
import wa.block.TileEntityStill;

public abstract class TileEntityStillBase
extends TileEntity
implements ISidedInventory {
    public FluidTankEx productTank = new FluidTankEx(10000);
    private int age = 0;
    private boolean isAged = false;
    private int grade = 0;
    private int recipeID = 0;
    private int lastDay = 0;
    private int lastAmount = 0;
    public ItemStack[] itemstacks = new ItemStack[this.func_70302_i_()];

    public void func_145845_h() {
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (metadata == 1 && !this.field_145850_b.field_72995_K) {
            boolean update = false;
            if (this.isConfortablePlace()) {
                if (this.recipeID > 0) {
                    if (this.completeDistill()) {
                        if (this.onDistill()) {
                            update = true;
                            this.setAged(true);
                            this.setAgingTime(0);
                        }
                    } else if (this.onProgress()) {
                        ++this.age;
                    } else {
                        this.resetBarrel();
                    }
                } else if (this.startDistill()) {
                    update = true;
                }
            }
            if (this.fillFluidContainerItem()) {
                update = true;
            }
            if (this.lastAmount != this.productTank.getFluidAmount()) {
                this.lastAmount = this.productTank.getFluidAmount();
                update = true;
            }
            if (update) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public ForgeDirection getPairDir() {
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (metadata == 1) {
            for (ForgeDirection d : new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST}) {
                ForgeDirection o = d.getOpposite();
                Block block = this.field_145850_b.func_147439_a(this.field_145851_c + o.offsetX, this.field_145848_d + o.offsetY, this.field_145849_e + o.offsetZ);
                int meta = this.field_145850_b.func_72805_g(this.field_145851_c + o.offsetX, this.field_145848_d + o.offsetY, this.field_145849_e + o.offsetZ);
                if (block != Blocks.still) continue;
                if (meta == 2 && d == ForgeDirection.NORTH) {
                    return o;
                }
                if (meta == 3 && d == ForgeDirection.EAST) {
                    return o;
                }
                if (meta == 4 && d == ForgeDirection.SOUTH) {
                    return o;
                }
                if (meta != 5 || d != ForgeDirection.WEST) continue;
                return o;
            }
        }
        if (metadata == 2) {
            return ForgeDirection.NORTH;
        }
        if (metadata == 3) {
            return ForgeDirection.EAST;
        }
        if (metadata == 4) {
            return ForgeDirection.SOUTH;
        }
        if (metadata == 5) {
            return ForgeDirection.WEST;
        }
        return ForgeDirection.UNKNOWN;
    }

    private boolean startDistill() {
        int id = this.getCurrentRecipeID();
        if (id > 0) {
            this.recipeID = id;
            this.setGrade(100);
            return true;
        }
        return false;
    }

    private boolean findWater() {
        for (ForgeDirection d : new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST}) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY, this.field_145849_e + d.offsetZ);
            if (block == Blocks.field_150355_j) {
                return true;
            }
            if (block != Blocks.field_150358_i) continue;
            return true;
        }
        return false;
    }

    private boolean findIce() {
        for (ForgeDirection d : new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST}) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY, this.field_145849_e + d.offsetZ);
            if (block == Blocks.field_150432_aD) {
                return true;
            }
            if (block != Blocks.field_150403_cj) continue;
            return true;
        }
        return false;
    }

    private boolean findSpiritLamp() {
        TileEntitySpiritLamp tile;
        ForgeDirection d = ForgeDirection.DOWN;
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY, this.field_145849_e + d.offsetZ);
        return block == Blocks.spiritLamp && (tile = (TileEntitySpiritLamp)this.field_145850_b.func_147438_o(this.field_145851_c + ForgeDirection.DOWN.offsetX, this.field_145848_d + ForgeDirection.DOWN.offsetY, this.field_145849_e + ForgeDirection.DOWN.offsetZ)) != null && tile.getIgnited();
    }

    private boolean findFire() {
        for (ForgeDirection d : new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST}) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY, this.field_145849_e + d.offsetZ);
            if (block == Blocks.field_150480_ab) {
                return true;
            }
            if (block == Blocks.field_150353_l) {
                return true;
            }
            if (block != Blocks.field_150356_k) continue;
            return true;
        }
        return false;
    }

    protected boolean isConfortablePlace() {
        if (this.findIce() || this.findWater()) {
            return false;
        }
        if (this.findFire()) {
            return true;
        }
        return this.findSpiritLamp();
    }

    public int getDay() {
        long day = this.field_145850_b.func_72912_H().func_76073_f() / 24000L + 1L;
        if (day > Integer.MAX_VALUE) {
            day -= Integer.MAX_VALUE;
        }
        return (int)day;
    }

    protected boolean onProgress() {
        IWaDistillingRecipe recipe = RecipeManagerWa.distillingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null) {
            return false;
        }
        ItemStack input = this.func_70301_a(0);
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)input);
        if (recipe.getInput().isFluidEqual(input) && this.productTank.getCapacity() - this.productTank.getFluidAmount() >= fluid.amount) {
            NBTTagCompound nbt;
            EntityItem entityItem;
            this.fill(ForgeDirection.UNKNOWN, fluid, true);
            --input.field_77994_a;
            if (input.field_77994_a == 0) {
                this.func_70299_a(0, null);
            } else {
                this.func_70299_a(0, input);
            }
            ItemStack emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)input);
            ItemStack emptyContainerSlot = this.func_70301_a(1);
            if (emptyContainer != null) {
                if (emptyContainerSlot == null) {
                    this.func_70299_a(1, emptyContainer);
                } else if (emptyContainer.func_77969_a(emptyContainerSlot)) {
                    ++emptyContainerSlot.field_77994_a;
                    this.func_70299_a(1, emptyContainerSlot);
                } else {
                    entityItem = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, emptyContainer);
                    this.field_145850_b.func_72838_d((Entity)entityItem);
                }
            } else if (input != null && input.func_77973_b() == Items.field_151117_aB) {
                emptyContainer = new ItemStack(Items.field_151133_ar);
                if (emptyContainerSlot == null) {
                    this.func_70299_a(2, emptyContainer);
                } else {
                    entityItem = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, emptyContainer);
                    this.field_145850_b.func_72838_d((Entity)entityItem);
                }
            }
            int grade = 100;
            if (input.func_77942_o() && (nbt = input.func_77978_p()) != null) {
                grade = nbt.func_74765_d("Grade");
            }
            this.setGrade(Math.min(this.getGrade(), grade));
        }
        return this.productTank.getFluidAmount() >= recipe.getInputRequire();
    }

    protected boolean completeDistill() {
        IWaDistillingRecipe recipe = RecipeManagerWa.distillingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null) {
            return false;
        }
        return this.age > recipe.getDistillingTime();
    }

    protected boolean onDistill() {
        IWaDistillingRecipe recipe = RecipeManagerWa.distillingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null) {
            return false;
        }
        int outputGrade = recipe.getOutputGrade(this, this.productTank.getFluid(), this.getGrade());
        this.drain(ForgeDirection.UNKNOWN, recipe.getInputRequire(), true);
        ForgeDirection pairDir = this.getPairDir();
        if (pairDir != ForgeDirection.UNKNOWN) {
            TileEntityStill tile = (TileEntityStill)this.field_145850_b.func_147438_o(this.field_145851_c + pairDir.offsetX, this.field_145848_d + pairDir.offsetY, this.field_145849_e + pairDir.offsetZ);
            FluidStack output = recipe.getOutput();
            if (this.findFire()) {
                output.amount /= 2;
            }
            tile.fill(pairDir.getOpposite(), output, true);
            tile.setGrade(outputGrade);
        }
        this.setAgingTime(0);
        return true;
    }

    protected int getCurrentRecipeID() {
        ItemStack input = this.func_70301_a(0);
        if (input == null) {
            return -1;
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)input);
        if (fluid == null) {
            return -1;
        }
        return RecipeManagerWa.distillingRegistry.getRecipeID(fluid);
    }

    protected void resetBarrel() {
        this.setAged(false);
        this.setAgingTime(0);
        this.setGrade(0);
        this.setRecipeID(0);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected boolean fillFluidContainerItem() {
        ForgeDirection pairDir = this.getPairDir();
        if (pairDir == ForgeDirection.UNKNOWN) {
            return false;
        }
        ItemStack emptyContainer = this.func_70301_a(1);
        ItemStack output = this.func_70301_a(2);
        TileEntityStill tile = (TileEntityStill)this.field_145850_b.func_147438_o(this.field_145851_c + pairDir.offsetX, this.field_145848_d + pairDir.offsetY, this.field_145849_e + pairDir.offsetZ);
        FluidStack fluid = tile.productTank.getFluid();
        if (emptyContainer == null || fluid == null) {
            return false;
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)emptyContainer)) {
            ItemStack ret = FluidContainerRegistry.fillFluidContainer((FluidStack)fluid, (ItemStack)emptyContainer);
            boolean flag1 = ret != null;
            boolean flag2 = false;
            if (output == null) {
                flag2 = true;
            } else if (TileEntityStillBase.isItemStackable(ret, output)) {
                flag2 = true;
            }
            if (flag1 && flag2) {
                NBTTagCompound tag = ret.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                tag.func_74777_a("Grade", (short)this.grade);
                ret.func_77982_d(tag);
                tile.drain(pairDir.getOpposite(), FluidContainerRegistry.getContainerCapacity((ItemStack)ret), true);
                this.incrStackInSlot(2, ret);
                if (this.func_70298_a(1, 1) == null) {
                    this.func_70296_d();
                }
                tile.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c + pairDir.offsetX, this.field_145848_d + pairDir.offsetY, this.field_145849_e + pairDir.offsetZ);
                return true;
            }
        }
        return false;
    }

    private static boolean isItemStackable(ItemStack target, ItemStack current) {
        if (target == null || current == null) {
            return false;
        }
        if (target.func_77973_b() == current.func_77973_b() && target.func_77960_j() == current.func_77960_j()) {
            return current.field_77994_a + target.field_77994_a <= current.func_77976_d();
        }
        return false;
    }

    private void incrStackInSlot(int i, ItemStack input) {
        if (i < this.func_70302_i_() && input != null && this.itemstacks[i] != null) {
            if (this.itemstacks[i].func_77973_b() == input.func_77973_b() && this.itemstacks[i].func_77960_j() == input.func_77960_j()) {
                this.itemstacks[i].field_77994_a += input.field_77994_a;
                if (this.itemstacks[i].field_77994_a > this.func_70297_j_()) {
                    this.itemstacks[i].field_77994_a = this.func_70297_j_();
                }
            }
        } else {
            this.func_70299_a(i, input);
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Items", 10);
        this.itemstacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.itemstacks.length) continue;
            this.itemstacks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.age = par1NBTTagCompound.func_74762_e("Age");
        this.grade = par1NBTTagCompound.func_74762_e("Grade");
        this.recipeID = par1NBTTagCompound.func_74762_e("ID");
        this.isAged = par1NBTTagCompound.func_74767_n("IsAged");
        this.productTank = new FluidTankEx(10000);
        if (par1NBTTagCompound.func_74764_b("productTank")) {
            this.productTank.readFromNBT(par1NBTTagCompound.func_74775_l("productTank"));
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Age", this.age);
        par1NBTTagCompound.func_74768_a("Grade", this.grade);
        par1NBTTagCompound.func_74768_a("ID", this.recipeID);
        par1NBTTagCompound.func_74757_a("IsAged", this.isAged);
        NBTTagCompound sink = new NBTTagCompound();
        this.productTank.writeToNBT(sink);
        par1NBTTagCompound.func_74782_a("productTank", (NBTBase)sink);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.itemstacks.length; ++i) {
            if (this.itemstacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.itemstacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int getAgingTime() {
        return this.age;
    }

    public void setAgingTime(int par1) {
        this.age = par1;
    }

    public boolean getAged() {
        return this.isAged;
    }

    public void setAged(boolean par1) {
        this.isAged = par1;
    }

    public int getGrade() {
        return this.grade;
    }

    public void setGrade(int par1) {
        this.grade = par1;
    }

    public int getRecipeID() {
        return this.recipeID;
    }

    public void setRecipeID(int par1) {
        this.recipeID = par1;
    }

    public int getAgingProgress(int i) {
        IWaDistillingRecipe recipe = RecipeManagerWa.distillingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null) {
            return 0;
        }
        int ret = this.age * i / recipe.getDistillingTime();
        return ret;
    }

    public int getDistillingTime() {
        IWaDistillingRecipe recipe = RecipeManagerWa.distillingRegistry.getRecipeFromID(this.recipeID);
        if (recipe == null) {
            return 0;
        }
        return recipe.getDistillingTime();
    }

    public int getMetadata() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getUpper() {
        int i = this.age;
        int get = i >>> 4;
        return get;
    }

    public int getUnder() {
        int i = this.age;
        int get = i & 0xF;
        return get;
    }

    public void setUpper(int i) {
        int current = this.age & 0xF;
        int get = i << 4;
        this.age = get += current;
    }

    public void setUnder(int i) {
        int currentUpper = this.age >>> 4;
        int cur = currentUpper << 4;
        int get = i & 0xF;
        this.age = get += cur;
    }

    public void getGuiFluidUpdate(int id, int val) {
        ForgeDirection d;
        if (id == 2) {
            if (this.productTank.getFluid() == null) {
                this.productTank.setFluidById(val);
            } else {
                int amo = this.productTank.getFluidAmount();
                this.productTank.setFluidById(val);
            }
        } else if (id == 3) {
            if (this.productTank.getFluid() == null) {
                this.productTank.setFluid(null);
            } else {
                this.productTank.getFluid().amount = val;
            }
        }
        if (id == 4) {
            ForgeDirection d2 = this.getPairDir();
            if (d2 != ForgeDirection.UNKNOWN) {
                TileEntityStill tileConnected = (TileEntityStill)this.field_145850_b.func_147438_o(this.field_145851_c + d2.offsetX, this.field_145848_d + d2.offsetY, this.field_145849_e + d2.offsetZ);
                if (tileConnected.productTank.getFluid() == null) {
                    tileConnected.productTank.setFluidById(val);
                } else {
                    int amo = tileConnected.productTank.getFluidAmount();
                    tileConnected.productTank.setFluidById(val);
                }
            }
        } else if (id == 5 && (d = this.getPairDir()) != ForgeDirection.UNKNOWN) {
            TileEntityStill tileConnected = (TileEntityStill)this.field_145850_b.func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY, this.field_145849_e + d.offsetZ);
            if (tileConnected.productTank.getFluid() == null) {
                tileConnected.productTank.setFluid(null);
            } else {
                tileConnected.productTank.getFluid().amount = val;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getFluidAmountScaled(int par1) {
        return this.productTank.getFluidAmount() * par1 / 10000;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (this.productTank.getFluidType() == resource.getFluid()) {
            FluidStack ret = this.productTank.drain(resource.amount, doDrain);
            return ret;
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.productTank.drain(maxDrain, doDrain);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() == null) {
            return 0;
        }
        FluidStack current = this.productTank.getFluid();
        FluidStack resourceCopy = resource.copy();
        if (current != null && current.amount > 0 && !current.isFluidEqual(resourceCopy)) {
            return 0;
        }
        int i = 0;
        if (from != ForgeDirection.UNKNOWN) {
            if (this.findFire() || this.findSpiritLamp()) {
                return 0;
            }
            if (!this.findIce()) {
                resourceCopy.amount = this.findWater() ? (int)((double)resourceCopy.amount * 0.7) : (int)((double)resourceCopy.amount * 0.7);
            }
        }
        int used = this.productTank.fill(resourceCopy, doFill);
        resourceCopy.amount -= used;
        return i += used;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid != null && this.productTank.isEmpty();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    protected int[] slotsTop() {
        return new int[]{0, 1};
    }

    protected int[] slotsBottom() {
        return new int[]{2};
    }

    protected int[] slotsSides() {
        return new int[]{0, 1, 2};
    }

    public int func_70302_i_() {
        return 3;
    }

    public ItemStack func_70301_a(int par1) {
        return par1 < this.func_70302_i_() ? this.itemstacks[par1] : null;
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.itemstacks[par1] != null) {
            if (this.itemstacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.itemstacks[par1];
                this.itemstacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.itemstacks[par1].func_77979_a(par2);
            if (this.itemstacks[par1].field_77994_a == 0) {
                this.itemstacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.itemstacks[par1] != null) {
            ItemStack itemstack = this.itemstacks[par1];
            this.itemstacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        if (par1 > this.func_70302_i_()) {
            par1 = 0;
        }
        this.itemstacks[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public abstract String func_145825_b();

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 0) {
            return FluidContainerRegistry.isFilledContainer((ItemStack)stack);
        }
        if (i == 1) {
            return FluidContainerRegistry.isEmptyContainer((ItemStack)stack);
        }
        return false;
    }

    public int[] func_94128_d(int par1) {
        return par1 == 0 ? this.slotsBottom() : (par1 == 1 ? this.slotsTop() : this.slotsSides());
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return true;
    }

    public boolean connected() {
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return metadata == 1;
    }
}

