/*
 * Decompiled with CFR 0.152.
 */
package wa.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import wa.api.IBrewingRegistry;
import wa.api.IWaBrewingRecipe;
import wa.api.RecipeManagerWa;

public class WaBrewingManager
implements IBrewingRegistry {
    private static ArrayList<WaBrewingRecipe> recipes;
    private static Map<Integer, WaBrewingRecipe> recipeMap;

    public WaBrewingManager() {
        recipes = new ArrayList();
        recipeMap = new HashMap<Integer, WaBrewingRecipe>();
    }

    public IBrewingRegistry instance() {
        return RecipeManagerWa.brewingRegistry;
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public ArrayList<? extends IWaBrewingRecipe> getRecipeList() {
        return recipes;
    }

    @Override
    public IWaBrewingRecipe getRecipe(ItemStack input, ItemStack second) {
        for (WaBrewingRecipe recipe : recipes) {
            ItemStack[] checks = new ItemStack[]{input, second};
            if (!recipe.matches(checks)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public void addRecipe(Object input, int inputRequire, Object secondary, int secondRequire, FluidStack output, int brewingTime) {
        if (input != null && output != null && inputRequire > 0) {
            WaBrewingRecipe add = new WaBrewingRecipe(output, input, secondary, inputRequire, secondRequire, brewingTime);
            int id = recipeMap.isEmpty() ? 1 : recipeMap.size() + 1;
            recipes.add(add);
            recipeMap.put(id, add);
        }
    }

    @Override
    public int getRecipeID(ItemStack input, ItemStack second) {
        for (Map.Entry<Integer, WaBrewingRecipe> entry : recipeMap.entrySet()) {
            ItemStack[] checks = new ItemStack[]{input, second};
            if (!entry.getValue().matches(checks)) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public IWaBrewingRecipe getRecipeFromID(int id) {
        if (recipeMap.isEmpty() || id < 1 || id > recipeMap.size()) {
            return null;
        }
        if (recipeMap.containsKey(id)) {
            return recipeMap.get(id);
        }
        return null;
    }

    private boolean isItemEqual(ItemStack a, ItemStack b) {
        if (a == null || a.func_77973_b() == null || b == null || b.func_77973_b() == null) {
            return a == null && b == null;
        }
        boolean flag = false;
        if (a.func_77973_b() == b.func_77973_b()) {
            if (a.func_77960_j() == b.func_77960_j()) {
                flag = true;
            } else if (b.func_77960_j() == Short.MAX_VALUE) {
                flag = true;
            }
        }
        return flag;
    }

    public class WaBrewingRecipe
    implements IWaBrewingRecipe {
        private final Object input;
        private final Object second;
        private final int require1;
        private final int require2;
        private final int day;
        private final FluidStack output;

        public WaBrewingRecipe(FluidStack out, Object in, Object sec, int r1, int r2, int d) {
            this.input = in;
            this.second = sec;
            this.require1 = r1;
            this.require2 = r2;
            this.day = d;
            this.output = out;
        }

        @Override
        public Object getInput() {
            return this.input;
        }

        @Override
        public Object getSecondInput() {
            return this.second;
        }

        @Override
        public FluidStack getOutput() {
            return this.output.copy();
        }

        @Override
        public List<ItemStack> getProcessedInput() {
            ArrayList<ItemStack> processedInput = new ArrayList<ItemStack>();
            if (this.input instanceof String) {
                processedInput.addAll(OreDictionary.getOres((String)((String)this.input)));
            } else if (this.input instanceof ItemStack) {
                processedInput.add(((ItemStack)this.input).func_77946_l());
            } else if (this.input instanceof Item) {
                processedInput.add(new ItemStack((Item)this.input, 1, 0));
            } else if (this.input instanceof Block) {
                processedInput.add(new ItemStack((Block)this.input, 1, 0));
            }
            return processedInput;
        }

        @Override
        public List<ItemStack> getSecondProcessedInput() {
            ArrayList<ItemStack> processedSecond = new ArrayList<ItemStack>();
            if (this.second instanceof String) {
                processedSecond.addAll(OreDictionary.getOres((String)((String)this.second)));
            } else if (this.second instanceof ItemStack) {
                processedSecond.add(((ItemStack)this.second).func_77946_l());
            } else if (this.second instanceof Item) {
                processedSecond.add(new ItemStack((Item)this.second, 1, 0));
            } else if (this.second instanceof Block) {
                processedSecond.add(new ItemStack((Block)this.second, 1, 0));
            }
            return processedSecond;
        }

        @Override
        public int getInputRequire() {
            return this.require1;
        }

        @Override
        public int getSecondRequire() {
            return this.require2;
        }

        @Override
        public boolean matches(ItemStack[] items) {
            if (items.length != 2) {
                return false;
            }
            boolean fst = false;
            boolean sec = false;
            for (ItemStack check : items) {
                if (check == null) {
                    if (this.second != null) continue;
                    sec = true;
                    continue;
                }
                for (ItemStack target : this.getProcessedInput()) {
                    if (!WaBrewingManager.this.isItemEqual(check, target)) continue;
                    fst = true;
                }
                for (ItemStack target : this.getSecondProcessedInput()) {
                    if (!WaBrewingManager.this.isItemEqual(check, target)) continue;
                    sec = true;
                }
            }
            return fst && sec;
        }

        @Override
        public int getBrewingTime() {
            return this.day;
        }

        @Override
        public int getOutputGrade(TileEntity tile, int inputNum, int secondNum) {
            int grade = 100;
            int i1 = 100 - Math.abs(this.require1 - inputNum);
            float f1 = (float)i1 / 80.0f;
            int i2 = 100 + secondNum - this.require2;
            float f2 = (float)i2 / 100.0f;
            if (tile.func_145831_w().field_73012_v.nextInt(10) == 0) {
                grade += 50;
            }
            int ret = MathHelper.func_76123_f((float)((float)grade * f1 * f2));
            return ret;
        }
    }
}

