/*
 * Decompiled with CFR 0.152.
 */
package wa.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import wa.api.IDistillingRegistry;
import wa.api.IWaDistillingRecipe;
import wa.api.RecipeManagerWa;

public class WaDistillingManager
implements IDistillingRegistry {
    private static ArrayList<WaDistillingRecipe> recipes;
    private static Map<Integer, WaDistillingRecipe> recipeMap;

    public WaDistillingManager() {
        recipes = new ArrayList();
        recipeMap = new HashMap<Integer, WaDistillingRecipe>();
    }

    public IDistillingRegistry instance() {
        return RecipeManagerWa.distillingRegistry;
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public ArrayList<? extends IWaDistillingRecipe> getRecipeList() {
        return recipes;
    }

    @Override
    public IWaDistillingRecipe getRecipe(FluidStack input) {
        for (WaDistillingRecipe recipe : recipes) {
            if (!recipe.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public void addRecipe(Fluid input, int inputRequire, FluidStack output, int distillingTime) {
        FluidStack fluid = new FluidStack(input, inputRequire);
        this.addRecipe(fluid, inputRequire, output, distillingTime);
    }

    @Override
    public void addRecipe(FluidStack input, int inputRequire, FluidStack output, int distillingTime) {
        if (input != null && output != null && inputRequire > 0) {
            WaDistillingRecipe add = new WaDistillingRecipe(output, input, inputRequire, distillingTime);
            int id = recipeMap.isEmpty() ? 1 : recipeMap.size() + 1;
            recipes.add(add);
            recipeMap.put(id, add);
        }
    }

    @Override
    public void addRecipe(FluidStack input, FluidStack output, int distillingTime) {
        this.addRecipe(input, input.amount, output, distillingTime);
    }

    @Override
    public int getRecipeID(FluidStack input) {
        for (Map.Entry<Integer, WaDistillingRecipe> entry : recipeMap.entrySet()) {
            if (!entry.getValue().matches(input)) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public IWaDistillingRecipe getRecipeFromID(int id) {
        if (recipeMap.isEmpty() || id < 1 || id > recipeMap.size()) {
            return null;
        }
        if (recipeMap.containsKey(id)) {
            return recipeMap.get(id);
        }
        return null;
    }

    public class WaDistillingRecipe
    implements IWaDistillingRecipe {
        private final FluidStack input;
        private final int require1;
        private final int day;
        private final FluidStack output;

        public WaDistillingRecipe(FluidStack out, FluidStack in, int r1, int d) {
            this.input = in;
            this.require1 = r1;
            this.day = d;
            this.output = out;
        }

        @Override
        public FluidStack getInput() {
            return this.input;
        }

        @Override
        public FluidStack getOutput() {
            return this.output.copy();
        }

        @Override
        public int getInputRequire() {
            return this.require1;
        }

        @Override
        public boolean matches(FluidStack fluidStack) {
            if (fluidStack == null) {
                return false;
            }
            return fluidStack.isFluidEqual(this.getInput());
        }

        @Override
        public int getDistillingTime() {
            return this.day;
        }

        @Override
        public int getOutputGrade(TileEntity tile, FluidStack input, int inputGrade) {
            return inputGrade;
        }
    }
}

