/*
 * Decompiled with CFR 0.152.
 */
package wa.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import wa.api.ISqueezingRegistry;
import wa.api.IWaSqueezingRecipe;
import wa.api.RecipeManagerWa;

public class WaSqueezingManager
implements ISqueezingRegistry {
    private static ArrayList<WaSqueezingRecipe> recipes;
    private static Map<Integer, WaSqueezingRecipe> recipeMap;

    public WaSqueezingManager() {
        recipes = new ArrayList();
        recipeMap = new HashMap<Integer, WaSqueezingRecipe>();
    }

    public ISqueezingRegistry instance() {
        return RecipeManagerWa.squeezingRegistry;
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public ArrayList<? extends IWaSqueezingRecipe> getRecipeList() {
        return recipes;
    }

    @Override
    public IWaSqueezingRecipe getRecipe(ItemStack input) {
        for (WaSqueezingRecipe recipe : recipes) {
            if (!recipe.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public void addRecipe(Object input, int inputRequire, FluidStack output, int squeezingTime) {
        if (input != null && output != null && inputRequire > 0) {
            WaSqueezingRecipe add = new WaSqueezingRecipe(output, input, inputRequire, squeezingTime);
            int id = recipeMap.isEmpty() ? 1 : recipeMap.size() + 1;
            recipes.add(add);
            recipeMap.put(id, add);
        }
    }

    @Override
    public int getRecipeID(ItemStack input) {
        for (Map.Entry<Integer, WaSqueezingRecipe> entry : recipeMap.entrySet()) {
            if (!entry.getValue().matches(input)) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public IWaSqueezingRecipe getRecipeFromID(int id) {
        if (recipeMap.isEmpty() || id < 1 || id > recipeMap.size()) {
            return null;
        }
        if (recipeMap.containsKey(id)) {
            return recipeMap.get(id);
        }
        return null;
    }

    private boolean isItemEqual(ItemStack a, ItemStack b) {
        if (a == null || a.func_77973_b() == null || b == null || b.func_77973_b() == null) {
            return a == null && b == null;
        }
        boolean flag = false;
        if (a.func_77973_b() == b.func_77973_b()) {
            if (a.func_77960_j() == b.func_77960_j()) {
                flag = true;
            } else if (b.func_77960_j() == Short.MAX_VALUE) {
                flag = true;
            }
        }
        return flag;
    }

    public class WaSqueezingRecipe
    implements IWaSqueezingRecipe {
        private final Object input;
        private final int require1;
        private final int day;
        private final FluidStack output;

        public WaSqueezingRecipe(FluidStack out, Object in, int r1, int d) {
            this.input = in;
            this.require1 = r1;
            this.day = d;
            this.output = out;
        }

        @Override
        public Object getInput() {
            return this.input;
        }

        @Override
        public FluidStack getOutput() {
            return this.output.copy();
        }

        @Override
        public List<ItemStack> getProcessedInput() {
            ArrayList<ItemStack> processedInput = new ArrayList<ItemStack>();
            if (this.input instanceof String) {
                processedInput.addAll(OreDictionary.getOres((String)((String)this.input)));
            } else if (this.input instanceof ItemStack) {
                processedInput.add(((ItemStack)this.input).func_77946_l());
            } else if (this.input instanceof Item) {
                processedInput.add(new ItemStack((Item)this.input, 1, 0));
            } else if (this.input instanceof Block) {
                processedInput.add(new ItemStack((Block)this.input, 1, 0));
            }
            return processedInput;
        }

        @Override
        public int getInputRequire() {
            return this.require1;
        }

        @Override
        public boolean matches(ItemStack itemStack) {
            if (itemStack == null) {
                return false;
            }
            for (ItemStack target : this.getProcessedInput()) {
                if (!WaSqueezingManager.this.isItemEqual(itemStack, target)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getSqueezingTime() {
            return this.day;
        }

        @Override
        public int getOutputGrade(TileEntity tile, int inputNum) {
            return 100;
        }
    }
}

