/*
 * Decompiled with CFR 0.152.
 */
package wa.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenDesert;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import wa.Config;
import wa.world.BiomeGenAutumn;
import wa.world.BiomeGenSpring;
import wa.world.BiomeGenSummer;
import wa.world.BiomeGenWaPlains;
import wa.world.BiomeGenWinter;

public class WorldChunkManagerWa
extends WorldChunkManager {
    public static final BiomeGenBase[] biomeList = new BiomeGenBase[256];
    public static final BiomeGenBase spring = new BiomeGenSpring(Config.biomeID).func_76739_b(16757476).func_76732_a(0.8f, 0.4f).func_76735_a("Spring");
    public static final BiomeGenBase summer = new BiomeGenSummer(Config.biomeID + 1).func_76739_b(2313215).func_76732_a(1.2f, 0.9f).func_76735_a("Summer");
    public static final BiomeGenBase autumn = new BiomeGenAutumn(Config.biomeID + 2).func_76739_b(16738605).func_76732_a(0.7f, 0.8f).func_76735_a("Autumn");
    public static final BiomeGenBase winter = new BiomeGenWinter(Config.biomeID + 3, 1).func_76739_b(0xEDEFFF).func_76742_b().func_150570_a(new BiomeGenBase.Height(0.3f, 1.3f)).func_76732_a(0.0f, 0.5f).func_76735_a("Winter");
    public static final BiomeGenBase wadesert = new BiomeGenDesert(Config.biomeID + 4).func_76739_b(16421912).func_76735_a("Desert").func_76745_m().func_76732_a(2.0f, 0.0f).func_150570_a(new BiomeGenBase.Height(0.1f, 0.2f));
    public static final BiomeGenBase waplains = new BiomeGenWaPlains(Config.biomeID + 5).func_76739_b(9286496).func_76735_a("Plains").func_76732_a(0.8f, 0.4f);
    public static final BiomeGenBase[] waBiomeList = new BiomeGenBase[]{spring, summer, autumn, winter, wadesert, waplains};
    public static ArrayList<BiomeGenBase> allowedBiomes = new ArrayList<BiomeGenBase>(Arrays.asList(BiomeGenBase.field_76767_f, BiomeGenBase.field_76768_g, BiomeGenBase.field_76784_u, BiomeGenBase.field_76785_t));
    private GenLayer genBiomes;
    private GenLayer biomeIndexLayer;
    private BiomeCache biomeCache = new BiomeCache((WorldChunkManager)this);
    private List biomesToSpawnIn = new ArrayList();

    public static void init() {
        BiomeGenBase[] src = new BiomeGenBase[]{spring, summer, autumn, winter, wadesert, BiomeGenBase.field_76771_b, BiomeGenBase.field_76781_i, BiomeGenBase.field_76776_l, BiomeGenBase.field_76777_m, BiomeGenBase.field_76774_n, BiomeGenBase.field_76775_o, BiomeGenBase.field_76767_f, BiomeGenBase.field_76780_h, BiomeGenBase.field_76768_g, BiomeGenBase.field_76787_r, BiomeGenBase.field_76786_s, BiomeGenBase.field_76785_t, BiomeGenBase.field_76784_u, BiomeGenBase.field_76783_v};
        for (int i = 0; i < 256; ++i) {
            WorldChunkManagerWa.biomeList[i] = src[i % src.length];
        }
    }

    protected WorldChunkManagerWa() {
        this.biomesToSpawnIn.addAll(allowedBiomes);
    }

    public WorldChunkManagerWa(long par1, WorldType par3WorldType) {
        this();
        GenLayer[] var4 = GenLayer.func_75901_a((long)par1, (WorldType)par3WorldType);
        this.genBiomes = var4[0];
        this.biomeIndexLayer = var4[1];
    }

    public WorldChunkManagerWa(World par1World) {
        this(par1World.func_72905_C(), par1World.func_72912_H().func_76067_t());
    }

    public List func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public BiomeGenBase func_76935_a(int par1, int par2) {
        return this.biomeCache.func_76837_b(par1, par2);
    }

    public float[] func_76936_a(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        int[] var6 = this.biomeIndexLayer.func_75904_a(par2, par3, par4, par5);
        for (int var7 = 0; var7 < par4 * par5; ++var7) {
            float var8 = (float)biomeList[var6[var7]].func_76744_g() / 65536.0f;
            if (var8 > 1.0f) {
                var8 = 1.0f;
            }
            par1ArrayOfFloat[var7] = var8;
        }
        return par1ArrayOfFloat;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    public float[] getTemperatures(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        int[] var6 = this.biomeIndexLayer.func_75904_a(par2, par3, par4, par5);
        for (int var7 = 0; var7 < par4 * par5; ++var7) {
            float var8 = biomeList[var6[var7]].func_150564_a(par2, 64, par3) / 65536.0f;
            if (var8 > 1.0f) {
                var8 = 1.0f;
            }
            par1ArrayOfFloat[var7] = var8;
        }
        return par1ArrayOfFloat;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        int[] var6 = this.genBiomes.func_75904_a(par2, par3, par4, par5);
        for (int var7 = 0; var7 < par4 * par5; ++var7) {
            par1ArrayOfBiomeGenBase[var7] = biomeList[var6[var7]];
        }
        return par1ArrayOfBiomeGenBase;
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        return this.func_76931_a(par1ArrayOfBiomeGenBase, par2, par3, par4, par5, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5, boolean par6) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        if (par6 && par4 == 16 && par5 == 16 && (par2 & 0xF) == 0 && (par3 & 0xF) == 0) {
            BiomeGenBase[] var9 = this.biomeCache.func_76839_e(par2, par3);
            System.arraycopy(var9, 0, par1ArrayOfBiomeGenBase, 0, par4 * par5);
            return par1ArrayOfBiomeGenBase;
        }
        int[] var7 = this.biomeIndexLayer.func_75904_a(par2, par3, par4, par5);
        for (int var8 = 0; var8 < par4 * par5; ++var8) {
            par1ArrayOfBiomeGenBase[var8] = biomeList[var7[var8]];
        }
        return par1ArrayOfBiomeGenBase;
    }

    public boolean func_76940_a(int par1, int par2, int par3, List par4List) {
        IntCache.func_76446_a();
        int var5 = par1 - par3 >> 2;
        int var6 = par2 - par3 >> 2;
        int var7 = par1 + par3 >> 2;
        int var8 = par2 + par3 >> 2;
        int var9 = var7 - var5 + 1;
        int var10 = var8 - var6 + 1;
        int[] var11 = this.genBiomes.func_75904_a(var5, var6, var9, var10);
        for (int var12 = 0; var12 < var9 * var10; ++var12) {
            BiomeGenBase var13 = biomeList[var11[var12]];
            if (par4List.contains(var13)) continue;
            return false;
        }
        return true;
    }

    public ChunkPosition func_150795_a(int par1, int par2, int par3, List par4List, Random par5Random) {
        IntCache.func_76446_a();
        int var6 = par1 - par3 >> 2;
        int var7 = par2 - par3 >> 2;
        int var8 = par1 + par3 >> 2;
        int var9 = par2 + par3 >> 2;
        int var10 = var8 - var6 + 1;
        int var11 = var9 - var7 + 1;
        int[] var12 = this.genBiomes.func_75904_a(var6, var7, var10, var11);
        ChunkPosition var13 = null;
        int var14 = 0;
        for (int var15 = 0; var15 < var10 * var11; ++var15) {
            int var16 = var6 + var15 % var10 << 2;
            int var17 = var7 + var15 / var10 << 2;
            BiomeGenBase var18 = biomeList[var12[var15]];
            if (!par4List.contains(var18) || var13 != null && par5Random.nextInt(var14 + 1) != 0) continue;
            var13 = new ChunkPosition(var16, 0, var17);
            ++var14;
        }
        return var13;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

