/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.command;

import com.hungteen.pvz.utils.enums.InvasionEvents;
import com.hungteen.pvz.world.data.PVZInvasionData;
import com.hungteen.pvz.world.invasion.OverworldInvasion;
import com.hungteen.pvz.world.invasion.WaveManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.world.World;

public class InvasionCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"invasion").requires(ctx -> ctx.func_197034_c(2));
        for (InvasionEvents event : InvasionEvents.values()) {
            builder.then(Commands.func_197057_a((String)"event").then(Commands.func_197057_a((String)"add").then(Commands.func_197057_a((String)event.toString().toLowerCase()).executes(commond -> InvasionCommand.addInvasionEvent((CommandSource)commond.getSource(), event)))));
        }
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"event").then(Commands.func_197057_a((String)"clear").executes(commond -> InvasionCommand.clearInvasionEvent((CommandSource)commond.getSource())))).then(Commands.func_197057_a((String)"show").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(commond -> InvasionCommand.showInvasionEvent((CommandSource)commond.getSource(), EntityArgument.func_197090_e((CommandContext)commond, (String)"targets"))))));
        builder.then(Commands.func_197057_a((String)"wave").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(commond -> InvasionCommand.spawnHugeWave(EntityArgument.func_197090_e((CommandContext)commond, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)commond, (String)"amount"))))));
        dispatcher.register(builder);
    }

    private static int spawnHugeWave(Collection<? extends ServerPlayerEntity> targets, int num) {
        targets.forEach(player -> {
            WaveManager manager = new WaveManager((PlayerEntity)player, 0);
            if (num != 0) {
                manager.spawnCnt = num;
            }
            manager.spawnWaveZombies();
        });
        return targets.size();
    }

    private static int addInvasionEvent(CommandSource source, InvasionEvents event) {
        OverworldInvasion.activateEvent((World)source.func_197023_e(), event);
        return 0;
    }

    private static int clearInvasionEvent(CommandSource source) {
        OverworldInvasion.deactivateZombieAttackEvents((World)source.func_197023_e(), false);
        return 0;
    }

    private static int showInvasionEvent(CommandSource source, Collection<? extends ServerPlayerEntity> targets) {
        targets.forEach(player -> {
            PVZInvasionData data = PVZInvasionData.getOverWorldInvasionData((World)source.func_197023_e());
            for (InvasionEvents event : InvasionEvents.values()) {
                if (!data.hasEvent(event)) continue;
                player.func_145747_a(InvasionEvents.getEventText(event), Util.field_240973_b_);
            }
        });
        return targets.size();
    }
}

