/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.command;

import com.hungteen.pvz.capability.CapabilityHandler;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class PlantLvlCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"plantlvl").requires(ctx -> ctx.func_197034_c(2));
        for (Plants p : Plants.values()) {
            builder.then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197057_a((String)"add").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)p.toString().toLowerCase()).then(Commands.func_197057_a((String)"xp").then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(command -> PlantLvlCommand.addPlantXp((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"targets"), p, IntegerArgumentType.getInteger((CommandContext)command, (String)"amount")))))).then(Commands.func_197057_a((String)"lvl").then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(command -> PlantLvlCommand.addPlantLvl((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"targets"), p, IntegerArgumentType.getInteger((CommandContext)command, (String)"amount"))))))));
            builder.then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197057_a((String)"query").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)p.toString().toLowerCase()).then(Commands.func_197057_a((String)"xp").executes(command -> PlantLvlCommand.queryPlantXp((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"targets"), p)))).then(Commands.func_197057_a((String)"lvl").executes(command -> PlantLvlCommand.queryPlantLvl((CommandSource)command.getSource(), EntityArgument.func_197090_e((CommandContext)command, (String)"targets"), p))))));
        }
        dispatcher.register(builder);
    }

    public static int addPlantLvl(CommandSource source, Collection<? extends ServerPlayerEntity> targets, Plants plant, int num) {
        for (ServerPlayerEntity serverPlayerEntity : targets) {
            PlayerUtil.addPlantLvl((PlayerEntity)serverPlayerEntity, plant, num);
        }
        return targets.size();
    }

    public static int addPlantXp(CommandSource source, Collection<? extends ServerPlayerEntity> targets, Plants plant, int num) {
        for (ServerPlayerEntity serverPlayerEntity : targets) {
            PlayerUtil.addPlantXp((PlayerEntity)serverPlayerEntity, plant, num);
        }
        return targets.size();
    }

    public static int queryPlantLvl(CommandSource source, Collection<? extends ServerPlayerEntity> targets, Plants plant) {
        for (ServerPlayerEntity serverPlayerEntity : targets) {
            serverPlayerEntity.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> source.func_197030_a((ITextComponent)new StringTextComponent("" + l.getPlayerData().getPlantStats().getPlantLevel(plant)), true));
        }
        return targets.size();
    }

    public static int queryPlantXp(CommandSource source, Collection<? extends ServerPlayerEntity> targets, Plants plant) {
        for (ServerPlayerEntity serverPlayerEntity : targets) {
            serverPlayerEntity.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> source.func_197030_a((ITextComponent)new StringTextComponent("" + l.getPlayerData().getPlantStats().getPlantXp(plant)), true));
        }
        return targets.size();
    }
}

