/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.data;

import com.hungteen.pvz.register.BlockRegister;
import com.hungteen.pvz.utils.StringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockModelGenerator
extends BlockModelProvider {
    private Set<Block> addedBlocks = new HashSet<Block>();

    public BlockModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "pvz", existingFileHelper);
    }

    protected void registerModels() {
        this.addedBlocks.addAll(Arrays.asList((Block)BlockRegister.CARD_FUSION_TABLE.get(), (Block)BlockRegister.CHOMPER.get(), (Block)BlockRegister.DIAMOND_SUNFLOWER_TROPHY.get(), (Block)BlockRegister.ESSENCE_ALTAR.get(), (Block)BlockRegister.FLOWER_POT.get(), (Block)BlockRegister.GOLD_SUNFLOWER_TROPHY.get(), (Block)BlockRegister.LANTERN.get(), (Block)BlockRegister.LILY_PAD.get(), (Block)BlockRegister.SILVER_SUNFLOWER_TROPHY.get(), (Block)BlockRegister.STEEL_LADDER.get(), (Block)BlockRegister.SUN_CONVERTER.get()));
        this.genCrop((Block)BlockRegister.CABBAGE.get(), 3);
        this.genCrop((Block)BlockRegister.CORN.get(), 6);
        this.genCrop((Block)BlockRegister.PEA_PLANT.get(), 7);
        this.genCrop((Block)BlockRegister.TOXIC_SHROOM.get(), 3);
        Arrays.asList((Block)BlockRegister.FRAGMENT_SPLICE.get(), (Block)BlockRegister.SLOT_MACHINE.get()).forEach(b -> this.topSideBottom((Block)b));
        Arrays.asList((Block)BlockRegister.FROZEN_MELON.get()).forEach(b -> this.topSide((Block)b));
        Arrays.asList((Block)BlockRegister.NUT_SAPLING.get()).forEach(b -> {
            this.cross(b.getRegistryName().func_110623_a(), StringUtil.prefix("block/" + b.getRegistryName().func_110623_a()));
            this.addedBlocks.add((Block)b);
        });
        for (Block b2 : ForgeRegistries.BLOCKS) {
            if (!b2.getRegistryName().func_110624_b().equals("pvz") || this.addedBlocks.contains(b2)) continue;
            this.fullCube(b2);
        }
    }

    private void fullCube(Block block) {
        this.cubeAll(block.getRegistryName().func_110623_a(), StringUtil.prefix("block/" + block.getRegistryName().func_110623_a()));
    }

    private void genCrop(Block block, int cnt) {
        for (int i = 0; i <= cnt; ++i) {
            this.crop(block.getRegistryName().func_110623_a() + "_" + i, StringUtil.prefix("block/" + block.getRegistryName().func_110623_a() + "_" + i));
        }
        this.addedBlocks.add(block);
    }

    private void topSideBottom(Block block) {
        this.cube(block.getRegistryName().func_110623_a(), StringUtil.prefix("block/" + block.getRegistryName().func_110623_a() + "_down"), StringUtil.prefix("block/" + block.getRegistryName().func_110623_a() + "_top"), StringUtil.prefix("block/" + block.getRegistryName().func_110623_a() + "_side"), StringUtil.prefix("block/" + block.getRegistryName().func_110623_a() + "_side"), StringUtil.prefix("block/" + block.getRegistryName().func_110623_a() + "_side"), StringUtil.prefix("block/" + block.getRegistryName().func_110623_a() + "_side"));
        this.addedBlocks.add(block);
    }

    private void topSide(Block b) {
        this.cubeColumn(b.getRegistryName().func_110623_a(), StringUtil.prefix("block/" + b.getRegistryName().func_110623_a() + "_side"), StringUtil.prefix("block/" + b.getRegistryName().func_110623_a() + "_top"));
        this.addedBlocks.add(b);
    }

    public String func_200397_b() {
        return "Plants vs Zombies block models";
    }
}

