/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.data;

import com.hungteen.pvz.item.PVZSpawnEggItem;
import com.hungteen.pvz.item.tool.card.PlantCardItem;
import com.hungteen.pvz.register.BlockRegister;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.StringUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemModelGenerator
extends ItemModelProvider {
    private Set<Item> addedItems = new HashSet<Item>();

    public ItemModelGenerator(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, "pvz", helper);
    }

    protected void registerModels() {
        this.addedItems.addAll(Arrays.asList((Item)ItemRegister.PEA_GUN.get(), (Item)ItemRegister.ZOMBIE_FLAG.get(), (Item)ItemRegister.BOBSLE_CAR.get(), (Item)ItemRegister.SCREEN_DOOR.get(), (Item)ItemRegister.BOWLING_GLOVE.get(), (Item)ItemRegister.JACK_BOX.get(), (Item)ItemRegister.BALLOON.get(), (Item)ItemRegister.WARNING_SIGN.get(), (Item)ItemRegister.ZOMBIE_DOLL.get(), (Item)ItemRegister.POLE.get(), (Item)ItemRegister.CONE_HEAD.get(), (Item)ItemRegister.BUCKET_HEAD.get(), (Item)ItemRegister.SUN_COLLECTOR.get()));
        Arrays.asList((Item)ItemRegister.PEA.get(), (Item)ItemRegister.SPORE.get(), (Item)ItemRegister.CABBAGE_SEEDS.get(), (Item)ItemRegister.CORN_SEEDS.get()).forEach(i -> {
            this.genNormalModel((Item)i);
            this.addedItems.add((Item)i);
        });
        Arrays.asList((Block)BlockRegister.NUT_SAPLING.get(), (Block)BlockRegister.STEEL_LADDER.get()).forEach(i -> {
            this.genItemModelWithBlock(i.func_199767_j());
            this.addedItems.add(i.func_199767_j());
        });
        for (Item i2 : ForgeRegistries.ITEMS) {
            if (!i2.getRegistryName().func_110624_b().equals("pvz") || this.addedItems.contains(i2)) continue;
            if (i2 instanceof PVZSpawnEggItem) {
                this.addedItems.add(i2);
                ((ItemModelBuilder)this.getBuilder(i2.getRegistryName().func_110623_a())).parent((ModelFile)this.getExistingFile(new ResourceLocation("item/template_spawn_egg")));
                continue;
            }
            if (i2 instanceof PlantCardItem) {
                ResourceLocation r;
                Plants plant = ((PlantCardItem)i2).plantType;
                ResourceLocation plantResource = StringUtil.prefix("screenshot/plant/" + plant.toString().toLowerCase());
                this.addedItems.add(i2);
                if (((PlantCardItem)i2).isEnjoyCard) {
                    r = StringUtil.prefix("item/red_card");
                    this.genNormal(i2.getRegistryName().func_110623_a(), r, plantResource);
                    continue;
                }
                r = StringUtil.prefix("item/" + PlantUtil.getPlantRankByName(plant).toString().toLowerCase() + "_card");
                this.genNormal(i2.getRegistryName().func_110623_a(), r, plantResource);
                continue;
            }
            if (!(i2 instanceof BlockItem)) continue;
            this.addedItems.add(i2);
            this.genBlockModel(((BlockItem)i2).func_179223_d());
        }
        Arrays.asList((Item)ItemRegister.STEEL_AXE.get(), (Item)ItemRegister.STEEL_HOE.get(), (Item)ItemRegister.STEEL_PICKAXE.get(), (Item)ItemRegister.STEEL_SHOVEL.get(), (Item)ItemRegister.STEEL_SWORD.get()).forEach(i -> {
            this.addedItems.add((Item)i);
            this.genHeld(i.getRegistryName().func_110623_a(), StringUtil.prefix("item/" + i.getRegistryName().func_110623_a()));
        });
        for (Item i2 : ForgeRegistries.ITEMS) {
            if (!i2.getRegistryName().func_110624_b().equals("pvz") || this.addedItems.contains(i2)) continue;
            this.genNormal(i2.getRegistryName().func_110623_a(), StringUtil.prefix("item/" + i2.getRegistryName().func_110623_a()));
        }
    }

    private void genNormalModel(Item i) {
        this.genNormal(i.getRegistryName().func_110623_a(), StringUtil.prefix("item/" + i.getRegistryName().func_110623_a()));
    }

    private ItemModelBuilder genNormal(String name, ResourceLocation ... layers) {
        return this.gen(name, "item/generated", layers);
    }

    private ItemModelBuilder genHeld(String name, ResourceLocation ... layers) {
        return this.gen(name, "item/handheld", layers);
    }

    private ItemModelBuilder gen(String name, String parent, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(name, parent);
        for (int i = 0; i < layers.length; ++i) {
            builder = (ItemModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    private void genBlockModel(Block b) {
        this.withExistingParent(b.getRegistryName().func_110623_a(), StringUtil.prefix("block/" + b.getRegistryName().func_110623_a()));
    }

    private void genItemModelWithBlock(Item i) {
        this.genNormal(i.getRegistryName().func_110623_a(), StringUtil.prefix("block/" + i.getRegistryName().func_110623_a()));
    }

    public String func_200397_b() {
        return "Plants vs Zombies item and itemblock models";
    }
}

